/*
 * Decompiled with CFR 0.152.
 */
package test.junit;

import junit.framework.TestCase;
import xjyb.cn.org.bjca.exception.Base64Exception;
import xjyb.cn.org.bjca.exception.GetCertInfoException;
import xjyb.cn.org.bjca.exception.Pkcs7DecodeEnvelopeException;
import xjyb.cn.org.bjca.exception.Pkcs7DecodeException;
import xjyb.cn.org.bjca.exception.Pkcs7EncodeEnvelopeException;
import xjyb.cn.org.bjca.exception.Pkcs7EncodeException;
import xjyb.cn.org.bjca.exception.Pkcs7SignException;
import xjyb.cn.org.bjca.exception.Pkcs7VerifySignException;
import xjyb.cn.org.bjca.exception.RsaDecryptException;
import xjyb.cn.org.bjca.exception.RsaEncryptException;
import xjyb.cn.org.bjca.security.SecurityEngineDeal;

public class TestP11InterfaceByJava
extends TestCase {
    SecurityEngineDeal secEngineDeal = null;

    protected void setUp() throws Exception {
        this.secEngineDeal = SecurityEngineDeal.getInstance("SecXV3Default");
    }

    protected void tearDown() throws Exception {
    }

    public void testGetServerCertificate() throws Base64Exception {
        String cert = this.secEngineDeal.getServerCertificate();
        System.out.println("\u5f53\u524d\u5e94\u7528\u7684\u670d\u52a1\u5668\u7684\u7b7e\u540d\u8bc1\u4e66\u4e3a: " + cert);
    }

    public void testKeyPairEncrypt() throws Base64Exception, GetCertInfoException, RsaEncryptException, RsaDecryptException {
        String pubKeyEn = this.secEngineDeal.pubKeyEncrypt(this.secEngineDeal.getServerCertificate(), "hello");
        System.out.println(pubKeyEn);
        String outPrivate = this.secEngineDeal.priKeyDecrypt(pubKeyEn);
        System.out.println(outPrivate);
    }

    public void testP7SignAndVerify() throws Pkcs7SignException, Pkcs7EncodeException, Base64Exception, Pkcs7VerifySignException {
        String outP7SignedValue = this.secEngineDeal.signDataPkcs7("hello");
        boolean isSuccess = this.secEngineDeal.verifySignedDataPkcs7(outP7SignedValue);
        if (isSuccess) {
            System.out.println("\u9a8c\u8bc1P7\u7b7e\u540d\u6210\u529f\uff01\uff01");
        } else {
            System.out.println("\u9a8c\u8bc1P7\u7b7e\u540d\u5931\u8d25\uff01\uff01");
        }
        TestP11InterfaceByJava.assertTrue((boolean)isSuccess);
    }

    public void testP7EnvelopMethod() throws Base64Exception, Pkcs7EncodeEnvelopeException, Pkcs7EncodeException, Pkcs7DecodeEnvelopeException, Pkcs7DecodeException {
        String p7EnData = this.secEngineDeal.encodeP7EnvelopedData(this.secEngineDeal.getServerCertificate(), "\u4f60\u597d\uff01");
        String outP7DecData = this.secEngineDeal.decodeP7EnvelopedData(p7EnData);
        if ("\u4f60\u597d\uff01".endsWith(outP7DecData)) {
            System.out.println("P7\u52a0\u5bc6\u4fe1\u5c01\uff0c\u89e3\u5bc6\u6210\u529f\uff01");
        } else {
            System.out.println("P7\u52a0\u5bc6\u4fe1\u5c01\uff0c\u89e3\u5bc6\u5931\u8d25\uff01");
        }
        TestP11InterfaceByJava.assertTrue((boolean)"\u4f60\u597d\uff01".endsWith(outP7DecData));
    }

    public void testP7SignAndEnvelopMethod() throws Base64Exception, Pkcs7EncodeEnvelopeException, Pkcs7EncodeException, Pkcs7DecodeEnvelopeException, Pkcs7DecodeException {
        String p7SignAndEnvelopData = this.secEngineDeal.encodeP7SignAndEnvelopData(this.secEngineDeal.getServerCertificate(), "\u4f60\u597d\uff01");
        String outP7SignAndEnvelopData = this.secEngineDeal.decodeP7SignAndEnvelopData(p7SignAndEnvelopData);
        if ("\u4f60\u597d\uff01".endsWith(outP7SignAndEnvelopData)) {
            System.out.println("P7\u7b7e\u540d\u52a0\u5bc6\u4fe1\u5c01\uff0c\u89e3\u5bc6\u6210\u529f\uff01");
        } else {
            System.out.println("P7\u7b7e\u540d\u52a0\u5bc6\u4fe1\u5c01\uff0c\u89e3\u5bc6\u5931\u8d25\uff01");
        }
        TestP11InterfaceByJava.assertTrue((boolean)"\u4f60\u597d\uff01".endsWith(outP7SignAndEnvelopData));
    }
}

