/*
 * Decompiled with CFR 0.152.
 */
package test.junit;

import java.io.FileInputStream;
import java.io.IOException;
import java.security.InvalidKeyException;
import java.security.NoSuchAlgorithmException;
import java.security.NoSuchProviderException;
import java.security.Security;
import java.security.SignatureException;
import java.security.cert.CRLException;
import java.security.cert.CertificateException;
import java.util.Properties;
import junit.framework.TestCase;
import org.bouncycastle.jce.provider.BouncyCastleProvider;
import xjyb.cn.org.bjca.exception.Base64Exception;
import xjyb.cn.org.bjca.exception.DecryptDataException;
import xjyb.cn.org.bjca.exception.EncryptDataException;
import xjyb.cn.org.bjca.exception.GetCertInfoException;
import xjyb.cn.org.bjca.exception.HashException;
import xjyb.cn.org.bjca.exception.Pkcs7DecodeException;
import xjyb.cn.org.bjca.exception.Pkcs7SignException;
import xjyb.cn.org.bjca.exception.RandomNumberException;
import xjyb.cn.org.bjca.exception.RsaEncryptException;
import xjyb.cn.org.bjca.exception.RsaVerifySignException;
import xjyb.cn.org.bjca.security.SecurityUtil;

public class TestSecurityUtil
extends TestCase {
    Properties properties = new Properties();
    SecurityUtil secUtil = null;

    protected void setUp() throws Exception {
        Security.addProvider(new BouncyCastleProvider());
        this.properties.load(new FileInputStream("src/test/junit/test_util.properties"));
        this.secUtil = SecurityUtil.getInstance();
    }

    protected void tearDown() throws Exception {
    }

    public void testGenRandom() throws RandomNumberException, Base64Exception {
        String random = this.secUtil.genRandom();
        System.out.println("\u751f\u6210\u7684\u968f\u673a\u6570\u4e3a\uff1a" + random);
    }

    public void testGenRandomInt() throws RandomNumberException, Base64Exception {
        System.out.println("\u4f20\u51651\uff0c\u751f\u6210\u7684\u968f\u673a\u6570\u4e3a: " + this.secUtil.genRandom(1));
        System.out.println("\u4f20\u516513\uff0c\u751f\u6210\u7684\u968f\u673a\u6570\u4e3a: " + this.secUtil.genRandom(13));
    }

    public void testGetCertInfo() throws Base64Exception, GetCertInfoException {
        String[] title = new String[]{"\u8bc1\u4e66\u7248\u672c", "\u8bc1\u4e66\u5e8f\u5217\u53f7", "\u6458\u8981\u7b7e\u540d\u7b97\u6cd5\u540d\u79f0", "\u8bc1\u4e66\u53d1\u653e\u8005\u56fd\u5bb6\u540d", "\u8bc1\u4e66\u53d1\u653e\u8005\u7ec4\u7ec7\u540d", "\u8bc1\u4e66\u53d1\u653e\u8005\u90e8\u95e8\u540d", "\u8bc1\u4e66\u53d1\u653e\u8005\u7701\u5dde\u540d", "\u8bc1\u4e66\u53d1\u653e\u8005\u901a\u7528\u540d", "\u8bc1\u4e66\u53d1\u653e\u8005\u57ce\u5e02\u540d", "\u8bc1\u4e66\u53d1\u653e\u8005EMAIL\u5730\u5740", "\u8bc1\u4e66\u6709\u6548\u671f\u8d77\u59cb", "\u8bc1\u4e66\u6709\u6548\u671f\u622a\u6b62", "\u7528\u6237\u56fd\u5bb6\u540d", "\u7528\u6237\u7ec4\u7ec7\u540d", "\u7528\u6237\u90e8\u95e8\u540d", "\u7528\u6237\u7701\u5dde\u540d", "\u7528\u6237\u901a\u7528\u540d", "\u7528\u6237\u57ce\u5e02\u540d", "\u7528\u6237EMAIL\u5730\u5740"};
        String cert = this.properties.getProperty("userCert");
        for (int i = 1; i < 20; ++i) {
            System.out.println(title[i - 1] + ": " + this.secUtil.getCertInfo(cert, i));
        }
        System.out.println("\u6d4b\u8bd5\u83b7\u53d6\u8bc1\u4e66\u4fe1\u606f\uff0c\u4f20\u5165-1\uff1a" + this.secUtil.getCertInfo(cert, -1));
        System.out.println("\u6d4b\u8bd5\u83b7\u53d6\u8bc1\u4e66\u4fe1\u606f\uff0c\u4f20\u516550\uff1a" + this.secUtil.getCertInfo(cert, 50));
    }

    public void testGetCertInfoByOid() throws Base64Exception, GetCertInfoException {
        String cert = this.properties.getProperty("userCert");
        String oid = this.properties.getProperty("oid");
        System.out.println("\u6d4b\u8bd5\u901a\u8fc7OID\u83b7\u53d6\u8bc1\u4e66\u6269\u5c55\u4fe1\u606f\uff1a" + this.secUtil.getCertInfoByOid(cert, oid));
    }

    public void testEncryptData() throws EncryptDataException, IOException, Base64Exception {
        String key = this.properties.getProperty("data_symencry_key");
        String data = this.properties.getProperty("data_symencry_data");
        System.out.println("\u4f7f\u7528\u5bf9\u79f0\u7b97\u6cd5\u52a0\u5bc6\u6570\u636e\uff0c\u5bc6\u94a5\u4e3a: " + key);
        System.out.println("\u4f7f\u7528\u5bf9\u79f0\u7b97\u6cd5\u52a0\u5bc6\u6570\u636e\uff0c\u5f85\u52a0\u5bc6\u660e\u6587\u4e3a\uff1a" + data);
        System.out.println("\u4f7f\u7528\u5bf9\u79f0\u7b97\u6cd5\u52a0\u5bc6\u6570\u636e\uff0c\u5bc6\u6587\u4e3a\uff1a" + this.secUtil.encryptData(key, data));
    }

    public void testDecryptData() throws DecryptDataException, Base64Exception, IOException, EncryptDataException {
        String key = this.properties.getProperty("data_symencry_key");
        String data = this.properties.getProperty("data_symencry_data");
        String eString = this.secUtil.encryptData(key, data);
        String dString = this.secUtil.decryptData(key, eString);
        System.out.println("\u4f7f\u7528\u5bf9\u79f0\u7b97\u6cd5\u89e3\u5bc6\u6570\u636e\uff0c\u5bc6\u94a5\u4e3a: " + key);
        System.out.println("\u4f7f\u7528\u5bf9\u79f0\u7b97\u6cd5\u89e3\u5bc6\u6570\u636e\uff0c\u5bc6\u6587\u4e3a: " + eString);
        System.out.println("\u4f7f\u7528\u5bf9\u79f0\u7b97\u6cd5\u89e3\u5bc6\u6570\u636e\uff0c\u660e\u6587\u4e3a: " + dString);
        TestSecurityUtil.assertEquals((String)"\u4f7f\u7528\u5bf9\u79f0\u7b97\u6cd5\u89e3\u5bc6\u51fa\u9519", (String)this.secUtil.decryptData(key, this.secUtil.encryptData(key, data)), (String)data);
    }

    public void testEncryptFile() throws Base64Exception, EncryptDataException {
        String key = this.properties.getProperty("file_symencry_key");
        String inPath = this.properties.getProperty("file_symencry_inPath");
        String outPath = this.properties.getProperty("file_symencry_outPath");
        System.out.println("\u52a0\u5bc6\u6587\u4ef6\uff0c\u5bc6\u94a5\u4e3a\uff1a" + key);
        System.out.println("\u52a0\u5bc6\u6587\u4ef6\uff0c\u6587\u4ef6\u8def\u5f84\u4e3a\uff1a" + inPath);
        System.out.println("\u52a0\u5bc6\u6587\u4ef6\uff0c\u52a0\u5bc6\u540e\u6587\u4ef6\u8def\u5f84\u4e3a\uff1a" + outPath);
        System.out.println(this.secUtil.encryptFile(key, inPath, outPath) ? "\u6587\u4ef6\u52a0\u5bc6\u6210\u529f!" : "\u6587\u4ef6\u52a0\u5bc6\u5931\u8d25!");
        TestSecurityUtil.assertTrue((boolean)this.secUtil.encryptFile(key, inPath, outPath));
    }

    public void testDecryptFile() throws Base64Exception, DecryptDataException {
        String key = this.properties.getProperty("file_symencry_key");
        String inPath = this.properties.getProperty("file_symencry_outPath");
        String outPath = this.properties.getProperty("file_sysdecry_outPath");
        System.out.println("\u4f7f\u7528\u5bf9\u79f0\u7b97\u6cd5\u89e3\u5bc6\u6587\u4ef6\uff0c\u5bc6\u94a5\u4e3a\uff1a" + key);
        System.out.println("\u4f7f\u7528\u5bf9\u79f0\u7b97\u6cd5\u89e3\u5bc6\u6587\u4ef6\uff0c\u52a0\u5bc6\u7684\u6587\u4ef6\u8def\u5f84\u4e3a\uff1a" + inPath);
        System.out.println("\u4f7f\u7528\u5bf9\u79f0\u7b97\u6cd5\u89e3\u5bc6\u6587\u4ef6\uff0c\u89e3\u5bc6\u540e\u7684\u6587\u4ef6\u8def\u5f84\u4e3a\uff1a" + outPath);
        TestSecurityUtil.assertTrue((boolean)this.secUtil.decryptFile(key, inPath, outPath));
    }

    public void testBase64Encode() throws Base64Exception {
        String inString = this.properties.getProperty("data_base64_encode");
        byte[] inData = inString.getBytes();
        String result = this.secUtil.base64Encode(inData);
        System.out.println("Base64\u7f16\u7801\u524d\u7684\u6570\u636e\u4e3a:" + new String(inData));
        System.out.println("Base64\u7f16\u7801\u540e\u7684\u6570\u636e\u4e3a:" + result);
    }

    public void testBase64Decode() throws Base64Exception {
        String inString = this.properties.getProperty("data_base64_decode");
        byte[] result = this.secUtil.base64Decode(inString);
        System.out.println("base64\u89e3\u7801\u524d\u7684\u6570\u636e\u4e3a: " + inString);
        System.out.println("base64\u89e3\u7801\u540e\u7684\u6570\u636e\u4e3a: " + new String(result));
    }

    public void testVerifySignedData() throws Base64Exception, HashException, GetCertInfoException, RsaVerifySignException {
        String cert = this.properties.getProperty("userCert");
        String inData = this.properties.getProperty("data_sign");
        inData = "abc123";
        String signValue = this.properties.getProperty("data_signed");
        boolean result = this.secUtil.verifySignedData(cert, inData, signValue);
        System.out.println(result ? "\u9a8c\u8bc1\u6570\u636e\u7b7e\u540d\u6210\u529f!" : "\u9a8c\u8bc1\u7b7e\u540d\u6570\u636e\u5931\u8d25!");
    }

    public void testGetP7SignDataInfo() throws InvalidKeyException, SecurityException, CRLException, NoSuchProviderException, NoSuchAlgorithmException, CertificateException, SignatureException, Base64Exception, Pkcs7SignException, Pkcs7DecodeException {
        String pkcs7SignData = this.properties.getProperty("data_p7signdata");
        int type = 1;
        type = Integer.MAX_VALUE;
        String result = this.secUtil.getP7SignDataInfo(pkcs7SignData, type);
        System.out.println("\u89e3\u6790p7\u7b7e\u540d\u5305\u4fe1\u606f\uff0c\u60f3\u83b7\u53d6\u7684\u4fe1\u606f\u7c7b\u578b\u4e3a(1.\u539f\u6587\uff0c2.\u7b7e\u540d\u8005\u8bc1\u4e66):");
        System.out.println("\u89e3\u6790p7\u7b7e\u540d\u5305\u4fe1\u606f 1: " + result);
        System.out.println("\u89e3\u6790p7\u7b7e\u540d\u5305\u4fe1\u606f 2: " + this.secUtil.getP7SignDataInfo(pkcs7SignData, 2));
    }

    public void testHash_string() throws HashException, Base64Exception {
        String inData = this.properties.getProperty("data_hash_string");
        String result = this.secUtil.hash_string(inData);
        System.out.println("\u5f85\u53d6hash\u503c\u5b57\u7b26\u4e32\u662f:" + inData);
        System.out.println("\u5b57\u7b26\u4e32\u7684hash\u503c\u662f: " + result);
    }

    public void testPubKeyEncrypt() throws Base64Exception, GetCertInfoException, RsaEncryptException {
        String inData = this.properties.getProperty("data_pubkeyencrypt");
        String cert = this.properties.getProperty("userCert");
        String result = this.secUtil.pubKeyEncrypt(cert, inData);
        System.out.println("\u516c\u94a5\u52a0\u5bc6, \u52a0\u5bc6\u4f7f\u7528\u7684\u8bc1\u4e66\u662f:" + cert);
        System.out.println("\u516c\u94a5\u52a0\u5bc6, \u5f85\u52a0\u5bc6\u7684\u6570\u636e\u662f:" + inData);
        System.out.println("\u516c\u94a5\u52a0\u5bc6, \u52a0\u5bc6\u540e\u7684\u5bc6\u6587\u662f:" + result);
    }
}

