/*
 * Decompiled with CFR 0.152.
 */
package xjyb.bjca.org.apache.log4j;

import java.net.MalformedURLException;
import java.net.URL;
import java.util.Enumeration;
import xjyb.bjca.org.apache.log4j.Hierarchy;
import xjyb.bjca.org.apache.log4j.Level;
import xjyb.bjca.org.apache.log4j.Logger;
import xjyb.bjca.org.apache.log4j.helpers.Loader;
import xjyb.bjca.org.apache.log4j.helpers.LogLog;
import xjyb.bjca.org.apache.log4j.helpers.OptionConverter;
import xjyb.bjca.org.apache.log4j.spi.DefaultRepositorySelector;
import xjyb.bjca.org.apache.log4j.spi.LoggerFactory;
import xjyb.bjca.org.apache.log4j.spi.LoggerRepository;
import xjyb.bjca.org.apache.log4j.spi.NOPLoggerRepository;
import xjyb.bjca.org.apache.log4j.spi.RepositorySelector;
import xjyb.bjca.org.apache.log4j.spi.RootLogger;

public class LogManager {
    public static final String DEFAULT_CONFIGURATION_FILE = "";
    static final String DEFAULT_XML_CONFIGURATION_FILE = "";
    public static final String DEFAULT_CONFIGURATION_KEY = "";
    public static final String CONFIGURATOR_CLASS_KEY = "";
    public static final String DEFAULT_INIT_OVERRIDE_KEY = "";
    private static Object guard = null;
    private static RepositorySelector repositorySelector;

    static {
        Hierarchy h = new Hierarchy(new RootLogger(Level.DEBUG));
        repositorySelector = new DefaultRepositorySelector(h);
        String override = OptionConverter.getSystemProperty("", null);
        if (override == null || "false".equalsIgnoreCase(override)) {
            String configurationOptionStr = OptionConverter.getSystemProperty("", null);
            String configuratorClassName = OptionConverter.getSystemProperty("", null);
            URL url = null;
            if (configurationOptionStr == null) {
                url = Loader.getResource("");
                if (url == null) {
                    url = Loader.getResource("");
                }
            } else {
                try {
                    url = new URL(configurationOptionStr);
                }
                catch (MalformedURLException ex) {
                    url = Loader.getResource(configurationOptionStr);
                }
            }
            if (url != null) {
                LogLog.debug("Using URL [" + url + "] for automatic log4j configuration.");
                try {
                    OptionConverter.selectAndConfigure(url, configuratorClassName, LogManager.getLoggerRepository());
                }
                catch (NoClassDefFoundError e) {
                    LogLog.warn("Error during default initialization", e);
                }
            } else {
                LogLog.debug("Could not find resource: [" + configurationOptionStr + "].");
            }
        }
    }

    public static void setRepositorySelector(RepositorySelector selector, Object guard) throws IllegalArgumentException {
        if (LogManager.guard != null && LogManager.guard != guard) {
            throw new IllegalArgumentException("Attempted to reset the LoggerFactory without possessing the guard.");
        }
        if (selector == null) {
            throw new IllegalArgumentException("RepositorySelector must be non-null.");
        }
        LogManager.guard = guard;
        repositorySelector = selector;
    }

    public static LoggerRepository getLoggerRepository() {
        if (repositorySelector == null) {
            repositorySelector = new DefaultRepositorySelector(new NOPLoggerRepository());
            guard = null;
            LogLog.error("LogMananger.repositorySelector was null likely due to error in class reloading, using NOPLoggerRepository.");
        }
        return repositorySelector.getLoggerRepository();
    }

    public static Logger getRootLogger() {
        return LogManager.getLoggerRepository().getRootLogger();
    }

    public static Logger getLogger(String name) {
        return LogManager.getLoggerRepository().getLogger(name);
    }

    public static Logger getLogger(Class clazz) {
        return LogManager.getLoggerRepository().getLogger(clazz.getName());
    }

    public static Logger getLogger(String name, LoggerFactory factory) {
        return LogManager.getLoggerRepository().getLogger(name, factory);
    }

    public static Logger exists(String name) {
        return LogManager.getLoggerRepository().exists(name);
    }

    public static Enumeration getCurrentLoggers() {
        return LogManager.getLoggerRepository().getCurrentLoggers();
    }

    public static void shutdown() {
        LogManager.getLoggerRepository().shutdown();
    }

    public static void resetConfiguration() {
        LogManager.getLoggerRepository().resetConfiguration();
    }
}

