/*
 * Decompiled with CFR 0.152.
 */
package xjyb.bjca.org.multi.util.log;

import xjyb.bjca.org.apache.log4j.Layout;
import xjyb.bjca.org.apache.log4j.Level;
import xjyb.bjca.org.apache.log4j.Logger;
import xjyb.bjca.org.apache.log4j.PatternLayout;
import xjyb.bjca.org.multi.util.exceptions.LoggerException;
import xjyb.bjca.org.multi.util.log.AbstractLogger;
import xjyb.bjca.org.multi.util.log.LoggerRes;
import xjyb.bjca.org.multi.util.log.MyRollingFileAppender;

public class SystemLogger
extends AbstractLogger {
    public SystemLogger(LoggerRes res) throws LoggerException {
        this.createSystemlogger(res);
    }

    public void Log(String msg) {
        this.logger.info(msg);
    }

    private void createSystemlogger(LoggerRes loggerres) throws LoggerException {
        if (loggerres.IsUseRemoteLogger()) {
            throw new LoggerException("Now We Can not Implement The Remote Logger");
        }
        String logFile = loggerres.getLogFile();
        this.logger = Logger.getLogger(loggerres.getLoggerName());
        this.logger.removeAllAppenders();
        PatternLayout layout = new PatternLayout();
        layout.setConversionPattern("%-5p  [%d{yyyy-MM-dd HH:mm:ss S}] %m%n");
        MyRollingFileAppender da = null;
        try {
            da = new MyRollingFileAppender((Layout)layout, logFile);
            da.setMaxBackupIndex(loggerres.getMaxBackUpIndex());
            da.setMaxFileSize(loggerres.getMaxFileSize());
            this.logger.addAppender(da);
            this.logger.setLevel(Level.INFO);
        }
        catch (Exception ex) {
            throw new LoggerException(ex);
        }
    }

    public static void main(String[] args) throws Exception {
        LoggerRes res = new LoggerRes();
        res.setLogFile("system2.log");
        res.setMaxFileSize("1kb");
        res.setMaxBackupIndex(10);
        res.setLoggerName("system");
        SystemLogger logger = new SystemLogger(res);
        int i = 0;
        while (i < 100) {
            logger.Log("start  ok");
            ++i;
        }
    }
}

