/*
 * Decompiled with CFR 0.152.
 */
package xjyb.cn.org.bjca.java.utils;

import java.io.ByteArrayInputStream;
import java.text.SimpleDateFormat;
import org.bouncycastle.asn1.cms.CMSAttributes;
import xjyb.cn.org.bjca.exception.Pkcs7DecodeException;
import xjyb.cn.org.bjca.utils.Base64Util;
import xjyb.org.bjca.asn1.ASN1EncodableVector;
import xjyb.org.bjca.asn1.ASN1Object;
import xjyb.org.bjca.asn1.ASN1Set;
import xjyb.org.bjca.asn1.ASN1TaggedObject;
import xjyb.org.bjca.asn1.DERConstructedSequence;
import xjyb.org.bjca.asn1.DERConstructedSet;
import xjyb.org.bjca.asn1.DEREncodable;
import xjyb.org.bjca.asn1.DERInputStream;
import xjyb.org.bjca.asn1.DERObjectIdentifier;
import xjyb.org.bjca.asn1.DEROctetString;
import xjyb.org.bjca.asn1.DERSet;
import xjyb.org.bjca.asn1.DERTaggedObject;
import xjyb.org.bjca.asn1.DERUTCTime;

public class GetP7InfoUtil {
    public static Object[] checkIsAttr(byte[] p7sign) throws Exception {
        DERConstructedSet signerinfos;
        byte[][] rets = new byte[6][];
        Object[] returnObjs = new Object[2];
        DERInputStream derInputStream = new DERInputStream(new ByteArrayInputStream(p7sign));
        if (derInputStream == null) {
            throw new Exception("get DERInputStream is null");
        }
        DERConstructedSequence whole = (DERConstructedSequence)derInputStream.readObject();
        if (whole == null) {
            throw new Exception("get DERConstructedSequence is null");
        }
        DERTaggedObject tagObj = (DERTaggedObject)whole.getObjectAt(1);
        if (tagObj == null) {
            throw new Exception("get DERTaggedObject is null");
        }
        DERConstructedSequence body = (DERConstructedSequence)tagObj.getObject();
        if (body == null) {
            throw new Exception("get DERConstructedSequence is null");
        }
        DERConstructedSequence contextObj = (DERConstructedSequence)body.getObjectAt(2);
        if (contextObj != null && contextObj.size() >= 2) {
            DERTaggedObject cxtDerTaggedObject = (DERTaggedObject)contextObj.getObjectAt(1);
            DEROctetString derOctetString = (DEROctetString)cxtDerTaggedObject.getObject();
            returnObjs[1] = derOctetString.getOctets();
        }
        if ((signerinfos = (DERConstructedSet)body.getObjectAt(4)) == null) {
            throw new Exception("get signerinfos is null");
        }
        DERConstructedSequence signerinfo = (DERConstructedSequence)signerinfos.getObjectAt(0);
        if (signerinfo == null) {
            throw new Exception("get signerinfo is null");
        }
        DEREncodable object = signerinfo.getObjectAt(3);
        if (object instanceof DERTaggedObject) {
            DERTaggedObject derSequence = (DERTaggedObject)object;
            DERConstructedSequence derSequence2 = (DERConstructedSequence)derSequence.getObject();
            if (derSequence2 != null) {
                ASN1EncodableVector attributeVector = new ASN1EncodableVector();
                for (int i = 0; i < derSequence2.size(); ++i) {
                    attributeVector.add(derSequence2.getObjectAt(i));
                }
                DERSet derRSet = new DERSet(attributeVector);
                rets[2] = derRSet.getDEREncoded();
            }
        } else if (object instanceof DERConstructedSet) {
            DERConstructedSet derSequence = (DERConstructedSet)object;
            rets[2] = derSequence.getEncoded();
        }
        returnObjs[0] = rets[2] != null ? Boolean.valueOf(true) : Boolean.valueOf(false);
        return returnObjs;
    }

    public static String[] getAttrsFromP7(byte[] p7sign) throws Exception {
        String[] attrsStrings = new String[3];
        byte[][] infos = GetP7InfoUtil.getAttributeSignValueAndCert(p7sign);
        if (infos != null && infos.length >= 3) {
            ByteArrayInputStream byteArrayInputStream = new ByteArrayInputStream(infos[2]);
            if (byteArrayInputStream == null) {
                throw new Pkcs7DecodeException("construct ByteArrayInputStream is null");
            }
            DERInputStream derInputStream = new DERInputStream(byteArrayInputStream);
            if (derInputStream == null) {
                throw new Pkcs7DecodeException("construct DERInputStream is null");
            }
            DERConstructedSet derSet = (DERConstructedSet)derInputStream.readObject();
            if (derSet == null) {
                throw new Pkcs7DecodeException("get DERConstructedSet is null");
            }
            for (int i = 0; i < derSet.getSize(); ++i) {
                DERConstructedSequence attrSequence = (DERConstructedSequence)derSet.getObjectAt(i);
                DERObjectIdentifier derObjectIdentifier = (DERObjectIdentifier)attrSequence.getObjectAt(0);
                if (attrSequence == null) continue;
                DERConstructedSet attrSet = (DERConstructedSet)attrSequence.getObjectAt(1);
                if (CMSAttributes.contentType.getId().equals(derObjectIdentifier.getId())) {
                    DERObjectIdentifier contentTypeIdentifier = (DERObjectIdentifier)attrSet.getObjectAt(0);
                    attrsStrings[0] = contentTypeIdentifier.toString();
                    continue;
                }
                if (CMSAttributes.signingTime.getId().equals(derObjectIdentifier.getId())) {
                    DERUTCTime utcTime = (DERUTCTime)attrSet.getObjectAt(0);
                    SimpleDateFormat dateFormat = new SimpleDateFormat("yyyyMMddHHmmss");
                    attrsStrings[1] = dateFormat.format(utcTime.getDate());
                    continue;
                }
                if (!CMSAttributes.messageDigest.getId().equals(derObjectIdentifier.getId())) continue;
                DEROctetString derOctetString = (DEROctetString)attrSet.getObjectAt(0);
                Base64Util base64Util = new Base64Util("");
                attrsStrings[2] = base64Util.BJS_EncodeBase64(derOctetString.getOctets());
            }
        }
        return attrsStrings;
    }

    public static byte[][] getAttributeSignValueAndCert(byte[] p7sign) throws Exception {
        DERConstructedSequence derSequence2;
        ASN1Object derSequence;
        byte[][] rets = new byte[6][];
        DERInputStream derInputStream = new DERInputStream(new ByteArrayInputStream(p7sign));
        if (derInputStream == null) {
            return null;
        }
        DERConstructedSequence whole = (DERConstructedSequence)derInputStream.readObject();
        if (whole == null) {
            return null;
        }
        DERTaggedObject tagObj = (DERTaggedObject)whole.getObjectAt(1);
        if (tagObj == null) {
            return null;
        }
        DERConstructedSequence body = (DERConstructedSequence)tagObj.getObject();
        if (body == null) {
            return null;
        }
        DERConstructedSequence contextObj = (DERConstructedSequence)body.getObjectAt(2);
        if (contextObj != null && contextObj.size() >= 2) {
            DERTaggedObject cxtDerTaggedObject = (DERTaggedObject)contextObj.getObjectAt(1);
            DEROctetString derOctetString = (DEROctetString)cxtDerTaggedObject.getObject();
            rets[4] = derOctetString.getOctets();
        }
        DERTaggedObject certObj = (DERTaggedObject)body.getObjectAt(3);
        DERConstructedSequence dercertificates = (DERConstructedSequence)certObj.getObject();
        rets[0] = dercertificates.getEncoded();
        DERConstructedSet signerinfos = (DERConstructedSet)body.getObjectAt(4);
        if (signerinfos == null) {
            return null;
        }
        DERConstructedSequence signerinfo = (DERConstructedSequence)signerinfos.getObjectAt(0);
        if (signerinfo == null) {
            return null;
        }
        if (signerinfo.size() >= 6) {
            DEROctetString digest = (DEROctetString)signerinfo.getObjectAt(5);
            if (digest == null) {
                return null;
            }
            rets[1] = digest.getOctets();
        } else {
            rets[1] = null;
        }
        DEREncodable object = signerinfo.getObjectAt(3);
        if (object instanceof DERTaggedObject) {
            derSequence = (DERTaggedObject)object;
            derSequence2 = (DERConstructedSequence)((ASN1TaggedObject)derSequence).getObject();
            if (derSequence2 != null) {
                ASN1EncodableVector attributeVector = new ASN1EncodableVector();
                for (int i = 0; i < derSequence2.size(); ++i) {
                    attributeVector.add(derSequence2.getObjectAt(i));
                }
                DERSet derRSet = new DERSet(attributeVector);
                rets[2] = derRSet.getDEREncoded();
                if (derSequence2.size() > 2) {
                    DERConstructedSequence attribute = (DERConstructedSequence)derSequence2.getObjectAt(2);
                    DERConstructedSet derSet = (DERConstructedSet)attribute.getObjectAt(1);
                    DEROctetString derOctetString = (DEROctetString)derSet.getObjectAt(0);
                    rets[3] = derOctetString.getOctets();
                } else if (derSequence2.size() == 2) {
                    DERConstructedSequence attribute = (DERConstructedSequence)derSequence2.getObjectAt(1);
                    DERConstructedSet derSet = (DERConstructedSet)attribute.getObjectAt(1);
                    DEROctetString derOctetString = (DEROctetString)derSet.getObjectAt(0);
                    rets[3] = derOctetString.getOctets();
                }
            }
        } else if (object instanceof DERConstructedSet) {
            derSequence = (DERConstructedSet)object;
            rets[2] = derSequence.getEncoded();
            derSequence2 = (DERConstructedSequence)((ASN1Set)derSequence).getObjectAt(2);
            if (derSequence2 != null) {
                DERConstructedSet derSet = (DERConstructedSet)derSequence2.getObjectAt(1);
                DEROctetString derOctetString = (DEROctetString)derSet.getObjectAt(0);
                rets[3] = derOctetString.getOctets();
            }
        }
        if (signerinfo.size() >= 7) {
            DERTaggedObject dt = (DERTaggedObject)signerinfo.getObjectAt(6);
            if (dt == null) {
                return null;
            }
            DERConstructedSequence unauthenticatedAttributeSequence = (DERConstructedSequence)dt.getObject();
            DERConstructedSet timeStampSet = (DERConstructedSet)unauthenticatedAttributeSequence.getObjectAt(1);
            DERConstructedSequence timeStampConstructedSequence = (DERConstructedSequence)timeStampSet.getObjectAt(0);
            rets[5] = timeStampConstructedSequence.getEncoded();
        }
        return rets;
    }
}

