/*
 * Decompiled with CFR 0.152.
 */
package xjyb.cn.org.bjca.java.utils;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.security.KeyFactory;
import java.security.KeyPair;
import java.security.KeyPairGenerator;
import java.security.NoSuchAlgorithmException;
import java.security.PrivateKey;
import java.security.PublicKey;
import java.security.Signature;
import java.security.cert.Certificate;
import java.security.cert.CertificateFactory;
import java.security.cert.X509Certificate;
import java.security.spec.InvalidKeySpecException;
import java.security.spec.PKCS8EncodedKeySpec;
import java.security.spec.X509EncodedKeySpec;
import xjyb.cn.org.bjca.exception.AlgorithmNotFoundException;
import xjyb.cn.org.bjca.exception.Pkcs7SignException;
import xjyb.cn.org.bjca.framework.SuperUtil;
import xjyb.cn.org.bjca.java.utils.KeyUtil;
import xjyb.cn.org.bjca.java.utils.Pkcs7Util;
import xjyb.cn.org.bjca.security.SecurityUtil;
import xjyb.cn.org.bjca.utils.Base64Util;
import xjyb.cn.org.bjca.utils.CertificateUtil;
import xjyb.com.sansec.device.local.WrapCard;
import xjyb.org.bjca.asn1.ASN1Sequence;
import xjyb.org.bjca.asn1.DERBitString;
import xjyb.org.bjca.asn1.DERConstructedSequence;
import xjyb.org.bjca.asn1.DERInteger;
import xjyb.org.bjca.asn1.DERObjectIdentifier;
import xjyb.org.bjca.asn1.DEROctetString;
import xjyb.org.bjca.asn1.DERTaggedObject;
import xjyb.org.bjca.asn1.x509.AlgorithmIdentifier;
import xjyb.org.bjca.asn1.x509.X509CertificateStructure;
import xjyb.org.bjca.crypto.params.RSAPrivateCrtKeyParameters;
import xjyb.org.bjca.crypto.signers.BJCASigner;
import xjyb.org.bjca.jce.CNPKCS7SignedData;
import xjyb.org.bjca.jce.PKCS7SignedData;
import xjyb.org.bjca.jce.fastparser.DerUtil;
import xjyb.org.bjca.jce.valuebean.DeviceKeyPair;

public class KeyPairUtil
extends SuperUtil {
    private KeyPair keyPair;

    public KeyPairUtil(String appName) {
        super(appName);
    }

    public void generatorKeyPair() {
        KeyPair newkeyPair;
        KeyPairGenerator keyGen = null;
        try {
            keyGen = KeyPairGenerator.getInstance("RSA");
        }
        catch (NoSuchAlgorithmException e) {
            this.errorlog("Exception in KeyPairGenerator !", e);
            this.debuglog("Exception in KeyPairGenerator !");
        }
        this.keyPair = newkeyPair = keyGen.generateKeyPair();
    }

    public void generatorKeyPair(int length) {
        KeyPair newkeyPair;
        KeyPairGenerator keyGen = null;
        try {
            keyGen = KeyPairGenerator.getInstance("RSA");
            keyGen.initialize(length);
        }
        catch (NoSuchAlgorithmException e) {
            this.errorlog("Exception in KeyPairGenerator !", e);
            this.debuglog("Exception in KeyPairGenerator !");
        }
        this.keyPair = newkeyPair = keyGen.generateKeyPair();
    }

    public DeviceKeyPair generatorKeyPair_sm2() {
        WrapCard wc = new WrapCard();
        DeviceKeyPair keyPair = wc.genSm2Keypair();
        return keyPair;
    }

    public PrivateKey getPrivateKey() {
        return this.keyPair.getPrivate();
    }

    public PublicKey getPublicKey() {
        return this.keyPair.getPublic();
    }

    public byte[] getPrivateKeyByte() throws IOException {
        ByteArrayOutputStream byteArrayOutStream = new ByteArrayOutputStream();
        ObjectOutputStream oos = new ObjectOutputStream(byteArrayOutStream);
        oos.writeObject(this.keyPair.getPrivate());
        byte[] realPrivateKeyObjByte = byteArrayOutStream.toByteArray();
        return realPrivateKeyObjByte;
    }

    public byte[] getPublicKeyByte() {
        return this.keyPair.getPublic().getEncoded();
    }

    public KeyPair getKeyPair() {
        return this.keyPair;
    }

    public void setKeyPair(KeyPair keyPair) {
        this.keyPair = keyPair;
    }

    public byte[] createPrivateKey_sm2(DeviceKeyPair keyPairs) throws Exception {
        AlgorithmIdentifier derAlgEncKey = new AlgorithmIdentifier(new DERObjectIdentifier("1.2.840.10045.2.1"), new DERObjectIdentifier("1.2.156.10197.1.301"));
        DERConstructedSequence privateKeySM2 = new DERConstructedSequence();
        privateKeySM2.addObject(new DERInteger(0));
        privateKeySM2.addObject(derAlgEncKey);
        DERConstructedSequence pubAndPriKey = new DERConstructedSequence();
        pubAndPriKey.addObject(new DERInteger(1));
        pubAndPriKey.addObject(new DEROctetString(keyPairs.getPrivateKey()));
        pubAndPriKey.addObject(new DERTaggedObject(0, new DERObjectIdentifier("1.2.156.10197.1.301")));
        byte[] pubKey = new byte[keyPairs.getPublicKey().length + 1];
        pubKey[0] = 4;
        System.arraycopy(keyPairs.getPublicKey(), 0, pubKey, 1, keyPairs.getPublicKey().length);
        pubAndPriKey.addObject(new DERTaggedObject(1, new DERBitString(pubKey)));
        privateKeySM2.addObject(new DEROctetString(pubAndPriKey));
        return privateKeySM2.getEncoded();
    }

    public PrivateKey createPrivateKeyWithKeyEncoded(byte[] priKeyEncodedBytes) throws AlgorithmNotFoundException, InvalidKeySpecException {
        PrivateKey privateKeyO = null;
        try {
            PKCS8EncodedKeySpec pkcs8KeySpec = new PKCS8EncodedKeySpec(priKeyEncodedBytes);
            KeyFactory factory = KeyFactory.getInstance("RSA");
            privateKeyO = factory.generatePrivate(pkcs8KeySpec);
        }
        catch (NoSuchAlgorithmException e) {
            throw new AlgorithmNotFoundException("CreatePrivateKey Exception", e);
        }
        catch (InvalidKeySpecException e) {
            throw new InvalidKeySpecException("Invalid KeySpec Exception", e);
        }
        return privateKeyO;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public PrivateKey createPrivateKey(byte[] key) throws IOException, ClassNotFoundException {
        ByteArrayInputStream in = null;
        ObjectInputStream oIn = null;
        PrivateKey privateKeyO = null;
        try {
            in = new ByteArrayInputStream(key);
            oIn = new ObjectInputStream(in);
            privateKeyO = (PrivateKey)oIn.readObject();
        }
        catch (IOException e) {
            this.errorlog("Exception in createPrivateKey!", e);
            this.debuglog("Exception in createPrivateKey!");
        }
        finally {
            if (oIn != null) {
                oIn.close();
            }
            if (in != null) {
                ((InputStream)in).close();
            }
        }
        return privateKeyO;
    }

    public PublicKey createPublicKey(byte[] key) throws InvalidKeySpecException, AlgorithmNotFoundException {
        PublicKey publicKey = null;
        X509EncodedKeySpec spec = new X509EncodedKeySpec(key);
        try {
            KeyFactory factory1 = KeyFactory.getInstance("RSA");
            publicKey = factory1.generatePublic(spec);
        }
        catch (NoSuchAlgorithmException e) {
            throw new AlgorithmNotFoundException("CreatePublicKey Exception", e);
        }
        catch (InvalidKeySpecException e) {
            throw new InvalidKeySpecException("Invalid KeySpec Exception", e);
        }
        return publicKey;
    }

    public byte[] signHashedData(byte[] hashedContent) {
        KeyUtil keyUtil = new KeyUtil(this.applicationName);
        RSAPrivateCrtKeyParameters privateCrtKey = keyUtil.getPrivateKey(this.keyPair.getPrivate());
        byte[] signedData = null;
        BJCASigner bjcaSigner = new BJCASigner();
        bjcaSigner.init(true, privateCrtKey);
        bjcaSigner.update(hashedContent, 0, hashedContent.length);
        try {
            signedData = bjcaSigner.generateSignature();
        }
        catch (Exception e) {
            this.errorlog("Exception in signData by once private crt key!", e);
            this.debuglog("Exception in signData by once private crt key!");
        }
        return signedData;
    }

    public byte[] signHashedData(byte[] hashedContent, PrivateKey privateKey) {
        KeyUtil keyUtil = new KeyUtil(this.applicationName);
        RSAPrivateCrtKeyParameters privateCrtKey = keyUtil.getPrivateKey(privateKey);
        byte[] signedData = null;
        BJCASigner bjcaSigner = new BJCASigner();
        bjcaSigner.init(true, privateCrtKey);
        bjcaSigner.update(hashedContent, 0, hashedContent.length);
        try {
            signedData = bjcaSigner.generateSignature();
        }
        catch (Exception e) {
            this.errorlog("Exception in signData by once private crt key!", e);
            this.debuglog("Exception in signData by once private crt key!");
        }
        return signedData;
    }

    public byte[] signHashedData(byte[] hashedContent, byte[] privateKey) {
        byte[] signedData = null;
        try {
            WrapCard wCard = new WrapCard();
            signedData = wCard.sm2SignWithHashedData(hashedContent, privateKey);
        }
        catch (Exception e) {
            this.errorlog("Exception in sm2 signature with hashed Data!", e);
            return null;
        }
        return signedData;
    }

    public byte[] signHashedDataByP7DetachAttribute(byte[] hashedContent, byte[] signCertBytes, PrivateKey privateKey, byte[] privateKeyByte) {
        Pkcs7Util pkcs7Util = new Pkcs7Util("");
        int init_model = 0;
        CertificateUtil certificateUtil = new CertificateUtil("");
        String algorithmType = certificateUtil.BJC_GetBasicCertInfo(signCertBytes, 31L);
        if ("RSA".equals(algorithmType)) {
            init_model = 4;
        } else if ("ECC".equals(algorithmType)) {
            init_model = 8;
        }
        try {
            return pkcs7Util.signAttributeP7(hashedContent, init_model, signCertBytes, null, null, privateKey, privateKeyByte, null);
        }
        catch (Pkcs7SignException e) {
            e.printStackTrace();
            return null;
        }
    }

    public byte[] signHashedDataByP7Detach(byte[] hashedContent, byte[] signCertBytes, PrivateKey privateKey) throws IOException, Pkcs7SignException {
        InputStream ois = null;
        try {
            byte[] p7SignData;
            CertificateFactory oCf = CertificateFactory.getInstance("X.509");
            ois = new ByteArrayInputStream(signCertBytes);
            X509Certificate oCert = (X509Certificate)oCf.generateCertificate(ois);
            Certificate[] certs = new Certificate[]{oCert};
            byte[] signedBuf = null;
            KeyUtil keyUtil = new KeyUtil(this.applicationName);
            RSAPrivateCrtKeyParameters privateCrtKey = keyUtil.getPrivateKey(privateKey);
            BJCASigner bjcaSigner = new BJCASigner();
            bjcaSigner.init(true, privateCrtKey);
            bjcaSigner.update(hashedContent, 0, hashedContent.length);
            try {
                signedBuf = bjcaSigner.generateSignature();
            }
            catch (Exception e) {
                this.errorlog("Exception in signData by once private crt key!", e);
                this.debuglog("Exception in signData by once private crt key!");
            }
            PKCS7SignedData p7sign = new PKCS7SignedData(certs, null, "SHA1", "");
            byte[] byArray = p7SignData = p7sign.getEncoded(signedBuf, null);
            return byArray;
        }
        catch (Exception e) {
            this.errorlog("Exception in signing data by pkcs7!", e);
            this.debuglog("Exception in signing data by pkcs7!");
            throw new Pkcs7SignException("Exception in signing data by pkcs7!");
        }
        finally {
            if (ois != null) {
                ois.close();
            }
        }
    }

    public byte[] signHashedDataByP7Detach_sm2(byte[] hashedContent, byte[] signCertBytes, byte[] privateKey) throws Pkcs7SignException {
        try {
            byte[] p7SignData = null;
            X509CertificateStructure x509Cert = new X509CertificateStructure((ASN1Sequence)DerUtil.getDerObject(signCertBytes));
            X509CertificateStructure[] x509Certs = new X509CertificateStructure[]{x509Cert};
            WrapCard wCard = new WrapCard();
            byte[] signedData = wCard.sm2SignWithHashedData(hashedContent, privateKey);
            CNPKCS7SignedData cnP7sign = new CNPKCS7SignedData(x509Certs, null, "SM3", "");
            p7SignData = cnP7sign.getEncoded(signedData, null);
            return p7SignData;
        }
        catch (Exception e) {
            this.errorlog("Exception in signing data by pkcs7!", e);
            this.debuglog("Exception in signing data by pkcs7!");
            throw new Pkcs7SignException("Exception in signing data by pkcs7!");
        }
    }

    public byte[] signData(byte[] inData) {
        byte[] signedBuf = null;
        try {
            Signature oSign = Signature.getInstance("SHA1withRSA");
            oSign.initSign(this.keyPair.getPrivate());
            oSign.update(inData);
            signedBuf = oSign.sign();
        }
        catch (Exception e) {
            this.errorlog("Exception in signData by once private key!", e);
            this.debuglog("Exception in signData by once private key!");
        }
        return signedBuf;
    }

    public byte[] signData(byte[] inData, PrivateKey privateKey) {
        byte[] signedBuf = null;
        try {
            Signature oSign = Signature.getInstance("SHA1withRSA");
            oSign.initSign(privateKey);
            oSign.update(inData);
            signedBuf = oSign.sign();
        }
        catch (Exception e) {
            this.errorlog("Exception in signData by once private key!", e);
            this.debuglog("Exception in signData by once private key!");
        }
        return signedBuf;
    }

    public static void main(String[] str) {
        try {
            KeyPairUtil keyPairU = new KeyPairUtil("");
            Base64Util base64U = new Base64Util("");
            String testCert = "MIICETCCAbigAwIBAgIKEKAAAAAAAAAAAzAKBggqgRzPVQGDdTBmMQswCQYDVQQGDAJDTjEQMA4GA1UECAwHQmVpSmluZzEQMA4GA1UEBwwHQmVpSmluZzENMAsGA1UECgwEQVhUWDENMAsGA1UECwwEQVhUWDEVMBMGA1UEAwwMRUND5LqM57qn5qC5MB4XDTExMTEwODA4MDEzN1oXDTEyMTEwODA4MDEzN1owPTELMAkGA1UEBhMCQ04xDTALBgNVBAoMBGJqY2ExDTALBgNVBAsMBGJqY2ExEDAOBgNVBAMMB3NtMmNlcnQwWTATBgcqhkjOPQIBBggqgRzPVQGCLQNCAAQpmchGphP65/ofGrxsgx0CsR4lRaGSJ3bM/kFc2HO5murbre1onXHvNBU7R6crej3tQvLsn2RSV2nXcGVjWK8wo3cwdTAJBgNVHRMEAjAAMAsGA1UdDwQEAwIGwDAbBghghkgBhvhEAgEBAAQMMjAxMTExMDgxNjAzMB0GA1UdDgQWBBTarxifM+zetL5Kd3AHhYhndD2sCzAfBgNVHSMEGDAWgBRWxQbIOP6wnm0/fKCXSKIWFNfeJTAKBggqgRzPVQGDdQNHADBEAiAPiT59agG7z0kLRqfz2PZZM+LQrCEo+AkhUJkqOVGP4gIgTHrXFXNgZ03HoGNCWyE2mDzf5/dPgSOO+VYF2Gqmu2Y=";
            byte[] inData = "hello".getBytes();
            DeviceKeyPair sm2KeyPair = keyPairU.generatorKeyPair_sm2();
            SecurityUtil secU = SecurityUtil.getInstance();
            byte[] hashedContent = secU.hash_byte(inData, sm2KeyPair.getPublicKey());
            byte[] signedData = keyPairU.signHashedDataByP7Detach_sm2(hashedContent, base64U.BJS_DecodeBase64(testCert), sm2KeyPair.getPrivateKey());
            System.out.println(signedData.length);
            System.out.println(base64U.BJS_EncodeBase64(signedData));
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }
}

