/*
 * Decompiled with CFR 0.152.
 */
package xjyb.cn.org.bjca.java.utils;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.math.BigInteger;
import java.security.InvalidKeyException;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.security.NoSuchProviderException;
import java.security.PrivateKey;
import java.security.Signature;
import java.security.SignatureException;
import java.security.cert.CRL;
import java.security.cert.Certificate;
import java.security.cert.CertificateException;
import java.security.cert.CertificateFactory;
import java.security.cert.X509CRL;
import java.security.cert.X509Certificate;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Calendar;
import java.util.Collection;
import java.util.Date;
import java.util.Enumeration;
import java.util.GregorianCalendar;
import java.util.HashSet;
import java.util.Set;
import org.bouncycastle.asn1.ASN1Encodable;
import org.bouncycastle.asn1.ASN1EncodableVector;
import org.bouncycastle.asn1.ASN1Enumerated;
import org.bouncycastle.asn1.ASN1InputStream;
import org.bouncycastle.asn1.ASN1Integer;
import org.bouncycastle.asn1.ASN1ObjectIdentifier;
import org.bouncycastle.asn1.ASN1OctetString;
import org.bouncycastle.asn1.ASN1OutputStream;
import org.bouncycastle.asn1.ASN1Primitive;
import org.bouncycastle.asn1.ASN1Sequence;
import org.bouncycastle.asn1.ASN1Set;
import org.bouncycastle.asn1.ASN1TaggedObject;
import org.bouncycastle.asn1.DERNull;
import org.bouncycastle.asn1.DEROctetString;
import org.bouncycastle.asn1.DERSequence;
import org.bouncycastle.asn1.DERTaggedObject;
import org.bouncycastle.asn1.cms.Attribute;
import org.bouncycastle.asn1.cms.AttributeTable;
import org.bouncycastle.asn1.cms.ContentInfo;
import org.bouncycastle.asn1.ocsp.BasicOCSPResponse;
import org.bouncycastle.asn1.ocsp.OCSPObjectIdentifiers;
import org.bouncycastle.asn1.pkcs.PKCSObjectIdentifiers;
import org.bouncycastle.asn1.tsp.MessageImprint;
import org.bouncycastle.asn1.x509.AlgorithmIdentifier;
import org.bouncycastle.cert.X509CertificateHolder;
import org.bouncycastle.cert.jcajce.JcaX509CertificateHolder;
import org.bouncycastle.cert.ocsp.BasicOCSPResp;
import org.bouncycastle.cert.ocsp.CertificateID;
import org.bouncycastle.cert.ocsp.SingleResp;
import org.bouncycastle.cms.jcajce.JcaSimpleSignerInfoVerifierBuilder;
import org.bouncycastle.jce.X509Principal;
import org.bouncycastle.jce.provider.X509CertParser;
import org.bouncycastle.operator.OperatorCreationException;
import org.bouncycastle.operator.jcajce.JcaDigestCalculatorProviderBuilder;
import org.bouncycastle.tsp.TSPException;
import org.bouncycastle.tsp.TSPValidationException;
import org.bouncycastle.tsp.TimeStampToken;
import org.bouncycastle.tsp.TimeStampTokenInfo;
import xjyb.cn.org.bjca.java.utils.pdf.CertificateInfo;
import xjyb.cn.org.bjca.java.utils.pdf.DigestAlgorithms;
import xjyb.cn.org.bjca.java.utils.pdf.EncryptionAlgorithms;
import xjyb.cn.org.bjca.java.utils.pdf.ExternalDigest;
import xjyb.cn.org.bjca.java.utils.pdf.MakeSignature;
import xjyb.cn.org.bjca.java.utils.pdf.TSAClient;
import xjyb.cn.org.bjca.utils.Base64Util;
import xjyb.org.bjca.asn1.DERConstructedSequence;
import xjyb.org.bjca.asn1.DERConstructedSet;
import xjyb.org.bjca.asn1.DERInputStream;
import xjyb.org.bjca.asn1.DERInteger;
import xjyb.org.bjca.asn1.DERObject;
import xjyb.org.bjca.asn1.DERObjectIdentifier;
import xjyb.org.bjca.asn1.DEROutputStream;
import xjyb.org.bjca.asn1.DERSet;
import xjyb.org.bjca.util.GetP7InfoUtil;

public class PdfPKCS7 {
    private String provider;
    private String signName;
    private String reason;
    private String location;
    private Calendar signDate;
    private int version = 1;
    private int signerversion = 1;
    private String digestAlgorithmOid;
    private MessageDigest messageDigest;
    private Set<String> digestalgos;
    private byte[] digestAttr;
    private String digestEncryptionAlgorithmOid;
    private ExternalDigest interfaceDigest;
    private byte[] externalDigest;
    private byte[] externalRSAdata;
    private Signature sig;
    private byte[] digest;
    private byte[] RSAdata;
    private byte[] sigAttr;
    private MessageDigest encContDigest;
    private boolean verified;
    private boolean verifyResult;
    private Collection<Certificate> certs;
    private Collection<Certificate> signCerts;
    private X509Certificate signCert;
    private Collection<CRL> crls;
    private BasicOCSPResp basicResp;
    private boolean isTsp;
    private TimeStampToken timeStampToken;

    public PdfPKCS7() {
    }

    public PdfPKCS7(PrivateKey privKey, Certificate[] certChain, String hashAlgorithm, String provider, ExternalDigest interfaceDigest, boolean hasRSAdata) throws InvalidKeyException, NoSuchProviderException, NoSuchAlgorithmException {
        this.provider = provider;
        this.interfaceDigest = interfaceDigest;
        this.digestAlgorithmOid = DigestAlgorithms.getAllowedDigests(hashAlgorithm);
        if (this.digestAlgorithmOid == null) {
            throw new NoSuchAlgorithmException("unknown.hash.algorithm.1 " + hashAlgorithm);
        }
        this.signCert = (X509Certificate)certChain[0];
        this.certs = new ArrayList<Certificate>();
        for (Certificate element : certChain) {
            this.certs.add(element);
        }
        this.digestalgos = new HashSet<String>();
        this.digestalgos.add(this.digestAlgorithmOid);
        if (privKey != null) {
            this.digestEncryptionAlgorithmOid = privKey.getAlgorithm();
            if (this.digestEncryptionAlgorithmOid.equals("RSA")) {
                this.digestEncryptionAlgorithmOid = "1.2.840.113549.1.1.1";
            } else if (this.digestEncryptionAlgorithmOid.equals("DSA")) {
                this.digestEncryptionAlgorithmOid = "1.2.840.10040.4.1";
            } else {
                throw new NoSuchAlgorithmException("unknown.key.algorithm.1 " + this.digestEncryptionAlgorithmOid);
            }
        }
        if (hasRSAdata) {
            this.RSAdata = new byte[0];
            this.messageDigest = DigestAlgorithms.getMessageDigest(this.getHashAlgorithm(), provider);
        }
        if (privKey != null) {
            this.sig = provider == null ? Signature.getInstance(this.getDigestAlgorithm()) : Signature.getInstance(this.getDigestAlgorithm(), provider);
            this.sig.initSign(privKey);
        }
    }

    public PdfPKCS7(byte[] contentsKey, byte[] certsKey, String provider) {
        try {
            this.provider = provider;
            X509CertParser cr = new X509CertParser();
            cr.engineInit(new ByteArrayInputStream(certsKey));
            this.certs = cr.engineReadAll();
            this.signCerts = this.certs;
            this.signCert = (X509Certificate)this.certs.iterator().next();
            this.crls = new ArrayList<CRL>();
            ASN1InputStream in = new ASN1InputStream(new ByteArrayInputStream(contentsKey));
            this.digest = ((ASN1OctetString)in.readObject()).getOctets();
            this.sig = provider == null ? Signature.getInstance("SHA1withRSA") : Signature.getInstance("SHA1withRSA", provider);
            this.sig.initVerify(this.signCert.getPublicKey());
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public PdfPKCS7(byte[] contentsKey, String provider) {
        this(contentsKey, false, provider);
    }

    public PdfPKCS7(byte[] contentsKey, boolean tsp, String provider) {
        this.isTsp = tsp;
        try {
            ASN1TaggedObject taggedObject;
            ASN1Set unat;
            AttributeTable attble;
            Attribute ts;
            ASN1Primitive pkcs;
            this.provider = provider;
            ASN1InputStream din = new ASN1InputStream(new ByteArrayInputStream(contentsKey));
            try {
                pkcs = din.readObject();
            }
            catch (IOException e) {
                throw new IllegalArgumentException("can.t.decode.pkcs7signeddata.object");
            }
            if (!(pkcs instanceof ASN1Sequence)) {
                throw new IllegalArgumentException("not.a.valid.pkcs.7.object.not.a.sequence");
            }
            ASN1Sequence signedData = (ASN1Sequence)pkcs;
            ASN1ObjectIdentifier objId = (ASN1ObjectIdentifier)signedData.getObjectAt(0);
            if (!objId.getId().equals("1.2.840.113549.1.7.2") && !objId.getId().equals("1.2.156.10197.6.1.4.2.2")) {
                throw new IllegalArgumentException("not.a.valid.pkcs.7.object.not.signed.data");
            }
            ASN1Sequence content = (ASN1Sequence)((ASN1TaggedObject)signedData.getObjectAt(1)).getObject();
            this.version = ((ASN1Integer)content.getObjectAt(0)).getValue().intValue();
            this.digestalgos = new HashSet<String>();
            Enumeration e = ((ASN1Set)content.getObjectAt(1)).getObjects();
            while (e.hasMoreElements()) {
                ASN1Sequence s = (ASN1Sequence)e.nextElement();
                ASN1ObjectIdentifier o = (ASN1ObjectIdentifier)s.getObjectAt(0);
                this.digestalgos.add(o.getId());
            }
            X509CertParser cr = new X509CertParser();
            cr.engineInit(new ByteArrayInputStream(contentsKey));
            this.certs = cr.engineReadAll();
            ASN1Sequence rsaData = (ASN1Sequence)content.getObjectAt(2);
            if (rsaData.size() > 1) {
                ASN1OctetString rsaDataContent = (ASN1OctetString)((ASN1TaggedObject)rsaData.getObjectAt(1)).getObject();
                this.RSAdata = rsaDataContent.getOctets();
            }
            int next = 3;
            while (content.getObjectAt(next) instanceof ASN1TaggedObject) {
                ++next;
            }
            ASN1Set signerInfos = (ASN1Set)content.getObjectAt(next);
            if (signerInfos.size() != 1) {
                throw new IllegalArgumentException("this.pkcs.7.object.has.multiple.signerinfos.only.one.is.supported.at.this.time");
            }
            ASN1Sequence signerInfo = (ASN1Sequence)signerInfos.getObjectAt(0);
            this.signerversion = ((ASN1Integer)signerInfo.getObjectAt(0)).getValue().intValue();
            ASN1Sequence issuerAndSerialNumber = (ASN1Sequence)signerInfo.getObjectAt(1);
            X509Principal issuer = new X509Principal(issuerAndSerialNumber.getObjectAt(0).toASN1Primitive().getEncoded());
            BigInteger serialNumber = ((ASN1Integer)issuerAndSerialNumber.getObjectAt(1)).getValue();
            for (Certificate element : this.certs) {
                X509Certificate cert = (X509Certificate)element;
                if (!((Object)cert.getIssuerDN()).equals(issuer) || !serialNumber.equals(cert.getSerialNumber())) continue;
                this.signCert = cert;
                break;
            }
            if (this.signCert == null) {
                throw new IllegalArgumentException("can.t.find.signing.certificate.with.serial.1" + issuer.getName() + " / " + serialNumber.toString(16));
            }
            this.signCertificateChain();
            this.digestAlgorithmOid = ((ASN1ObjectIdentifier)((ASN1Sequence)signerInfo.getObjectAt(2)).getObjectAt(0)).getId();
            next = 3;
            if (signerInfo.getObjectAt(next) instanceof ASN1TaggedObject) {
                ASN1TaggedObject tagsig = (ASN1TaggedObject)signerInfo.getObjectAt(next);
                ASN1Set sseq = ASN1Set.getInstance(tagsig, false);
                this.sigAttr = sseq.getEncoded("DER");
                for (int k = 0; k < sseq.size(); ++k) {
                    ASN1Sequence seq2 = (ASN1Sequence)sseq.getObjectAt(k);
                    if (((ASN1ObjectIdentifier)seq2.getObjectAt(0)).getId().equals("1.2.840.113549.1.9.4")) {
                        ASN1Set set = (ASN1Set)seq2.getObjectAt(1);
                        this.digestAttr = ((ASN1OctetString)set.getObjectAt(0)).getOctets();
                        continue;
                    }
                    if (!((ASN1ObjectIdentifier)seq2.getObjectAt(0)).getId().equals("1.2.840.113583.1.1.8")) continue;
                    ASN1Set setout = (ASN1Set)seq2.getObjectAt(1);
                    ASN1Sequence seqout = (ASN1Sequence)setout.getObjectAt(0);
                    for (int j = 0; j < seqout.size(); ++j) {
                        ASN1Sequence seqin;
                        ASN1TaggedObject tg = (ASN1TaggedObject)seqout.getObjectAt(j);
                        if (tg.getTagNo() == 0) {
                            seqin = (ASN1Sequence)tg.getObject();
                            this.findCRL(seqin);
                        }
                        if (tg.getTagNo() != 1) continue;
                        seqin = (ASN1Sequence)tg.getObject();
                        this.findOcsp(seqin);
                    }
                }
                if (this.digestAttr == null) {
                    throw new IllegalArgumentException("authenticated.attribute.is.missing.the.digest");
                }
            }
            int n = ++next;
            this.digestEncryptionAlgorithmOid = ((ASN1ObjectIdentifier)((ASN1Sequence)signerInfo.getObjectAt(n)).getObjectAt(0)).getId();
            int n2 = ++next;
            this.digest = ((ASN1OctetString)signerInfo.getObjectAt(n2)).getOctets();
            if (++next < signerInfo.size() && signerInfo.getObjectAt(next) instanceof ASN1TaggedObject && (ts = (attble = new AttributeTable(unat = ASN1Set.getInstance(taggedObject = (ASN1TaggedObject)signerInfo.getObjectAt(next), false))).get(PKCSObjectIdentifiers.id_aa_signatureTimeStampToken)) != null && ts.getAttrValues().size() > 0) {
                ASN1Set attributeValues = ts.getAttrValues();
                ASN1Sequence tokenSequence = ASN1Sequence.getInstance(attributeValues.getObjectAt(0));
                ContentInfo contentInfo = new ContentInfo(tokenSequence);
                this.timeStampToken = new TimeStampToken(contentInfo);
            }
            if (this.isTsp) {
                ContentInfo contentInfoTsp = new ContentInfo(signedData);
                this.timeStampToken = new TimeStampToken(contentInfoTsp);
                TimeStampTokenInfo info = this.timeStampToken.getTimeStampInfo();
                String algOID = info.getMessageImprintAlgOID().getId();
                this.messageDigest = DigestAlgorithms.getMessageDigestFromOid(algOID, null);
            } else {
                if (this.RSAdata != null || this.digestAttr != null) {
                    this.messageDigest = DigestAlgorithms.getMessageDigest(this.getHashAlgorithm(), provider);
                    this.encContDigest = DigestAlgorithms.getMessageDigest(this.getHashAlgorithm(), provider);
                }
                this.sig = provider == null ? Signature.getInstance(this.getDigestAlgorithm()) : Signature.getInstance(this.getDigestAlgorithm(), provider);
                this.sig.initVerify(this.signCert.getPublicKey());
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public String getSignName() {
        return this.signName;
    }

    public void setSignName(String signName) {
        this.signName = signName;
    }

    public String getReason() {
        return this.reason;
    }

    public void setReason(String reason) {
        this.reason = reason;
    }

    public String getLocation() {
        return this.location;
    }

    public void setLocation(String location) {
        this.location = location;
    }

    public Calendar getSignDate() {
        return this.signDate;
    }

    public void setSignDate(Calendar signDate) {
        this.signDate = signDate;
    }

    public int getVersion() {
        return this.version;
    }

    public int getSigningInfoVersion() {
        return this.signerversion;
    }

    public String getDigestAlgorithmOid() {
        return this.digestAlgorithmOid;
    }

    public String getHashAlgorithm() {
        return DigestAlgorithms.getDigest(this.digestAlgorithmOid);
    }

    public String getDigestEncryptionAlgorithmOid() {
        return this.digestEncryptionAlgorithmOid;
    }

    public String getDigestAlgorithm() {
        String dea = EncryptionAlgorithms.getAlgorithm(this.digestEncryptionAlgorithmOid);
        if (dea == null) {
            dea = this.digestEncryptionAlgorithmOid;
        }
        return this.getHashAlgorithm() + "with" + dea;
    }

    public void setExternalDigest(byte[] digest, byte[] RSAdata, String digestEncryptionAlgorithm) throws NoSuchAlgorithmException {
        this.externalDigest = digest;
        this.externalRSAdata = RSAdata;
        if (digestEncryptionAlgorithm != null) {
            if (digestEncryptionAlgorithm.equals("RSA")) {
                this.digestEncryptionAlgorithmOid = "1.2.840.113549.1.1.1";
            } else if (digestEncryptionAlgorithm.equals("DSA")) {
                this.digestEncryptionAlgorithmOid = "1.2.840.10040.4.1";
            } else {
                throw new NoSuchAlgorithmException(" error , " + digestEncryptionAlgorithm);
            }
        }
    }

    public void update(byte[] buf, int off, int len) throws SignatureException {
        if (this.RSAdata != null || this.digestAttr != null || this.isTsp) {
            this.messageDigest.update(buf, off, len);
        } else {
            this.sig.update(buf, off, len);
        }
    }

    public byte[] getEncodedPKCS1() {
        try {
            this.digest = this.externalDigest != null ? this.externalDigest : this.sig.sign();
            ByteArrayOutputStream bOut = new ByteArrayOutputStream();
            ASN1OutputStream dout = new ASN1OutputStream(bOut);
            dout.writeObject((ASN1Encodable)new DEROctetString(this.digest));
            dout.close();
            return bOut.toByteArray();
        }
        catch (Exception e) {
            e.printStackTrace();
            return null;
        }
    }

    public byte[] getEncodedPKCS7() {
        return this.getEncodedPKCS7(null, null, null, null, null, MakeSignature.CryptoStandard.CMS);
    }

    public byte[] getEncodedPKCS7(byte[] secondDigest, Calendar signingTime) {
        return this.getEncodedPKCS7(secondDigest, signingTime, null, null, null, MakeSignature.CryptoStandard.CMS);
    }

    public byte[] getEncodedPKCS7(byte[] secondDigest, Calendar signingTime, TSAClient tsaClient, byte[] ocsp, Collection<byte[]> crlBytes, MakeSignature.CryptoStandard sigtype) {
        try {
            ASN1EncodableVector unauthAttributes;
            byte[] tsToken;
            if (this.externalDigest != null) {
                this.digest = this.externalDigest;
                if (this.RSAdata != null) {
                    this.RSAdata = this.externalRSAdata;
                }
            } else if (this.externalRSAdata != null && this.RSAdata != null) {
                this.RSAdata = this.externalRSAdata;
                this.sig.update(this.RSAdata);
                this.digest = this.sig.sign();
            } else {
                if (this.RSAdata != null) {
                    this.RSAdata = this.messageDigest.digest();
                    this.sig.update(this.RSAdata);
                }
                this.digest = this.sig.sign();
            }
            ASN1EncodableVector digestAlgorithms = new ASN1EncodableVector();
            for (String element : this.digestalgos) {
                ASN1EncodableVector algos = new ASN1EncodableVector();
                algos.add(new ASN1ObjectIdentifier(element));
                algos.add(DERNull.INSTANCE);
                digestAlgorithms.add(new DERSequence(algos));
            }
            ASN1EncodableVector v = new ASN1EncodableVector();
            v.add(new ASN1ObjectIdentifier("1.2.840.113549.1.7.1"));
            if (this.RSAdata != null) {
                v.add(new DERTaggedObject(0, new DEROctetString(this.RSAdata)));
            }
            DERSequence contentinfo = new DERSequence(v);
            v = new ASN1EncodableVector();
            for (Certificate element : this.certs) {
                ASN1InputStream tempstream = new ASN1InputStream(new ByteArrayInputStream(((X509Certificate)element).getEncoded()));
                v.add(tempstream.readObject());
            }
            org.bouncycastle.asn1.DERSet dercertificates = new org.bouncycastle.asn1.DERSet(v);
            ASN1EncodableVector signerinfo = new ASN1EncodableVector();
            signerinfo.add(new ASN1Integer(this.signerversion));
            v = new ASN1EncodableVector();
            v.add(CertificateInfo.getIssuer(this.signCert.getTBSCertificate()));
            v.add(new ASN1Integer(this.signCert.getSerialNumber()));
            signerinfo.add(new DERSequence(v));
            v = new ASN1EncodableVector();
            v.add(new ASN1ObjectIdentifier(this.digestAlgorithmOid));
            v.add(new DERNull());
            signerinfo.add(new DERSequence(v));
            if (secondDigest != null && signingTime != null) {
                signerinfo.add(new DERTaggedObject(false, 0, this.getAuthenticatedAttributeSet(secondDigest, signingTime, ocsp, crlBytes, sigtype)));
            }
            v = new ASN1EncodableVector();
            v.add(new ASN1ObjectIdentifier(this.digestEncryptionAlgorithmOid));
            v.add(new DERNull());
            signerinfo.add(new DERSequence(v));
            signerinfo.add(new DEROctetString(this.digest));
            if (tsaClient != null && (tsToken = tsaClient.getTimeStampToken(this.digest)) != null && (unauthAttributes = this.buildUnauthenticatedAttributes(tsToken)) != null) {
                signerinfo.add(new DERTaggedObject(false, 1, new org.bouncycastle.asn1.DERSet(unauthAttributes)));
            }
            ASN1EncodableVector body = new ASN1EncodableVector();
            body.add(new ASN1Integer(this.version));
            body.add(new org.bouncycastle.asn1.DERSet(digestAlgorithms));
            body.add(contentinfo);
            body.add(new DERTaggedObject(false, 0, dercertificates));
            body.add(new org.bouncycastle.asn1.DERSet(new DERSequence(signerinfo)));
            ASN1EncodableVector whole = new ASN1EncodableVector();
            whole.add(new ASN1ObjectIdentifier("1.2.840.113549.1.7.2"));
            whole.add(new DERTaggedObject(0, new DERSequence(body)));
            ByteArrayOutputStream bOut = new ByteArrayOutputStream();
            ASN1OutputStream dout = new ASN1OutputStream(bOut);
            dout.writeObject((ASN1Encodable)new DERSequence(whole));
            dout.close();
            return bOut.toByteArray();
        }
        catch (Exception e) {
            e.printStackTrace();
            return null;
        }
    }

    public byte[] addTimeStamp(byte[] p7sign, byte[] hash, TSAClient tsaClient) {
        try {
            ASN1EncodableVector unauthAttributes;
            byte[] tsToken;
            DERInputStream derInputStream = new DERInputStream(new ByteArrayInputStream(p7sign));
            if (derInputStream == null) {
                return null;
            }
            DERConstructedSequence whole = (DERConstructedSequence)derInputStream.readObject();
            if (whole == null) {
                return null;
            }
            xjyb.org.bjca.asn1.DERTaggedObject tagObj = (xjyb.org.bjca.asn1.DERTaggedObject)whole.getObjectAt(1);
            if (tagObj == null) {
                return null;
            }
            DERConstructedSequence body = (DERConstructedSequence)tagObj.getObject();
            if (body == null) {
                return null;
            }
            DERInteger versionGet = (DERInteger)body.getObjectAt(0);
            DERConstructedSet digestAlgorithms = (DERConstructedSet)body.getObjectAt(1);
            DERConstructedSequence contentinfo = (DERConstructedSequence)body.getObjectAt(2);
            xjyb.org.bjca.asn1.DERTaggedObject dercertificates = (xjyb.org.bjca.asn1.DERTaggedObject)body.getObjectAt(3);
            DERConstructedSet signerinfos = (DERConstructedSet)body.getObjectAt(4);
            if (signerinfos == null) {
                return null;
            }
            DERConstructedSequence signerinfo = (DERConstructedSequence)signerinfos.getObjectAt(0);
            if (signerinfo == null) {
                return null;
            }
            if (tsaClient != null && (tsToken = tsaClient.getTimeStampToken(hash)) != null && (unauthAttributes = this.buildUnauthenticatedAttributes(tsToken)) != null) {
                DERTaggedObject dt = new DERTaggedObject(false, 1, new org.bouncycastle.asn1.DERSet(unauthAttributes));
                DERInputStream dis2 = new DERInputStream(new ByteArrayInputStream(dt.getEncoded()));
                DERObject do2 = dis2.readObject();
                signerinfo.addObject(do2);
            }
            DERConstructedSequence body1 = new DERConstructedSequence();
            body1.addObject(versionGet);
            body1.addObject(digestAlgorithms);
            body1.addObject(contentinfo);
            body1.addObject(dercertificates);
            signerinfos = new DERConstructedSet();
            signerinfos.addObject(signerinfo);
            body1.addObject(signerinfos);
            DERConstructedSequence digestAlgorithmSeq = (DERConstructedSequence)digestAlgorithms.getObjectAt(0);
            DERObjectIdentifier digestAlgorithm = (DERObjectIdentifier)digestAlgorithmSeq.getObjectAt(0);
            DERConstructedSequence whole1 = new DERConstructedSequence();
            if ("1.2.156.10197.1.401.1".equals(digestAlgorithm.getId()) || "1.2.156.10197.1.401.2".equals(digestAlgorithm.getId())) {
                whole1.addObject(new DERObjectIdentifier("1.2.156.10197.6.1.4.2.2"));
            } else {
                whole1.addObject(new DERObjectIdentifier("1.2.840.113549.1.7.2"));
            }
            whole1.addObject(new xjyb.org.bjca.asn1.DERTaggedObject(0, body));
            ByteArrayOutputStream bOut = new ByteArrayOutputStream();
            DEROutputStream dout = new DEROutputStream(bOut);
            dout.writeObject(whole1);
            dout.close();
            return bOut.toByteArray();
        }
        catch (Exception e) {
            e.printStackTrace();
            return null;
        }
    }

    public byte[] addTimeStamp(byte[] p7sign, byte[] timeStamp) {
        try {
            ASN1EncodableVector unauthAttributes;
            byte[] tsToken;
            DERInputStream derInputStream = new DERInputStream(new ByteArrayInputStream(p7sign));
            if (derInputStream == null) {
                return null;
            }
            DERConstructedSequence whole = (DERConstructedSequence)derInputStream.readObject();
            if (whole == null) {
                return null;
            }
            DERObjectIdentifier identifier = (DERObjectIdentifier)whole.getObjectAt(0);
            xjyb.org.bjca.asn1.DERTaggedObject tagObj = (xjyb.org.bjca.asn1.DERTaggedObject)whole.getObjectAt(1);
            if (tagObj == null) {
                return null;
            }
            DERConstructedSequence body = (DERConstructedSequence)tagObj.getObject();
            if (body == null) {
                return null;
            }
            DERInteger versionGet = (DERInteger)body.getObjectAt(0);
            DERConstructedSet digestAlgorithms = (DERConstructedSet)body.getObjectAt(1);
            DERConstructedSequence contentinfo = (DERConstructedSequence)body.getObjectAt(2);
            xjyb.org.bjca.asn1.DERTaggedObject dercertificates = (xjyb.org.bjca.asn1.DERTaggedObject)body.getObjectAt(3);
            DERConstructedSet signerinfos = (DERConstructedSet)body.getObjectAt(4);
            if (signerinfos == null) {
                return null;
            }
            DERConstructedSequence signerinfo = (DERConstructedSequence)signerinfos.getObjectAt(0);
            if (signerinfo == null) {
                return null;
            }
            if (timeStamp != null && (tsToken = timeStamp) != null && (unauthAttributes = this.buildUnauthenticatedAttributes(tsToken)) != null) {
                DERTaggedObject dt = new DERTaggedObject(false, 1, new org.bouncycastle.asn1.DERSet(unauthAttributes));
                DERInputStream dis2 = new DERInputStream(new ByteArrayInputStream(dt.getEncoded()));
                DERObject do2 = dis2.readObject();
                signerinfo.addObject(do2);
            }
            DERConstructedSequence body1 = new DERConstructedSequence();
            body1.addObject(versionGet);
            body1.addObject(digestAlgorithms);
            body1.addObject(contentinfo);
            body1.addObject(dercertificates);
            signerinfos = new DERConstructedSet();
            signerinfos.addObject(signerinfo);
            body1.addObject(signerinfos);
            DERConstructedSequence whole1 = new DERConstructedSequence();
            whole1.addObject(identifier);
            whole1.addObject(new xjyb.org.bjca.asn1.DERTaggedObject(0, body));
            ByteArrayOutputStream bOut = new ByteArrayOutputStream();
            DEROutputStream dout = new DEROutputStream(bOut);
            dout.writeObject(whole1);
            dout.close();
            return bOut.toByteArray();
        }
        catch (Exception e) {
            e.printStackTrace();
            return null;
        }
    }

    public byte[][] getTimeStampAndCertAndDigestAttrFromPKCS7(byte[] p7sign) throws IOException {
        byte[][] rets = new byte[3][];
        try {
            byte[][] infos = GetP7InfoUtil.getAttributeSignValueAndCert(p7sign);
            if (infos != null && infos.length >= 6) {
                rets[0] = infos[0];
                rets[1] = infos[3];
                rets[2] = infos[5];
                return rets;
            }
        }
        catch (Exception e) {
            throw new IOException(e);
        }
        return null;
    }

    private ASN1EncodableVector buildUnauthenticatedAttributes(byte[] timeStampToken) throws IOException {
        if (timeStampToken == null) {
            return null;
        }
        String ID_TIME_STAMP_TOKEN = "1.2.840.113549.1.9.16.2.14";
        ASN1InputStream tempstream = new ASN1InputStream(new ByteArrayInputStream(timeStampToken));
        ASN1EncodableVector unauthAttributes = new ASN1EncodableVector();
        ASN1EncodableVector v = new ASN1EncodableVector();
        v.add(new ASN1ObjectIdentifier(ID_TIME_STAMP_TOKEN));
        ASN1Sequence seq = (ASN1Sequence)tempstream.readObject();
        v.add(new org.bouncycastle.asn1.DERSet(seq));
        unauthAttributes.add(new DERSequence(v));
        return unauthAttributes;
    }

    private xjyb.org.bjca.asn1.DERTaggedObject buildUnauthenticatedAttributes_der(byte[] timeStampToken) throws IOException {
        if (timeStampToken == null) {
            return null;
        }
        String ID_TIME_STAMP_TOKEN = "1.2.840.113549.1.9.16.2.14";
        DERInputStream derInputStream = new DERInputStream(new ByteArrayInputStream(timeStampToken));
        DERConstructedSequence derEncodableVector = new DERConstructedSequence();
        derEncodableVector.addObject(new DERObjectIdentifier(ID_TIME_STAMP_TOKEN));
        DERConstructedSequence whole = (DERConstructedSequence)derInputStream.readObject();
        derEncodableVector.addObject(new DERSet(whole));
        xjyb.org.bjca.asn1.DERTaggedObject derTaggedObject = new xjyb.org.bjca.asn1.DERTaggedObject(1, derEncodableVector);
        return derTaggedObject;
    }

    public byte[] getAuthenticatedAttributeBytes(byte[] secondDigest, Calendar signingTime, byte[] ocsp, Collection<byte[]> crlBytes, MakeSignature.CryptoStandard sigtype) {
        try {
            return this.getAuthenticatedAttributeSet(secondDigest, signingTime, ocsp, crlBytes, sigtype).getEncoded("DER");
        }
        catch (Exception e) {
            e.printStackTrace();
            return null;
        }
    }

    private org.bouncycastle.asn1.DERSet getAuthenticatedAttributeSet(byte[] secondDigest, Calendar signingTime, byte[] ocsp, Collection<byte[]> crlBytes, MakeSignature.CryptoStandard sigtype) {
        try {
            ASN1EncodableVector attribute = new ASN1EncodableVector();
            ASN1EncodableVector v = new ASN1EncodableVector();
            v.add(new ASN1ObjectIdentifier("1.2.840.113549.1.9.3"));
            v.add(new org.bouncycastle.asn1.DERSet(new ASN1ObjectIdentifier("1.2.840.113549.1.7.1")));
            attribute.add(new DERSequence(v));
            v = new ASN1EncodableVector();
            v.add(new ASN1ObjectIdentifier("1.2.840.113549.1.9.4"));
            v.add(new org.bouncycastle.asn1.DERSet(new DEROctetString(secondDigest)));
            attribute.add(new DERSequence(v));
            boolean haveCrl = false;
            if (crlBytes != null) {
                for (byte[] bCrl : crlBytes) {
                    if (bCrl == null) continue;
                    haveCrl = true;
                    break;
                }
            }
            if (ocsp != null || haveCrl) {
                v = new ASN1EncodableVector();
                v.add(new ASN1ObjectIdentifier("1.2.840.113583.1.1.8"));
                ASN1EncodableVector revocationV = new ASN1EncodableVector();
                if (haveCrl) {
                    ASN1EncodableVector v2 = new ASN1EncodableVector();
                    for (byte[] bCrl : crlBytes) {
                        if (bCrl == null) continue;
                        ASN1InputStream t = new ASN1InputStream(new ByteArrayInputStream(bCrl));
                        v2.add(t.readObject());
                    }
                    revocationV.add(new DERTaggedObject(true, 0, new DERSequence(v2)));
                }
                if (ocsp != null) {
                    DEROctetString doctet = new DEROctetString(ocsp);
                    ASN1EncodableVector vo1 = new ASN1EncodableVector();
                    ASN1EncodableVector v2 = new ASN1EncodableVector();
                    v2.add(OCSPObjectIdentifiers.id_pkix_ocsp_basic);
                    v2.add(doctet);
                    ASN1Enumerated den = new ASN1Enumerated(0);
                    ASN1EncodableVector v3 = new ASN1EncodableVector();
                    v3.add(den);
                    v3.add(new DERTaggedObject(true, 0, new DERSequence(v2)));
                    vo1.add(new DERSequence(v3));
                    revocationV.add(new DERTaggedObject(true, 1, new DERSequence(vo1)));
                }
                v.add(new org.bouncycastle.asn1.DERSet(new DERSequence(revocationV)));
                attribute.add(new DERSequence(v));
            }
            if (sigtype == MakeSignature.CryptoStandard.CADES) {
                v = new ASN1EncodableVector();
                v.add(new ASN1ObjectIdentifier("1.2.840.113549.1.9.16.2.47"));
                ASN1EncodableVector aaV2 = new ASN1EncodableVector();
                AlgorithmIdentifier algoId = new AlgorithmIdentifier(new ASN1ObjectIdentifier(this.digestAlgorithmOid), null);
                aaV2.add(algoId);
                MessageDigest md = this.interfaceDigest.getMessageDigest(this.getHashAlgorithm());
                byte[] dig = md.digest(this.signCert.getEncoded());
                aaV2.add(new DEROctetString(dig));
                v.add(new org.bouncycastle.asn1.DERSet(new DERSequence(new DERSequence(new DERSequence(aaV2)))));
                attribute.add(new DERSequence(v));
            }
            return new org.bouncycastle.asn1.DERSet(attribute);
        }
        catch (Exception e) {
            e.printStackTrace();
            return null;
        }
    }

    public boolean verify() throws SignatureException {
        if (this.verified) {
            return this.verifyResult;
        }
        if (this.isTsp) {
            TimeStampTokenInfo info = this.timeStampToken.getTimeStampInfo();
            MessageImprint imprint = info.toASN1Structure().getMessageImprint();
            byte[] md = this.messageDigest.digest();
            byte[] imphashed = imprint.getHashedMessage();
            this.verifyResult = Arrays.equals(md, imphashed);
        } else if (this.sigAttr != null) {
            boolean absentEncContDigestCompare;
            byte[] msgDigestBytes = this.messageDigest.digest();
            boolean verifyRSAdata = true;
            this.sig.update(this.sigAttr);
            boolean encContDigestCompare = false;
            if (this.RSAdata != null) {
                verifyRSAdata = Arrays.equals(msgDigestBytes, this.RSAdata);
                this.encContDigest.update(this.RSAdata);
                encContDigestCompare = Arrays.equals(this.encContDigest.digest(), this.digestAttr);
            }
            boolean concludingDigestCompare = (absentEncContDigestCompare = Arrays.equals(msgDigestBytes, this.digestAttr)) || encContDigestCompare;
            boolean sigVerify = this.sig.verify(this.digest);
            this.verifyResult = concludingDigestCompare && sigVerify && verifyRSAdata;
        } else {
            if (this.RSAdata != null) {
                this.sig.update(this.messageDigest.digest());
            }
            this.verifyResult = this.sig.verify(this.digest);
        }
        this.verified = true;
        return this.verifyResult;
    }

    public boolean verifyTimestampImprint() throws NoSuchAlgorithmException, NoSuchProviderException, TSPValidationException, OperatorCreationException, CertificateException, TSPException {
        if (this.timeStampToken == null) {
            return false;
        }
        TimeStampTokenInfo info = this.timeStampToken.getTimeStampInfo();
        MessageImprint imprint = info.toASN1Structure().getMessageImprint();
        String algOID = info.getMessageImprintAlgOID().getId();
        byte[] md = DigestAlgorithms.getMessageDigestFromOid(algOID, null).digest(this.digest);
        byte[] imphashed = imprint.getHashedMessage();
        boolean res = Arrays.equals(md, imphashed);
        X509CertificateHolder certificate = this.timeStampToken.getCertificates().getMatches(null).iterator().next();
        this.timeStampToken.validate(new JcaSimpleSignerInfoVerifierBuilder().setProvider("BC").build(certificate));
        this.verified = true;
        return res;
    }

    public Certificate[] getCertificates() {
        return this.certs.toArray(new X509Certificate[this.certs.size()]);
    }

    public Certificate[] getSignCertificateChain() {
        return this.signCerts.toArray(new X509Certificate[this.signCerts.size()]);
    }

    public X509Certificate getSigningCertificate() {
        return this.signCert;
    }

    private void signCertificateChain() {
        ArrayList<Certificate> cc = new ArrayList<Certificate>();
        cc.add(this.signCert);
        ArrayList<Certificate> oc = new ArrayList<Certificate>(this.certs);
        for (int k = 0; k < oc.size(); ++k) {
            if (!this.signCert.equals(oc.get(k))) continue;
            oc.remove(k);
            --k;
        }
        boolean found = true;
        block3: while (found) {
            X509Certificate v = (X509Certificate)cc.get(cc.size() - 1);
            found = false;
            for (int k = 0; k < oc.size(); ++k) {
                try {
                    if (this.provider == null) {
                        v.verify(((X509Certificate)oc.get(k)).getPublicKey());
                    } else {
                        v.verify(((X509Certificate)oc.get(k)).getPublicKey(), this.provider);
                    }
                    found = true;
                    cc.add(oc.get(k));
                    oc.remove(k);
                    continue block3;
                }
                catch (Exception e) {
                    continue;
                }
            }
        }
        this.signCerts = cc;
    }

    public Collection<CRL> getCRLs() {
        return this.crls;
    }

    private void findCRL(ASN1Sequence seq) {
        try {
            this.crls = new ArrayList<CRL>();
            for (int k = 0; k < seq.size(); ++k) {
                ByteArrayInputStream ar = new ByteArrayInputStream(seq.getObjectAt(k).toASN1Primitive().getEncoded("DER"));
                CertificateFactory cf = CertificateFactory.getInstance("X.509");
                X509CRL crl = (X509CRL)cf.generateCRL(ar);
                this.crls.add(crl);
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public BasicOCSPResp getOcsp() {
        return this.basicResp;
    }

    public boolean isRevocationValid() {
        if (this.basicResp == null) {
            return false;
        }
        if (this.signCerts.size() < 2) {
            return false;
        }
        try {
            X509Certificate[] cs = (X509Certificate[])this.getSignCertificateChain();
            SingleResp sr = this.basicResp.getResponses()[0];
            CertificateID cid = sr.getCertID();
            X509Certificate sigcer = this.getSigningCertificate();
            X509Certificate isscer = cs[1];
            CertificateID tis = new CertificateID(new JcaDigestCalculatorProviderBuilder().build().get(CertificateID.HASH_SHA1), new JcaX509CertificateHolder(isscer), sigcer.getSerialNumber());
            return tis.equals(cid);
        }
        catch (Exception exception) {
            return false;
        }
    }

    private void findOcsp(ASN1Sequence seq) throws IOException {
        this.basicResp = null;
        boolean ret = false;
        while (!(seq.getObjectAt(0) instanceof ASN1ObjectIdentifier) || !((ASN1ObjectIdentifier)seq.getObjectAt(0)).getId().equals(OCSPObjectIdentifiers.id_pkix_ocsp_basic.getId())) {
            ret = true;
            for (int k = 0; k < seq.size(); ++k) {
                if (seq.getObjectAt(k) instanceof ASN1Sequence) {
                    seq = (ASN1Sequence)seq.getObjectAt(0);
                    ret = false;
                    break;
                }
                if (!(seq.getObjectAt(k) instanceof ASN1TaggedObject)) continue;
                ASN1TaggedObject tag = (ASN1TaggedObject)seq.getObjectAt(k);
                if (tag.getObject() instanceof ASN1Sequence) {
                    seq = (ASN1Sequence)tag.getObject();
                    ret = false;
                    break;
                }
                return;
            }
            if (!ret) continue;
            return;
        }
        ASN1OctetString os = (ASN1OctetString)seq.getObjectAt(1);
        ASN1InputStream inp = new ASN1InputStream(os.getOctets());
        BasicOCSPResponse resp = BasicOCSPResponse.getInstance(inp.readObject());
        this.basicResp = new BasicOCSPResp(resp);
    }

    public boolean isTsp() {
        return this.isTsp;
    }

    public TimeStampToken getTimeStampToken() {
        return this.timeStampToken;
    }

    public Calendar getTimeStampDate() {
        if (this.timeStampToken == null) {
            return null;
        }
        GregorianCalendar cal = new GregorianCalendar();
        Date date = this.timeStampToken.getTimeStampInfo().getGenTime();
        cal.setTime(date);
        return cal;
    }

    public byte[] getDigestAttr() {
        return this.digestAttr;
    }

    public static void main(String[] args) {
        String p7 = "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";
        Base64Util base64Util = new Base64Util("");
    }
}

