/*
 * Decompiled with CFR 0.152.
 */
package xjyb.cn.org.bjca.java.utils;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.math.BigInteger;
import java.security.GeneralSecurityException;
import java.security.InvalidKeyException;
import java.security.NoSuchAlgorithmException;
import java.security.NoSuchProviderException;
import java.security.PrivateKey;
import java.security.PublicKey;
import java.security.Security;
import java.security.Signature;
import java.security.SignatureException;
import java.security.cert.Certificate;
import java.security.cert.CertificateEncodingException;
import java.security.cert.CertificateException;
import java.security.cert.CertificateFactory;
import java.security.cert.X509Certificate;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Calendar;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import java.util.TimeZone;
import org.bouncycastle.asn1.ASN1ObjectIdentifier;
import org.bouncycastle.asn1.ASN1Primitive;
import org.bouncycastle.asn1.ASN1Sequence;
import org.bouncycastle.asn1.ASN1Set;
import org.bouncycastle.asn1.ASN1TaggedObject;
import org.bouncycastle.cert.X509CertificateHolder;
import org.bouncycastle.cms.CMSSignedData;
import org.bouncycastle.cms.SignerInformation;
import org.bouncycastle.cms.SignerInformationStore;
import org.bouncycastle.jce.provider.BouncyCastleProvider;
import org.bouncycastle.tsp.TSPValidationException;
import org.bouncycastle.util.Store;
import xjyb.cn.org.bjca.exception.Base64Exception;
import xjyb.cn.org.bjca.exception.GetCertInfoException;
import xjyb.cn.org.bjca.exception.HashException;
import xjyb.cn.org.bjca.exception.Pkcs7DecodeEnvelopeException;
import xjyb.cn.org.bjca.exception.Pkcs7DecodeException;
import xjyb.cn.org.bjca.exception.Pkcs7EncodeEnvelopeException;
import xjyb.cn.org.bjca.exception.Pkcs7EncodeException;
import xjyb.cn.org.bjca.exception.Pkcs7SignException;
import xjyb.cn.org.bjca.exception.Pkcs7VerifySignException;
import xjyb.cn.org.bjca.exception.TsException;
import xjyb.cn.org.bjca.framework.SuperUtil;
import xjyb.cn.org.bjca.java.utils.PdfPKCS7;
import xjyb.cn.org.bjca.java.utils.RsaUtil;
import xjyb.cn.org.bjca.java.utils.TimeStampUtil;
import xjyb.cn.org.bjca.java.utils.pdf.BouncyCastleDigest;
import xjyb.cn.org.bjca.java.utils.pdf.MakeSignature;
import xjyb.cn.org.bjca.java.utils.pdf.PrivateKeySignature;
import xjyb.cn.org.bjca.java.utils.pdf.TSAClientBouncyCastle;
import xjyb.cn.org.bjca.security.SecurityUtil;
import xjyb.cn.org.bjca.utils.Base64Util;
import xjyb.cn.org.bjca.utils.CertificateUtil;
import xjyb.cn.org.bjca.utils.HashUtil;
import xjyb.cn.org.bjca.valuebean.Copyright;
import xjyb.com.sansec.device.local.Card;
import xjyb.com.sansec.device.local.WrapCard;
import xjyb.org.bjca.asn1.ASN1EncodableVector;
import xjyb.org.bjca.asn1.ASN1InputStream;
import xjyb.org.bjca.asn1.DERBitString;
import xjyb.org.bjca.asn1.DERConstructedSequence;
import xjyb.org.bjca.asn1.DERConstructedSet;
import xjyb.org.bjca.asn1.DERInputStream;
import xjyb.org.bjca.asn1.DERObjectIdentifier;
import xjyb.org.bjca.asn1.DEROctetString;
import xjyb.org.bjca.asn1.DEROutputStream;
import xjyb.org.bjca.asn1.DERSequence;
import xjyb.org.bjca.asn1.DERSet;
import xjyb.org.bjca.asn1.DERTaggedObject;
import xjyb.org.bjca.asn1.DERUTCTime;
import xjyb.org.bjca.asn1.cms.CMSAttributes;
import xjyb.org.bjca.asn1.cms.Time;
import xjyb.org.bjca.asn1.pkcs.Attribute;
import xjyb.org.bjca.asn1.x509.RSAPublicKeyStructure;
import xjyb.org.bjca.asn1.x509.SubjectPublicKeyInfo;
import xjyb.org.bjca.asn1.x509.X509CertificateStructure;
import xjyb.org.bjca.crypto.digests.SHA1Digest;
import xjyb.org.bjca.crypto.digests.SHA256Digest;
import xjyb.org.bjca.crypto.params.RSAKeyParameters;
import xjyb.org.bjca.crypto.params.RSAPrivateCrtKeyParameters;
import xjyb.org.bjca.crypto.signers.BJCASigner;
import xjyb.org.bjca.jce.CNEnvelopedData;
import xjyb.org.bjca.jce.CNPKCS7SignedData;
import xjyb.org.bjca.jce.PKCS7EnvelopedData;
import xjyb.org.bjca.jce.PKCS7SignedAndEnvelopedData;
import xjyb.org.bjca.jce.PKCS7SignedData;
import xjyb.org.bjca.jce.exception.P11ConnectException;
import xjyb.org.bjca.jce.fastparser.DerUtil;
import xjyb.org.bjca.jce.interfaces.P11Interface;
import xjyb.org.bjca.util.ByteArrayUtil;
import xjyb.org.bjca.util.GetP7InfoUtil;

public class Pkcs7Util
extends SuperUtil {
    private static String hexStr = "0123456789ABCDEF";

    public Pkcs7Util(String appName) {
        super(appName);
    }

    public byte[] getValidP7Length(byte[] p7) {
        byte[] validP7 = null;
        if (p7 != null && p7.length > 4) {
            byte[] lengthByte = new byte[]{0, 0, 0, 0};
            lengthByte[3] = p7[1];
            int lengthLen = 0xF & ByteArrayUtil.byteToInt(lengthByte);
            byte[] actLengthByte = new byte[lengthLen];
            System.arraycopy(p7, 2, actLengthByte, 0, lengthLen);
            byte[] actcontextLengthByte = new byte[]{0, 0, 0, 0};
            for (int i = 0; i < lengthLen; ++i) {
                actcontextLengthByte[3 - i] = actLengthByte[lengthLen - i - 1];
            }
            int actcontextLength = ByteArrayUtil.byteToInt(actcontextLengthByte);
            validP7 = new byte[actcontextLength + 2 + lengthLen];
            System.arraycopy(p7, 0, validP7, 0, validP7.length);
        }
        return validP7;
    }

    public byte[] signHashedDataByP7Detach(byte[] hashedData, int m_Iinitmodel, byte[] m_signCertBytes, String m_keyType, String m_container, RSAPrivateCrtKeyParameters privateCrtKey, byte[] SM2PrivateKeyByte) throws Pkcs7SignException {
        try {
            byte[] p7SignData = null;
            byte[] signedBuf = null;
            if (m_Iinitmodel == 4 || m_Iinitmodel == 6) {
                CertificateFactory oCf = CertificateFactory.getInstance("X.509");
                ByteArrayInputStream ois = new ByteArrayInputStream(m_signCertBytes);
                X509Certificate oCert = (X509Certificate)oCf.generateCertificate(ois);
                Certificate[] certs = new Certificate[]{oCert};
                WrapCard wrapCard = new WrapCard(m_Iinitmodel);
                signedBuf = wrapCard.externalSign(privateCrtKey, hashedData, SM2PrivateKeyByte);
                String hashAlg = "SHA1";
                if (hashedData != null && hashedData.length == 20) {
                    hashAlg = "SHA1";
                } else if (hashedData != null && hashedData.length == 32) {
                    hashAlg = "SHA256";
                }
                PKCS7SignedData p7sign = new PKCS7SignedData(certs, null, hashAlg, "");
                p7SignData = p7sign.getEncoded(signedBuf, null);
            } else if (m_Iinitmodel != 5 && (m_Iinitmodel == 7 || m_Iinitmodel == 8)) {
                X509CertificateStructure x509Cert = new X509CertificateStructure((xjyb.org.bjca.asn1.ASN1Sequence)DerUtil.getDerObject(m_signCertBytes));
                X509CertificateStructure[] x509Certs = new X509CertificateStructure[]{x509Cert};
                WrapCard wCard = new WrapCard(m_Iinitmodel);
                byte[] signedData = wCard.sm2SignWithHashedData(hashedData, SM2PrivateKeyByte);
                CNPKCS7SignedData cnP7sign = new CNPKCS7SignedData(x509Certs, null, "SM3", "");
                p7SignData = cnP7sign.getEncoded(signedData, null);
            }
            return p7SignData;
        }
        catch (Exception e) {
            this.errorlog("Exception in signing data by pkcs7!", e);
            throw new Pkcs7SignException("Exception in signing data by pkcs7!");
        }
    }

    public byte[] signAttributeP7(byte[] hashedData, int m_Iinitmodel, byte[] m_signCertBytes, String m_keyType, String m_container, PrivateKey privateCrtKey, byte[] privateKeyByte, RSAPrivateCrtKeyParameters privateCrtKeyParameters) throws Pkcs7SignException {
        try {
            byte[] p7SignData = null;
            if (m_Iinitmodel == 4 || m_Iinitmodel == 6) {
                p7SignData = this.signAttributeP7RSA(hashedData, m_signCertBytes, privateCrtKeyParameters, privateKeyByte);
            } else if (m_Iinitmodel != 5 && (m_Iinitmodel == 7 || m_Iinitmodel == 8)) {
                p7SignData = this.signAttributeP7SM2(hashedData, m_signCertBytes, privateKeyByte);
            }
            return p7SignData;
        }
        catch (Exception e) {
            this.errorlog("Exception in signAttributeP7!", e);
            throw new Pkcs7SignException("Exception in signAttributeP7!");
        }
    }

    public byte[] signAttributeP7RSA(byte[] hashedData, byte[] m_signCertBytes, RSAPrivateCrtKeyParameters privateCrtKey, byte[] privateKeyByte) throws Pkcs7SignException {
        try {
            ASN1EncodableVector attributeVector = new ASN1EncodableVector();
            Attribute[] attributes = new Attribute[]{new Attribute(CMSAttributes.contentType, new DERSet(new DERObjectIdentifier("1.2.840.113549.1.7.1"))), new Attribute(CMSAttributes.signingTime, new DERSet(new Time(new Date()))), new Attribute(CMSAttributes.messageDigest, new DERSet(new DEROctetString(hashedData)))};
            attributeVector.add(attributes[0]);
            attributeVector.add(attributes[1]);
            attributeVector.add(attributes[2]);
            DERSet derRSet = new DERSet(attributeVector);
            DERSequence attributeSequence = new DERSequence(attributeVector);
            DERTaggedObject derTaggedObject = new DERTaggedObject(false, 0, attributeSequence);
            byte[] attributesByte = derRSet.getEncoded();
            CertificateFactory oCf = CertificateFactory.getInstance("X.509");
            ByteArrayInputStream ois = new ByteArrayInputStream(m_signCertBytes);
            X509Certificate oCert = (X509Certificate)oCf.generateCertificate(ois);
            Certificate[] certs = new Certificate[]{oCert};
            WrapCard wrapCard = new WrapCard();
            byte[] hashAttr = HashUtil.hash(HashUtil.getHashAlg(this.applicationName), attributesByte, null);
            byte[] signedBuf = wrapCard.externalSign(privateCrtKey, hashAttr, privateKeyByte);
            PKCS7SignedData p7sign = new PKCS7SignedData(certs, null, HashUtil.getHashAlg(this.applicationName), "");
            byte[] p7SignData = p7sign.getEncoded(signedBuf, null, derTaggedObject);
            return p7SignData;
        }
        catch (Exception e) {
            this.errorlog("Exception in signAttributeP7RSA!", e);
            throw new Pkcs7SignException("Exception in signAttributeP7RSA!");
        }
    }

    public byte[] signAttributeP7SM2(byte[] hashedData, byte[] m_signCertBytes, byte[] privateKeyByte) throws Pkcs7SignException {
        byte[] p7SignData = null;
        byte[] signedBuf = null;
        try {
            ASN1EncodableVector attributeVector = new ASN1EncodableVector();
            Attribute[] attributes = new Attribute[]{new Attribute(CMSAttributes.contentType, new DERSet(new DERObjectIdentifier("1.2.156.10197.6.1.4.2.1"))), new Attribute(CMSAttributes.signingTime, new DERSet(new Time(new Date()))), new Attribute(CMSAttributes.messageDigest, new DERSet(new DEROctetString(hashedData)))};
            attributeVector.add(attributes[0]);
            attributeVector.add(attributes[1]);
            attributeVector.add(attributes[2]);
            DERSet derRSet = new DERSet(attributeVector);
            DERSequence attributeSequence = new DERSequence(attributeVector);
            DERTaggedObject derTaggedObject = new DERTaggedObject(false, 0, attributeSequence);
            byte[] attributesByte = derRSet.getEncoded();
            CertificateUtil certU = new CertificateUtil(this.applicationName);
            X509CertificateStructure strcSignCert = certU.getX509CertStrc(m_signCertBytes);
            X509CertificateStructure[] x509Certs = new X509CertificateStructure[]{strcSignCert};
            SubjectPublicKeyInfo spki = strcSignCert.getSubjectPublicKeyInfo();
            byte[] bPubKey = spki.getPublicKeyData().getBytes();
            byte[] publicKey = new byte[64];
            System.arraycopy(bPubKey, 1, publicKey, 0, publicKey.length);
            WrapCard wCard = new WrapCard();
            try {
                signedBuf = wCard.sm3WithSM2Sign(attributesByte, strcSignCert, privateKeyByte);
            }
            catch (Exception e) {
                this.errorlog("Exception in sm2 signature !", e);
                return null;
            }
            CNPKCS7SignedData cnpkcs7SignedData = new CNPKCS7SignedData(x509Certs, null, "SM3", "");
            p7SignData = cnpkcs7SignedData.getEncoded(signedBuf, null, derTaggedObject);
            return p7SignData;
        }
        catch (Exception e) {
            this.errorlog("Exception in signAttributeP7SM2!", e);
            throw new Pkcs7SignException("Exception in signAttributeP7SM2!");
        }
    }

    public byte[] BJE_Pkcs7Sign(byte[] toBeSignedBlob, long signMethod, int m_Iinitmodel, byte[] m_signPfx, byte[] m_signCertBytes, String m_keyType, String m_container, PrivateKey privateKey, P11Interface p11Impl, byte[] privateKeyByte, boolean isAttach, RSAPrivateCrtKeyParameters privateCrtKey) throws Pkcs7SignException {
        try {
            byte[] signedBuf = null;
            byte[] p7SignData = null;
            if (m_Iinitmodel == 4 || m_Iinitmodel == 5 || m_Iinitmodel == 6) {
                CertificateFactory oCf = CertificateFactory.getInstance("X.509");
                ByteArrayInputStream ois = new ByteArrayInputStream(m_signCertBytes);
                X509Certificate oCert = (X509Certificate)oCf.generateCertificate(ois);
                Certificate[] certs = new Certificate[]{oCert};
                if (m_Iinitmodel == 4) {
                    WrapCard wrapCard = new WrapCard(m_Iinitmodel);
                    signedBuf = wrapCard.externalSign(privateCrtKey, HashUtil.hash(HashUtil.getHashAlg(this.applicationName), toBeSignedBlob, null), privateKeyByte);
                } else if (m_Iinitmodel == 5) {
                    try {
                        signedBuf = p11Impl.signByRsaSha1(toBeSignedBlob, m_container, Integer.parseInt(m_keyType));
                    }
                    catch (P11ConnectException e) {
                        System.out.println("Exception in p11 connection !");
                        this.errorlog("Exception in p11 connection !", e);
                    }
                } else if (m_Iinitmodel == 6) {
                    HashUtil hashU = new HashUtil("");
                    byte[] hashedData = hashU.BJS_HashBytes(HashUtil.getHashAlgLong(this.applicationName), toBeSignedBlob);
                    Card card = Card.getInstance();
                    byte[] buffer = card.externalSign(1, hashedData, privateKeyByte);
                    int rv = ByteArrayUtil.getFirstIntFromByteArray(buffer, 0);
                    if (rv != 0) {
                        this.errorlog("external sign failed, rv[0x" + Integer.toHexString(rv) + "]");
                        return null;
                    }
                    signedBuf = new byte[buffer.length - 4];
                    System.arraycopy(buffer, 4, signedBuf, 0, buffer.length - 4);
                }
                PKCS7SignedData p7sign = new PKCS7SignedData(certs, null, HashUtil.getHashAlg(this.applicationName), "");
                p7SignData = isAttach ? p7sign.getEncoded(signedBuf, toBeSignedBlob) : p7sign.getEncoded(signedBuf, null);
            } else if (m_Iinitmodel == 7 || m_Iinitmodel == 8) {
                X509CertificateStructure x509Cert = new X509CertificateStructure((xjyb.org.bjca.asn1.ASN1Sequence)DerUtil.getDerObject(m_signCertBytes));
                X509CertificateStructure[] x509Certs = new X509CertificateStructure[]{x509Cert};
                WrapCard wCard = new WrapCard(m_Iinitmodel);
                byte[] signedData = wCard.sm3WithSM2Sign(toBeSignedBlob, x509Cert, privateKeyByte);
                CNPKCS7SignedData cnP7sign = new CNPKCS7SignedData(x509Certs, null, "SM3", "");
                p7SignData = isAttach ? cnP7sign.getEncoded(signedData, toBeSignedBlob) : cnP7sign.getEncoded(signedData, null);
            }
            return p7SignData;
        }
        catch (Exception e) {
            this.errorlog("Exception in signing data by pkcs7!", e);
            throw new Pkcs7SignException("Exception in signing data by pkcs7!");
        }
    }

    public byte[] BJE_Pkcs7SignForJit(byte[] toBeSignedBlob, long signMethod, int m_Iinitmodel, byte[] m_signPfx, byte[] m_signCertBytes, String m_keyType, String m_container, PrivateKey privateKey, P11Interface p11Impl, byte[] privateKeyByte, boolean isAttach, RSAPrivateCrtKeyParameters privateCrtKey) throws Pkcs7SignException {
        try {
            byte[] signedBuf = null;
            byte[] p7SignData = null;
            if (m_Iinitmodel == 4 || m_Iinitmodel == 5 || m_Iinitmodel == 6) {
                CertificateFactory oCf = CertificateFactory.getInstance("X.509");
                ByteArrayInputStream ois = new ByteArrayInputStream(m_signCertBytes);
                X509Certificate oCert = (X509Certificate)oCf.generateCertificate(ois);
                Certificate[] certs = new Certificate[]{oCert};
                if (m_Iinitmodel == 4) {
                    WrapCard wrapCard = new WrapCard();
                    signedBuf = wrapCard.externalSign(privateCrtKey, HashUtil.hash(HashUtil.getHashAlg(this.applicationName), toBeSignedBlob, null), privateKeyByte);
                } else if (m_Iinitmodel == 5) {
                    try {
                        signedBuf = p11Impl.signByRsaSha1(toBeSignedBlob, m_container, Integer.parseInt(m_keyType));
                    }
                    catch (P11ConnectException e) {
                        System.out.println("Exception in p11 connection !");
                        this.errorlog("Exception in p11 connection !", e);
                    }
                } else if (m_Iinitmodel == 6) {
                    HashUtil hashU = new HashUtil("");
                    byte[] hashedData = hashU.BJS_HashBytes(HashUtil.getHashAlgLong(this.applicationName), toBeSignedBlob);
                    Card card = Card.getInstance();
                    byte[] buffer = card.externalSign(1, hashedData, privateKeyByte);
                    int rv = ByteArrayUtil.getFirstIntFromByteArray(buffer, 0);
                    if (rv != 0) {
                        this.errorlog("external sign failed, rv[0x" + Integer.toHexString(rv) + "]");
                        return null;
                    }
                    signedBuf = new byte[buffer.length - 4];
                    System.arraycopy(buffer, 4, signedBuf, 0, buffer.length - 4);
                }
                PKCS7SignedData p7sign = new PKCS7SignedData(certs, null, HashUtil.getHashAlg(this.applicationName), "");
                p7SignData = isAttach ? p7sign.getEncoded(signedBuf, toBeSignedBlob) : p7sign.getEncoded(signedBuf, null);
            } else if (m_Iinitmodel == 7 || m_Iinitmodel == 8) {
                X509CertificateStructure x509Cert = new X509CertificateStructure((xjyb.org.bjca.asn1.ASN1Sequence)DerUtil.getDerObject(m_signCertBytes));
                X509CertificateStructure[] x509Certs = new X509CertificateStructure[]{x509Cert};
                WrapCard wCard = new WrapCard();
                byte[] signedData = wCard.sm3WithSM2Sign(toBeSignedBlob, x509Cert, privateKeyByte);
                CNPKCS7SignedData cnP7sign = new CNPKCS7SignedData(x509Certs, null, "SM3", "", "");
                p7SignData = isAttach ? cnP7sign.getEncoded4Jit(signedData, toBeSignedBlob) : cnP7sign.getEncoded4Jit(signedData, null);
            }
            return p7SignData;
        }
        catch (Exception e) {
            this.errorlog("Exception in signing data by pkcs7!", e);
            throw new Pkcs7SignException("Exception in signing data by pkcs7!");
        }
    }

    public byte[] encodePkcs7Data(byte[] cert, byte[] signedData, byte[] originalData) throws Pkcs7SignException {
        try {
            CertificateFactory oCf = CertificateFactory.getInstance("X.509");
            ByteArrayInputStream ois = new ByteArrayInputStream(cert);
            X509Certificate oCert = (X509Certificate)oCf.generateCertificate(ois);
            Certificate[] certs = new Certificate[]{oCert};
            PKCS7SignedData p7sign = new PKCS7SignedData(certs, null, "SHA1", "");
            byte[] p7SignData = p7sign.getEncoded(signedData, originalData);
            return p7SignData;
        }
        catch (Exception e) {
            this.errorlog("Exception in signing data by pkcs7!", e);
            throw new Pkcs7SignException("Exception in signing data by pkcs7!");
        }
    }

    public String BJE_Pkcs7Sign_file_detach(String sFilePath, long signMethod, int m_Iinitmodel, byte[] m_signPfx, byte[] m_signCertBytes, String m_keyType, String m_container, PrivateKey privateKey, P11Interface p11Impl, byte[] privateKeyByte) throws Pkcs7SignException {
        try {
            Base64Util base64Util = new Base64Util(this.applicationName);
            CertificateFactory oCf = CertificateFactory.getInstance("X.509");
            ByteArrayInputStream ois = new ByteArrayInputStream(m_signCertBytes);
            X509Certificate oCert = (X509Certificate)oCf.generateCertificate(ois);
            Certificate[] certs = new Certificate[]{oCert};
            String base64P7Sign = null;
            byte[] signedBuf = null;
            Signature oSign = null;
            String hashTypeString = HashUtil.getHashAlg(this.applicationName);
            if ("SHA1".equals(hashTypeString)) {
                oSign = Signature.getInstance("SHA1withRSA");
            } else if ("SHA256".equals(hashTypeString)) {
                oSign = Signature.getInstance("SHA256withRSA");
            }
            switch (m_Iinitmodel) {
                case 4: {
                    int len;
                    oSign.initSign(privateKey);
                    FileInputStream in = new FileInputStream(sFilePath);
                    int blockSize = 131072;
                    byte[] inBytes = new byte[blockSize];
                    while ((len = ((InputStream)in).read(inBytes)) != -1) {
                        oSign.update(inBytes, 0, len);
                    }
                    signedBuf = oSign.sign();
                    ((InputStream)in).close();
                    break;
                }
                case 6: {
                    int len;
                    oSign.initSign(privateKey);
                    FileInputStream in = new FileInputStream(sFilePath);
                    int blockSize = 131072;
                    byte[] inBytes = new byte[blockSize];
                    while ((len = ((InputStream)in).read(inBytes)) != -1) {
                        oSign.update(inBytes, 0, len);
                    }
                    signedBuf = oSign.sign();
                    ((InputStream)in).close();
                    break;
                }
            }
            PKCS7SignedData p7sign = new PKCS7SignedData(certs, null, hashTypeString, "");
            byte[] p7SignData = p7sign.getEncoded(signedBuf, null);
            base64P7Sign = base64Util.BJS_EncodeBase64(p7SignData);
            return base64P7Sign;
        }
        catch (Exception e) {
            this.errorlog("Exception in signing data by pkcs7!", e);
            throw new Pkcs7SignException("Exception in signing data by pkcs7!");
        }
    }

    public boolean BJE_Pkcs7Verify(byte[] inData, String beSignedBlob) throws Pkcs7VerifySignException {
        try {
            byte[] signCert = this.BJE_Pkcs7Verify_reCert(inData, beSignedBlob);
            return signCert != null;
        }
        catch (Exception e) {
            this.errorlog("Exception in verify sign data by pkcs7!", e);
            throw new Pkcs7VerifySignException("Exception in verify sign data by pkcs7!");
        }
    }

    public boolean BJE_Pkcs7Verify(byte[] inData, byte[] beSignedBlob) throws Pkcs7VerifySignException {
        try {
            byte[] signCert = this.BJE_Pkcs7Verify_reCert(inData, beSignedBlob);
            return signCert != null;
        }
        catch (Exception e) {
            this.errorlog("Exception in verify sign data by pkcs7!", e);
            throw new Pkcs7VerifySignException("Exception in verify sign data by pkcs7!");
        }
    }

    public boolean BJE_Pkcs7_file_Verify(String sFilePath, String beSignedBlob) throws Pkcs7VerifySignException {
        try {
            Base64Util base64Util = new Base64Util(this.applicationName);
            byte[] signData = base64Util.BJS_DecodeBase64(beSignedBlob);
            PKCS7SignedData pkcs7 = new PKCS7SignedData(signData);
            if (sFilePath != null) {
                int len;
                FileInputStream in = new FileInputStream(sFilePath);
                int blockSize = 131072;
                byte[] inBytes = new byte[blockSize];
                while ((len = ((InputStream)in).read(inBytes)) != -1) {
                    pkcs7.update(inBytes, 0, len);
                }
                ((InputStream)in).close();
            }
            boolean verified = pkcs7.verify();
            return verified;
        }
        catch (Exception e) {
            this.errorlog("Exception in verify sign data by pkcs7!", e);
            throw new Pkcs7VerifySignException("Exception in verify sign data by pkcs7!");
        }
    }

    public byte[] BJE_Pkcs7Verify_reCert(byte[] inData, String beSignedBlob) throws Pkcs7VerifySignException {
        byte[] signCert = null;
        try {
            Base64Util base64Util = new Base64Util(this.applicationName);
            byte[] signedData = base64Util.BJS_DecodeBase64(beSignedBlob);
            signCert = this.verifyP7CompAttr_detach(inData, signedData, false);
            return signCert;
        }
        catch (Exception e) {
            e.printStackTrace();
            this.errorlog("Exception in verify sign data by pkcs7!", e);
            throw new Pkcs7VerifySignException("Exception in verify sign data by pkcs7!");
        }
    }

    public byte[] BJE_Pkcs7Verify_reCert(byte[] inData, byte[] beSignedBlob) throws Pkcs7VerifySignException {
        byte[] signCert = null;
        try {
            Base64Util base64Util = new Base64Util(this.applicationName);
            signCert = this.verifyP7CompAttr_detach(inData, beSignedBlob, false);
            return signCert;
        }
        catch (Exception e) {
            e.printStackTrace();
            this.errorlog("Exception in verify sign data by pkcs7!", e);
            throw new Pkcs7VerifySignException("Exception in verify sign data by pkcs7!");
        }
    }

    public byte[] BJE_Pkcs7Verify_reCert_ForJit(byte[] inData, String beSignedBlob) throws Pkcs7VerifySignException {
        byte[] signCert = null;
        try {
            Base64Util base64Util = new Base64Util(this.applicationName);
            byte[] signedData = base64Util.BJS_DecodeBase64(beSignedBlob);
            signCert = this.verifyP7CompAttr_detach_ForJit(inData, signedData, false);
            return signCert;
        }
        catch (Exception e) {
            e.printStackTrace();
            this.errorlog("Exception in verify sign data by pkcs7!", e);
            throw new Pkcs7VerifySignException("Exception in verify sign data by pkcs7!");
        }
    }

    private byte[] verifyPkcs7ByHashNotContainAttrSM2(byte[] signedData, byte[] hashedData) throws Exception {
        byte[] signValue;
        byte[] signCert = null;
        WrapCard wCard = new WrapCard();
        CNPKCS7SignedData pkcs7 = new CNPKCS7SignedData(signedData);
        X509CertificateStructure cert = pkcs7.getSigningCertificate();
        boolean verified = wCard.vefiySm2SignWithHashedData(hashedData, cert, signValue = pkcs7.getSignValue());
        if (verified) {
            signCert = pkcs7.getSigningCertificate().getDEREncoded();
        }
        return signCert;
    }

    private byte[] verifyPkcs7ByHashContainAttrSM2(byte[][] certAndsignedValue, byte[] contentData, byte[] hashedData) throws IOException {
        byte[] signCert = null;
        byte[] cert = certAndsignedValue[0];
        byte[] signedValue = certAndsignedValue[1];
        byte[] hashData = certAndsignedValue[3];
        X509CertificateStructure x509Cert = null;
        WrapCard wCard = new WrapCard();
        boolean verified = false;
        x509Cert = new X509CertificateStructure((xjyb.org.bjca.asn1.ASN1Sequence)DerUtil.writeBytesToDERObj(cert));
        verified = wCard.vefiySM3WithSM2Sign(contentData, x509Cert, signedValue);
        boolean contentEqual = Arrays.equals(hashedData, hashData);
        if (verified && contentEqual) {
            signCert = cert;
        }
        return signCert;
    }

    private byte[] verifyPkcs7ByHashSM2(byte[][] certAndsignedValue, byte[] contentData, byte[] signedData, byte[] hashedData) throws Exception {
        byte[] signCert = null;
        signCert = contentData == null ? this.verifyPkcs7ByHashNotContainAttrSM2(signedData, hashedData) : this.verifyPkcs7ByHashContainAttrSM2(certAndsignedValue, contentData, hashedData);
        return signCert;
    }

    private byte[] verifyPkcs7ByHashSM2Forjit(byte[] signedData, byte[] hashedData) throws Exception {
        byte[] signCert = null;
        signCert = this.verifyPkcs7ByHashNotContainAttrSM2(signedData, hashedData);
        return signCert;
    }

    private byte[] verifyPkcs7ByHashNotContainAttrRSA(byte[] signedData, byte[] hashedData) throws Exception {
        byte[] signCert = null;
        CertificateUtil certU = new CertificateUtil(this.applicationName);
        PKCS7SignedData pkcs7 = new PKCS7SignedData(signedData);
        byte[] signedValue = pkcs7.getSignValue();
        X509Certificate x509SignCert = pkcs7.getSigningCertificate();
        X509CertificateStructure strcCert = certU.getX509CertStrc(x509SignCert.getEncoded());
        byte[] pubKey = strcCert.getSubjectPublicKeyInfo().getPublicKeyData().getBytes();
        ByteArrayInputStream bin = new ByteArrayInputStream(pubKey);
        ASN1InputStream aIn = new ASN1InputStream(bin);
        xjyb.org.bjca.asn1.ASN1Sequence seq = (xjyb.org.bjca.asn1.ASN1Sequence)aIn.readObject();
        RSAPublicKeyStructure rSAPublicKeyStructure = new RSAPublicKeyStructure(seq);
        BigInteger modulus = rSAPublicKeyStructure.getModulus();
        BigInteger exponents = rSAPublicKeyStructure.getPublicExponent();
        RSAKeyParameters RSApubKey = new RSAKeyParameters(false, modulus, exponents);
        BJCASigner bjcaSigner = null;
        if (hashedData != null && hashedData.length == 20) {
            bjcaSigner = new BJCASigner(new SHA1Digest());
        } else if (hashedData != null && hashedData.length == 32) {
            bjcaSigner = new BJCASigner(new SHA256Digest());
        }
        bjcaSigner.init(false, RSApubKey);
        bjcaSigner.update(hashedData, 0, hashedData.length);
        boolean verified = bjcaSigner.verifySignature(signedValue);
        if (verified) {
            signCert = pkcs7.getSigningCertificate().getEncoded();
        }
        return signCert;
    }

    private byte[] verifyPkcs7ByHashContainAttrRSA(byte[][] certAndsignedValue, byte[] contentData, byte[] hashedData) throws GetCertInfoException {
        byte[] signCert = null;
        byte[] cert = certAndsignedValue[0];
        byte[] signedValue = certAndsignedValue[1];
        byte[] hashData = certAndsignedValue[3];
        RsaUtil rsaUtil = new RsaUtil(this.applicationName);
        boolean verified = rsaUtil.BJK_RsaVerifyNoHash(contentData, signedValue, cert, 0L);
        boolean contentEqual = Arrays.equals(hashedData, hashData);
        if (verified && contentEqual) {
            signCert = cert;
        }
        return signCert;
    }

    public static String BinaryToHexString(byte[] bytes) {
        String result = "";
        String hex = "";
        for (int i = 0; i < bytes.length; ++i) {
            hex = String.valueOf(hexStr.charAt((bytes[i] & 0xF0) >> 4));
            hex = hex + String.valueOf(hexStr.charAt(bytes[i] & 0xF));
            result = result + hex + " ";
        }
        return result;
    }

    private byte[] verifyPkcs7ByHashRSA(byte[][] certAndsignedValue, byte[] contentData, byte[] signedData, byte[] hashedData) throws Exception {
        byte[] signCert = null;
        signCert = contentData == null ? this.verifyPkcs7ByHashNotContainAttrRSA(signedData, hashedData) : this.verifyPkcs7ByHashContainAttrRSA(certAndsignedValue, contentData, hashedData);
        return signCert;
    }

    public byte[] verifyP7CompAttr_detach(byte[] hashedDataOrInData, byte[] p7Sign, boolean isHash) throws Pkcs7VerifySignException {
        ASN1Primitive pkcs;
        byte[] signCert = null;
        org.bouncycastle.asn1.ASN1InputStream din = new org.bouncycastle.asn1.ASN1InputStream(new ByteArrayInputStream(p7Sign));
        try {
            pkcs = din.readObject();
        }
        catch (IOException e) {
            throw new IllegalArgumentException("can.t.decode.pkcs7signeddata.object");
        }
        if (!(pkcs instanceof ASN1Sequence)) {
            throw new IllegalArgumentException("not.a.valid.pkcs.7.object.not.a.sequence");
        }
        ASN1Sequence signedP7Data = (ASN1Sequence)pkcs;
        ASN1ObjectIdentifier objId = (ASN1ObjectIdentifier)signedP7Data.getObjectAt(0);
        PKCS7SignedData pkcs7_rsa = new PKCS7SignedData();
        byte[] hashedData = null;
        try {
            byte[][] certAndsignedValue = GetP7InfoUtil.getAttributeSignValueAndCert(p7Sign);
            byte[] contentData = certAndsignedValue[2];
            if (hashedDataOrInData == null) {
                hashedDataOrInData = certAndsignedValue[4];
            }
            if (objId.getId().equals("1.2.156.10197.6.1.4.2.2")) {
                if (!isHash) {
                    CNPKCS7SignedData pkcs7 = new CNPKCS7SignedData(p7Sign);
                    X509CertificateStructure cert = pkcs7.getSigningCertificate();
                    hashedData = HashUtil.hash("SM3", hashedDataOrInData, cert);
                } else {
                    hashedData = hashedDataOrInData;
                }
                signCert = this.verifyPkcs7ByHashSM2(certAndsignedValue, contentData, p7Sign, hashedData);
            } else if (objId.getId().equals("1.2.840.113549.1.7.2")) {
                ASN1TaggedObject tagObj;
                ASN1Sequence body;
                ASN1Set hashAlgSet;
                ASN1Sequence hashAlgSeq;
                ASN1ObjectIdentifier hashAlg = null;
                hashedData = !isHash ? ((hashAlg = (ASN1ObjectIdentifier)(hashAlgSeq = (ASN1Sequence)(hashAlgSet = (ASN1Set)(body = (ASN1Sequence)(tagObj = (ASN1TaggedObject)signedP7Data.getObjectAt(1)).getObject()).getObjectAt(1)).getObjectAt(0)).getObjectAt(0)).getId().equals("1.3.14.3.2.26") ? HashUtil.hash("SHA1", hashedDataOrInData, null) : HashUtil.hash("SHA256", hashedDataOrInData, null)) : hashedDataOrInData;
                signCert = this.verifyPkcs7ByHashRSA(certAndsignedValue, contentData, p7Sign, hashedData);
                if (!isHash && null == signCert) {
                    hashedData = hashAlg.getId().equals("1.3.14.3.2.26") ? HashUtil.hash("SHA256", hashedDataOrInData, null) : HashUtil.hash("SHA1", hashedDataOrInData, null);
                    signCert = this.verifyPkcs7ByHashRSA(certAndsignedValue, contentData, p7Sign, hashedData);
                }
            }
        }
        catch (Exception e) {
            this.errorlog("Exception in verify sign data by pkcs7!", e);
            throw new Pkcs7VerifySignException("Exception in verify sign data by pkcs7!");
        }
        return signCert;
    }

    public byte[] verifyP7CompAttr_detach_ForJit(byte[] hashedDataOrInData, byte[] p7Sign, boolean isHash) throws Pkcs7VerifySignException {
        byte[] signCert = null;
        byte[] hashedData = null;
        try {
            if (!isHash) {
                CNPKCS7SignedData pkcs7 = new CNPKCS7SignedData(p7Sign);
                X509CertificateStructure cert = pkcs7.getSigningCertificate();
                hashedData = HashUtil.hash("SM3", hashedDataOrInData, cert);
            } else {
                hashedData = hashedDataOrInData;
            }
            signCert = this.verifyPkcs7ByHashSM2(null, null, p7Sign, hashedData);
        }
        catch (Exception e) {
            this.errorlog("Exception in verify sign data by pkcs7!", e);
            throw new Pkcs7VerifySignException("Exception in verify sign data by pkcs7!");
        }
        return signCert;
    }

    public String BJE_Pkcs7Verify_byHash_reCert(byte[] hashedData, String beSignedBlob) throws Pkcs7VerifySignException {
        try {
            Base64Util base64Util = new Base64Util(this.applicationName);
            byte[] signedDataTmp = base64Util.BJS_DecodeBase64(beSignedBlob);
            byte[] signedData = this.getValidP7Length(signedDataTmp);
            String certStr = null;
            byte[] signCert = this.verifyP7CompAttr_detach(hashedData, signedData, true);
            if (signCert == null) {
                return null;
            }
            certStr = base64Util.BJS_EncodeBase64(signCert);
            return certStr;
        }
        catch (Exception e) {
            this.errorlog("Exception in verify sign data by pkcs7!", e);
            throw new Pkcs7VerifySignException("Exception in verify sign data by pkcs7!");
        }
    }

    public String BJE_Pkcs7Verify_byHash_reCert(byte[] hashedData, byte[] beSignedBlob) throws Pkcs7VerifySignException {
        try {
            Base64Util base64Util = new Base64Util(this.applicationName);
            byte[] signedData = this.getValidP7Length(beSignedBlob);
            String certStr = null;
            byte[] signCert = this.verifyP7CompAttr_detach(hashedData, signedData, true);
            if (signCert == null) {
                return null;
            }
            certStr = base64Util.BJS_EncodeBase64(signCert);
            return certStr;
        }
        catch (Exception e) {
            this.errorlog("Exception in verify sign data by pkcs7!", e);
            throw new Pkcs7VerifySignException("Exception in verify sign data by pkcs7!");
        }
    }

    public String BJE_Pkcs7Verify_byHash_reCertForCPIC(byte[] hashedData, byte[] beSignedBlob) throws Pkcs7VerifySignException {
        try {
            Base64Util base64Util = new Base64Util(this.applicationName);
            CertificateUtil certU = new CertificateUtil(this.applicationName);
            String certStr = null;
            byte[] signCert = null;
            Security.addProvider(new BouncyCastleProvider());
            CMSSignedData sign = new CMSSignedData(beSignedBlob);
            Store<X509CertificateHolder> certStore = sign.getCertificates();
            SignerInformationStore signers = sign.getSignerInfos();
            Collection<SignerInformation> c = signers.getSigners();
            for (SignerInformation signer : c) {
                Collection<X509CertificateHolder> certCollection = certStore.getMatches(signer.getSID());
                Iterator<X509CertificateHolder> certIt = certCollection.iterator();
                X509CertificateHolder cert = certIt.next();
                X509CertificateStructure strcCert = certU.getX509CertStrc(cert.getEncoded());
                byte[] pubKey = strcCert.getSubjectPublicKeyInfo().getPublicKeyData().getBytes();
                ByteArrayInputStream bin = new ByteArrayInputStream(pubKey);
                ASN1InputStream aIn = new ASN1InputStream(bin);
                xjyb.org.bjca.asn1.ASN1Sequence seq = (xjyb.org.bjca.asn1.ASN1Sequence)aIn.readObject();
                RSAPublicKeyStructure rSAPublicKeyStructure = new RSAPublicKeyStructure(seq);
                BigInteger modulus = rSAPublicKeyStructure.getModulus();
                BigInteger exponents = rSAPublicKeyStructure.getPublicExponent();
                RSAKeyParameters RSApubKey = new RSAKeyParameters(false, modulus, exponents);
                BJCASigner bjcaSigner = null;
                if (hashedData != null && hashedData.length == 20) {
                    bjcaSigner = new BJCASigner(new SHA1Digest());
                } else if (hashedData != null && hashedData.length == 32) {
                    bjcaSigner = new BJCASigner(new SHA256Digest());
                }
                bjcaSigner.init(false, RSApubKey);
                bjcaSigner.update(hashedData, 0, hashedData.length);
                boolean verified = bjcaSigner.verifySignature(signer.getSignature());
                if (!verified) continue;
                signCert = cert.getEncoded();
            }
            if (signCert == null) {
                return null;
            }
            certStr = base64Util.BJS_EncodeBase64(signCert);
            return certStr;
        }
        catch (Exception e) {
            this.errorlog("Exception in verify sign data by pkcs7!", e);
            throw new Pkcs7VerifySignException("Exception in verify sign data by pkcs7!");
        }
    }

    public String BJE_Pkcs7TsVerify_byHash_reCert(byte[] hashedData, String beSignedBlob) throws Pkcs7VerifySignException {
        try {
            ASN1Primitive pkcs;
            Base64Util base64Util = new Base64Util(this.applicationName);
            byte[] signedDataTmp = base64Util.BJS_DecodeBase64(beSignedBlob);
            byte[] signedData = this.getValidP7Length(signedDataTmp);
            org.bouncycastle.asn1.ASN1InputStream din = new org.bouncycastle.asn1.ASN1InputStream(new ByteArrayInputStream(signedData));
            try {
                pkcs = din.readObject();
            }
            catch (IOException e) {
                throw new IllegalArgumentException("can.t.decode.pkcs7signeddata.object", e);
            }
            if (!(pkcs instanceof ASN1Sequence)) {
                throw new IllegalArgumentException("not.a.valid.pkcs.7.object.not.a.sequence");
            }
            ASN1Sequence signedP7Data = (ASN1Sequence)pkcs;
            ASN1ObjectIdentifier objId = (ASN1ObjectIdentifier)signedP7Data.getObjectAt(0);
            int verifyRet = 0;
            if (objId.getId().equals("1.2.156.10197.6.1.4.2.2")) {
                verifyRet = this.verifyPkcs7TsByHashSM2(signedData, hashedData);
                return this.assembleP7TsSignInfo(signedData, verifyRet, 8);
            }
            verifyRet = this.verifyPkcs7TsByHashRSA(signedData, hashedData);
            return this.assembleP7TsSignInfo(signedData, verifyRet, 4);
        }
        catch (Exception e) {
            this.errorlog("Exception in verify sign data by pkcs7!", e);
            throw new Pkcs7VerifySignException("Exception in verify sign data by pkcs7!", e);
        }
    }

    public String assembleP7TsSignInfo(byte[] signedData, int verifyRet, int m_Iinitmodel) throws Exception {
        byte[][] certAndsignedValue = GetP7InfoUtil.getAttributeSignValueAndCert(signedData);
        String preInfoList = this.assembleCounterSignInfoList(certAndsignedValue, m_Iinitmodel);
        boolean veryStatus = false;
        if (1 == verifyRet) {
            veryStatus = true;
        }
        return SecurityUtil.getInstance().jointVerifyCounterSignRetStr(null, verifyRet, preInfoList, veryStatus);
    }

    String assembleCounterSignInfoList(byte[][] certAndsignedValue, int m_Iinitmodel) throws Base64Exception, GetCertInfoException, ParseException, TsException, IOException {
        byte[] attributes = certAndsignedValue[2];
        ASN1InputStream derInputStream = new ASN1InputStream(new ByteArrayInputStream(attributes));
        DERSet derSetObject = (DERSet)derInputStream.readObject();
        DERSequence allAttribute = (DERSequence)derSetObject.getObjectAt(1);
        DERSet copyrightSet = (DERSet)allAttribute.getObjectAt(1);
        DERSequence copyrightAttribute = (DERSequence)copyrightSet.getObjectAt(0);
        Copyright copyright = new Copyright(copyrightAttribute);
        byte[] cert = certAndsignedValue[0];
        CertificateUtil certificateUtil = new CertificateUtil(this.applicationName);
        StringBuilder sb = new StringBuilder();
        sb.append("[");
        String beforeDate = this.convertFormat(certificateUtil.BJC_GetBasicCertInfo(cert, 11L), "yyyy/MM/dd", "yyyy-MM-dd");
        String endDate = this.convertFormat(certificateUtil.BJC_GetBasicCertInfo(cert, 12L), "yyyy/MM/dd", "yyyy-MM-dd");
        sb.append("{\"beforeDate\":\"").append(beforeDate).append("\",\"endDate\":\"").append(endDate).append("\",\"dci\":\"").append(copyright.getDci()).append("\",\"appName\":\"").append(copyright.getAppName()).append("\",\"version\":\"").append(copyright.getVersion()).append("\",\"author\":\"").append(copyright.getAuthor()).append("\",\"developTime\":\"").append(copyright.getDevelopTimeString()).append("\",\"issueTime\":\"").append(copyright.getIssueTimeString()).append("\",\"publicTime\":\"").append(copyright.getPublicTimeString()).append("\",\"pdfHash\":\"").append(copyright.getPdfHash()).append("\",\"issueDN\":\"").append(certificateUtil.BJC_GetBasicCertInfo(cert, 20L)).append("\",\"subjectDN\":\"").append(certificateUtil.BJC_GetBasicCertInfo(cert, 21L)).append("\"}");
        sb.append("]");
        return sb.toString();
    }

    String convertFormat(String time, String oriFormat, String desFormat) throws ParseException {
        SimpleDateFormat in = new SimpleDateFormat(oriFormat);
        SimpleDateFormat out = new SimpleDateFormat(desFormat);
        String desTime = out.format(in.parse(time));
        return desTime;
    }

    public int verifyPkcs7TsByHashSM2(byte[] p7TimestampSignData, byte[] hashedData) throws Pkcs7VerifySignException {
        try {
            byte[][] certAndsignedValue = GetP7InfoUtil.getAttributeSignValueAndCert(p7TimestampSignData);
            byte[] contentData = certAndsignedValue[2];
            byte[] signCert = this.verifyPkcs7ByHashSM2(certAndsignedValue, contentData, p7TimestampSignData, hashedData);
            if (signCert == null) {
                return 1400;
            }
            byte[] timestamp = certAndsignedValue[5];
            if (null != timestamp) {
                byte[] hashedDataInTs;
                TimeStampUtil timeStampUtil = new TimeStampUtil(this.applicationName);
                boolean veryTsRet = timeStampUtil.verifyTimeStamp(timestamp, certAndsignedValue[0], 8);
                if (!veryTsRet) {
                    return 1401;
                }
                ArrayList timestampList = timeStampUtil.getTimeStampInfo(timestamp, 8);
                Base64Util base64Util = new Base64Util(this.applicationName);
                byte[] hashBytes = null;
                WrapCard wCard = new WrapCard();
                hashBytes = wCard.sm3(certAndsignedValue[1], null, null);
                boolean contentEqual = Arrays.equals(hashBytes, hashedDataInTs = base64Util.BJS_DecodeBase64((String)timestampList.get(1)));
                if (!contentEqual) {
                    return 1402;
                }
            }
        }
        catch (Exception e) {
            throw new Pkcs7VerifySignException("Exception in verify sign data by sm2_pkcs7_ts !", e);
        }
        return 1;
    }

    public int verifyPkcs7TsByHashRSA(byte[] p7TimestampSignData, byte[] hashedData) throws Pkcs7VerifySignException {
        try {
            byte[][] certAndsignedValue = GetP7InfoUtil.getAttributeSignValueAndCert(p7TimestampSignData);
            byte[] contentData = certAndsignedValue[2];
            byte[] signCert = this.verifyPkcs7ByHashRSA(certAndsignedValue, contentData, p7TimestampSignData, hashedData);
            if (signCert == null) {
                return 1400;
            }
            byte[] timestamp = certAndsignedValue[5];
            if (null != timestamp) {
                Base64Util base64Util;
                byte[] hashedDataInTs;
                TimeStampUtil timeStampUtil = new TimeStampUtil(this.applicationName);
                boolean veryTsRet = timeStampUtil.verifyTimeStamp(timestamp, certAndsignedValue[0], 4);
                if (!veryTsRet) {
                    return 1401;
                }
                ArrayList timestampList = timeStampUtil.getTimeStampInfo(timestamp, 8);
                ByteArrayInputStream inputStream = new ByteArrayInputStream(certAndsignedValue[1]);
                HashUtil hashUtil = new HashUtil(this.applicationName);
                byte[] hashBytes = null;
                hashBytes = hashUtil.hashByInputStream(inputStream);
                boolean contentEqual = Arrays.equals(hashBytes, hashedDataInTs = (base64Util = new Base64Util(this.applicationName)).BJS_DecodeBase64((String)timestampList.get(1)));
                if (!contentEqual) {
                    return 1402;
                }
            }
        }
        catch (Exception e) {
            throw new Pkcs7VerifySignException("Exception in verify sign data by sm2_pkcs7_ts !", e);
        }
        return 1;
    }

    private byte[] getCertFromPKCS7SM2(CNPKCS7SignedData p7sign) {
        X509CertificateStructure cert = p7sign.getSigningCertificate();
        return cert.getDEREncoded();
    }

    private byte[] getCertFromPKCS7RSA(PKCS7SignedData p7sign) throws Exception {
        X509Certificate cert = p7sign.getSigningCertificate();
        return cert.getEncoded();
    }

    public ArrayList getP7SignDataInfo(byte[] pkcs7SignData) throws Pkcs7DecodeException {
        try {
            ASN1Primitive pkcs;
            ArrayList<byte[]> infoList = new ArrayList<byte[]>();
            byte[] validP7 = this.getValidP7Length(pkcs7SignData);
            org.bouncycastle.asn1.ASN1InputStream din = new org.bouncycastle.asn1.ASN1InputStream(new ByteArrayInputStream(validP7));
            try {
                pkcs = din.readObject();
            }
            catch (IOException e) {
                throw new IllegalArgumentException("can.t.decode.pkcs7signeddata.object");
            }
            if (!(pkcs instanceof ASN1Sequence)) {
                throw new IllegalArgumentException("not.a.valid.pkcs.7.object.not.a.sequence");
            }
            ASN1Sequence signedP7Data = (ASN1Sequence)pkcs;
            ASN1ObjectIdentifier objId = (ASN1ObjectIdentifier)signedP7Data.getObjectAt(0);
            if (objId.getId().equals("1.2.156.10197.6.1.4.2.2")) {
                CNPKCS7SignedData p7sign = new CNPKCS7SignedData(pkcs7SignData);
                infoList.add(p7sign.getPlainFromP7SignatureInfo(pkcs7SignData));
                byte[] certCode = this.getCertFromPKCS7SM2(p7sign);
                infoList.add(certCode);
                byte[] signValue = p7sign.getSignValue();
                infoList.add(signValue);
            } else if (objId.getId().equals("1.2.840.113549.1.7.2")) {
                PKCS7SignedData p7sign = new PKCS7SignedData(pkcs7SignData);
                byte[] inData = p7sign.getContentData();
                infoList.add(inData);
                byte[] certCode = this.getCertFromPKCS7RSA(p7sign);
                infoList.add(certCode);
                byte[] signValue = p7sign.getSignValue();
                infoList.add(signValue);
            }
            return infoList;
        }
        catch (Exception e) {
            this.errorlog("Exception in decoding sign data by pkcs7!", e);
            throw new Pkcs7DecodeException("Exception in decoding sign data by pkcs7!", e);
        }
    }

    public byte[] BJE_Pkcs7EncodeEnvelope(byte[] toBeEncryptedBlob, byte[] cert, long encryptMethod) throws Pkcs7EncodeEnvelopeException {
        try {
            CertificateUtil certUtil = new CertificateUtil(this.applicationName);
            PKCS7EnvelopedData pkcs7Envelope = new PKCS7EnvelopedData();
            PublicKey pubKey = certUtil.getCertPublicKey(cert);
            byte[] p7Envelop = pkcs7Envelope.encrypt(toBeEncryptedBlob, cert, "3DES", "BC", pubKey);
            return p7Envelop;
        }
        catch (Exception e) {
            this.errorlog("Exception in envelope data encode by pkcs7!", e);
            throw new Pkcs7EncodeEnvelopeException("Exception in envelope data encode by pkcs7!");
        }
    }

    public byte[] BJE_Pkcs7EncodeEnvelope(long toBeEncryptedBlobLen, byte[] cert, byte[] key, byte[] iv) throws Pkcs7EncodeEnvelopeException {
        byte[] outData = null;
        CertificateUtil certUtil = new CertificateUtil("");
        PKCS7EnvelopedData pkcs7Envelope = new PKCS7EnvelopedData();
        try {
            PublicKey pubKey = certUtil.getCertPublicKey(cert);
            outData = pkcs7Envelope.encrypt(toBeEncryptedBlobLen, cert, "3DES", "BC", pubKey, key, iv);
        }
        catch (Exception e) {
            this.errorlog("Exception in envelope data encode by pkcs7!", e);
            throw new Pkcs7EncodeEnvelopeException("Exception in envelope data encode by pkcs7!");
        }
        return outData;
    }

    public byte[] pkcs7EncodeEnvelope_sm2(byte[] toBeEncryptedBlob, byte[] cert) throws Pkcs7EncodeEnvelopeException {
        try {
            CNEnvelopedData pkcs7Envelope = new CNEnvelopedData();
            CertificateUtil certU = new CertificateUtil(this.applicationName);
            X509CertificateStructure strcCert = certU.getX509CertStrc(cert);
            byte[] p7Envelop = pkcs7Envelope.encrypt(toBeEncryptedBlob, strcCert);
            return p7Envelop;
        }
        catch (Exception e) {
            this.errorlog("Exception in envelope data encode by pkcs7_sm2!", e);
            throw new Pkcs7EncodeEnvelopeException("Exception in envelope data encode by pkcs7_sm2!");
        }
    }

    public byte[] pkcs7EncodeEnvelope_sm24Jit(byte[] toBeEncryptedBlob, byte[] cert) throws Pkcs7EncodeEnvelopeException {
        try {
            CNEnvelopedData pkcs7Envelope = new CNEnvelopedData();
            CertificateUtil certU = new CertificateUtil(this.applicationName);
            X509CertificateStructure strcCert = certU.getX509CertStrc(cert);
            byte[] p7Envelop = pkcs7Envelope.encrypt(toBeEncryptedBlob, strcCert, 1);
            return p7Envelop;
        }
        catch (Exception e) {
            this.errorlog("Exception in envelope data encode by pkcs7_sm2!", e);
            throw new Pkcs7EncodeEnvelopeException("Exception in envelope data encode by pkcs7_sm2!");
        }
    }

    public byte[] pkcs7EncodeEnvelope_sm2(long toBeEncryptedBlobLen, byte[] cert, byte[] key, byte[] iv) throws Pkcs7EncodeEnvelopeException {
        try {
            CNEnvelopedData pkcs7Envelope = new CNEnvelopedData();
            CertificateUtil certU = new CertificateUtil(this.applicationName);
            X509CertificateStructure strcCert = certU.getX509CertStrc(cert);
            byte[] p7Envelop = pkcs7Envelope.encrypt(toBeEncryptedBlobLen, strcCert, key, iv);
            return p7Envelop;
        }
        catch (Exception e) {
            this.errorlog("Exception in envelope data encode by pkcs7_sm2!", e);
            throw new Pkcs7EncodeEnvelopeException("Exception in envelope data encode by pkcs7_sm2!");
        }
    }

    public byte[] BJE_Pkcs7DecodeEnvelope(byte[] beEncryptedBlob, int m_Iinitmodel, byte[] m_encryptPfx, String m_keyType, String m_container, PrivateKey privateKey, P11Interface p11Impl, byte[] cert) throws Pkcs7DecodeEnvelopeException {
        try {
            CertificateFactory oCf = CertificateFactory.getInstance("X.509");
            ByteArrayInputStream ois = new ByteArrayInputStream(cert);
            X509Certificate oCert = (X509Certificate)oCf.generateCertificate(ois);
            PKCS7EnvelopedData pkcs7Envelope = new PKCS7EnvelopedData();
            byte[] outData = null;
            if (m_Iinitmodel == 4 || m_Iinitmodel == 6) {
                outData = pkcs7Envelope.decrypt(beEncryptedBlob, oCert, privateKey);
            } else if (m_Iinitmodel == 5) {
                try {
                    outData = pkcs7Envelope.decrypt(beEncryptedBlob, oCert, p11Impl, m_keyType, m_container);
                }
                catch (P11ConnectException e) {
                    System.out.println("Exception in p11 connection !");
                    this.errorlog("Exception in p11 connection !", e);
                }
            }
            return outData;
        }
        catch (Exception e) {
            this.errorlog("Exception in decoding envelope data by pkcs7!", e);
            throw new Pkcs7DecodeEnvelopeException(e.getMessage());
        }
    }

    public byte[] pkcs7DecodeEnvelope_sm2(byte[] encryptedBlob, byte[] privateKey, byte[] cert) throws Pkcs7DecodeEnvelopeException {
        try {
            CNEnvelopedData pkcs7Envelope = new CNEnvelopedData();
            CertificateUtil certU = new CertificateUtil(this.applicationName);
            X509CertificateStructure strcCert = certU.getX509CertStrc(cert);
            byte[] outData = pkcs7Envelope.decrypt(encryptedBlob, privateKey, strcCert);
            return outData;
        }
        catch (Exception e) {
            this.errorlog("Exception in decoding envelope data by pkcs7_sm2!", e);
            throw new Pkcs7DecodeEnvelopeException("Exception in decoding envelope data by pkcs7_sm2!");
        }
    }

    public byte[] pkcs7DecodeEnvelope_sm24Jit(byte[] encryptedBlob, byte[] privateKey, byte[] cert) throws Pkcs7DecodeEnvelopeException {
        try {
            CNEnvelopedData pkcs7Envelope = new CNEnvelopedData();
            CertificateUtil certU = new CertificateUtil(this.applicationName);
            X509CertificateStructure strcCert = certU.getX509CertStrc(cert);
            byte[] outData = pkcs7Envelope.decrypt(encryptedBlob, privateKey, strcCert, 1);
            return outData;
        }
        catch (Exception e) {
            this.errorlog("Exception in decoding envelope data by pkcs7_sm2!", e);
            throw new Pkcs7DecodeEnvelopeException("Exception in decoding envelope data by pkcs7_sm2!");
        }
    }

    public String BJE_Pkcs7EncodeSignAndEnvelope_SM2(byte[] inData, byte[] m_signCertBytes, byte[] privateKeyByte, byte[] receiveCertByte) throws Pkcs7EncodeException {
        try {
            CertificateUtil certU = new CertificateUtil(this.applicationName);
            X509CertificateStructure strcSignCert = certU.getX509CertStrc(m_signCertBytes);
            X509CertificateStructure[] x509Certs = new X509CertificateStructure[]{strcSignCert};
            X509CertificateStructure receiveX509Cert = certU.getX509CertStrc(receiveCertByte);
            PKCS7SignedAndEnvelopedData signedAndEnvelop = new PKCS7SignedAndEnvelopedData();
            byte[] signedData = signedAndEnvelop.encrypt_sm2(privateKeyByte, x509Certs, null, inData, receiveX509Cert);
            Base64Util base64Util = new Base64Util(this.applicationName);
            String base64P7Sign = base64Util.BJS_EncodeBase64(signedData);
            return base64P7Sign;
        }
        catch (Exception e) {
            this.errorlog("Exception in encode sign and envelope data by pkcs7!", e);
            throw new Pkcs7EncodeException("Exception in encode sign and envelope data by pkcs7!");
        }
    }

    public byte[] BJE_Pkcs7DecodeSignAndEnvelope_SM2(String beEncryptedBlob, byte[] privateKeyByte, byte[] receiveCertByte) throws Pkcs7DecodeException {
        try {
            CertificateUtil certU = new CertificateUtil(this.applicationName);
            Base64Util base64Util = new Base64Util(this.applicationName);
            X509CertificateStructure receiveX509Cert = certU.getX509CertStrc(receiveCertByte);
            PKCS7SignedAndEnvelopedData signedAndEnvelop = new PKCS7SignedAndEnvelopedData();
            byte[] signedData = signedAndEnvelop.decrypt_sm2(base64Util.BJS_DecodeBase64(beEncryptedBlob), receiveX509Cert, privateKeyByte);
            return signedData;
        }
        catch (Exception e) {
            this.errorlog("Exception in decode sign and envelope data by pkcs7!", e);
            throw new Pkcs7DecodeException("Exception in decode sign and envelope data by pkcs7!", e);
        }
    }

    public byte[] BJE_Pkcs7DecodeSignAndEnvelope_SM2_Jit(String beEncryptedBlob, byte[] privateKeyByte, byte[] receiveCertByte) throws Pkcs7DecodeException {
        try {
            CertificateUtil certU = new CertificateUtil(this.applicationName);
            Base64Util base64Util = new Base64Util(this.applicationName);
            X509CertificateStructure receiveX509Cert = certU.getX509CertStrc(receiveCertByte);
            PKCS7SignedAndEnvelopedData signedAndEnvelop = new PKCS7SignedAndEnvelopedData();
            byte[] signedData = signedAndEnvelop.decrypt_sm2ForJit(base64Util.BJS_DecodeBase64(beEncryptedBlob), receiveX509Cert, privateKeyByte);
            return signedData;
        }
        catch (Exception e) {
            this.errorlog("Exception in decode sign and envelope data by pkcs7!", e);
            throw new Pkcs7DecodeException("Exception in decode sign and envelope data by pkcs7!", e);
        }
    }

    public String BJE_Pkcs7EncodeSignAndEnvelope(byte[] inData, int m_Iinitmodel, byte[] m_signCertBytes, String m_keyType, String m_container, PrivateKey privateKey, P11Interface p11Impl, byte[] receiveCertByte) throws Pkcs7EncodeException {
        try {
            CertificateUtil certUtil = new CertificateUtil(this.applicationName);
            Base64Util base64Util = new Base64Util(this.applicationName);
            CertificateFactory oCf = CertificateFactory.getInstance("X.509");
            ByteArrayInputStream ois = new ByteArrayInputStream(m_signCertBytes);
            X509Certificate oCert = (X509Certificate)oCf.generateCertificate(ois);
            Certificate[] certs = new Certificate[]{oCert};
            PublicKey pubKey = certUtil.getCertPublicKey(receiveCertByte);
            ByteArrayInputStream receiveOis = new ByteArrayInputStream(receiveCertByte);
            X509Certificate receiveCert = (X509Certificate)oCf.generateCertificate(receiveOis);
            PKCS7SignedAndEnvelopedData signedAndEnvelop = new PKCS7SignedAndEnvelopedData();
            String base64P7Sign = null;
            if (m_Iinitmodel == 4 || m_Iinitmodel == 6) {
                byte[] p7SignAndEnvelopData = signedAndEnvelop.encrypt(privateKey, certs, null, inData, receiveCert, pubKey);
                base64P7Sign = base64Util.BJS_EncodeBase64(p7SignAndEnvelopData);
            } else if (m_Iinitmodel == 5) {
                try {
                    byte[] p7SignAndEnvelopData = signedAndEnvelop.encrypt(p11Impl, m_keyType, m_container, certs, null, inData, receiveCert, pubKey);
                    base64P7Sign = base64Util.BJS_EncodeBase64(p7SignAndEnvelopData);
                }
                catch (P11ConnectException e) {
                    System.out.println("Exception in p11 connection !");
                    this.errorlog("Exception in p11 connection !", e);
                }
            }
            return base64P7Sign;
        }
        catch (Exception e) {
            this.errorlog("Exception in encode sign and envelope data by pkcs7!", e);
            throw new Pkcs7EncodeException("Exception in encode sign and envelope data by pkcs7!");
        }
    }

    public byte[] BJE_Pkcs7DecodeSignAndEnvelope(String beEncryptedBlob, int m_Iinitmodel, String m_keyType, String m_container, PrivateKey privateKey, P11Interface p11Impl, byte[] cert) throws Pkcs7DecodeException {
        try {
            Base64Util base64Util = new Base64Util(this.applicationName);
            CertificateFactory oCf = CertificateFactory.getInstance("X.509");
            ByteArrayInputStream ois = new ByteArrayInputStream(cert);
            X509Certificate oCert = (X509Certificate)oCf.generateCertificate(ois);
            PKCS7SignedAndEnvelopedData pkcs7Envelope = new PKCS7SignedAndEnvelopedData();
            byte[] outData = null;
            byte[] encryptedData = base64Util.BJS_DecodeBase64(beEncryptedBlob);
            if (m_Iinitmodel == 4 || m_Iinitmodel == 6) {
                outData = pkcs7Envelope.decrypt(encryptedData, oCert, privateKey);
            } else if (m_Iinitmodel == 5) {
                try {
                    outData = pkcs7Envelope.decrypt(encryptedData, oCert, p11Impl, m_keyType, m_container);
                }
                catch (P11ConnectException e) {
                    System.out.println("Exception in p11 connection !");
                    this.errorlog("Exception in p11 connection !", e);
                }
            }
            return outData;
        }
        catch (Exception e) {
            this.errorlog("Exception in decoding sign and envelope data by pkcs7!", e);
            throw new Pkcs7DecodeException("Exception in decoding sign and envelope data by pkcs7!");
        }
    }

    public byte[] createP7DetachedAndTimeStampedData(byte[] hashedOriginalData, byte[] m_signCertBytes, PrivateKey privateKey) throws GeneralSecurityException {
        CertificateFactory oCf = CertificateFactory.getInstance("X.509");
        ByteArrayInputStream ois = new ByteArrayInputStream(m_signCertBytes);
        X509Certificate oCert = (X509Certificate)oCf.generateCertificate(ois);
        Certificate[] certs = new Certificate[]{oCert};
        Certificate[] certsChain = new Certificate[]{oCert};
        TSAClientBouncyCastle tsaClient = new TSAClientBouncyCastle("");
        PrivateKeySignature externalSignature = null;
        String hashTypeString = HashUtil.getHashAlg(this.applicationName);
        externalSignature = "SHA1".equals(hashTypeString) ? new PrivateKeySignature(privateKey, "SHA-1", "BC") : new PrivateKeySignature(privateKey, "SHA-256", "BC");
        String hashAlgorithm = externalSignature.getHashAlgorithm();
        BouncyCastleDigest externalDigest = new BouncyCastleDigest();
        PdfPKCS7 sgn = new PdfPKCS7(null, certsChain, hashAlgorithm, null, externalDigest, false);
        Calendar cal = Calendar.getInstance();
        byte[] ocsp = null;
        Collection<byte[]> crlBytes = null;
        byte[] sh = sgn.getAuthenticatedAttributeBytes(hashedOriginalData, cal, ocsp, crlBytes, MakeSignature.CryptoStandard.CMS);
        byte[] extSignature = externalSignature.sign(sh);
        sgn.setExternalDigest(extSignature, null, externalSignature.getEncryptionAlgorithm());
        byte[] encodedSig = sgn.getEncodedPKCS7(hashedOriginalData, cal, tsaClient, ocsp, crlBytes, MakeSignature.CryptoStandard.CMS);
        return encodedSig;
    }

    public byte[] createP7DetachedAndTimeStampedData_ts(byte[] p7sign, byte[] hashedOriginalData) throws GeneralSecurityException {
        TSAClientBouncyCastle tsaClient = new TSAClientBouncyCastle("");
        PdfPKCS7 sgn = new PdfPKCS7();
        byte[] encodedSig = sgn.addTimeStamp(p7sign, hashedOriginalData, tsaClient);
        return encodedSig;
    }

    public byte[] generateP7DetachedByP7AndTimeStampedData(byte[] p7sign, byte[] timeStamp) throws GeneralSecurityException {
        PdfPKCS7 sgn = new PdfPKCS7();
        byte[] encodedSig = sgn.addTimeStamp(p7sign, timeStamp);
        return encodedSig;
    }

    public int verifyP7DetachedAndTimeStampedData(byte[] p7DetachedAndTsData) {
        int verifyP7TsRet;
        block13: {
            verifyP7TsRet = -4;
            try {
                ASN1Primitive pkcs;
                byte[][] certAndsignedValue = GetP7InfoUtil.getAttributeSignValueAndCert(p7DetachedAndTsData);
                byte[] signedData = this.getValidP7Length(p7DetachedAndTsData);
                org.bouncycastle.asn1.ASN1InputStream din = new org.bouncycastle.asn1.ASN1InputStream(new ByteArrayInputStream(signedData));
                try {
                    pkcs = din.readObject();
                }
                catch (IOException e) {
                    this.errorlog("can.t.decode.pkcs7signeddata.object!", e);
                    return -4;
                }
                if (!(pkcs instanceof ASN1Sequence)) {
                    this.errorlog("not.a.valid.pkcs.7.object.not.a.sequence!");
                    return -4;
                }
                ASN1Sequence signedP7Data = (ASN1Sequence)pkcs;
                ASN1ObjectIdentifier objId = (ASN1ObjectIdentifier)signedP7Data.getObjectAt(0);
                int verifyRet = 0;
                if (objId.getId().equals("1.2.156.10197.6.1.4.2.2")) {
                    try {
                        verifyRet = this.verifyPkcs7TsByHashSM2(signedData, certAndsignedValue[3]);
                    }
                    catch (Pkcs7VerifySignException e) {
                        this.errorlog("Pkcs7VerifySignException in verify P7Detached and TimeStamped!", e);
                        return -4;
                    }
                    verifyP7TsRet = 1 == verifyRet ? 1 : (1400 == verifyRet ? -1 : (1401 == verifyRet ? -3 : (1402 == verifyRet ? -2 : -4)));
                    break block13;
                }
                PdfPKCS7 pdfP7 = new PdfPKCS7(p7DetachedAndTsData, false, null);
                try {
                    pdfP7.verify();
                }
                catch (SignatureException e) {
                    this.errorlog("SignatureException in verify P7Detached!", e);
                    return -1;
                }
                try {
                    boolean isSuccess = pdfP7.verifyTimestampImprint();
                    verifyP7TsRet = isSuccess ? 1 : -2;
                }
                catch (TSPValidationException e) {
                    this.errorlog("TSPValidationException in verify timestamp by P7DetachedTimestamp!", e);
                    return -3;
                }
                catch (Exception e) {
                    this.errorlog("Exception in verify timestamp by P7DetachedTimestamp!", e);
                    return -4;
                }
            }
            catch (Exception e) {
                this.errorlog("Exception in verify P7Detached and TimeStamped!", e);
                return -4;
            }
        }
        return verifyP7TsRet;
    }

    private String getInfoFromTimeStamp(byte[] timeStamp, int m_Iinitmodel, int type) {
        TimeStampUtil tsUtil = new TimeStampUtil(this.applicationName);
        ArrayList tsInfoList = new ArrayList();
        try {
            if (timeStamp != null) {
                tsInfoList = tsUtil.getTimeStampInfo(timeStamp, m_Iinitmodel);
            }
        }
        catch (TsException e) {
            this.errorlog("Exception in getTimeStampInfo!", e);
        }
        if (type == 1 && tsInfoList != null && tsInfoList.size() > 0) {
            return (String)tsInfoList.get(0);
        }
        if (type == 3 && tsInfoList != null && tsInfoList.size() > 2) {
            return (String)tsInfoList.get(2);
        }
        return null;
    }

    public ArrayList getP7DetachedAndTimeStampedDataInfo(byte[] p7DetachedAndTsData, int m_Iinitmodel) throws IOException, CertificateEncodingException {
        Base64Util base64Util = new Base64Util(this.applicationName);
        ArrayList<String> infoList = new ArrayList<String>();
        PdfPKCS7 pdfPKCS7 = new PdfPKCS7();
        byte[][] rets = pdfPKCS7.getTimeStampAndCertAndDigestAttrFromPKCS7(p7DetachedAndTsData);
        byte[] timeStamp = null;
        if (rets != null && rets.length > 2 && rets[2] != null) {
            timeStamp = rets[2];
        }
        infoList.add(this.getInfoFromTimeStamp(timeStamp, m_Iinitmodel, 1));
        String digestAttr = "";
        if (rets != null && rets.length > 1 && rets[1] != null) {
            digestAttr = base64Util.BJS_EncodeBase64(rets[1]);
        }
        infoList.add(digestAttr);
        String signCertString = "";
        if (rets != null && rets.length > 0 && rets[0] != null) {
            signCertString = base64Util.BJS_EncodeBase64(rets[0]);
        }
        infoList.add(signCertString);
        infoList.add(this.getInfoFromTimeStamp(timeStamp, m_Iinitmodel, 3));
        infoList.add(base64Util.BJS_EncodeBase64(timeStamp));
        return infoList;
    }

    public byte[] pkcs7CounterSign(byte[] p7SignData, byte[] p7ConterSignData, int m_Iinitmodel, byte[] signCertBytes) throws Pkcs7SignException, IOException, CertificateException, InvalidKeyException, SecurityException, NoSuchProviderException, NoSuchAlgorithmException {
        DERInputStream CertTempstream = new DERInputStream(new ByteArrayInputStream(signCertBytes));
        try {
            DERInputStream derInputStream = new DERInputStream(new ByteArrayInputStream(p7SignData));
            if (derInputStream == null) {
                return null;
            }
            DERConstructedSequence whole = (DERConstructedSequence)derInputStream.readObject();
            if (whole == null) {
                return null;
            }
            DERTaggedObject tagObj = (DERTaggedObject)whole.getObjectAt(1);
            if (tagObj == null) {
                return null;
            }
            DERConstructedSequence body = (DERConstructedSequence)tagObj.getObject();
            if (body == null) {
                return null;
            }
            DERTaggedObject newDercertificates = null;
            DERTaggedObject certObj = (DERTaggedObject)body.getObjectAt(3);
            DERConstructedSequence oriDercertificates = (DERConstructedSequence)certObj.getObject();
            if (oriDercertificates.size() > 2) {
                if (oriDercertificates.getObjectAt(2) instanceof DERBitString) {
                    DERConstructedSet counterDercertificates = new DERConstructedSet();
                    counterDercertificates.addObject(oriDercertificates);
                    counterDercertificates.addObject(CertTempstream.readObject());
                    newDercertificates = new DERTaggedObject(false, 0, counterDercertificates);
                } else {
                    oriDercertificates.addObject(CertTempstream.readObject());
                    newDercertificates = new DERTaggedObject(false, 0, oriDercertificates);
                }
            } else {
                oriDercertificates.addObject(CertTempstream.readObject());
                newDercertificates = new DERTaggedObject(false, 0, oriDercertificates);
            }
            DERConstructedSet signerinfos = null;
            signerinfos = body.size() == 6 ? (DERConstructedSet)body.getObjectAt(5) : (DERConstructedSet)body.getObjectAt(4);
            if (signerinfos == null) {
                return null;
            }
            DERConstructedSequence signerinfo = (DERConstructedSequence)signerinfos.getObjectAt(0);
            if (signerinfo == null) {
                return null;
            }
            DERInputStream counterSignInputStream = new DERInputStream(new ByteArrayInputStream(p7ConterSignData));
            if (derInputStream == null) {
                return null;
            }
            DERConstructedSequence counterSignWhole = (DERConstructedSequence)counterSignInputStream.readObject();
            if (counterSignWhole == null) {
                return null;
            }
            DERTaggedObject counterSignTagObj = (DERTaggedObject)counterSignWhole.getObjectAt(1);
            if (counterSignTagObj == null) {
                return null;
            }
            DERConstructedSequence counterSignBody = (DERConstructedSequence)counterSignTagObj.getObject();
            if (counterSignBody == null) {
                return null;
            }
            DERConstructedSet counterSignSignerinfos = (DERConstructedSet)counterSignBody.getObjectAt(4);
            if (counterSignSignerinfos == null) {
                return null;
            }
            DERConstructedSequence counterSignSignerinfo = (DERConstructedSequence)counterSignSignerinfos.getObjectAt(0);
            if (counterSignSignerinfo == null) {
                return null;
            }
            Attribute[] attributes = new Attribute[]{new Attribute(CMSAttributes.counterSignature, new DERSet(counterSignSignerinfo))};
            if (signerinfo.getSize() >= 6) {
                DERTaggedObject signerinfoObj = (DERTaggedObject)signerinfo.getObjectAt(signerinfo.getSize() - 1);
                DERConstructedSequence unauthenticatedAttributes = (DERConstructedSequence)signerinfoObj.getObject();
                if (unauthenticatedAttributes.getObjectAt(0) instanceof DERObjectIdentifier) {
                    DERConstructedSet counterSignatures = new DERConstructedSet();
                    counterSignatures.addObject(unauthenticatedAttributes);
                    counterSignatures.addObject(attributes[0]);
                    signerinfos = new DERConstructedSet();
                    DERConstructedSequence newSignerinfo = new DERConstructedSequence();
                    for (int i = 0; i < signerinfo.getSize() - 1; ++i) {
                        newSignerinfo.addObject(signerinfo.getObjectAt(i));
                    }
                    newSignerinfo.addObject(new DERTaggedObject(false, 1, counterSignatures));
                    signerinfos.addObject(newSignerinfo);
                } else {
                    unauthenticatedAttributes.addObject(attributes[0]);
                }
            } else {
                DERConstructedSet counterSignatures = new DERConstructedSet();
                counterSignatures.addObject(attributes[0]);
                signerinfo.addObject(new DERTaggedObject(false, 1, counterSignatures));
            }
            DERConstructedSequence newWhole = new DERConstructedSequence();
            DERConstructedSequence newBody = new DERConstructedSequence();
            newBody.addObject(body.getObjectAt(0));
            newBody.addObject(body.getObjectAt(1));
            newBody.addObject(body.getObjectAt(2));
            newBody.addObject(newDercertificates);
            newBody.addObject(signerinfos);
            newWhole.addObject(new DERObjectIdentifier("1.2.840.113549.1.7.2"));
            newWhole.addObject(new DERTaggedObject(0, newBody));
            ByteArrayOutputStream bOut = new ByteArrayOutputStream();
            DEROutputStream dout = new DEROutputStream(bOut);
            dout.writeObject(newWhole);
            dout.close();
            return bOut.toByteArray();
        }
        catch (Exception e) {
            this.errorlog("Exception in BJE_Pkcs7CounterSign!", e);
            throw new Pkcs7SignException("Exception in BJE_Pkcs7CounterSign!");
        }
    }

    public Object[] getP7CounterSignDataInfo(byte[] beSignedBlob) throws Pkcs7DecodeException {
        Object[] rets = new Object[7];
        try {
            DERTaggedObject signerinfoObj;
            DERConstructedSequence unauthenticatedAttributes;
            DERInputStream derInputStream = new DERInputStream(new ByteArrayInputStream(beSignedBlob));
            if (derInputStream == null) {
                return null;
            }
            DERConstructedSequence whole = (DERConstructedSequence)derInputStream.readObject();
            if (whole == null) {
                return null;
            }
            DERTaggedObject tagObj = (DERTaggedObject)whole.getObjectAt(1);
            if (tagObj == null) {
                return null;
            }
            DERConstructedSequence body = (DERConstructedSequence)tagObj.getObject();
            if (body == null) {
                return null;
            }
            DERTaggedObject certObj = (DERTaggedObject)body.getObjectAt(3);
            DERConstructedSequence dercertificates = (DERConstructedSequence)certObj.getObject();
            ArrayList<byte[]> certList = new ArrayList<byte[]>();
            if (dercertificates.size() == 3 && dercertificates.getObjectAt(2) instanceof DERBitString) {
                return null;
            }
            for (int i = 1; i < dercertificates.size(); ++i) {
                DERConstructedSequence cert = (DERConstructedSequence)dercertificates.getObjectAt(i);
                certList.add(cert.getEncoded());
            }
            rets[0] = certList;
            DERConstructedSet signerinfos = (DERConstructedSet)body.getObjectAt(4);
            if (signerinfos == null) {
                return null;
            }
            DERConstructedSequence signerinfo = (DERConstructedSequence)signerinfos.getObjectAt(0);
            if (signerinfo == null) {
                return null;
            }
            DEROctetString digest = (DEROctetString)signerinfo.getObjectAt(4);
            if (digest == null) {
                return null;
            }
            rets[1] = digest.getOctets();
            ArrayList<String> contentTypeList = new ArrayList<String>();
            ArrayList<String> signingTimeList = new ArrayList<String>();
            ArrayList<byte[]> messageDigestList = new ArrayList<byte[]>();
            ArrayList<byte[]> counterSignValueList = new ArrayList<byte[]>();
            ArrayList<byte[]> attributeSetBinaryList = new ArrayList<byte[]>();
            if (signerinfo.size() >= 6 && (unauthenticatedAttributes = (DERConstructedSequence)(signerinfoObj = (DERTaggedObject)signerinfo.getObjectAt(signerinfo.getSize() - 1)).getObject()) != null) {
                if (unauthenticatedAttributes.getObjectAt(0) instanceof DERObjectIdentifier) {
                    DERConstructedSet counterSignerinfos = (DERConstructedSet)unauthenticatedAttributes.getObjectAt(1);
                    DERConstructedSequence counterSignerinfo = (DERConstructedSequence)counterSignerinfos.getObjectAt(0);
                    DEROctetString counterSignValue = (DEROctetString)counterSignerinfo.getObjectAt(5);
                    counterSignValueList.add(counterSignValue.getOctets());
                    DERTaggedObject atrributesObj = (DERTaggedObject)counterSignerinfo.getObjectAt(3);
                    DERConstructedSequence atrributes = (DERConstructedSequence)atrributesObj.getObject();
                    attributeSetBinaryList.add(atrributes.getEncoded());
                    DERConstructedSequence contentTypeAtrribute = (DERConstructedSequence)atrributes.getObjectAt(0);
                    DERConstructedSet contentTypeSet = (DERConstructedSet)contentTypeAtrribute.getObjectAt(1);
                    DERObjectIdentifier contentType = (DERObjectIdentifier)contentTypeSet.getObjectAt(0);
                    contentTypeList.add(contentType.toString());
                    DERConstructedSequence signingTimeAtrribute = (DERConstructedSequence)atrributes.getObjectAt(1);
                    DERConstructedSet signingTimeSet = (DERConstructedSet)signingTimeAtrribute.getObjectAt(1);
                    DERUTCTime signingTime = (DERUTCTime)signingTimeSet.getObjectAt(0);
                    SimpleDateFormat dbDateFormat = new SimpleDateFormat("yyyy-MM-dd");
                    dbDateFormat.setTimeZone(TimeZone.getTimeZone("GMT+8"));
                    String strOptDate = dbDateFormat.format(signingTime.getDate());
                    signingTimeList.add(strOptDate);
                    DERConstructedSequence messageDigestAtrribute = (DERConstructedSequence)atrributes.getObjectAt(2);
                    DERConstructedSet messageDigestSet = (DERConstructedSet)messageDigestAtrribute.getObjectAt(1);
                    DEROctetString messageDigest = (DEROctetString)messageDigestSet.getObjectAt(0);
                    messageDigestList.add(messageDigest.getOctets());
                } else {
                    for (int i = 0; i < unauthenticatedAttributes.size(); ++i) {
                        DERConstructedSequence counterSignerinfos = (DERConstructedSequence)unauthenticatedAttributes.getObjectAt(i);
                        DERConstructedSet counterSignerinfoSet = (DERConstructedSet)counterSignerinfos.getObjectAt(1);
                        DERConstructedSequence counterSignerinfo = (DERConstructedSequence)counterSignerinfoSet.getObjectAt(0);
                        DEROctetString counterSignValue = (DEROctetString)counterSignerinfo.getObjectAt(5);
                        counterSignValueList.add(counterSignValue.getOctets());
                        DERTaggedObject atrributesObj = (DERTaggedObject)counterSignerinfo.getObjectAt(3);
                        DERConstructedSequence atrributes = (DERConstructedSequence)atrributesObj.getObject();
                        attributeSetBinaryList.add(atrributes.getEncoded());
                        DERConstructedSequence contentTypeAtrribute = (DERConstructedSequence)atrributes.getObjectAt(0);
                        DERConstructedSet contentTypeSet = (DERConstructedSet)contentTypeAtrribute.getObjectAt(1);
                        DERObjectIdentifier contentType = (DERObjectIdentifier)contentTypeSet.getObjectAt(0);
                        contentTypeList.add(contentType.toString());
                        DERConstructedSequence signingTimeAtrribute = (DERConstructedSequence)atrributes.getObjectAt(1);
                        DERConstructedSet signingTimeSet = (DERConstructedSet)signingTimeAtrribute.getObjectAt(1);
                        DERUTCTime signingTime = (DERUTCTime)signingTimeSet.getObjectAt(0);
                        SimpleDateFormat dbDateFormat = new SimpleDateFormat("yyyy-MM-dd");
                        dbDateFormat.setTimeZone(TimeZone.getTimeZone("GMT+8"));
                        String strOptDate = dbDateFormat.format(signingTime.getDate());
                        signingTimeList.add(strOptDate);
                        DERConstructedSequence messageDigestAtrribute = (DERConstructedSequence)atrributes.getObjectAt(2);
                        DERConstructedSet messageDigestSet = (DERConstructedSet)messageDigestAtrribute.getObjectAt(1);
                        DEROctetString messageDigest = (DEROctetString)messageDigestSet.getObjectAt(0);
                        messageDigestList.add(messageDigest.getOctets());
                    }
                }
            }
            rets[2] = contentTypeList;
            rets[3] = signingTimeList;
            rets[4] = messageDigestList;
            rets[5] = counterSignValueList;
            rets[6] = attributeSetBinaryList;
            return rets;
        }
        catch (Exception e) {
            this.errorlog("Exception in get Pkcs7 CounterSignData Info!", e);
            throw new Pkcs7DecodeException("Exception in get Pkcs7 CounterSignData Info!");
        }
    }

    public byte[] getP7SignDataInfoR(byte[] beSignedBlob) throws Pkcs7DecodeException {
        try {
            DERInputStream derInputStream = new DERInputStream(new ByteArrayInputStream(beSignedBlob));
            if (derInputStream == null) {
                return null;
            }
            DERConstructedSequence whole = (DERConstructedSequence)derInputStream.readObject();
            if (whole == null) {
                return null;
            }
            DERTaggedObject tagObj = (DERTaggedObject)whole.getObjectAt(1);
            if (tagObj == null) {
                return null;
            }
            DERConstructedSequence body = (DERConstructedSequence)tagObj.getObject();
            if (body == null) {
                return null;
            }
            DERConstructedSet signerinfos = (DERConstructedSet)body.getObjectAt(4);
            if (signerinfos == null) {
                return null;
            }
            DERConstructedSequence signerinfo = (DERConstructedSequence)signerinfos.getObjectAt(0);
            if (signerinfo == null) {
                return null;
            }
            DEROctetString digest = (DEROctetString)signerinfo.getObjectAt(4);
            if (digest == null) {
                return null;
            }
            return digest.getOctets();
        }
        catch (Exception e) {
            this.errorlog("Exception in get Pkcs7 CounterSignData Info!", e);
            throw new Pkcs7DecodeException("Exception in get Pkcs7 CounterSignData Info!");
        }
    }

    public int verifyPkcs7CounterSign(Object[] infoList) throws HashException, IOException, GetCertInfoException {
        Base64Util base64Util = new Base64Util(this.applicationName);
        CertificateUtil certUtil = new CertificateUtil(this.applicationName);
        ArrayList certs = (ArrayList)infoList[0];
        byte[] oriSignValue = (byte[])infoList[1];
        ArrayList contentTypeList = (ArrayList)infoList[2];
        ArrayList signingTimeList = (ArrayList)infoList[3];
        ArrayList messageDigestList = (ArrayList)infoList[4];
        ArrayList counterSignValueList = (ArrayList)infoList[5];
        ArrayList attributeSetBinaryList = (ArrayList)infoList[6];
        if (certs.size() != contentTypeList.size() || certs.size() != signingTimeList.size() || certs.size() != messageDigestList.size() || certs.size() != counterSignValueList.size() || certs.size() != attributeSetBinaryList.size()) {
            return -2;
        }
        byte[] signCert = null;
        for (int i = 0; i < certs.size(); ++i) {
            byte[][] certAndsignedValue = new byte[4][];
            certAndsignedValue[0] = (byte[])certs.get(i);
            certAndsignedValue[1] = (byte[])counterSignValueList.get(i);
            certAndsignedValue[3] = (byte[])messageDigestList.get(i);
            X509CertificateStructure counterSignCert = certUtil.getX509CertStrc(certAndsignedValue[0]);
            String contentType = (String)contentTypeList.get(i);
            byte[] hashedData = this.hashByteByContentType(oriSignValue, counterSignCert, contentType);
            byte[] attributeSetBinary = (byte[])attributeSetBinaryList.get(i);
            if (contentType.equals("1.2.156.10197.6.1.4.2.1")) {
                signCert = this.verifyPkcs7ByHashContainAttrSM2(certAndsignedValue, attributeSetBinary, hashedData);
                continue;
            }
            if (!contentType.equals("1.2.840.113549.1.7.1")) continue;
            signCert = this.verifyPkcs7ByHashContainAttrRSA(certAndsignedValue, attributeSetBinary, hashedData);
        }
        if (signCert != null) {
            return 1;
        }
        return -1;
    }

    public byte[] hashByteByContentType(byte[] inData, X509CertificateStructure strucCert, String contentType) throws HashException {
        if (contentType.equals("1.2.156.10197.6.1.4.2.1")) {
            byte[] publicKey = null;
            byte[] id = null;
            if (strucCert != null) {
                SubjectPublicKeyInfo spki = strucCert.getSubjectPublicKeyInfo();
                byte[] bPubKey = spki.getPublicKeyData().getBytes();
                publicKey = new byte[64];
                System.arraycopy(bPubKey, 1, publicKey, 0, publicKey.length);
                id = "1234567812345678".getBytes();
            }
            try {
                WrapCard wCard = new WrapCard();
                byte[] hashedData = wCard.sm3(inData, publicKey, id);
                return hashedData;
            }
            catch (Exception e) {
                this.errorlog("Exception in sm2 signature with hashed Data!", e);
                return null;
            }
        }
        HashUtil hashUtil = new HashUtil(this.applicationName);
        return hashUtil.BJS_HashBytes(1L, inData);
    }

    public byte[] signAttributeP7Ybq(byte[] hashedData, String oids, int m_Iinitmodel, byte[] m_signCertBytes, String m_keyType, String m_container, PrivateKey privateCrtKey, byte[] privateKeyByte) throws Pkcs7SignException {
        try {
            byte[] p7SignData = null;
            Object signedBuf = null;
            Map oidMap = null;
            oidMap = !"".equals(oids) && null != oids ? this.getMapInfoFromJson(oids) : new HashMap();
            if (m_Iinitmodel == 4 || m_Iinitmodel == 6) {
                p7SignData = this.signAttributeP7RSAYbq(hashedData, oidMap, m_signCertBytes, privateCrtKey);
            } else if (m_Iinitmodel != 5 && (m_Iinitmodel == 7 || m_Iinitmodel == 8)) {
                p7SignData = this.signAttributeP7SM2Ybq(hashedData, oidMap, m_signCertBytes, privateKeyByte);
            }
            return p7SignData;
        }
        catch (Exception e) {
            this.errorlog("Exception in signAttributeP7Ybq!", e);
            throw new Pkcs7SignException("Exception in signAttributeP7Ybq!", e);
        }
    }

    private Map getMapInfoFromJson(String json) {
        HashMap<String, String> oidValueMap = new HashMap<String, String>();
        json = json.replaceAll("[\"{}]", "");
        String[] strarray = json.split(",");
        for (int i = 0; i < strarray.length; ++i) {
            String[] strarray2 = strarray[i].split(":");
            for (int j = 0; j < strarray2.length; ++j) {
                oidValueMap.put(strarray2[0], strarray2[1]);
            }
        }
        return oidValueMap;
    }

    public byte[] signAttributeP7RSAYbq(byte[] hashedData, Map oids, byte[] m_signCertBytes, PrivateKey privateCrtKey) throws Pkcs7SignException {
        try {
            ASN1EncodableVector attributeVector = new ASN1EncodableVector();
            Attribute[] attributes = new Attribute[2 + oids.size()];
            attributes[0] = new Attribute(CMSAttributes.contentType, new DERSet(new DERObjectIdentifier("1.2.840.113549.1.7.1")));
            attributeVector.add(attributes[0]);
            Set set = oids.keySet();
            int attributesOidNum = 0;
            int attributesOidLength = 0;
            Base64Util base64Util = new Base64Util(this.applicationName);
            Iterator iter = set.iterator();
            while (iter.hasNext()) {
                ++attributesOidNum;
                String key = (String)iter.next();
                String value = (String)oids.get(key);
                ASN1InputStream derInputStream = new ASN1InputStream(new ByteArrayInputStream(base64Util.BJS_DecodeBase64(value)));
                if (derInputStream == null) break;
                DERSequence whole = (DERSequence)derInputStream.readObject();
                attributes[attributesOidNum] = new Attribute(new DERObjectIdentifier(key), new DERSet(whole));
                attributeVector.add(attributes[attributesOidNum]);
                attributesOidLength += attributes[attributesOidNum].getEncoded().length;
            }
            attributes[2] = new Attribute(CMSAttributes.messageDigest, new DERSet(new DEROctetString(hashedData)));
            attributeVector.add(attributes[2]);
            DERSet derRSet = new DERSet(attributeVector, false);
            DERSequence attributeSequence = new DERSequence(attributeVector);
            DERTaggedObject derTaggedObject = new DERTaggedObject(false, 0, attributeSequence);
            byte[] attributesByte = derRSet.getEncoded();
            CertificateFactory oCf = CertificateFactory.getInstance("X.509");
            ByteArrayInputStream ois = new ByteArrayInputStream(m_signCertBytes);
            X509Certificate oCert = (X509Certificate)oCf.generateCertificate(ois);
            Certificate[] certs = new Certificate[]{oCert};
            Signature oSign = null;
            String hashTypeString = HashUtil.getHashAlg(this.applicationName);
            if ("SHA1".equals(hashTypeString)) {
                oSign = Signature.getInstance("SHA1withRSA");
            } else if ("SHA256".equals(hashTypeString)) {
                oSign = Signature.getInstance("SHA256withRSA");
            }
            oSign.initSign(privateCrtKey);
            oSign.update(attributesByte);
            byte[] signedBuf = oSign.sign();
            PKCS7SignedData p7sign = new PKCS7SignedData(certs, null, hashTypeString, "");
            byte[] p7SignData = p7sign.getEncoded(signedBuf, null, derTaggedObject);
            return p7SignData;
        }
        catch (Exception e) {
            this.errorlog("Exception in signAttributeP7RSA!", e);
            throw new Pkcs7SignException("Exception in signAttributeP7RSA!", e);
        }
    }

    public byte[] signAttributeP7SM2Ybq(byte[] hashedData, Map oids, byte[] m_signCertBytes, byte[] privateKeyByte) throws Pkcs7SignException {
        byte[] p7SignData = null;
        byte[] signedBuf = null;
        try {
            ASN1EncodableVector attributeVector = new ASN1EncodableVector();
            Attribute[] attributes = new Attribute[3];
            attributes[0] = new Attribute(CMSAttributes.contentType, new DERSet(new DERObjectIdentifier("1.2.156.10197.6.1.4.2.1")));
            attributeVector.add(attributes[0]);
            Set set = oids.keySet();
            int attributesOidNum = 0;
            boolean attributesOidLength = false;
            Base64Util base64Util = new Base64Util(this.applicationName);
            Iterator iter = set.iterator();
            while (iter.hasNext()) {
                ++attributesOidNum;
                String key = (String)iter.next();
                String value = (String)oids.get(key);
                ASN1InputStream derInputStream = new ASN1InputStream(new ByteArrayInputStream(base64Util.BJS_DecodeBase64(value)));
                if (derInputStream == null) break;
                DERSequence whole = (DERSequence)derInputStream.readObject();
                attributes[1] = new Attribute(new DERObjectIdentifier(key), new DERSet(whole));
            }
            attributeVector.add(attributes[1]);
            attributes[2] = new Attribute(CMSAttributes.messageDigest, new DERSet(new DEROctetString(hashedData)));
            attributeVector.add(attributes[2]);
            CertificateUtil certU = new CertificateUtil(this.applicationName);
            X509CertificateStructure strcSignCert = certU.getX509CertStrc(m_signCertBytes);
            X509CertificateStructure[] x509Certs = new X509CertificateStructure[]{strcSignCert};
            SubjectPublicKeyInfo spki = strcSignCert.getSubjectPublicKeyInfo();
            byte[] bPubKey = spki.getPublicKeyData().getBytes();
            byte[] publicKey = new byte[64];
            System.arraycopy(bPubKey, 1, publicKey, 0, publicKey.length);
            WrapCard wCard = new WrapCard();
            DERSet derRSet = new DERSet(attributeVector, false);
            DERSequence attributeSequence = new DERSequence(attributeVector);
            DERTaggedObject derTaggedObject = new DERTaggedObject(false, 0, attributeSequence);
            byte[] attributesByte = derRSet.getDEREncoded();
            signedBuf = wCard.sm3WithSM2Sign(attributesByte, strcSignCert, privateKeyByte);
            CNPKCS7SignedData cnpkcs7SignedData = new CNPKCS7SignedData(x509Certs, null, "SM3", "");
            p7SignData = cnpkcs7SignedData.getEncoded(signedBuf, null, derTaggedObject);
            return p7SignData;
        }
        catch (Exception e) {
            this.errorlog("Exception in signAttributeP7SM2!", e);
            throw new Pkcs7SignException("Exception in signAttributeP7SM2!", e);
        }
    }
}

