/*
 * Decompiled with CFR 0.152.
 */
package xjyb.cn.org.bjca.java.utils;

import java.io.ByteArrayInputStream;
import java.io.FileInputStream;
import java.io.InputStream;
import java.math.BigInteger;
import java.security.PrivateKey;
import java.security.PublicKey;
import java.security.Signature;
import java.security.cert.CertificateFactory;
import java.security.cert.X509Certificate;
import javax.crypto.Cipher;
import xjyb.cn.org.bjca.exception.Base64Exception;
import xjyb.cn.org.bjca.exception.GetCertInfoException;
import xjyb.cn.org.bjca.exception.HashException;
import xjyb.cn.org.bjca.exception.RsaDecryptException;
import xjyb.cn.org.bjca.exception.RsaEncryptException;
import xjyb.cn.org.bjca.exception.RsaSignException;
import xjyb.cn.org.bjca.exception.RsaVerifySignException;
import xjyb.cn.org.bjca.exception.VerifySignDataException;
import xjyb.cn.org.bjca.framework.SuperUtil;
import xjyb.cn.org.bjca.java.utils.FileUtil;
import xjyb.cn.org.bjca.utils.Base64Util;
import xjyb.cn.org.bjca.utils.HashUtil;
import xjyb.com.sansec.device.local.WrapCard;
import xjyb.org.bjca.asn1.ASN1InputStream;
import xjyb.org.bjca.asn1.ASN1Sequence;
import xjyb.org.bjca.asn1.x509.RSAPublicKeyStructure;
import xjyb.org.bjca.asn1.x509.X509CertificateStructure;
import xjyb.org.bjca.crypto.CryptoException;
import xjyb.org.bjca.crypto.DataLengthException;
import xjyb.org.bjca.crypto.digests.SHA1Digest;
import xjyb.org.bjca.crypto.digests.SHA256Digest;
import xjyb.org.bjca.crypto.params.RSAKeyParameters;
import xjyb.org.bjca.crypto.params.RSAPrivateCrtKeyParameters;
import xjyb.org.bjca.crypto.signers.BJCASigner;
import xjyb.org.bjca.jce.exception.P11ConnectException;
import xjyb.org.bjca.jce.interfaces.P11Interface;
import xjyb.org.bjca.sm2soft.SM2Algorithm;
import xjyb.org.bjca.util.ByteArrayUtil;

public class RsaUtil
extends SuperUtil {
    public RsaUtil(String appName) {
        super(appName);
    }

    public byte[] BJK_RsaEncrypt(byte[] toBeEncryptedBlob, byte[] cert) throws GetCertInfoException, RsaEncryptException, Base64Exception {
        try {
            CertificateFactory oCf = CertificateFactory.getInstance("X.509");
            ByteArrayInputStream ois = new ByteArrayInputStream(cert);
            X509Certificate oCert = (X509Certificate)oCf.generateCertificate(ois);
            PublicKey publickey = oCert.getPublicKey();
            Cipher cpher = Cipher.getInstance("RSA/ECB/PKCS1Padding");
            cpher.init(1, publickey);
            byte[] enData = cpher.doFinal(toBeEncryptedBlob);
            return enData;
        }
        catch (Exception e) {
            this.errorlog("Exception in asymmetric encryption of RSA", e);
            this.debuglog("Exception in asymmetric encryption of RSA");
            return null;
        }
    }

    public String BJK_RsaEncrypt_OAEP(byte[] toBeEncryptedBlob, byte[] cert) throws GetCertInfoException, RsaEncryptException, Base64Exception {
        Base64Util base64Util = new Base64Util(this.applicationName);
        try {
            CertificateFactory oCf = CertificateFactory.getInstance("X.509");
            ByteArrayInputStream ois = new ByteArrayInputStream(cert);
            X509Certificate oCert = (X509Certificate)oCf.generateCertificate(ois);
            PublicKey publickey = oCert.getPublicKey();
            Cipher cpher = Cipher.getInstance("RSA/ECB/PKCS1Padding");
            cpher.init(1, publickey);
            byte[] rand = cpher.doFinal(toBeEncryptedBlob);
            return base64Util.BJS_EncodeBase64(rand);
        }
        catch (Exception e) {
            this.errorlog("Exception in asymmetric encryption of RSA", e);
            this.debuglog("Exception in asymmetric encryption of RSA");
            return null;
        }
    }

    public byte[] BJK_RsaDecrypt(byte[] encryptedBlob, int m_Iinitmodel, String m_keyType, String m_container, byte[] m_encryptPfx, PrivateKey privateKey, P11Interface p11Impl) throws Base64Exception, RsaDecryptException {
        this.debuglog("start RSA decrypt ...");
        try {
            byte[] randByte = null;
            if (m_Iinitmodel == 4 || m_Iinitmodel == 6) {
                WrapCard wrapCard = new WrapCard();
                randByte = wrapCard.rsaExternalDecrypt(privateKey, encryptedBlob);
            } else if (m_Iinitmodel == 5) {
                try {
                    randByte = p11Impl.priKeyDecryptByRsa(m_container, Integer.parseInt(m_keyType), encryptedBlob);
                }
                catch (P11ConnectException e) {
                    System.out.println("Exception in p11 connection !");
                    this.errorlog("Exception in p11 connection !", e);
                    this.debuglog("Exception in p11 connection !");
                }
            }
            this.debuglog("RSA decrypt end...");
            this.debuglog("decrypt result == " + new String(randByte));
            return randByte;
        }
        catch (Exception e) {
            this.errorlog("Exception in asymmetric decryption of RSA", e);
            this.debuglog("Exception in asymmetric decryption of RSA");
            return null;
        }
    }

    public String BJK_RsaDecrypt_OAEP(String encryptedBlob, int m_Iinitmodel, String m_keyType, String m_container, byte[] m_encryptPfx, PrivateKey privateKey, P11Interface p11Impl) throws Base64Exception, RsaDecryptException {
        Base64Util base64Util = new Base64Util(this.applicationName);
        this.debuglog("start RSA decrypt ...");
        try {
            byte[] indataByte = base64Util.BJS_DecodeBase64(encryptedBlob);
            String randString = null;
            if (m_Iinitmodel == 4 || m_Iinitmodel == 6) {
                Cipher cpher = Cipher.getInstance("RSA/ECB/PKCS1Padding");
                cpher.init(2, privateKey);
                byte[] rand = cpher.doFinal(indataByte);
                randString = new String(rand);
            } else if (m_Iinitmodel == 5) {
                try {
                    byte[] rand = p11Impl.priKeyDecryptByRsa(m_container, Integer.parseInt(m_keyType), indataByte);
                    randString = new String(rand);
                }
                catch (P11ConnectException e) {
                    System.out.println("Exception in p11 connection !");
                    this.errorlog("Exception in p11 connection !", e);
                    this.debuglog("Exception in p11 connection !");
                }
            }
            this.debuglog("RSA decrypt end...");
            this.debuglog("decrypt result == " + randString);
            return randString;
        }
        catch (Exception e) {
            this.errorlog("Exception in asymmetric decryption of RSA", e);
            this.debuglog("Exception in asymmetric decryption of RSA");
            return null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean BJK_RsaVerifyNoHash(byte[] toBeSignedBlob, byte[] beSignedBlob, byte[] cert, long signMethod) throws GetCertInfoException {
        boolean verifyRet = true;
        Signature oSign = null;
        String hashTypeString = "";
        X509Certificate oCert = null;
        try {
            CertificateFactory oCf = CertificateFactory.getInstance("X.509");
            ByteArrayInputStream ois = new ByteArrayInputStream(cert);
            oCert = (X509Certificate)oCf.generateCertificate(ois);
            hashTypeString = HashUtil.getHashAlg(this.applicationName);
            if ("SHA1".equals(hashTypeString)) {
                oSign = Signature.getInstance("SHA1withRSA");
            } else if ("SHA256".equals(hashTypeString)) {
                oSign = Signature.getInstance("SHA256withRSA");
            }
            oSign.initVerify(oCert);
            oSign.update(toBeSignedBlob);
            verifyRet = oSign.verify(beSignedBlob);
            ((InputStream)ois).close();
        }
        catch (Exception e) {
            verifyRet = false;
            this.debuglog("Exception in verifying signature,RsaVerifyNoHash");
            this.errorlog("Exception in verifying signature,RsaVerifyNoHash", e);
        }
        finally {
            try {
                if (!verifyRet) {
                    oSign = null;
                    if ("SHA1".equals(hashTypeString)) {
                        oSign = Signature.getInstance("SHA256withRSA");
                    } else if ("SHA256".equals(hashTypeString)) {
                        oSign = Signature.getInstance("SHA1withRSA");
                    }
                    oSign.initVerify(oCert);
                    oSign.update(toBeSignedBlob);
                    verifyRet = oSign.verify(beSignedBlob);
                }
            }
            catch (Exception e2) {
                this.errorlog("Exception in verifying signature,RsaVerifyNoHash", e2);
            }
        }
        return verifyRet;
    }

    public boolean BJK_RsaVerifyNoHash(byte[] toBeSignedBlob, byte[] beSignedBlob, PublicKey publicKey) throws GetCertInfoException {
        boolean verifyRet = true;
        try {
            Signature oSign = null;
            String hashType = HashUtil.getHashAlg(this.applicationName);
            if (hashType == null || hashType.equals("")) {
                hashType = "SHA1";
            }
            if ("SHA1".equals(hashType)) {
                oSign = Signature.getInstance("SHA1withRSA");
            } else if ("SHA256".equals(hashType)) {
                oSign = Signature.getInstance("SHA256withRSA");
            }
            oSign.initVerify(publicKey);
            oSign.update(toBeSignedBlob);
            verifyRet = oSign.verify(beSignedBlob);
            if (!verifyRet) {
                if ("SHA1".equals(hashType)) {
                    oSign = Signature.getInstance("SHA256withRSA");
                } else if ("SHA256".equals(hashType)) {
                    oSign = Signature.getInstance("SHA1withRSA");
                }
                oSign.initVerify(publicKey);
                oSign.update(toBeSignedBlob);
                verifyRet = oSign.verify(beSignedBlob);
            }
        }
        catch (Exception e) {
            verifyRet = false;
            this.debuglog("Exception in verifying signature,RsaVerifyNoHash");
            this.errorlog("Exception in verifying signature,RsaVerifyNoHash", e);
        }
        return verifyRet;
    }

    public byte[] signHashedData(byte[] hashedContent, int m_Iinitmodel, String m_keyType, String m_container, RSAPrivateCrtKeyParameters privateCrtKey, P11Interface p11Impl, byte[] privateKeyByte) {
        byte[] signedData = null;
        try {
            if (m_Iinitmodel == 4 || m_Iinitmodel == 6) {
                WrapCard wrapCard = new WrapCard(m_Iinitmodel);
                signedData = wrapCard.externalSign(privateCrtKey, hashedContent, privateKeyByte);
            } else if (m_Iinitmodel == 5) {
                try {
                    signedData = p11Impl.signByRsa(hashedContent, m_container, Integer.parseInt(m_keyType));
                    return signedData;
                }
                catch (P11ConnectException e) {
                    System.out.println("Exception in p11 connection !");
                    this.errorlog("Exception in p11 connection !", e);
                    this.debuglog("Exception in p11 connection !");
                    return null;
                }
            }
        }
        catch (Exception e) {
            this.debuglog("Exception in signature,signHashData", e);
            this.errorlog("Exception in signature,signHashData", e);
            return null;
        }
        return signedData;
    }

    public boolean verifySignHashedData(byte[] toBeSignedHashedData, byte[] beSignedBlob, X509CertificateStructure strcCert) throws VerifySignDataException {
        try {
            byte[] pubKey = strcCert.getSubjectPublicKeyInfo().getPublicKeyData().getBytes();
            ByteArrayInputStream bin = new ByteArrayInputStream(pubKey);
            ASN1InputStream aIn = new ASN1InputStream(bin);
            ASN1Sequence seq = (ASN1Sequence)aIn.readObject();
            RSAPublicKeyStructure rSAPublicKeyStructure = new RSAPublicKeyStructure(seq);
            BigInteger modulus = rSAPublicKeyStructure.getModulus();
            BigInteger exponents = rSAPublicKeyStructure.getPublicExponent();
            RSAKeyParameters RSApubKey = new RSAKeyParameters(false, modulus, exponents);
            BJCASigner bjcaSigner = null;
            if (toBeSignedHashedData != null && toBeSignedHashedData.length == 20) {
                bjcaSigner = new BJCASigner(new SHA1Digest());
            } else if (toBeSignedHashedData != null && toBeSignedHashedData.length == 32) {
                bjcaSigner = new BJCASigner(new SHA256Digest());
            }
            bjcaSigner.init(false, RSApubKey);
            bjcaSigner.update(toBeSignedHashedData, 0, toBeSignedHashedData.length);
            boolean isSuccess = bjcaSigner.verifySignature(beSignedBlob);
            return isSuccess;
        }
        catch (Exception e) {
            this.debuglog("Exception in verify signature, verifySignHashedData", e);
            this.errorlog("Exception in verify signature, verifySignHashedData", e);
            throw new VerifySignDataException("Exception in verify signature, verifySignHashedData");
        }
    }

    public String BJK_RsaSign_File(String sFilePath, long signMethod, int m_Iinitmodel, byte[] m_signPfx, String m_keyType, String m_container, PrivateKey privateKey, P11Interface p11Impl) throws HashException, RsaSignException, Base64Exception {
        Base64Util base64Util = new Base64Util(this.applicationName);
        HashUtil hashUtil = new HashUtil(this.applicationName);
        String sdata = null;
        byte[] signResult = null;
        try {
            if (m_Iinitmodel == 4 || m_Iinitmodel == 6) {
                int len;
                Signature oSign = null;
                String hashTypeString = HashUtil.getHashAlg(this.applicationName);
                if ("SHA1".equals(hashTypeString)) {
                    oSign = Signature.getInstance("SHA1withRSA");
                } else if ("SHA256".equals(hashTypeString)) {
                    oSign = Signature.getInstance("SHA256withRSA");
                }
                oSign.initSign(privateKey);
                FileInputStream in = new FileInputStream(sFilePath);
                int blockSize = 131072;
                byte[] inBytes = new byte[blockSize];
                while ((len = ((InputStream)in).read(inBytes)) != -1) {
                    oSign.update(inBytes, 0, len);
                }
                signResult = oSign.sign();
                ((InputStream)in).close();
            } else if (m_Iinitmodel == 5) {
                byte[] hashValue = hashUtil.BJS_HashFile(0L, sFilePath);
                try {
                    signResult = p11Impl.signByRsa(hashValue, m_container, Integer.parseInt(m_keyType));
                }
                catch (P11ConnectException e) {
                    System.out.println("Exception in p11 connection !");
                    this.errorlog("Exception in p11 connection !", e);
                    this.debuglog("Exception in p11 connection !");
                }
            }
            sdata = base64Util.BJS_EncodeBase64(signResult);
        }
        catch (Exception e) {
            this.errorlog("Exception in BJK_RsaSign_File!", e);
            this.debuglog("Exception in BJK_RsaSign_File!");
            return null;
        }
        return sdata;
    }

    public boolean BJK_RsaVerify_File(String sFilePath, String beSignedBlob, String cert, long signMethod) throws Base64Exception, HashException, GetCertInfoException {
        try {
            int len;
            Base64Util base64Util = new Base64Util(this.applicationName);
            FileUtil fileUtil = new FileUtil(this.applicationName);
            byte[] bedecodeBlob = base64Util.BJS_DecodeBase64(beSignedBlob);
            byte[] bcert = base64Util.BJS_DecodeBase64(cert);
            CertificateFactory oCf = CertificateFactory.getInstance("X.509");
            ByteArrayInputStream ois = new ByteArrayInputStream(bcert);
            X509Certificate oCert = (X509Certificate)oCf.generateCertificate(ois);
            Signature oSign = null;
            String hashTypeString = HashUtil.getHashAlg(this.applicationName);
            if ("SHA1".equals(hashTypeString)) {
                oSign = Signature.getInstance("SHA1withRSA");
            } else if ("SHA256".equals(hashTypeString)) {
                oSign = Signature.getInstance("SHA256withRSA");
            }
            oSign.initVerify(oCert);
            FileInputStream in = new FileInputStream(sFilePath);
            int blockSize = 131072;
            byte[] inBytes = new byte[blockSize];
            while ((len = ((InputStream)in).read(inBytes)) != -1) {
                oSign.update(inBytes, 0, len);
            }
            boolean isSuccess = oSign.verify(bedecodeBlob);
            ((InputStream)in).close();
            ((InputStream)ois).close();
            if (!isSuccess) {
                int len2;
                Signature oSignAg = null;
                if ("SHA1".equals(hashTypeString)) {
                    oSignAg = Signature.getInstance("SHA256withRSA");
                } else if ("SHA256".equals(hashTypeString)) {
                    oSignAg = Signature.getInstance("SHA1withRSA");
                }
                oSignAg.initVerify(oCert);
                FileInputStream inAg = new FileInputStream(sFilePath);
                inBytes = new byte[blockSize];
                while ((len2 = ((InputStream)inAg).read(inBytes)) != -1) {
                    oSignAg.update(inBytes, 0, len2);
                }
                ((InputStream)inAg).close();
                isSuccess = oSignAg.verify(bedecodeBlob);
            }
            return isSuccess;
        }
        catch (Exception e) {
            this.errorlog("Exception in BJK_RsaSign_File!", e);
            this.debuglog("Exception in BJK_RsaSign_File!");
            return false;
        }
    }

    public String BJK_RsaSign_File(InputStream inputStream, long signMethod, int m_Iinitmodel, byte[] m_signPfx, String m_keyType, String m_container, PrivateKey privateKey, P11Interface p11Impl) throws HashException, RsaSignException, Base64Exception {
        Base64Util base64Util = new Base64Util(this.applicationName);
        HashUtil hashUtil = new HashUtil(this.applicationName);
        String sdata = null;
        byte[] signResult = null;
        try {
            if (m_Iinitmodel == 4 || m_Iinitmodel == 6) {
                int len;
                Signature oSign = null;
                String hashTypeString = HashUtil.getHashAlg(this.applicationName);
                if ("SHA1".equals(hashTypeString)) {
                    oSign = Signature.getInstance("SHA1withRSA");
                } else if ("SHA256".equals(hashTypeString)) {
                    oSign = Signature.getInstance("SHA256withRSA");
                }
                oSign.initSign(privateKey);
                int blockSize = 131072;
                byte[] inBytes = new byte[blockSize];
                while ((len = inputStream.read(inBytes)) != -1) {
                    oSign.update(inBytes, 0, len);
                }
                signResult = oSign.sign();
                inputStream.close();
            } else if (m_Iinitmodel == 5) {
                byte[] hashValue = hashUtil.BJS_HashFile(0L, inputStream);
                try {
                    signResult = p11Impl.signByRsa(hashValue, m_container, Integer.parseInt(m_keyType));
                }
                catch (P11ConnectException e) {
                    System.out.println("Exception in p11 connection !");
                    this.errorlog("Exception in p11 connection !", e);
                    this.debuglog("Exception in p11 connection !");
                }
            }
            sdata = base64Util.BJS_EncodeBase64(signResult);
        }
        catch (Exception e) {
            this.errorlog("Exception in BJK_RsaSign_File!", e);
            this.debuglog("Exception in BJK_RsaSign_File!");
            return null;
        }
        return sdata;
    }

    public boolean BJK_RsaVerify_File(InputStream inputStream, String beSignedBlob, String cert, long signMethod) throws Base64Exception, HashException, GetCertInfoException, RsaVerifySignException {
        try {
            int len;
            Base64Util base64Util = new Base64Util(this.applicationName);
            FileUtil fileUtil = new FileUtil(this.applicationName);
            byte[] bedecodeBlob = base64Util.BJS_DecodeBase64(beSignedBlob);
            byte[] bcert = base64Util.BJS_DecodeBase64(cert);
            CertificateFactory oCf = CertificateFactory.getInstance("X.509");
            ByteArrayInputStream ois = new ByteArrayInputStream(bcert);
            X509Certificate oCert = (X509Certificate)oCf.generateCertificate(ois);
            Signature oSign = null;
            String hashTypeString = HashUtil.getHashAlg(this.applicationName);
            if ("SHA1".equals(hashTypeString)) {
                oSign = Signature.getInstance("SHA1withRSA");
            } else if ("SHA256".equals(hashTypeString)) {
                oSign = Signature.getInstance("SHA256withRSA");
            }
            oSign.initVerify(oCert);
            int blockSize = 131072;
            byte[] inBytes = new byte[blockSize];
            while ((len = inputStream.read(inBytes)) != -1) {
                oSign.update(inBytes, 0, len);
            }
            boolean isSuccess = oSign.verify(bedecodeBlob);
            inputStream.close();
            ((InputStream)ois).close();
            if (!isSuccess) {
                // empty if block
            }
            return isSuccess;
        }
        catch (Exception e) {
            this.errorlog("Exception in BJK_RsaSign_File!", e);
            this.debuglog("Exception in BJK_RsaSign_File!");
            return false;
        }
    }

    byte[] signData_rsa_java(byte[] hashedContent, RSAPrivateCrtKeyParameters privateCrtKey) throws DataLengthException, CryptoException {
        byte[] signedData = null;
        BJCASigner bjcaSigner = new BJCASigner();
        bjcaSigner.init(true, privateCrtKey);
        bjcaSigner.update(hashedContent, 0, hashedContent.length);
        signedData = bjcaSigner.generateSignature();
        return signedData;
    }

    byte[] signData_rsa_openssl(byte[] hashedContent, byte[] privateKeyByte) {
        byte[] signedData = null;
        SM2Algorithm soft = SM2Algorithm.getInstance();
        byte[] buffer = null;
        if (hashedContent != null && hashedContent.length == 20) {
            buffer = soft.externalSign(1, hashedContent, privateKeyByte);
        } else if (hashedContent != null && hashedContent.length == 32) {
            buffer = soft.externalSign(2, hashedContent, privateKeyByte);
        }
        int rv = ByteArrayUtil.getFirstIntFromByteArray(buffer, 0);
        if (rv != 0) {
            this.errorlog("external sign failed, rv[0x" + Integer.toHexString(rv) + "]");
            this.debuglog("external sign failed, rv[0x" + Integer.toHexString(rv) + "]");
            return null;
        }
        signedData = new byte[buffer.length - 4];
        System.arraycopy(buffer, 4, signedData, 0, buffer.length - 4);
        return signedData;
    }
}

