/*
 * Decompiled with CFR 0.152.
 */
package xjyb.cn.org.bjca.java.utils.pdf;

import java.io.IOException;
import java.security.GeneralSecurityException;
import java.security.MessageDigest;
import org.bouncycastle.tsp.TSPException;
import xjyb.bjca.org.jdom.JDOMException;
import xjyb.cn.org.bjca.exception.AppNotfoundException;
import xjyb.cn.org.bjca.exception.InitException;
import xjyb.cn.org.bjca.java.utils.pdf.BouncyCastleDigest;
import xjyb.cn.org.bjca.java.utils.pdf.TSAClient;
import xjyb.cn.org.bjca.java.utils.pdf.TSAInfoBouncyCastle;
import xjyb.cn.org.bjca.security.SecurityEngineDeal;

public class TSAClientBouncyCastle
implements TSAClient {
    protected String tsaURL;
    protected String tsaUsername;
    protected String tsaPassword;
    protected TSAInfoBouncyCastle tsaInfo;
    public static final int DEFAULTTOKENSIZE = 4096;
    protected int tokenSizeEstimate;
    public static final String DEFAULTHASHALGORITHM = "SHA-256";
    protected String digestAlgorithm;

    public TSAClientBouncyCastle(String url) {
        this(url, null, null, 4096, DEFAULTHASHALGORITHM);
    }

    public TSAClientBouncyCastle(String url, String username, String password) {
        this(url, username, password, 4096, DEFAULTHASHALGORITHM);
    }

    public TSAClientBouncyCastle(String url, String username, String password, int tokSzEstimate, String digestAlgorithm) {
        this.tsaURL = url;
        this.tsaUsername = username;
        this.tsaPassword = password;
        this.tokenSizeEstimate = tokSzEstimate;
        this.digestAlgorithm = digestAlgorithm;
    }

    public void setTSAInfo(TSAInfoBouncyCastle tsaInfo) {
        this.tsaInfo = tsaInfo;
    }

    @Override
    public int getTokenSizeEstimate() {
        return this.tokenSizeEstimate;
    }

    @Override
    public MessageDigest getMessageDigest() throws GeneralSecurityException {
        return new BouncyCastleDigest().getMessageDigest(this.digestAlgorithm);
    }

    @Override
    public byte[] getTimeStampToken(byte[] pdfOriginal) throws IOException, TSPException {
        byte[] respBytes = null;
        byte[] requestBytes = null;
        SecurityEngineDeal secEngine = null;
        try {
            secEngine = SecurityEngineDeal.getInstance("TSSDefault");
            requestBytes = secEngine.createTimeStampRequest(pdfOriginal, true);
        }
        catch (Exception e1) {
            e1.printStackTrace();
        }
        respBytes = this.getTSAResponse(requestBytes);
        return respBytes;
    }

    protected byte[] getTSAResponse(byte[] requestBytes) throws IOException {
        SecurityEngineDeal secEngine = null;
        try {
            secEngine = SecurityEngineDeal.getInstance("TSSDefault");
        }
        catch (JDOMException e1) {
            e1.printStackTrace();
        }
        catch (InitException e1) {
            e1.printStackTrace();
        }
        catch (AppNotfoundException e1) {
            e1.printStackTrace();
        }
        byte[] respBytes = null;
        try {
            respBytes = secEngine.createTimeStamp(requestBytes);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return respBytes;
    }
}

