/*
 * Decompiled with CFR 0.152.
 */
package xjyb.cn.org.bjca.jni.utils;

import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.FilterOutputStream;
import java.io.IOException;
import xjyb.bjcasafeapi.BjcaApiEngine;
import xjyb.cn.org.bjca.exception.DecryptDataException;
import xjyb.cn.org.bjca.exception.EncryptDataException;
import xjyb.cn.org.bjca.framework.SuperUtil;
import xjyb.cn.org.bjca.jni.utils.CryptoUtil;

public class FileUtil
extends SuperUtil {
    public FileUtil(String appName) {
        super(appName);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean BJS_SymmEncFile(BjcaApiEngine apiengine, String srcfile, String destfile, byte[] key, long EncAlg, long mode) throws EncryptDataException {
        CryptoUtil cryptoUtil = new CryptoUtil(this.applicationName);
        FileInputStream fis = null;
        FileOutputStream fos = null;
        try {
            int i;
            File fin = new File(srcfile);
            fis = new FileInputStream(fin);
            fos = new FileOutputStream(destfile);
            long filelen = fin.length();
            byte[] iv = new byte[8];
            for (i = 0; i < 8; ++i) {
                iv[i] = (byte)(i + 2);
            }
            cryptoUtil.BJS_SymmEncryptInit(apiengine, EncAlg, mode, key, key.length, iv);
            long count = filelen / 1024L;
            byte[] inbuf = new byte[1024];
            byte[] outbuf = null;
            i = 0;
            while ((long)i <= count) {
                int rlen = fis.read(inbuf);
                outbuf = cryptoUtil.BJS_SymmEncryptUpdata(apiengine, inbuf, rlen);
                fos.write(outbuf);
                ++i;
            }
            outbuf = cryptoUtil.BJS_SymmEncryptFinal(apiengine);
            fos.write(outbuf);
            fos.close();
            fis.close();
            boolean bl = true;
            return bl;
        }
        catch (IOException e) {
            this.errorlog("", e);
            this.debuglog("", e);
            boolean bl = false;
            return bl;
        }
        finally {
            try {
                fos.close();
                fis.close();
            }
            catch (IOException e) {}
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean BJS_SymmDecFile(BjcaApiEngine apiengine, String srcfile, String destfile, byte[] key, long EncAlg, long mode) throws DecryptDataException {
        CryptoUtil cryptoUtil = new CryptoUtil(this.applicationName);
        FileInputStream fis = null;
        FileOutputStream fos = null;
        try {
            int i;
            File fin = new File(srcfile);
            fis = new FileInputStream(fin);
            fos = new FileOutputStream(destfile);
            long filelen = fin.length();
            byte[] iv = new byte[8];
            for (i = 0; i < 8; ++i) {
                iv[i] = (byte)(i + 2);
            }
            cryptoUtil.BJS_SymmDecryptInit(apiengine, EncAlg, mode, key, key.length, iv);
            long count = filelen / 1024L;
            byte[] inbuf = new byte[1024];
            byte[] outbuf = null;
            i = 0;
            while ((long)i <= count) {
                int rlen = fis.read(inbuf);
                outbuf = cryptoUtil.BJS_SymmDecryptUpdata(apiengine, inbuf, rlen);
                fos.write(outbuf);
                ++i;
            }
            outbuf = cryptoUtil.BJS_SymmDecryptFinal(apiengine);
            fos.write(outbuf);
            fos.close();
            fis.close();
            boolean bl = true;
            return bl;
        }
        catch (IOException e) {
            this.errorlog("", e);
            this.debuglog("", e);
            boolean bl = false;
            return bl;
        }
        finally {
            try {
                fos.close();
                fis.close();
            }
            catch (IOException e) {}
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public byte[] readFile(String file_path) {
        BufferedInputStream bins = null;
        byte[] bfile = null;
        String path = file_path;
        try {
            bins = new BufferedInputStream(new FileInputStream(path), 1024);
            if (bins.available() > 0) {
                bfile = new byte[bins.available()];
                bins.read(bfile);
            }
            bins.close();
        }
        catch (IOException e) {
            bfile = null;
            this.errorlog("", e);
            this.debuglog("", e);
        }
        finally {
            try {
                bins.close();
            }
            catch (IOException e) {
                this.errorlog("", e);
                this.debuglog("", e);
                return null;
            }
        }
        return bfile;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void writeFile(byte[] bContent, String filePath) {
        FilterOutputStream bouts = null;
        try {
            bouts = new BufferedOutputStream(new FileOutputStream(filePath), 1024);
            bouts.write(bContent);
            bouts.close();
        }
        catch (IOException e) {
            this.errorlog("", e);
            this.debuglog("", e);
        }
        finally {
            try {
                bouts.close();
            }
            catch (IOException e) {
                this.errorlog("", e);
                this.debuglog("", e);
            }
        }
    }
}

