/*
 * Decompiled with CFR 0.152.
 */
package xjyb.cn.org.bjca.jni.utils;

import java.io.BufferedInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import xjyb.bjcasafeapi.BjcaApiEngine;
import xjyb.cn.org.bjca.exception.Base64Exception;
import xjyb.cn.org.bjca.exception.HashException;
import xjyb.cn.org.bjca.framework.SuperUtil;
import xjyb.cn.org.bjca.utils.Base64Util;

public class HashUtil
extends SuperUtil {
    private long[] hashObj = new long[1];

    public HashUtil(String appName) {
        super(appName);
    }

    public String BJS_Hash(BjcaApiEngine apiengine, long ALGID, byte[] data, int dataLen) throws HashException, Base64Exception {
        Base64Util base64Util = new Base64Util(this.applicationName);
        String strdata = null;
        int execflag = 0;
        byte[] dhash = null;
        long[] long1 = new long[1];
        try {
            execflag = apiengine.BCA_Hash(ALGID, data, dataLen, dhash, long1);
            if (execflag == 0) {
                dhash = new byte[(int)long1[0]];
                execflag = apiengine.BCA_Hash(ALGID, data, dataLen, dhash, long1);
            }
        }
        catch (Exception e) {
            strdata = null;
            this.errorlog("Exception in dynamic link libraries,BCA_Hash", e);
            this.debuglog("Exception in dynamic link libraries,BCA_Hash");
            throw new HashException("Exception in dynamic link libraries,BCA_Hash");
        }
        strdata = base64Util.BJS_EncodeBase64(dhash);
        if (execflag != 0 || strdata == null) {
            strdata = null;
            this.errorlog("Failed to hash,BCA_Hash");
            this.debuglog("Failed to hash,BCA_Hash");
            throw new HashException("Failed to hash,BCA_Hash");
        }
        return strdata;
    }

    public byte[] BJS_HashBytes(BjcaApiEngine apiengine, long ALGID, byte[] data, int dataLen) throws HashException {
        byte[] bdata = null;
        byte[] dhash = null;
        long[] long1 = new long[1];
        int execflag = 0;
        try {
            execflag = apiengine.BCA_Hash(ALGID, data, dataLen, dhash, long1);
            if (execflag == 0) {
                dhash = new byte[(int)long1[0]];
                execflag = apiengine.BCA_Hash(ALGID, data, dataLen, dhash, long1);
                bdata = new byte[(int)long1[0]];
                System.arraycopy(dhash, 0, bdata, 0, (int)long1[0]);
            }
        }
        catch (Exception e) {
            bdata = null;
            this.errorlog("Exception in dynamic link libraries,BCA_Hash", e);
            this.debuglog("Exception in dynamic link libraries,BCA_Hash");
            throw new HashException("Exception in dynamic link libraries,BCA_Hash");
        }
        if (execflag != 0) {
            bdata = null;
            this.errorlog("Failed to hash,BCA_Hash");
            this.debuglog("Failed to hash,BCA_Hash");
            throw new HashException("Failed to hash,BCA_Hash");
        }
        return bdata;
    }

    public boolean BJS_HashInit(BjcaApiEngine apiengine, long hashAlg) throws HashException {
        int rv = 0;
        try {
            rv = apiengine.BCA_CreateHashObj(this.hashObj, hashAlg);
        }
        catch (Exception see) {
            this.errorlog("Exception in dynamic link libraries,BCA_CreateHashObj", see);
            this.debuglog("Exception in dynamic link libraries,BCA_CreateHashObj");
            throw new HashException("Exception in dynamic link libraries,BCA_CreateHashObj");
        }
        if (rv == 0) {
            return true;
        }
        this.errorlog("Failed to hash,BCA_CreateHashObj");
        this.debuglog("Failed to hash,BCA_CreateHashObj");
        throw new HashException("Failed to hash,BCA_CreateHashObj");
    }

    public int BJS_HashUpdate(BjcaApiEngine apiengine, byte[] inData, long inDataLen) throws HashException {
        int rv = 0;
        if (this.hashObj[0] == 0L) {
            this.errorlog("Failed to initialize,BJS_HashUpdate");
            this.debuglog("Failed to initialize,BJS_HashUpdate");
            throw new HashException("Failed to initialize,BJS_HashUpdate");
        }
        try {
            rv = apiengine.BCA_HashUpdate(this.hashObj[0], inData, inDataLen);
        }
        catch (Exception see) {
            this.errorlog("Exception in dynamic link libraries,BCA_HashUpdate", see);
            this.debuglog("Exception in dynamic link libraries,BCA_HashUpdate");
            throw new HashException("Exception in dynamic link libraries,BCA_HashUpdate");
        }
        if (rv == 0) {
            return 0;
        }
        this.errorlog("Failed to hash,BCA_HashUpdate");
        this.debuglog("Failed to hash,BCA_HashUpdate");
        throw new HashException("Failed to hash,BCA_HashUpdate");
    }

    public byte[] BJS_HashFinal(BjcaApiEngine apiengine) throws HashException {
        byte[] outData = new byte[50];
        long[] outlen = new long[1];
        int rv = 0;
        if (this.hashObj[0] == 0L) {
            this.errorlog("Failed to initialize,BJS_HashFinal");
            this.debuglog("Failed to initialize,BJS_HashFinal");
            throw new HashException("Failed to initialize,BJS_HashFinal");
        }
        try {
            rv = apiengine.BCA_HashFinal(this.hashObj[0], outData, outlen);
        }
        catch (Exception see) {
            this.errorlog("Exception in dynamic link libraries,BCA_HashFinal", see);
            this.debuglog("Exception in dynamic link libraries,BCA_HashFinal");
            throw new HashException("Exception in dynamic link libraries,BCA_HashFinal");
        }
        finally {
            apiengine.BCA_DestroyHashObj(this.hashObj[0]);
            this.hashObj[0] = 0L;
        }
        if (rv != 0) {
            this.errorlog("Failed to hash,BCA_HashFinal");
            this.debuglog("Failed to hash,BCA_HashFinal");
            throw new HashException("Failed to hash,BCA_HashFinal");
        }
        byte[] rvbuf = new byte[(int)outlen[0]];
        System.arraycopy(outData, 0, rvbuf, 0, (int)outlen[0]);
        return rvbuf;
    }

    public byte[] BJS_HashFile(BjcaApiEngine apiengine, long ALGID, String sFilePath) throws HashException {
        byte[] bdata = null;
        FileInputStream fis = null;
        byte[] dhash = new byte[20];
        long[] long1 = new long[1];
        BufferedInputStream bins = null;
        try {
            File file = new File(sFilePath);
            byte[] data = new byte[1024];
            fis = new FileInputStream(file);
            bins = new BufferedInputStream(fis, 1024);
            int filelen = (int)file.length();
            long[] hash = new long[1];
            int rv = apiengine.BCA_CreateHashObj(hash, ALGID);
            if (rv != 0) {
                this.errorlog("Failed to initialize,BJS_HashFile");
                this.debuglog("Failed to initialize,BJS_HashFile");
                throw new HashException("Failed to initialize,BJS_HashFile");
            }
            for (int i = 0; i < filelen / 1024 + 1 && bins.available() > 0; ++i) {
                int datalen = bins.read(data);
                rv = apiengine.BCA_HashUpdate(hash[0], data, datalen);
                if (rv == 0) continue;
                this.errorlog("Failed to hash,BCA_HashUpdate");
                this.debuglog("Failed to hash,BCA_HashUpdate");
                throw new HashException("Failed to hash,BCA_HashUpdate");
            }
            rv = apiengine.BCA_HashFinal(hash[0], dhash, long1);
            if (rv != 0) {
                this.errorlog("Failed to hash,BCA_HashFinal");
                this.debuglog("Failed to hash,BCA_HashFinal");
                throw new HashException("Failed to hash,BCA_HashFinal");
            }
            bdata = new byte[(int)long1[0]];
            System.arraycopy(dhash, 0, bdata, 0, (int)long1[0]);
        }
        catch (IOException e) {
            bdata = null;
            this.errorlog("IOException,BJS_HashFile");
            this.debuglog("IOException,BJS_HashFile");
            throw new HashException("IOException,BJS_HashFile");
        }
        finally {
            try {
                fis.close();
                bins.close();
            }
            catch (IOException e) {
                this.errorlog("", e);
                this.debuglog("", e);
            }
        }
        return bdata;
    }
}

