/*
 * Decompiled with CFR 0.152.
 */
package xjyb.cn.org.bjca.jni.utils;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.dom.DOMSource;
import javax.xml.transform.stream.StreamResult;
import org.w3c.dom.Document;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.xml.sax.SAXException;
import xjyb.bjcasafeapi.BjcaApiEngine;
import xjyb.cn.org.bjca.exception.GetXMLSignInfoException;
import xjyb.cn.org.bjca.exception.XmlSignException;
import xjyb.cn.org.bjca.exception.XmlVerifySignException;
import xjyb.cn.org.bjca.framework.SuperUtil;
import xjyb.cn.org.bjca.jni.security.SecurityEngine;
import xjyb.cn.org.bjca.jni.utils.HashUtil;
import xjyb.cn.org.bjca.jni.utils.RsaUtil;
import xjyb.cn.org.bjca.utils.Base64Util;

public class XMLSignUtil_old
extends SuperUtil {
    DocumentBuilder db;

    public XMLSignUtil_old(String appName) {
        super(appName);
    }

    public XMLSignUtil_old() {
        try {
            DocumentBuilderFactory dbf = DocumentBuilderFactory.newInstance();
            dbf.setNamespaceAware(true);
            dbf.setIgnoringElementContentWhitespace(true);
            this.db = dbf.newDocumentBuilder();
        }
        catch (ParserConfigurationException e) {
            this.errorlog("", e);
            this.debuglog("", e);
        }
    }

    private String CreateSignStr(String digVal) {
        String outstr = "<SignedInfo xmlns=\"http://www.w3.org/2000/09/xmldsig#\"><CanonicalizationMethod Algorithm=\"http://www.w3.org/TR/2001/REC-xml-c14n-20010315\"></CanonicalizationMethod>";
        outstr = outstr + "<SignatureMethod Algorithm=\"http://www.w3.org/2000/09/xmldsig#rsa-sha1\"></SignatureMethod>";
        outstr = outstr + "<Reference URI=\"#TheFirstObjcet\">";
        outstr = outstr + "<Transforms><Transform Algorithm=\"http://www.w3.org/TR/2001/REC-xml-c14n-20010315#WithComments\"></Transform></Transforms>";
        outstr = outstr + "<DigestMethod Algorithm=\"http://www.w3.org/2000/09/xmldsig#sha1\"></DigestMethod>";
        outstr = outstr + "<DigestValue>";
        outstr = outstr + digVal + "</DigestValue>";
        outstr = outstr + "</Reference></SignedInfo>";
        return outstr;
    }

    public String BJX_SignedDataXML_Sign(BjcaApiEngine apiengine, SecurityEngine safeEng, String xmlsrc, long signMethod, int m_Iinitmodel, String m_password, byte[] m_signPfx, String m_keyType, String m_container) throws XmlSignException {
        HashUtil hashUtil = new HashUtil(this.applicationName);
        RsaUtil rsaUtil = new RsaUtil(this.applicationName);
        try {
            String org_xml = xmlsrc.substring(xmlsrc.indexOf(">"));
            org_xml = org_xml.substring(org_xml.indexOf("<"));
            Document node_tmp = this.getDocumentFromString(org_xml.getBytes("UTF-8"));
            String xmlStr = this.getXMLText(node_tmp);
            String digxml = "<Object xmlns=\"http://www.w3.org/2000/09/xmldsig#\" id=\"TheFirstObjcet\">" + xmlStr + "</Object>";
            byte[] tmpbyte = digxml.getBytes();
            String digval = hashUtil.BJS_Hash(apiengine, signMethod, tmpbyte, tmpbyte.length);
            String sInfo = this.CreateSignStr(digval);
            String sVal = rsaUtil.BJK_RsaSign(apiengine, sInfo.getBytes(), signMethod, m_Iinitmodel, m_password, m_signPfx, m_keyType, m_container);
            if (sVal == null) {
                this.errorlog("Rsa\u7b7e\u540d\u51fa\u9519!");
                this.debuglog("Rsa\u7b7e\u540d\u51fa\u9519!");
                throw new Exception("Rsa\u7b7e\u540d\u51fa\u9519!");
            }
            String out = "<?xml version=\"1.0\" encoding=\"GB2312\"?>\n<Signature xmlns=\"http://www.w3.org/2000/09/xmldsig#\">";
            out = out + sInfo;
            out = out + "<SignatureValue>";
            out = out + sVal + "</SignatureValue>";
            String cert = safeEng.getSignCertString();
            if (cert == null) {
                this.errorlog("\u7b7e\u540d\u8bc1\u4e66\u4e0d\u5b58\u5728\uff01");
                this.debuglog("\u7b7e\u540d\u8bc1\u4e66\u4e0d\u5b58\u5728\uff01");
                throw new Exception("\u7b7e\u540d\u8bc1\u4e66\u4e0d\u5b58\u5728\uff01");
            }
            out = out + "<KeyInfo><X509Data><X509Certificate>";
            out = out + cert + "</X509Certificate></X509Data></KeyInfo>";
            out = out + "<Object id=\"TheFirstObjcet\">";
            out = out + xmlStr + "</Object></Signature>";
            return out;
        }
        catch (Exception e) {
            this.errorlog("xml\u7b7e\u540d\u51fa\u9519\uff01", e);
            this.debuglog("xml\u7b7e\u540d\u51fa\u9519\uff01", e);
            throw new XmlSignException("xml\u7b7e\u540d\u51fa\u9519\uff01");
        }
    }

    public boolean BJX_SignedDataXML_Verify(BjcaApiEngine apiengine, String XmlSign, long signMethod) throws XmlVerifySignException {
        HashUtil hashUtil = new HashUtil(this.applicationName);
        Base64Util base64Util = new Base64Util(this.applicationName);
        RsaUtil rsaUtil = new RsaUtil(this.applicationName);
        try {
            ByteArrayInputStream bips = new ByteArrayInputStream(XmlSign.getBytes());
            Document doc = this.db.parse(bips);
            Node node_tmp = this.SelectNode(doc, "Signature/Object");
            String objStr = this.getNodeText(node_tmp);
            objStr = "<Object xmlns=\"http://www.w3.org/2000/09/xmldsig#\" id=\"TheFirstObjcet\">" + objStr + "</Object>";
            byte[] tmpbyte = objStr.getBytes();
            String digval = hashUtil.BJS_Hash(apiengine, signMethod, tmpbyte, tmpbyte.length);
            node_tmp = this.SelectNode(doc, "Signature/SignedInfo/Reference/DigestValue");
            String srcDigVal = this.getNodeText(node_tmp);
            if (digval.compareToIgnoreCase(srcDigVal) != 0) {
                this.errorlog("hash error.new hash is " + digval);
                this.debuglog("hash error.new hash is " + digval);
                this.errorlog("old hash is " + srcDigVal);
                this.debuglog("old hash is " + srcDigVal);
                return false;
            }
            node_tmp = this.SelectNode(doc, "Signature/SignedInfo");
            String signStr = this.getXMLText(node_tmp);
            node_tmp = this.SelectNode(doc, "Signature/KeyInfo/X509Data/X509Certificate");
            String certStr = this.getNodeText(node_tmp);
            node_tmp = this.SelectNode(doc, "Signature/SignatureValue");
            String signCode = this.getNodeText(node_tmp);
            byte[] certbuf = base64Util.BJS_DecodeBase64(certStr);
            boolean flag = rsaUtil.BJK_RsaVerify(apiengine, signStr.getBytes(), signCode, certbuf, signMethod);
            return flag;
        }
        catch (Exception e) {
            this.errorlog("xml\u9a8c\u7b7e\u540d\u51fa\u9519\uff01", e);
            this.debuglog("xml\u9a8c\u7b7e\u540d\u51fa\u9519\uff01", e);
            throw new XmlVerifySignException("xml\u9a8c\u7b7e\u540d\u51fa\u9519\uff01");
        }
    }

    private Node SelectNode(Node parentNode, String xpath) {
        String[] nodepath = xpath.split("/");
        Node tmpNode = parentNode;
        for (int i = 0; i < nodepath.length; ++i) {
            int j;
            NodeList nlist = tmpNode.getChildNodes();
            for (j = 0; j < nlist.getLength(); ++j) {
                if (nlist.item(j).getNodeName().compareToIgnoreCase(nodepath[i]) != 0) continue;
                tmpNode = nlist.item(j);
                break;
            }
            if (j != nlist.getLength()) continue;
            return null;
        }
        return tmpNode;
    }

    private String getNodeText(Node objnode) {
        ByteArrayOutputStream baops = new ByteArrayOutputStream(10240);
        try {
            Transformer t = TransformerFactory.newInstance().newTransformer();
            t.setOutputProperty("encoding", "GB2312");
            t.transform(new DOMSource(objnode), new StreamResult(baops));
        }
        catch (Exception e) {
            this.errorlog("", e);
            this.debuglog("", e);
        }
        String ret = baops.toString();
        int ind = ret.indexOf(62);
        ret = ret.substring(ind + 1);
        ind = ret.indexOf(62);
        int end = ret.lastIndexOf(60);
        ret = ret.substring(ind + 1, end);
        String out = this.zryTrans(ret);
        return out;
    }

    private String getXMLText(Node objnode) {
        ByteArrayOutputStream baops = new ByteArrayOutputStream(10240);
        try {
            Transformer t = TransformerFactory.newInstance().newTransformer();
            t.setOutputProperty("encoding", "GB2312");
            t.transform(new DOMSource(objnode), new StreamResult(baops));
        }
        catch (Exception e) {
            this.errorlog("", e);
            this.debuglog("", e);
        }
        String ret = baops.toString();
        int ind = ret.indexOf(62);
        ret = ret.substring(ind);
        ret = ret.substring(ret.indexOf(60));
        String out = this.zryTrans(ret);
        return out;
    }

    public String getObjText(Node objnode) {
        String ret = null;
        Node tmpnode = this.SelectNode(objnode, "Signature/SignedInfo");
        if (tmpnode == null) {
            return this.getNodeText(objnode);
        }
        tmpnode = this.SelectNode(objnode, "Signature");
        ret = this.getXMLText(tmpnode);
        int rt = ret.indexOf("<SignedInfo xmlns");
        if (rt < 0) {
            ret = ret.replaceAll("<SignedInfo", "<SignedInfo xmlns=\"http://www.w3.org/2000/09/xmldsig#\"");
        }
        String out = this.zryTrans(ret);
        return out;
    }

    private String getAttributeText(Node objnode, String attName) {
        String ret = null;
        NamedNodeMap nnm = objnode.getAttributes();
        for (int i = 0; i < nnm.getLength(); ++i) {
            if (nnm.item(i).getNodeName().compareToIgnoreCase(attName) != 0) continue;
            ret = nnm.item(i).getNodeValue();
        }
        return ret;
    }

    private String zryTrans(String srcstr) {
        String tmpstr = srcstr;
        String nodestr = "";
        int endlen = 0;
        while ((endlen = tmpstr.indexOf("/>", endlen)) >= 1) {
            int startlen = tmpstr.lastIndexOf(60, endlen);
            int spacelen = tmpstr.indexOf(32, startlen);
            nodestr = spacelen < endlen && spacelen > 0 ? tmpstr.substring(startlen + 1, spacelen) : tmpstr.substring(startlen + 1, endlen);
            tmpstr = tmpstr.replaceFirst("/>", "></" + nodestr + ">");
        }
        return tmpstr;
    }

    public String BJX_getXMLSignatureInfo(String XmlSign, int type) throws GetXMLSignInfoException {
        try {
            String ret = "";
            ByteArrayInputStream bips = new ByteArrayInputStream(XmlSign.getBytes());
            Document doc = this.db.parse(bips);
            switch (type) {
                case 1: {
                    Node node_obj = this.SelectNode(doc, "Signature/Object");
                    ret = this.getNodeText(node_obj);
                    break;
                }
                case 2: {
                    Node node_obj = this.SelectNode(doc, "Signature/SignedInfo/Reference/DigestValue");
                    ret = this.getNodeText(node_obj);
                    break;
                }
                case 3: {
                    Node node_obj = this.SelectNode(doc, "Signature/SignatureValue");
                    ret = this.getNodeText(node_obj);
                    break;
                }
                case 4: {
                    Node node_obj = this.SelectNode(doc, "Signature/KeyInfo/X509Data/X509Certificate");
                    ret = this.getNodeText(node_obj);
                    break;
                }
                case 5: {
                    Node node_obj = this.SelectNode(doc, "Signature/SignedInfo/Reference/DigestMethod");
                    ret = this.getAttributeText(node_obj, "Algorithm");
                    break;
                }
                case 6: {
                    Node node_obj = this.SelectNode(doc, "Signature/SignedInfo/SignatureMethod");
                    ret = this.getAttributeText(node_obj, "Algorithm");
                    break;
                }
                default: {
                    ret = null;
                }
            }
            return ret;
        }
        catch (SAXException e) {
            this.errorlog("\u83b7\u53d6XML\u7b7e\u540d\u4fe1\u606f\u51fa\u9519\uff01", e);
            this.debuglog("\u83b7\u53d6XML\u7b7e\u540d\u4fe1\u606f\u51fa\u9519\uff01", e);
            throw new GetXMLSignInfoException("\u83b7\u53d6XML\u7b7e\u540d\u4fe1\u606f\u51fa\u9519\uff01");
        }
        catch (IOException e) {
            this.errorlog("\u83b7\u53d6XML\u7b7e\u540d\u4fe1\u606f\u51fa\u9519\uff01", e);
            this.debuglog("\u83b7\u53d6XML\u7b7e\u540d\u4fe1\u606f\u51fa\u9519\uff01", e);
            throw new GetXMLSignInfoException("\u83b7\u53d6XML\u7b7e\u540d\u4fe1\u606f\u51fa\u9519\uff01");
        }
    }

    public Document getDocumentFromString(byte[] xml) throws SAXException, IOException {
        ByteArrayInputStream bips = new ByteArrayInputStream(xml);
        Document doc = this.db.parse(bips);
        return doc;
    }
}

