/*
 * Decompiled with CFR 0.152.
 */
package xjyb.cn.org.bjca.mac;

import java.security.InvalidKeyException;
import xjyb.cn.org.bjca.exception.AlgorithmNotFoundException;
import xjyb.com.sansec.device.local.WrapCard;

public class PBOCMac {
    private static final byte[] H0 = new byte[]{0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0};

    public static void main(String[] args) throws Exception {
        byte[] key = new byte[16];
        for (int i = 0; i < 16; ++i) {
            key[i] = (byte)i;
        }
        System.out.println(PBOCMac.pbocV3Mac(key, "123".getBytes(), key).length);
    }

    public static byte[] pbocV3Mac(byte[] key, byte[] data, byte[] iv_sm4) throws InvalidKeyException, AlgorithmNotFoundException {
        if (key == null || key.length != 16) {
            throw new InvalidKeyException("make sure the key's length is 16!");
        }
        int dataLength = data.length;
        int lastLength = dataLength % 8;
        int blockCount = dataLength / 8 + (lastLength > 0 ? 1 : 0);
        byte[][] blockArr = new byte[blockCount][16];
        for (int i = 0; i < blockCount; ++i) {
            if (i == blockCount - 1) {
                int paddingLen = 8 - lastLength;
                byte[] lastBlock = new byte[paddingLen];
                lastBlock[0] = 80;
                for (int j = 1; j < paddingLen; ++j) {
                    lastBlock[j] = 0;
                }
                System.arraycopy(data, i * 8, blockArr[i], 0, lastLength);
                System.arraycopy(lastBlock, 0, blockArr[i], lastLength, paddingLen);
                continue;
            }
            System.arraycopy(data, i * 8, blockArr[i], 0, 8);
        }
        byte[] xorRes = H0;
        for (int i = 0; i < blockCount; ++i) {
            byte[] xorTmp = PBOCMac.xOr(xorRes, blockArr[i]);
            WrapCard wCard = new WrapCard(9);
            xorRes = wCard.sm4Encrypt(4098, false, key, iv_sm4, xorTmp);
        }
        byte[] res = new byte[4];
        for (int i = 0; i < 4; ++i) {
            res[i] = xorRes[i];
        }
        return res;
    }

    private static byte[] xOr(byte[] x, byte[] y) {
        if (x.length != y.length) {
            return null;
        }
        byte[] xOrRes = new byte[x.length];
        for (int i = 0; i < x.length; ++i) {
            xOrRes[i] = (byte)(x[i] ^ y[i]);
        }
        return xOrRes;
    }
}

