/*
 * Decompiled with CFR 0.152.
 */
package xjyb.cn.org.bjca.security;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.security.GeneralSecurityException;
import java.security.InvalidKeyException;
import java.security.NoSuchAlgorithmException;
import java.security.NoSuchProviderException;
import java.security.Security;
import java.security.cert.CertificateEncodingException;
import java.security.cert.CertificateException;
import java.text.ParseException;
import org.bouncycastle.jce.provider.BouncyCastleProvider;
import xjyb.bjca.org.jdom.JDOMException;
import xjyb.bjca.org.multi.util.LoggerUtil;
import xjyb.cn.org.bjca.config.XmlConfig;
import xjyb.cn.org.bjca.exception.AlgorithmNotFoundException;
import xjyb.cn.org.bjca.exception.AppNotfoundException;
import xjyb.cn.org.bjca.exception.Base64Exception;
import xjyb.cn.org.bjca.exception.DecryptDataException;
import xjyb.cn.org.bjca.exception.EncryptDataException;
import xjyb.cn.org.bjca.exception.GetCertInfoException;
import xjyb.cn.org.bjca.exception.GetXMLSignInfoException;
import xjyb.cn.org.bjca.exception.HashException;
import xjyb.cn.org.bjca.exception.InitException;
import xjyb.cn.org.bjca.exception.ParameterNotSupportException;
import xjyb.cn.org.bjca.exception.Pkcs7DecodeEnvelopeException;
import xjyb.cn.org.bjca.exception.Pkcs7DecodeException;
import xjyb.cn.org.bjca.exception.Pkcs7EncodeEnvelopeException;
import xjyb.cn.org.bjca.exception.Pkcs7EncodeException;
import xjyb.cn.org.bjca.exception.Pkcs7SignException;
import xjyb.cn.org.bjca.exception.Pkcs7VerifySignException;
import xjyb.cn.org.bjca.exception.RandomNumberException;
import xjyb.cn.org.bjca.exception.RsaDecryptException;
import xjyb.cn.org.bjca.exception.RsaEncryptException;
import xjyb.cn.org.bjca.exception.RsaSignException;
import xjyb.cn.org.bjca.exception.RsaVerifySignException;
import xjyb.cn.org.bjca.exception.SecretRecoveryException;
import xjyb.cn.org.bjca.exception.SecretSegmentException;
import xjyb.cn.org.bjca.exception.TsException;
import xjyb.cn.org.bjca.exception.ValidateCertException;
import xjyb.cn.org.bjca.exception.VerifySignDataException;
import xjyb.cn.org.bjca.exception.XmlSignException;
import xjyb.cn.org.bjca.exception.XmlVerifySignException;
import xjyb.cn.org.bjca.java.security.SecurityEngineDeal_java;
import xjyb.cn.org.bjca.jni.security.SecurityEngineDeal_jni;
import xjyb.cn.org.bjca.security.SuperEngine;
import xjyb.cn.org.bjca.utils.GetPathUtil;

public abstract class SecurityEngineDeal
implements SuperEngine {
    public static synchronized void setRootPath(String rootPath) {
        GetPathUtil.setBJCAROOT_Path(rootPath);
        LoggerUtil.setLogPath(rootPath + "/logs/");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     * Converted monitor instructions to comments
     * Lifted jumps to return sites
     */
    public static SecurityEngineDeal getInstance(String appName) throws JDOMException, IOException, InitException, AppNotfoundException {
        int deviceType;
        Class<SecurityEngineDeal> clazz;
        if (GetPathUtil.getBJCAROOT_Path() == null) {
            clazz = SecurityEngineDeal.class;
            // MONITORENTER : xjyb.cn.org.bjca.security.SecurityEngineDeal.class
            if (GetPathUtil.getBJCAROOT_Path() == null) {
                GetPathUtil.setConfigPath();
            }
            // MONITOREXIT : clazz
        }
        if (XmlConfig.version == null) {
            clazz = SecurityEngineDeal.class;
            // MONITORENTER : xjyb.cn.org.bjca.security.SecurityEngineDeal.class
            if (XmlConfig.version == null) {
                System.out.println("Secx Version:2.7.2 build201808061400");
                LoggerUtil.systemlog("all", "Secx Version:2.7.2 build201808061400");
                XmlConfig.loadConfig();
                xmlThread.start();
                p7Thread.start();
                crlThread.start();
                Security.addProvider(new BouncyCastleProvider());
            }
            // MONITOREXIT : clazz
        }
        if ((deviceType = XmlConfig.getWebappsDeviceType(appName)) == 0) {
            LoggerUtil.errorlog(appName, "Not found that application name !");
            LoggerUtil.debuglog(appName, "Not found that application name !");
            throw new AppNotfoundException("Not found that application name !");
        }
        if (listApp.containsKey(appName)) {
            return (SecurityEngineDeal)listApp.get(appName);
        }
        Class<SecurityEngineDeal> clazz2 = SecurityEngineDeal.class;
        // MONITORENTER : xjyb.cn.org.bjca.security.SecurityEngineDeal.class
        if (listApp.containsKey(appName)) {
            // MONITOREXIT : clazz2
            return (SecurityEngineDeal)listApp.get(appName);
        }
        if (deviceType <= 3) {
            LoggerUtil.systemlog("all", appName + " application enter jni entrance!");
            SecurityEngineDeal_jni safeEngDealJni = new SecurityEngineDeal_jni(appName);
            listApp.put(appName, safeEngDealJni);
            safeEngDealJni.verifyCRL();
            // MONITOREXIT : clazz2
            return safeEngDealJni;
        }
        LoggerUtil.systemlog("all", appName + " application enter java entrance!");
        if (Security.addProvider(new BouncyCastleProvider()) != -1) {
            System.out.println(appName + " Add provider failed when application initialization !");
            LoggerUtil.errorlog(appName, appName + " Add provider failed when application initialization !");
            // MONITOREXIT : clazz2
            return null;
        }
        SecurityEngineDeal_java safeEngDealJava = new SecurityEngineDeal_java(appName);
        listApp.put(appName, safeEngDealJava);
        safeEngDealJava.verifyCRL();
        // MONITOREXIT : clazz2
        return safeEngDealJava;
    }

    public void release() {
        xmlThread.stop();
        p7Thread.stop();
        crlThread.stop();
    }

    @Override
    public abstract void initAppValue();

    @Override
    public abstract void initP7Cert();

    @Override
    public abstract String getApplicationName();

    public abstract void setApplicationName(String var1);

    @Override
    public abstract void setDebug(boolean var1) throws InitException;

    public abstract void setSignMethod(String var1) throws AlgorithmNotFoundException;

    public abstract String getSignMethod();

    public abstract String getEncryptMethod();

    public abstract String getServerCertificate() throws Base64Exception;

    public abstract String getServerCertificate(int var1) throws Base64Exception;

    public abstract String genRandom() throws RandomNumberException, Base64Exception;

    public abstract String genRandom(int var1) throws RandomNumberException, Base64Exception;

    public abstract byte[] genRandomByte(int var1);

    public abstract String getCertInfo(String var1, int var2) throws Base64Exception, GetCertInfoException;

    public abstract String getCertInfo0020(String var1, int var2) throws Base64Exception, GetCertInfoException;

    public abstract String getCertInfoByOid(String var1, String var2) throws Base64Exception, GetCertInfoException;

    public abstract int validateCert(String var1) throws CertificateException, Base64Exception, ValidateCertException, GetCertInfoException;

    public abstract String signData(String var1) throws Base64Exception, HashException, RsaSignException;

    public abstract String signData(byte[] var1) throws Base64Exception, HashException, RsaSignException;

    public abstract String signDataWithoutZ(String var1) throws Base64Exception, HashException;

    public abstract String signDataWithoutZ(byte[] var1) throws Base64Exception, HashException;

    public abstract boolean verifySignedDataWithoutZ(byte[] var1, byte[] var2, byte[] var3) throws VerifySignDataException, HashException;

    public abstract byte[] signDataReByte(byte[] var1) throws Base64Exception, HashException, RsaSignException;

    public abstract byte[] signDataNoDER(byte[] var1) throws Base64Exception, HashException, RsaSignException;

    public abstract byte[] signHashedData(byte[] var1);

    public abstract String signData(InputStream var1) throws HashException, RsaSignException, Base64Exception;

    public abstract boolean verifySignedData(String var1, String var2, String var3) throws Base64Exception, HashException, GetCertInfoException, VerifySignDataException;

    public abstract boolean verifySignedData(String var1, byte[] var2, String var3) throws Base64Exception, HashException, GetCertInfoException, VerifySignDataException;

    public abstract boolean verifySignedData(String var1, byte[] var2, byte[] var3) throws Base64Exception, HashException, GetCertInfoException, VerifySignDataException;

    public abstract boolean verifySignedDataNoDER(String var1, byte[] var2, byte[] var3) throws Base64Exception, HashException, GetCertInfoException, VerifySignDataException;

    public abstract boolean verifySignedData(byte[] var1, byte[] var2, byte[] var3) throws VerifySignDataException;

    public abstract boolean verifySignatureByHashedData(String var1, byte[] var2, byte[] var3) throws VerifySignDataException, Base64Exception;

    public abstract boolean verifySignatureByHashedData(byte[] var1, byte[] var2, byte[] var3) throws VerifySignDataException, Base64Exception;

    public abstract String signFile(String var1) throws HashException, RsaSignException, Base64Exception;

    public abstract boolean verifySignedFile(String var1, String var2, String var3) throws Base64Exception, HashException, GetCertInfoException, VerifySignDataException;

    public abstract boolean verifySignedData(String var1, InputStream var2, String var3) throws Base64Exception, HashException, GetCertInfoException, RsaVerifySignException;

    public abstract String secretSegment(String var1, int var2, int var3, int var4) throws SecretSegmentException;

    public abstract String secretRecovery(String var1) throws SecretRecoveryException;

    public abstract String encryptData(String var1, String var2) throws EncryptDataException, IOException, Base64Exception;

    public abstract byte[] encryptData(byte[] var1, byte[] var2) throws Base64Exception;

    public abstract byte[] encryptData(byte[] var1, byte[] var2, int var3);

    public abstract byte[] encryptData(byte[] var1, byte[] var2, int var3, byte[] var4, boolean var5);

    public abstract boolean encryptData(String var1, InputStream var2, OutputStream var3) throws EncryptDataException, IOException;

    public abstract boolean decryptData(String var1, InputStream var2, OutputStream var3) throws DecryptDataException, IOException;

    public abstract String decryptData(String var1, String var2) throws DecryptDataException, Base64Exception, IOException;

    public abstract byte[] decryptData(byte[] var1, byte[] var2) throws Base64Exception;

    public abstract byte[] decryptData(byte[] var1, byte[] var2, int var3);

    public abstract byte[] decryptData(byte[] var1, byte[] var2, int var3, byte[] var4, boolean var5);

    public abstract boolean encryptFile(String var1, String var2, String var3) throws Base64Exception, EncryptDataException;

    public abstract boolean decryptFile(String var1, String var2, String var3) throws Base64Exception, DecryptDataException;

    public abstract String pubKeyEncrypt(String var1, String var2) throws Base64Exception, GetCertInfoException, RsaEncryptException;

    public abstract byte[] pubKeyEncrypt(String var1, byte[] var2) throws Base64Exception, GetCertInfoException, RsaEncryptException;

    public abstract String pubKeyEncrypt_OAEP(String var1, String var2) throws Base64Exception, GetCertInfoException, RsaEncryptException;

    public abstract String pubKeyEncrypt_OAEP(String var1, byte[] var2) throws Base64Exception, GetCertInfoException, RsaEncryptException;

    public abstract String priKeyDecrypt(String var1) throws Base64Exception, RsaDecryptException;

    public abstract byte[] priKeyDecrypt(byte[] var1) throws Base64Exception, RsaDecryptException;

    public abstract String priKeyDecrypt_OAEP(String var1) throws Base64Exception, RsaDecryptException;

    public abstract boolean addSignFile(String var1);

    public abstract boolean addSignString(String var1);

    public abstract void clearAllSignData();

    public abstract boolean verifySignAll(String var1, String var2) throws Base64Exception, GetCertInfoException, VerifySignDataException, NoSuchAlgorithmException;

    public abstract String getTotalTsReq() throws TsException, Base64Exception, NoSuchAlgorithmException;

    public abstract String signDataPkcs7(String var1) throws Pkcs7SignException, Pkcs7EncodeException, Base64Exception;

    public abstract String signDataPkcs7(byte[] var1) throws Pkcs7SignException, Pkcs7EncodeException, Base64Exception;

    public abstract String signDataPkcs7ForJit(byte[] var1) throws Pkcs7SignException, Pkcs7EncodeException, Base64Exception;

    public abstract String signDataPkcs7ForJit_detach(byte[] var1) throws Pkcs7SignException, Pkcs7EncodeException, Base64Exception;

    public abstract byte[] signHashedDataPkcs7_detach(byte[] var1) throws Pkcs7SignException;

    public abstract byte[] signHashedDataPkcs7_detach(byte[] var1, boolean var2) throws Pkcs7SignException;

    public abstract String signDataPkcs7_detach(byte[] var1) throws Pkcs7SignException, Pkcs7EncodeException, Base64Exception;

    public abstract String signDataPkcs7_file_detach(String var1) throws Pkcs7SignException, Pkcs7EncodeException, Base64Exception;

    public abstract boolean verifySignedDataPkcs7(String var1) throws Base64Exception, Pkcs7VerifySignException;

    public abstract boolean verifySignedDataPkcs7(byte[] var1) throws Base64Exception, Pkcs7VerifySignException;

    public abstract String verifySignedDataPkcs7_detach(byte[] var1, String var2) throws Base64Exception, Pkcs7VerifySignException;

    public abstract String verifySignedDataPkcs7_detach_ForJit(byte[] var1, String var2) throws Base64Exception, Pkcs7VerifySignException;

    public abstract String verifySignedDataPkcs7_detach_hash(byte[] var1, String var2) throws Pkcs7VerifySignException;

    public abstract String verifySignedDataPkcs7_detach_hash(byte[] var1, byte[] var2) throws Pkcs7VerifySignException;

    public abstract String verifySignedDataPkcs7_detach_hash_ForCPIC(byte[] var1, byte[] var2) throws Pkcs7VerifySignException;

    public abstract boolean verifySignedDataPkcs7_file_detach(String var1, String var2) throws Base64Exception, Pkcs7VerifySignException;

    public abstract String getP7SignDataInfo(String var1, int var2) throws Pkcs7DecodeException, Base64Exception;

    public abstract byte[] getP7SignDataInfo(byte[] var1, int var2) throws Pkcs7DecodeException, Base64Exception;

    public abstract String encodeP7EnvelopedData(String var1, String var2) throws Base64Exception, Pkcs7EncodeEnvelopeException, Pkcs7EncodeException;

    public abstract byte[] encodeP7EnvelopedData(String var1, byte[] var2) throws Base64Exception, Pkcs7EncodeEnvelopeException;

    public abstract byte[] encodeP7EnvelopedData4Jit(String var1, byte[] var2) throws Base64Exception, Pkcs7EncodeEnvelopeException;

    public abstract String decodeP7EnvelopedData(String var1) throws Base64Exception, Pkcs7DecodeEnvelopeException, Pkcs7DecodeException;

    public abstract byte[] decodeP7EnvelopedData(byte[] var1) throws Pkcs7DecodeEnvelopeException;

    public abstract byte[] decodeP7EnvelopedData4Jit(byte[] var1) throws Pkcs7DecodeEnvelopeException;

    public abstract String encodeP7SignAndEnvelopData(String var1, String var2) throws Base64Exception, Pkcs7EncodeEnvelopeException, Pkcs7EncodeException;

    public abstract String encodeP7SignAndEnvelopData(String var1, byte[] var2) throws Base64Exception, Pkcs7EncodeEnvelopeException, Pkcs7EncodeException;

    public abstract String decodeP7SignAndEnvelopData(String var1) throws Base64Exception, Pkcs7DecodeEnvelopeException, Pkcs7DecodeException;

    public abstract byte[] decodeP7SignAndEnvelopData(byte[] var1) throws Base64Exception, Pkcs7DecodeEnvelopeException, Pkcs7DecodeException;

    public abstract byte[] decodeP7SignAndEnvelopData(byte[] var1, String var2) throws Base64Exception, Pkcs7DecodeEnvelopeException, Pkcs7DecodeException;

    public abstract String signDataXML(String var1) throws XmlSignException;

    public abstract String signDataXML0020(String var1) throws XmlSignException;

    public abstract boolean verifySignedDataXML(String var1) throws XmlVerifySignException;

    public abstract boolean verifySignedDataXML0020(String var1) throws XmlVerifySignException;

    public abstract String getXMLSignatureInfo(String var1, int var2) throws GetXMLSignInfoException, JDOMException;

    public abstract String createTimeStampRequest(String var1) throws HashException, TsException, Base64Exception;

    public abstract byte[] createTimeStampRequest(byte[] var1, boolean var2) throws HashException;

    public abstract String createTimeStampRequest(byte[] var1) throws HashException, TsException, Base64Exception;

    public abstract String createTimeStamp(String var1) throws Base64Exception, TsException;

    public abstract byte[] createTimeStamp(byte[] var1) throws TsException;

    public abstract byte[] createTimeStamp0033(byte[] var1) throws TsException;

    public abstract String createTimeStampNoCert(String var1) throws Base64Exception, TsException;

    public abstract String createTSByOriginalData(String var1) throws Base64Exception, TsException;

    public abstract String createTSByOriginalData(byte[] var1) throws Base64Exception, TsException;

    public abstract boolean verifyTimeStamp(String var1, String var2) throws Base64Exception, TsException, HashException;

    public abstract boolean verifyTimeStamp(byte[] var1) throws TsException;

    public abstract boolean verifyTimeStamp0033(byte[] var1) throws TsException;

    public abstract boolean verifyTimeStampByCert(String var1, byte[] var2) throws Base64Exception, TsException, HashException;

    public abstract boolean verifyTimeStampByCert(byte[] var1, byte[] var2) throws TsException;

    public abstract boolean verifyTimeStampByCert0033(byte[] var1, byte[] var2) throws TsException;

    public abstract String getTimeStampInfo(String var1, int var2) throws Base64Exception, TsException, ParseException, Pkcs7DecodeException;

    public abstract String getTimeStampInfo(byte[] var1, int var2) throws TsException;

    public abstract String getTimeStampInfo0033(byte[] var1, int var2) throws TsException;

    public abstract byte[] createP7DetachedAndTimeStampedData(byte[] var1) throws GeneralSecurityException;

    public abstract byte[] createP7DetachedAndTimeStampedData(byte[] var1, byte[] var2) throws GeneralSecurityException;

    public abstract byte[] generateP7DetachedByP7AndTimeStampedData(byte[] var1, byte[] var2) throws GeneralSecurityException;

    public abstract int verifyP7DetachedAndTimeStampedData(byte[] var1);

    public abstract String getP7DetachedAndTimeStampedDataInfo(byte[] var1, int var2) throws CertificateEncodingException, IOException;

    public abstract String base64Encode(byte[] var1) throws Base64Exception;

    public abstract byte[] base64Decode(String var1) throws Base64Exception;

    public abstract String hash_string(String var1) throws HashException, Base64Exception;

    public abstract byte[] hash_byte(byte[] var1) throws HashException;

    public abstract byte[] hashByteByAlg(byte[] var1, String var2) throws HashException;

    public abstract byte[] hash_byte(byte[] var1, String var2) throws HashException;

    public abstract String hash_file(String var1) throws HashException, RsaSignException, Base64Exception;

    public abstract String getAllP7b();

    public abstract Object[] generatorKeyPair(int var1, int var2) throws IOException;

    public abstract byte[] generatP7CounterSign(byte[] var1) throws IOException, Pkcs7SignException, Pkcs7DecodeException, HashException, InvalidKeyException, CertificateException, SecurityException, NoSuchProviderException, NoSuchAlgorithmException;

    public abstract String verifyP7CounterSign(byte[] var1) throws CertificateException, Pkcs7DecodeException, Base64Exception, ValidateCertException, GetCertInfoException, HashException, IOException, ParseException;

    public abstract byte[] createTimeStampRequestByHashedData(byte[] var1, boolean var2) throws TsException;

    public abstract byte[] createTimeStampRequestByFile(String var1, boolean var2) throws TsException;

    public abstract int verifyTimeStampByFile(byte[] var1, String var2) throws TsException, ParseException;

    public abstract byte[] createTimeStampRequestByLargebinary(byte[] var1, boolean var2) throws TsException, IOException;

    public abstract int verifyTimeStampByLargebinary(byte[] var1, byte[] var2) throws TsException, IOException;

    public abstract byte[] generatP7CounterSignYbq(byte[] var1, String var2) throws IOException, Pkcs7SignException, Pkcs7DecodeException, HashException, InvalidKeyException, CertificateException, SecurityException, NoSuchProviderException, NoSuchAlgorithmException, GeneralSecurityException;

    public abstract String verifyP7CounterSignYbq(byte[] var1, byte[] var2) throws CertificateException, Pkcs7DecodeException, Base64Exception, ValidateCertException, GetCertInfoException, HashException, IOException, ParseException, Pkcs7VerifySignException;

    public abstract byte[] getOriDateByTsRequest(byte[] var1) throws TsException;

    public abstract Object[] generatorKeyPairForDZHT(int var1, int var2) throws IOException, ParameterNotSupportException;

    public abstract byte[] decryptPriForDZHT(byte[] var1) throws IOException;
}

