/*
 * Decompiled with CFR 0.152.
 */
package xjyb.cn.org.bjca.utils;

import java.io.ByteArrayInputStream;
import java.security.PublicKey;
import java.security.cert.CertificateFactory;
import java.security.cert.X509Certificate;
import xjyb.bjca.org.multi.util.LoggerUtil;
import xjyb.cn.org.bjca.framework.SuperUtil;
import xjyb.cn.org.bjca.utils.Base64Util;
import xjyb.cn.org.bjca.utils.CertificateUtil;
import xjyb.cn.org.bjca.utils.FileUtil;
import xjyb.cn.org.bjca.utils.GetPathUtil;
import xjyb.cn.org.bjca.utils.HashUtil;

public class LicenceUtil
extends SuperUtil {
    private static String info = null;
    private static String licenceInfo = null;
    private static int remainDate = 0;
    private static final String root = "MIIEiDCCA3CgAwIBAgIKEAAAAAAAAAIAAjANBgkqhkiG9w0BAQUFADBaMQswCQYDVQQGEwJDTjENMAsGA1UECgwEQkpDQTEdMBsGA1UECwwUUHVibGljIFRydXN0IFJvb3QgQ0ExHTAbBgNVBAMMFFB1YmxpYyBUcnVzdCBSb290IENBMB4XDTA1MDEwMTA4MDAwMFoXDTI0MTIzMTA4MDAwMFowUjELMAkGA1UEBhMCQ04xDTALBgNVBAoMBEJKQ0ExGDAWBgNVBAsMD1B1YmxpYyBUcnVzdCBDQTEaMBgGA1UEAwwRUHVibGljIFRydXN0IENBLTEwggEiMA0GCSqGSIb3DQEBAQUAA4IBDwAwggEKAoIBAQC8HFQIaqUVTNX9mSB7Ymn7bKz6pjckK/N4iLaC2wDvL/OcAAnctU8BZ6Ootv2TiS7mtdIT636eN23kvGy4mWrL3a2kCS+NQwk6Xh7gW1VB9lvNDu1KpjxZ7KKncpfyHgedxSWQAQQewixNVgLNU3S60waxFQ4ppjixYJXhSacqxvDVeR79vYX/FxAi0pWJ+tmbvBpDsr4A4k89LdeE8AafErGL8GM/Kji+rSTVoMSrG04JrzXXDxEYPeAEemcOn4WqwfDFkg/wcIvLmdUbackBRmfR5Sbge5yKUEt/JBOfv5BmHu34zFrU8BUXMz1uQcfc37VyIYEMQGGl1R5obOTnAgMBAAGjggFWMIIBUjAfBgNVHSMEGDAWgBRgV2OcMBtwogEDmdLaNvRpCMA8pTAdBgNVHQ4EFgQUrDvsrwyjUA7vr6+0T2w729FX0okwDAYDVR0PBAUDAwcGADA/BgNVHSAEODA2MDQGADAwMC4GCCsGAQUFBwIBFiJodHRwOi8vd3d3LmJqY2Eub2cuY24vY3BzL2Nwcy5odG1sMA8GA1UdEwQIMAYBAf8CAQIwga8GA1UdHwSBpzCBpDBzoHGgb6RtMGsxCzAJBgNVBAYTAkNOMQ0wCwYDVQQKDARCSkNBMR0wGwYDVQQLDBRQdWJsaWMgVHJ1c3QgUm9vdCBDQTEdMBsGA1UEAwwUUHVibGljIFRydXN0IFJvb3QgQ0ExDzANBgNVBAMTBnB0cm9vdDAtoCugKYYnaHR0cDovL2xkYXAuYmpjYS5vcmcuY24vYXJsL3B0cm9vdC5jcmwgMA0GCSqGSIb3DQEBBQUAA4IBAQBzt6iN086M2tHqf86Iz9moALhCWgtY3LD0INjedUahaOXwl0lg2Q4iKes7D+UDee9A/DFM1AmVH2WVkZYlouG8zkILtSpBJVTQVVWct3gtGMw0pqUrBE+cNrMXT3GdHlwF64FjyDG8xgSwzLxzkMnv+EMpHqGxGvik2kx/47Sb6KTTSwC4O0vqhesJwQpfHh4eqkl8/caTzae8N3uEPiI++PEGu8iskmU//2LIuxvRITdi0yaYZ3xIe1gYYW38XsiupjCePf8MGX6Ltow5oAPe9xhisujFWWdk5pUkpyQCSQFlYjIE0ZZEkwTc6KEXY5C0rMAORiY0bt5ZoZAgjT9k";

    public LicenceUtil(String appName) {
        super(appName);
    }

    private static void generateNativeInfo() {
        try {
            HashUtil hashU = new HashUtil("all");
            Base64Util base64U = new Base64Util("all");
            String version = System.getProperty("java.version");
            String home = System.getProperty("java.home");
            String specialVersion = System.getProperty("java.vm.specification.version");
            String specialVendor = System.getProperty("java.vm.specification.vendor");
            String specialName = System.getProperty("java.vm.specification.name");
            String classVersion = System.getProperty("java.class.version");
            String osName = System.getProperty("os.name");
            String osArch = System.getProperty("os.arch");
            String osVersion = System.getProperty("os.version");
            String nativeInfomation = version + home + specialVersion + specialVendor + specialName + classVersion + osName + osArch + osVersion;
            byte[] hashedData = hashU.BJS_HashBytes(1L, nativeInfomation.getBytes());
            info = base64U.BJS_EncodeBase64(hashedData);
        }
        catch (Exception e) {
            LoggerUtil.errorlog("all", "Exception in getting native infomation !", e);
            LoggerUtil.systemlog("all", "Exception in getting native infomation !");
        }
    }

    private static void setLicenceInfo() {
        try {
            FileUtil fileU = new FileUtil("all");
            CertificateUtil certU = new CertificateUtil("all");
            String licencePath = GetPathUtil.getLicencePath();
            byte[] licenceCert = fileU.readFile(licencePath);
            licenceInfo = certU.BJC_GetExtCertInfo(licenceCert, "2.16.156.1.101.1.14").toUpperCase();
        }
        catch (Exception e) {
            LoggerUtil.errorlog("all", "Exception in getting licence infomation !", e);
            LoggerUtil.systemlog("all", "Exception in getting licence infomation !");
        }
    }

    private static void setValidate() {
        try {
            FileUtil fileU = new FileUtil("all");
            Base64Util base64U = new Base64Util("all");
            CertificateUtil certU = new CertificateUtil("all");
            String licencePath = GetPathUtil.getLicencePath();
            byte[] licenceCert = fileU.readFile(licencePath);
            CertificateFactory oCf = CertificateFactory.getInstance("X.509");
            ByteArrayInputStream ois = new ByteArrayInputStream(licenceCert);
            X509Certificate oCert = (X509Certificate)oCf.generateCertificate(ois);
            byte[] rootByte = base64U.BJS_DecodeBase64(root);
            ByteArrayInputStream rootInS = new ByteArrayInputStream(rootByte);
            X509Certificate rootCert = (X509Certificate)oCf.generateCertificate(rootInS);
            PublicKey rootPubKey = rootCert.getPublicKey();
            try {
                oCert.verify(rootPubKey);
            }
            catch (Exception e) {
                LoggerUtil.errorlog("all", "licence issuer error!", e);
                LoggerUtil.systemlog("all", "licence issuer error!");
                remainDate = -1;
            }
            remainDate = -certU.BJC_CheckCertValidity(licenceCert, null);
            LoggerUtil.systemlog("all", "Checking licence validity == " + remainDate);
        }
        catch (Exception e) {
            LoggerUtil.errorlog("all", "Exception in checking licence validity !", e);
            LoggerUtil.systemlog("all", "Exception in checking licence validity !");
        }
    }

    public static String getInfo() {
        return info;
    }

    public static String getLicenceInfo() {
        return licenceInfo;
    }

    public static int getRemainDate() {
        return remainDate;
    }

    public static boolean getLicence() {
        if (info == null) {
            LoggerUtil.errorlog("all", "Get native infomation error!");
            LoggerUtil.systemlog("all", "Get native infomation error!");
            return false;
        }
        if (info.equals(licenceInfo)) {
            return true;
        }
        LoggerUtil.systemlog("all", "Native info == " + info);
        LoggerUtil.systemlog("all", "Cert info == " + licenceInfo);
        LoggerUtil.systemlog("all", "Licence error, infomation not match\uff01");
        return false;
    }

    public static void main(String[] arg) {
        try {
            boolean isR = LicenceUtil.getLicence();
            System.out.println(isR);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    static {
        LicenceUtil.generateNativeInfo();
        LicenceUtil.setLicenceInfo();
        LicenceUtil.setValidate();
    }
}

