/*
 * Decompiled with CFR 0.152.
 */
package xjyb.cn.org.bjca.utils;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.security.KeyStore;
import java.security.KeyStoreException;
import java.security.NoSuchAlgorithmException;
import java.security.NoSuchProviderException;
import java.security.PrivateKey;
import java.security.cert.Certificate;
import java.security.cert.CertificateException;
import java.security.cert.CertificateFactory;
import java.security.cert.X509Certificate;
import xjyb.cn.org.bjca.framework.Log;
import xjyb.cn.org.bjca.java.utils.KeyPairUtil;
import xjyb.cn.org.bjca.utils.FileUtil;
import xjyb.cn.org.bjca.utils.GetPathUtil;

public class P12Util
extends Log {
    public P12Util() {
        super("P12Util");
    }

    public void p12Generator(String filePath, String p12Alias, PrivateKey privateKey, String keyPassword, String storePassword, X509Certificate cert) throws KeyStoreException, NoSuchAlgorithmException, CertificateException, IOException {
        Certificate[] caCertChain = new X509Certificate[]{cert};
        KeyStore ks1 = KeyStore.getInstance("PKCS12");
        ks1.load(null, null);
        ks1.setKeyEntry(p12Alias, privateKey, keyPassword.toCharArray(), caCertChain);
        String dirPath = GetPathUtil.getDirPathFromFilePath(filePath);
        GetPathUtil.confirmDir(dirPath);
        FileOutputStream fos = new FileOutputStream(filePath);
        ks1.store(fos, storePassword.toCharArray());
        fos.close();
    }

    public byte[] p12Generator(String p12Alias, PrivateKey privateKey, String keyPassword, String storePassword, X509Certificate cert) throws KeyStoreException, NoSuchAlgorithmException, CertificateException, IOException {
        Certificate[] caCertChain = new X509Certificate[]{cert};
        long begin = System.currentTimeMillis();
        KeyStore ks1 = null;
        try {
            ks1 = KeyStore.getInstance("PKCS12", "BC");
        }
        catch (NoSuchProviderException e) {
            e.printStackTrace();
        }
        ks1.load(null, null);
        ks1.setKeyEntry(p12Alias, privateKey, keyPassword.toCharArray(), caCertChain);
        long end = System.currentTimeMillis();
        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
        ks1.store(byteArrayOutputStream, storePassword.toCharArray());
        long end1 = System.currentTimeMillis();
        byte[] pfxCxt = byteArrayOutputStream.toByteArray();
        byteArrayOutputStream.close();
        long end2 = System.currentTimeMillis();
        return pfxCxt;
    }

    public static void main(String[] args) {
        try {
            P12Util p12U = new P12Util();
            FileUtil fileUtil = new FileUtil("");
            byte[] cert = fileUtil.readFile("c:/zhaosong.der");
            CertificateFactory oCf = CertificateFactory.getInstance("X.509");
            ByteArrayInputStream ois = new ByteArrayInputStream(cert);
            X509Certificate x509Cert = (X509Certificate)oCf.generateCertificate(ois);
            KeyPairUtil keyPairUtil = new KeyPairUtil("");
            keyPairUtil.generatorKeyPair();
            PrivateKey privateKey = keyPairUtil.getPrivateKey();
            ByteArrayOutputStream byteArrayOutStream = new ByteArrayOutputStream();
            ObjectOutputStream oos = new ObjectOutputStream(byteArrayOutStream);
            oos.writeObject(privateKey);
            byte[] realPrivateKeyObjByte = byteArrayOutStream.toByteArray();
            ByteArrayInputStream in = new ByteArrayInputStream(realPrivateKeyObjByte);
            ObjectInputStream oIn = new ObjectInputStream(in);
            PrivateKey privateKeyO = (PrivateKey)oIn.readObject();
            p12U.p12Generator("c:/test.pfx", "testKey", privateKeyO, "111111", "111111", x509Cert);
            KeyStore keyStore = KeyStore.getInstance("PKCS12");
            FileInputStream oFis = new FileInputStream("c:/test.pfx");
            keyStore.load(oFis, "111111".toCharArray());
            Certificate certGet = keyStore.getCertificate("testKey");
            byte[] certGetByte = certGet.getEncoded();
            System.out.println(certGetByte.length);
            fileUtil.writeFile(certGetByte, "c:\\test2.der");
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }
}

