/*
 * Decompiled with CFR 0.152.
 */
package xjyb.com.bjca.security.Util;

import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.Hashtable;
import java.util.List;
import xjyb.bjca.org.jdom.Content;
import xjyb.bjca.org.jdom.Document;
import xjyb.bjca.org.jdom.Element;
import xjyb.bjca.org.jdom.JDOMException;
import xjyb.bjca.org.jdom.input.SAXBuilder;
import xjyb.bjca.org.jdom.output.Format;
import xjyb.bjca.org.jdom.output.XMLOutputter;
import xjyb.cn.org.bjca.config.XmlConfig;
import xjyb.cn.org.bjca.framework.Log;
import xjyb.cn.org.bjca.utils.GetPathUtil;
import xjyb.com.bjca.security.SecurityEngineDeal_oldJni;
import xjyb.com.bjca.security.valuebean.CertContainerObject;
import xjyb.com.bjca.security.valuebean.TrustObject;

public class ConversionOldXml
extends Log {
    private String verifyTime;

    public ConversionOldXml() {
    }

    public ConversionOldXml(String appName) {
        super(appName);
    }

    public void addNewXmlFromXml() throws FileNotFoundException, JDOMException, IOException {
        XmlConfig.loadConfig();
        Element newRoot = (Element)XmlConfig.root.clone();
        SAXBuilder builder = new SAXBuilder("org.apache.xerces.parsers.SAXParser");
        Document oldDoc = builder.build((InputStream)new FileInputStream(GetPathUtil.getOldXMLConfigue()));
        Element root = oldDoc.getRootElement();
        List certlist = this.getAllCert(root);
        List trulist = this.getAllTrust(root);
        Element device = (Element)this.createDevices().getChild("device").clone();
        Element trustcerts = (Element)this.createTrustCerts(trulist).clone();
        Element cert = (Element)this.createCerts(certlist, trulist).getChild("cert").clone();
        Element webapp = (Element)this.createWebapps(certlist, trulist).getChild("webapp").clone();
        newRoot.getChild("webapps").addContent((Content)webapp);
        String containerId = cert.getChildText("container");
        Hashtable listCert = XmlConfig.getListCerts();
        if (!listCert.containsKey(containerId)) {
            newRoot.getChild("certs").addContent((Content)cert);
        }
        Hashtable listTrustcerts = XmlConfig.getListTrustcerts();
        List trustCertList = trustcerts.getChildren("trustcert");
        for (Element eTrustcert : trustCertList) {
            String alias = eTrustcert.getChildText("alias");
            if (listTrustcerts.containsKey(alias)) continue;
            Element trustCert = (Element)eTrustcert.clone();
            newRoot.getChild("trustcerts").addContent((Content)trustCert);
        }
        Hashtable listDevices = XmlConfig.getListDevices();
        if (!listDevices.containsKey("BJCASOFT")) {
            newRoot.getChild("devices").addContent((Content)device);
        }
        Document doc = new Document(newRoot);
        Format format = Format.getCompactFormat();
        format.setEncoding("gb2312");
        format.setIndent("    ");
        XMLOutputter XMLOut = new XMLOutputter(format);
        XMLOut.output(doc, (OutputStream)new FileOutputStream(GetPathUtil.getXMLConfigue()));
    }

    public void convOldXml_noNew() throws FileNotFoundException, JDOMException, IOException {
        SAXBuilder builder = new SAXBuilder();
        Document oldDoc = builder.build((InputStream)new FileInputStream(GetPathUtil.getOldXMLConfigue()));
        Element root = oldDoc.getRootElement();
        List certlist = this.getAllCert(root);
        List trulist = this.getAllTrust(root);
        Element bjcaroot = new Element("bjcaroot");
        Element version = new Element("version");
        version.setText("2");
        Element devices = this.createDevices();
        Element trustcerts = this.createTrustCerts(trulist);
        Element certs = this.createCerts(certlist, trulist);
        Element webapps = this.createWebapps(certlist, trulist);
        bjcaroot.addContent((Content)version);
        bjcaroot.addContent((Content)devices);
        bjcaroot.addContent((Content)trustcerts);
        bjcaroot.addContent((Content)certs);
        bjcaroot.addContent((Content)webapps);
        Document doc = new Document(bjcaroot);
        Format format = Format.getCompactFormat();
        format.setEncoding("gb2312");
        format.setIndent("    ");
        XMLOutputter XMLOut = new XMLOutputter(format);
        XMLOut.output(doc, (OutputStream)new FileOutputStream(GetPathUtil.getXMLConfigue()));
    }

    public Element createDevices() {
        Element devices = new Element("devices");
        Element device = new Element("device");
        Element name = new Element("name");
        name.setText("BJCASOFT");
        Element providertype = new Element("providertype");
        providertype.setText("3");
        Element provider = new Element("provider");
        Element privatedll = new Element("privatedll");
        device.addContent((Content)name);
        device.addContent((Content)providertype);
        device.addContent((Content)provider);
        device.addContent((Content)privatedll);
        devices.addContent((Content)device);
        return devices;
    }

    public Element createTrustCerts(List trulist) {
        Element trustcerts = new Element("trustcerts");
        int length = trulist.size();
        for (int i = 0; i < length; ++i) {
            TrustObject trustObject = (TrustObject)trulist.get(i);
            Element trustcert = new Element("trustcert");
            Element alias = new Element("alias");
            alias.setText(trustObject.getId());
            Element subjec = new Element("subjec");
            subjec.setText(trustObject.getName());
            Element uniqidoid = new Element("uniqidoid");
            uniqidoid.setText(trustObject.getUniqIdOid());
            Element crldistributionpoin = new Element("crldistributionpoin");
            Element url = new Element("url");
            Element localpath = new Element("localpath");
            crldistributionpoin.addContent((Content)url);
            crldistributionpoin.addContent((Content)localpath);
            trustcert.addContent((Content)alias);
            trustcert.addContent((Content)subjec);
            trustcert.addContent((Content)uniqidoid);
            trustcert.addContent((Content)crldistributionpoin);
            trustcerts.addContent((Content)trustcert);
        }
        return trustcerts;
    }

    public Element createCerts(List certlist, List trulist) {
        Element certs = new Element("certs");
        CertContainerObject certObject = (CertContainerObject)certlist.get(0);
        Element cert = new Element("cert");
        Element container = new Element("container");
        container.setText(certObject.getId());
        Element uniqid = new Element("uniqid");
        uniqid.setText(certObject.getUniqId());
        Element uniqidoid = new Element("uniqidoid");
        uniqidoid.setText(certObject.getUniqIdOid());
        Element subjectname = new Element("subjectname");
        subjectname.setText(certObject.getSubjectName());
        Element dept = new Element("dept");
        dept.setText(certObject.getDeptName());
        Element issueName = new Element("issueName");
        issueName.setText(certObject.getIssueName());
        Element avail = new Element("avail");
        avail.setText("1");
        Element tradetype = new Element("tradetype");
        tradetype.setText(certObject.getTradeType());
        Element devicename = new Element("devicename");
        devicename.setText("BJCASOFT");
        Element trustcert = new Element("trustcert");
        trustcert.setText(certObject.getCaType());
        Element password = new Element("password");
        password.setText(certObject.getPassword());
        Element keytype = new Element("keytype");
        keytype.setText("1");
        Element keynode = new Element("keynode");
        Element signature = new Element("signature");
        Element signKeySn = new Element("serialnum");
        signKeySn.setText(certObject.getSignKeySn());
        signature.addContent((Content)signKeySn);
        Element exchange = new Element("exchange");
        Element exchKeySn = new Element("serialnum");
        exchKeySn.setText(certObject.getExchKeySn());
        exchange.addContent((Content)exchKeySn);
        keynode.addContent((Content)signature);
        keynode.addContent((Content)exchange);
        cert.addContent((Content)container);
        cert.addContent((Content)uniqid);
        cert.addContent((Content)uniqidoid);
        cert.addContent((Content)subjectname);
        cert.addContent((Content)dept);
        cert.addContent((Content)issueName);
        cert.addContent((Content)avail);
        cert.addContent((Content)tradetype);
        cert.addContent((Content)devicename);
        cert.addContent((Content)trustcert);
        cert.addContent((Content)password);
        cert.addContent((Content)keytype);
        cert.addContent((Content)keynode);
        certs.addContent((Content)cert);
        return certs;
    }

    public Element createWebapps(List certlist, List trulist) {
        Element webapps = new Element("webapps");
        Element webapp = new Element("webapp");
        Element name = new Element("name");
        name.setText(SecurityEngineDeal_oldJni.applicationName);
        Element container = new Element("container");
        String containId = ((CertContainerObject)certlist.get(0)).getId();
        container.setText(containId);
        Element certverify = new Element("certverify");
        Element catype = new Element("catype");
        catype.setText(this.getAllCaType(trulist));
        Element policytype = new Element("policytype");
        policytype.setText("2");
        Element verifytime = new Element("verifytime");
        verifytime.setText(this.verifyTime);
        Element prohibitlist = new Element("prohibitlist");
        Element uniqid = new Element("uniqid");
        Element serialnum = new Element("serialnum");
        prohibitlist.addContent((Content)uniqid);
        prohibitlist.addContent((Content)serialnum);
        certverify.addContent((Content)catype);
        certverify.addContent((Content)policytype);
        certverify.addContent((Content)verifytime);
        certverify.addContent((Content)prohibitlist);
        webapp.addContent((Content)name);
        webapp.addContent((Content)container);
        webapp.addContent((Content)certverify);
        webapps.addContent((Content)webapp);
        return webapps;
    }

    public String getAllCaType(List trulist) {
        int length = trulist.size();
        StringBuffer strBuf = new StringBuffer();
        for (int i = 0; i < length; ++i) {
            TrustObject trustObject = (TrustObject)trulist.get(i);
            String id = trustObject.getId();
            if (i == 0) {
                strBuf.append(id);
                continue;
            }
            strBuf.append(";" + id);
        }
        return strBuf.toString();
    }

    public List getAllCert(Element root) {
        ArrayList<CertContainerObject> certlist = new ArrayList<CertContainerObject>();
        Element certemt = root.getChild("Cert");
        for (Element emt : certemt.getChildren()) {
            Element exchemt;
            if (!emt.getChildText("avail").equals("1")) continue;
            CertContainerObject certObj = new CertContainerObject();
            certObj.setId(emt.getName().substring(3));
            certObj.setUniqId(emt.getChildText("uniqID"));
            certObj.setUniqIdOid(emt.getChildText("uniqIdOid"));
            certObj.setSubjectName(emt.getChildText("subjectname"));
            certObj.setDeptName(emt.getChildText("dept"));
            certObj.setIssueName(emt.getChildText("issueName"));
            certObj.setAvailable(true);
            certObj.setTradeType(emt.getChildText("tradeType"));
            certObj.setDevType(emt.getChildText("devType"));
            certObj.setCaType(emt.getChildText("caType"));
            certObj.setPassword(emt.getChildText("password"));
            certObj.setKeyType(emt.getChildText("keyType"));
            Element signemt = emt.getChild("keyNode").getChild("signature");
            if (signemt != null) {
                certObj.setSignKeySn(signemt.getChildText("serialNum"));
            }
            if ((exchemt = emt.getChild("keyNode").getChild("exchange")) != null) {
                certObj.setExchKeySn(exchemt.getChildText("serialNum"));
            }
            certlist.add(certObj);
        }
        return certlist;
    }

    public List getAllTrust(Element root) {
        ArrayList<TrustObject> trulist = new ArrayList<TrustObject>();
        Element truemt = root.getChild("Trust");
        for (Element emt : truemt.getChildren()) {
            if (!emt.getName().equals("VerifyType") && !emt.getName().equals("VerifyTime")) {
                trulist.add(new TrustObject(emt.getName(), emt.getChildText("CAName"), emt.getChildText("uniqIdOid")));
                continue;
            }
            if (!emt.getName().equals("VerifyTime")) continue;
            this.verifyTime = emt.getText();
        }
        return trulist;
    }
}

