/*
 * Decompiled with CFR 0.152.
 */
package xjyb.com.sansec.device;

import java.io.FileInputStream;
import xjyb.com.sansec.device.local.Card;
import xjyb.org.bjca.util.PrintUtil;

public class CardTest1 {
    static String provider = "card";
    static int keysize = 1024;

    public static void main(String[] args) throws Exception {
        byte[] buffer = null;
        int rv = 0;
        Card card = Card.getInstance();
        rv = card.openDevice();
        if (rv != 0) {
            System.err.println("open device failed, rv[0x" + Integer.toHexString(rv) + "]");
            return;
        }
        int algId = 1;
        byte[] hash = "1234".getBytes();
        byte[] privateKey = "1234".getBytes();
        FileInputStream fis = new FileInputStream("private_" + keysize + ".dat");
        privateKey = new byte[fis.available()];
        fis.read(privateKey);
        fis.close();
        System.out.println("private key");
        PrintUtil.printWithHex(privateKey);
        buffer = card.externalSign(algId, hash, privateKey);
        rv = CardTest1.byte2int(buffer, 0);
        byte[] result = null;
        if (rv != 0) {
            System.err.println("external sign failed, rv[0x" + Integer.toHexString(rv) + "]");
            return;
        }
        result = new byte[buffer.length - 4];
        System.out.println("external sign successful");
        System.arraycopy(buffer, 4, result, 0, buffer.length - 4);
        System.out.println("sign value");
        PrintUtil.printWithHex(result);
        fis = new FileInputStream("public_" + keysize + ".dat");
        byte[] publicKey = new byte[fis.available()];
        fis.read(publicKey);
        fis.close();
        System.out.println("public key");
        PrintUtil.printWithHex(publicKey);
        buffer = card.externalVerify(algId, hash, result, publicKey);
        rv = CardTest1.byte2int(buffer, 0);
        if (rv != 0) {
            System.err.println("external verify failed, rv[0x" + Integer.toHexString(rv) + "]");
            return;
        }
        result = new byte[buffer.length - 4];
        System.out.println("external verify successful");
        System.arraycopy(buffer, 4, result, 0, buffer.length - 4);
        if (result[0] == 0) {
            System.out.println("verfiy successful");
        } else {
            System.out.println("verfiy failed");
        }
        rv = card.closeDevice();
        if (rv != 0) {
            System.err.println("closs device failed, rv[0x" + Integer.toHexString(rv) + "]");
            return;
        }
        System.out.println("close device successful");
    }

    public static int byte2int(byte[] buffer, int offset) {
        int num = 0;
        for (int i = 0; i < 4; ++i) {
            num = (int)((long)num + ((0xFFL & (long)buffer[i + offset]) << i * 8));
        }
        return num;
    }

    public static long byte2long(byte[] buffer, int offset) {
        byte[] tmp = new byte[buffer.length - offset];
        System.arraycopy(buffer, offset, tmp, 0, tmp.length);
        long n = Long.parseLong(new String(tmp));
        return n;
    }
}

