/*
 * Decompiled with CFR 0.152.
 */
package xjyb.com.sansec.device;

import java.io.FileInputStream;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import xjyb.com.sansec.device.Speed;
import xjyb.com.sansec.device.local.Card;
import xjyb.org.bjca.util.PrintUtil;

public class MutilTest {
    static int threads = 50;

    public static void main(String[] args) {
        ExecutorService executorService = Executors.newFixedThreadPool(threads);
        executorService.execute(new Speed());
        for (int i = 0; i < threads; ++i) {
            executorService.execute(new TestCard());
        }
    }

    public static int byte2int(byte[] buffer, int offset) {
        int num = 0;
        for (int i = 0; i < 4; ++i) {
            num = (int)((long)num + ((0xFFL & (long)buffer[i + offset]) << i * 8));
        }
        return num;
    }

    public static class TestCard
    implements Runnable {
        public static boolean running = true;
        public static int okCount = 0;
        public static int exCount = 0;
        public static int failCount = 0;
        static Card card = null;
        static byte[] hash = "12345678123456781234".getBytes();
        static byte[] buffer = null;
        static int algId = 1;
        static int rv = -1;
        static byte[] privateKey = null;
        static byte[] publicKey = null;

        @Override
        public void run() {
            while (running) {
                try {
                    buffer = card.externalSign(algId, hash, privateKey);
                    rv = MutilTest.byte2int(buffer, 0);
                    Object result = null;
                    if (rv != 0) {
                        System.err.println("external sign failed, rv[0x" + Integer.toHexString(rv) + "]");
                        return;
                    }
                    ++okCount;
                }
                catch (Exception e) {
                    e.printStackTrace();
                    ++exCount;
                }
            }
        }

        static {
            int keysize = 1024;
            try {
                FileInputStream fis = new FileInputStream("private_" + keysize + ".dat");
                privateKey = new byte[fis.available()];
                fis.read(privateKey);
                fis.close();
                System.out.println("private key");
                PrintUtil.printWithHex(privateKey);
                fis = new FileInputStream("public_" + keysize + ".dat");
                publicKey = new byte[fis.available()];
                fis.read(publicKey);
                fis.close();
                System.out.println("public key");
                PrintUtil.printWithHex(publicKey);
            }
            catch (Exception e) {
                e.printStackTrace();
            }
            Object buffer = null;
            int rv = -1;
            String provider = "card";
            card = Card.getInstance();
            rv = card.openDevice();
            if (rv != 0) {
                System.err.println("open device failed, rv[0x" + Integer.toHexString(rv) + "]");
            }
        }
    }
}

