/*
 * Decompiled with CFR 0.152.
 */
package xjyb.net.lingala.zip4j.crypto;

import java.util.ArrayList;
import java.util.Arrays;
import xjyb.net.lingala.zip4j.crypto.IDecrypter;
import xjyb.net.lingala.zip4j.crypto.PBKDF2.MacBasedPRF;
import xjyb.net.lingala.zip4j.crypto.PBKDF2.PBKDF2Engine;
import xjyb.net.lingala.zip4j.crypto.PBKDF2.PBKDF2Parameters;
import xjyb.net.lingala.zip4j.crypto.engine.AESEngine;
import xjyb.net.lingala.zip4j.exception.ZipException;
import xjyb.net.lingala.zip4j.model.AESExtraDataRecord;
import xjyb.net.lingala.zip4j.model.LocalFileHeader;
import xjyb.net.lingala.zip4j.util.Raw;
import xjyb.net.lingala.zip4j.util.Zip4jUtil;

public class AESDecrypter
implements IDecrypter {
    private LocalFileHeader localFileHeader;
    private AESEngine aesEngine;
    private MacBasedPRF mac;
    private final int PASSWORD_VERIFIER_LENGTH = 2;
    private int KEY_LENGTH;
    private int MAC_LENGTH;
    private int SALT_LENGTH;
    private byte[] aesKey;
    private byte[] macKey;
    private byte[] derivedPasswordVerifier;
    private byte[] storedMac;
    private int nonce = 1;

    public AESDecrypter(LocalFileHeader localFileHeader, byte[] salt, byte[] passwordVerifier) throws ZipException {
        if (localFileHeader == null) {
            throw new ZipException("one of the input parameters is null in AESDecryptor Constructor");
        }
        this.localFileHeader = localFileHeader;
        this.storedMac = null;
        this.init(salt, passwordVerifier);
    }

    private void init(byte[] salt, byte[] passwordVerifier) throws ZipException {
        if (this.localFileHeader == null) {
            throw new ZipException("invalid file header in init method of AESDecryptor");
        }
        AESExtraDataRecord aesExtraDataRecord = this.localFileHeader.getAesExtraDataRecord();
        if (aesExtraDataRecord == null) {
            throw new ZipException("invalid aes extra data record - in init method of AESDecryptor");
        }
        switch (aesExtraDataRecord.getAesStrength()) {
            case 1: {
                this.KEY_LENGTH = 16;
                this.MAC_LENGTH = 16;
                this.SALT_LENGTH = 8;
                break;
            }
            case 2: {
                this.KEY_LENGTH = 24;
                this.MAC_LENGTH = 24;
                this.SALT_LENGTH = 12;
                break;
            }
            case 3: {
                this.KEY_LENGTH = 32;
                this.MAC_LENGTH = 32;
                this.SALT_LENGTH = 16;
                break;
            }
            default: {
                throw new ZipException("invalid aes key strength for file: " + this.localFileHeader.getFileName());
            }
        }
        if (!Zip4jUtil.isStringNotNullAndNotEmpty(this.localFileHeader.getPassword())) {
            throw new ZipException("empty or null password provided for AES Decryptor");
        }
        byte[] derivedKey = this.deriveKey(salt, this.localFileHeader.getPassword());
        if (derivedKey == null || derivedKey.length != this.KEY_LENGTH + this.MAC_LENGTH + 2) {
            throw new ZipException("invalid derived key");
        }
        this.aesKey = new byte[this.KEY_LENGTH];
        this.macKey = new byte[this.MAC_LENGTH];
        this.derivedPasswordVerifier = new byte[2];
        System.arraycopy(derivedKey, 0, this.aesKey, 0, this.KEY_LENGTH);
        System.arraycopy(derivedKey, this.KEY_LENGTH, this.macKey, 0, this.MAC_LENGTH);
        System.arraycopy(derivedKey, this.KEY_LENGTH + this.MAC_LENGTH, this.derivedPasswordVerifier, 0, 2);
        if (this.derivedPasswordVerifier == null) {
            throw new ZipException("invalid derived password verifier for AES");
        }
        if (!Arrays.equals(passwordVerifier, this.derivedPasswordVerifier)) {
            throw new ZipException("Wrong Password for file: " + this.localFileHeader.getFileName(), 5);
        }
        this.aesEngine = new AESEngine(this.aesKey);
        this.mac = new MacBasedPRF("HmacSHA1");
        this.mac.init(this.macKey);
    }

    public int decryptData(byte[] buff, int start, int len) throws ZipException {
        if (this.aesEngine == null) {
            throw new ZipException("AES not initialized properly");
        }
        try {
            ArrayList<byte[]> byteBlocks = new ArrayList<byte[]>();
            ArrayList<byte[]> decBlocks = new ArrayList<byte[]>();
            for (int i = 0; i < len; i += 16) {
                byte[] block = i + 16 > len ? new byte[len - i] : new byte[16];
                System.arraycopy(buff, i, block, 0, block.length);
                byteBlocks.add(block);
            }
            byte[] iv = new byte[16];
            byte[] counterBlock = new byte[16];
            for (int i = 0; i < byteBlocks.size(); ++i) {
                byte[] cipherBlock = (byte[])byteBlocks.get(i);
                byte[] decryptedBlock = new byte[cipherBlock.length];
                this.mac.update(cipherBlock);
                iv = Raw.toByteArray(this.nonce, 16);
                this.aesEngine.processBlock(iv, counterBlock);
                for (int j = 0; j < cipherBlock.length; ++j) {
                    decryptedBlock[j] = (byte)(cipherBlock[j] ^ counterBlock[j]);
                }
                decBlocks.add(decryptedBlock);
                ++this.nonce;
            }
            int pos = 0;
            for (int i = 0; i < decBlocks.size(); ++i) {
                System.arraycopy(decBlocks.get(i), 0, buff, pos, ((byte[])decBlocks.get(i)).length);
                pos += ((byte[])decBlocks.get(i)).length;
            }
            return len;
        }
        catch (ZipException e) {
            throw e;
        }
        catch (Exception e) {
            throw new ZipException(e);
        }
    }

    public int decryptData(byte[] buff) throws ZipException {
        return this.decryptData(buff, 0, buff.length);
    }

    private byte[] deriveKey(byte[] salt, String password) throws ZipException {
        try {
            PBKDF2Parameters p = new PBKDF2Parameters("HmacSHA1", "ISO-8859-1", salt, 1000);
            PBKDF2Engine e = new PBKDF2Engine(p);
            byte[] derivedKey = e.deriveKey(password, this.KEY_LENGTH + this.MAC_LENGTH + 2);
            return derivedKey;
        }
        catch (Exception e) {
            throw new ZipException(e);
        }
    }

    public int getPasswordVerifierLength() {
        return 2;
    }

    public int getSaltLength() {
        return this.SALT_LENGTH;
    }

    public byte[] getCalculatedAuthenticationBytes() {
        return this.mac.doFinal();
    }

    public void setStoredMac(byte[] storedMac) {
        this.storedMac = storedMac;
    }

    public byte[] getStoredMac() {
        return this.storedMac;
    }
}

