/*
 * Decompiled with CFR 0.152.
 */
package xjyb.org.apache.http.impl.io;

import xjyb.org.apache.http.HttpResponse;
import xjyb.org.apache.http.HttpResponseFactory;
import xjyb.org.apache.http.annotation.Contract;
import xjyb.org.apache.http.annotation.ThreadingBehavior;
import xjyb.org.apache.http.config.MessageConstraints;
import xjyb.org.apache.http.impl.DefaultHttpResponseFactory;
import xjyb.org.apache.http.impl.io.DefaultHttpResponseParser;
import xjyb.org.apache.http.io.HttpMessageParser;
import xjyb.org.apache.http.io.HttpMessageParserFactory;
import xjyb.org.apache.http.io.SessionInputBuffer;
import xjyb.org.apache.http.message.BasicLineParser;
import xjyb.org.apache.http.message.LineParser;

@Contract(threading=ThreadingBehavior.IMMUTABLE_CONDITIONAL)
public class DefaultHttpResponseParserFactory
implements HttpMessageParserFactory<HttpResponse> {
    public static final DefaultHttpResponseParserFactory INSTANCE = new DefaultHttpResponseParserFactory();
    private final LineParser lineParser;
    private final HttpResponseFactory responseFactory;

    public DefaultHttpResponseParserFactory(LineParser lineParser, HttpResponseFactory responseFactory) {
        this.lineParser = lineParser != null ? lineParser : BasicLineParser.INSTANCE;
        this.responseFactory = responseFactory != null ? responseFactory : DefaultHttpResponseFactory.INSTANCE;
    }

    public DefaultHttpResponseParserFactory() {
        this(null, null);
    }

    @Override
    public HttpMessageParser<HttpResponse> create(SessionInputBuffer buffer, MessageConstraints constraints) {
        return new DefaultHttpResponseParser(buffer, this.lineParser, this.responseFactory, constraints);
    }
}

