/*
 * Decompiled with CFR 0.152.
 */
package xjyb.org.bjca.asn1;

import java.io.ByteArrayOutputStream;
import java.io.EOFException;
import java.io.IOException;
import java.io.InputStream;
import java.util.Vector;
import xjyb.org.bjca.asn1.ASN1EncodableVector;
import xjyb.org.bjca.asn1.BERConstructedOctetString;
import xjyb.org.bjca.asn1.BERConstructedSequence;
import xjyb.org.bjca.asn1.BERSet;
import xjyb.org.bjca.asn1.BERTaggedObject;
import xjyb.org.bjca.asn1.DERInputStream;
import xjyb.org.bjca.asn1.DERObject;
import xjyb.org.bjca.asn1.DEROctetString;
import xjyb.org.bjca.asn1.DEROutputStream;
import xjyb.org.bjca.asn1.DERTaggedObject;

public class BERInputStream
extends DERInputStream {
    private static final DERObject END_OF_STREAM = new DERObject(){

        @Override
        void encode(DEROutputStream out) throws IOException {
            throw new IOException("Eeek!");
        }

        @Override
        public int hashCode() {
            return 0;
        }

        @Override
        public boolean equals(Object o) {
            return o == this;
        }
    };

    public BERInputStream(InputStream is) {
        super(is);
    }

    private byte[] readIndefiniteLengthFully() throws IOException {
        int b;
        ByteArrayOutputStream bOut = new ByteArrayOutputStream();
        int b1 = this.read();
        while ((b = this.read()) >= 0 && (b1 != 0 || b != 0)) {
            bOut.write(b1);
            b1 = b;
        }
        return bOut.toByteArray();
    }

    private BERConstructedOctetString buildConstructedOctetString() throws IOException {
        DERObject o;
        Vector<DERObject> octs = new Vector<DERObject>();
        while ((o = this.readObject()) != END_OF_STREAM) {
            octs.addElement(o);
        }
        return new BERConstructedOctetString(octs);
    }

    @Override
    public DERObject readObject() throws IOException {
        int tag = this.read();
        if (tag == -1) {
            throw new EOFException();
        }
        int length = this.readLength();
        if (length < 0) {
            switch (tag) {
                case 5: {
                    return null;
                }
                case 48: {
                    DERObject obj;
                    BERConstructedSequence seq = new BERConstructedSequence();
                    while ((obj = this.readObject()) != END_OF_STREAM) {
                        seq.addObject(obj);
                    }
                    return seq;
                }
                case 36: {
                    return this.buildConstructedOctetString();
                }
                case 49: {
                    DERObject obj;
                    ASN1EncodableVector v = new ASN1EncodableVector();
                    while ((obj = this.readObject()) != END_OF_STREAM) {
                        v.add(obj);
                    }
                    return new BERSet(v);
                }
            }
            if ((tag & 0x80) != 0) {
                if ((tag & 0x1F) == 31) {
                    throw new IOException("unsupported high tag encountered");
                }
                if ((tag & 0x20) == 0) {
                    byte[] bytes = this.readIndefiniteLengthFully();
                    return new BERTaggedObject(false, tag & 0x1F, new DEROctetString(bytes));
                }
                DERObject dObj = this.readObject();
                if (dObj == END_OF_STREAM) {
                    return new DERTaggedObject(tag & 0x1F);
                }
                DERObject next = this.readObject();
                if (next == END_OF_STREAM) {
                    return new BERTaggedObject(tag & 0x1F, dObj);
                }
                BERConstructedSequence seq = new BERConstructedSequence();
                seq.addObject(dObj);
                do {
                    seq.addObject(next);
                } while ((next = this.readObject()) != END_OF_STREAM);
                return new BERTaggedObject(false, tag & 0x1F, seq);
            }
            throw new IOException("unknown BER object encountered");
        }
        if (tag == 0 && length == 0) {
            return END_OF_STREAM;
        }
        byte[] bytes = new byte[length];
        this.readFully(bytes);
        return this.buildObject(tag, bytes);
    }
}

