/*
 * Decompiled with CFR 0.152.
 */
package xjyb.org.bjca.asn1;

import java.io.IOException;
import java.io.InputStream;
import xjyb.org.bjca.asn1.ASN1EncodableVector;
import xjyb.org.bjca.asn1.ASN1StreamParser;
import xjyb.org.bjca.asn1.ASN1TaggedObjectParser;
import xjyb.org.bjca.asn1.BERFactory;
import xjyb.org.bjca.asn1.BEROctetStringParser;
import xjyb.org.bjca.asn1.BERSequenceParser;
import xjyb.org.bjca.asn1.BERSetParser;
import xjyb.org.bjca.asn1.BERTaggedObject;
import xjyb.org.bjca.asn1.DEREncodable;
import xjyb.org.bjca.asn1.DERFactory;
import xjyb.org.bjca.asn1.DERObject;
import xjyb.org.bjca.asn1.DEROctetString;
import xjyb.org.bjca.asn1.DEROctetStringParser;
import xjyb.org.bjca.asn1.DERSequenceParser;
import xjyb.org.bjca.asn1.DERSetParser;
import xjyb.org.bjca.asn1.DERTaggedObject;
import xjyb.org.bjca.asn1.DefiniteLengthInputStream;
import xjyb.org.bjca.asn1.IndefiniteLengthInputStream;

public class BERTaggedObjectParser
implements ASN1TaggedObjectParser {
    private int _baseTag;
    private int _tagNumber;
    private InputStream _contentStream;
    private boolean _indefiniteLength;

    protected BERTaggedObjectParser(int baseTag, int tagNumber, InputStream contentStream) {
        this._baseTag = baseTag;
        this._tagNumber = tagNumber;
        this._contentStream = contentStream;
        this._indefiniteLength = contentStream instanceof IndefiniteLengthInputStream;
    }

    public boolean isConstructed() {
        return (this._baseTag & 0x20) != 0;
    }

    @Override
    public int getTagNo() {
        return this._tagNumber;
    }

    @Override
    public DEREncodable getObjectParser(int tag, boolean isExplicit) throws IOException {
        if (isExplicit) {
            return new ASN1StreamParser(this._contentStream).readObject();
        }
        switch (tag) {
            case 17: {
                if (this._indefiniteLength) {
                    return new BERSetParser(new ASN1StreamParser(this._contentStream));
                }
                return new DERSetParser(new ASN1StreamParser(this._contentStream));
            }
            case 16: {
                if (this._indefiniteLength) {
                    return new BERSequenceParser(new ASN1StreamParser(this._contentStream));
                }
                return new DERSequenceParser(new ASN1StreamParser(this._contentStream));
            }
            case 4: {
                if (this._indefiniteLength || this.isConstructed()) {
                    return new BEROctetStringParser(new ASN1StreamParser(this._contentStream));
                }
                return new DEROctetStringParser((DefiniteLengthInputStream)this._contentStream);
            }
        }
        throw new RuntimeException("implicit tagging not implemented");
    }

    private ASN1EncodableVector rLoadVector(InputStream in) {
        try {
            return new ASN1StreamParser(in).readVector();
        }
        catch (IOException e) {
            throw new IllegalStateException(e.getMessage());
        }
    }

    @Override
    public DERObject getDERObject() {
        if (this._indefiniteLength) {
            ASN1EncodableVector v = this.rLoadVector(this._contentStream);
            return v.size() == 1 ? new BERTaggedObject(true, this._tagNumber, v.get(0)) : new BERTaggedObject(false, this._tagNumber, BERFactory.createSequence(v));
        }
        if (this.isConstructed()) {
            ASN1EncodableVector v = this.rLoadVector(this._contentStream);
            return v.size() == 1 ? new DERTaggedObject(true, this._tagNumber, v.get(0)) : new DERTaggedObject(false, this._tagNumber, DERFactory.createSequence(v));
        }
        try {
            DefiniteLengthInputStream defIn = (DefiniteLengthInputStream)this._contentStream;
            return new DERTaggedObject(false, this._tagNumber, new DEROctetString(defIn.toByteArray()));
        }
        catch (IOException e) {
            throw new IllegalStateException(e.getMessage());
        }
    }
}

