/*
 * Decompiled with CFR 0.152.
 */
package xjyb.org.bjca.asn1.cms;

import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.SimpleTimeZone;
import xjyb.org.bjca.asn1.ASN1Encodable;
import xjyb.org.bjca.asn1.ASN1TaggedObject;
import xjyb.org.bjca.asn1.DERGeneralizedTime;
import xjyb.org.bjca.asn1.DERObject;
import xjyb.org.bjca.asn1.DERUTCTime;

public class Time
extends ASN1Encodable {
    DERObject time;

    public static Time getInstance(ASN1TaggedObject obj, boolean explicit) {
        return Time.getInstance(obj.getObject());
    }

    public Time(DERObject time) {
        if (!(time instanceof DERUTCTime) && !(time instanceof DERGeneralizedTime)) {
            throw new IllegalArgumentException("unknown object passed to Time");
        }
        this.time = time;
    }

    public Time(Date date) {
        SimpleTimeZone tz = new SimpleTimeZone(0, "Z");
        SimpleDateFormat dateF = new SimpleDateFormat("yyyyMMddHHmmss");
        dateF.setTimeZone(tz);
        String d = dateF.format(date) + "Z";
        int year = Integer.parseInt(d.substring(0, 4));
        this.time = year < 1950 || year > 2049 ? new DERGeneralizedTime(d) : new DERUTCTime(d.substring(2));
    }

    public static Time getInstance(Object obj) {
        if (obj instanceof Time) {
            return (Time)obj;
        }
        if (obj instanceof DERUTCTime) {
            return new Time((DERUTCTime)obj);
        }
        if (obj instanceof DERGeneralizedTime) {
            return new Time((DERGeneralizedTime)obj);
        }
        throw new IllegalArgumentException("unknown object in factory: " + obj.getClass().getName());
    }

    public String getTime() {
        if (this.time instanceof DERUTCTime) {
            return ((DERUTCTime)this.time).getAdjustedTime();
        }
        return ((DERGeneralizedTime)this.time).getTime();
    }

    public Date getDate() {
        try {
            if (this.time instanceof DERUTCTime) {
                return ((DERUTCTime)this.time).getAdjustedDate();
            }
            return ((DERGeneralizedTime)this.time).getDate();
        }
        catch (ParseException e) {
            throw new IllegalStateException("invalid date string: " + e.getMessage());
        }
    }

    @Override
    public DERObject toASN1Object() {
        return this.time;
    }
}

