/*
 * Decompiled with CFR 0.152.
 */
package xjyb.org.bjca.asn1.crmf;

import java.util.Enumeration;
import xjyb.org.bjca.asn1.ASN1Encodable;
import xjyb.org.bjca.asn1.ASN1EncodableVector;
import xjyb.org.bjca.asn1.ASN1Sequence;
import xjyb.org.bjca.asn1.ASN1TaggedObject;
import xjyb.org.bjca.asn1.DERObject;
import xjyb.org.bjca.asn1.DERSequence;
import xjyb.org.bjca.asn1.x509.Time;

public class OptionalValidity
extends ASN1Encodable {
    private Time notBefore;
    private Time notAfter;

    private OptionalValidity(ASN1Sequence seq) {
        Enumeration en = seq.getObjects();
        while (en.hasMoreElements()) {
            ASN1TaggedObject tObj = (ASN1TaggedObject)en.nextElement();
            if (tObj.getTagNo() == 0) {
                this.notBefore = Time.getInstance(tObj, false);
                continue;
            }
            this.notAfter = Time.getInstance(tObj, false);
        }
    }

    public static OptionalValidity getInstance(Object o) {
        if (o instanceof OptionalValidity) {
            return (OptionalValidity)o;
        }
        if (o instanceof ASN1Sequence) {
            return new OptionalValidity((ASN1Sequence)o);
        }
        throw new IllegalArgumentException("Invalid object: " + o.getClass().getName());
    }

    @Override
    public DERObject toASN1Object() {
        ASN1EncodableVector v = new ASN1EncodableVector();
        v.add(this.notBefore);
        v.add(this.notAfter);
        return new DERSequence(v);
    }
}

