/*
 * Decompiled with CFR 0.152.
 */
package xjyb.org.bjca.asn1.ocsp;

import xjyb.org.bjca.asn1.ASN1Encodable;
import xjyb.org.bjca.asn1.ASN1EncodableVector;
import xjyb.org.bjca.asn1.ASN1Sequence;
import xjyb.org.bjca.asn1.ASN1TaggedObject;
import xjyb.org.bjca.asn1.DERObject;
import xjyb.org.bjca.asn1.DERSequence;
import xjyb.org.bjca.asn1.DERTaggedObject;
import xjyb.org.bjca.asn1.ocsp.Signature;
import xjyb.org.bjca.asn1.ocsp.TBSRequest;

public class OCSPRequest
extends ASN1Encodable {
    TBSRequest tbsRequest;
    Signature optionalSignature;

    public OCSPRequest(TBSRequest tbsRequest, Signature optionalSignature) {
        this.tbsRequest = tbsRequest;
        this.optionalSignature = optionalSignature;
    }

    public OCSPRequest(ASN1Sequence seq) {
        this.tbsRequest = TBSRequest.getInstance(seq.getObjectAt(0));
        if (seq.size() == 2) {
            this.optionalSignature = Signature.getInstance((ASN1TaggedObject)seq.getObjectAt(1), true);
        }
    }

    public static OCSPRequest getInstance(ASN1TaggedObject obj, boolean explicit) {
        return OCSPRequest.getInstance(ASN1Sequence.getInstance(obj, explicit));
    }

    public static OCSPRequest getInstance(Object obj) {
        if (obj == null || obj instanceof OCSPRequest) {
            return (OCSPRequest)obj;
        }
        if (obj instanceof ASN1Sequence) {
            return new OCSPRequest((ASN1Sequence)obj);
        }
        throw new IllegalArgumentException("unknown object in factory: " + obj.getClass().getName());
    }

    public TBSRequest getTbsRequest() {
        return this.tbsRequest;
    }

    public Signature getOptionalSignature() {
        return this.optionalSignature;
    }

    @Override
    public DERObject toASN1Object() {
        ASN1EncodableVector v = new ASN1EncodableVector();
        v.add(this.tbsRequest);
        if (this.optionalSignature != null) {
            v.add(new DERTaggedObject(true, 0, this.optionalSignature));
        }
        return new DERSequence(v);
    }
}

