/*
 * Decompiled with CFR 0.152.
 */
package xjyb.org.bjca.asn1.x509;

import xjyb.org.bjca.asn1.ASN1Encodable;
import xjyb.org.bjca.asn1.ASN1EncodableVector;
import xjyb.org.bjca.asn1.DERBitString;
import xjyb.org.bjca.asn1.DERGeneralizedTime;
import xjyb.org.bjca.asn1.DERInteger;
import xjyb.org.bjca.asn1.DERObjectIdentifier;
import xjyb.org.bjca.asn1.DERSequence;
import xjyb.org.bjca.asn1.DERSet;
import xjyb.org.bjca.asn1.x509.AlgorithmIdentifier;
import xjyb.org.bjca.asn1.x509.AttCertIssuer;
import xjyb.org.bjca.asn1.x509.AttCertValidityPeriod;
import xjyb.org.bjca.asn1.x509.Attribute;
import xjyb.org.bjca.asn1.x509.AttributeCertificateInfo;
import xjyb.org.bjca.asn1.x509.Holder;
import xjyb.org.bjca.asn1.x509.X509Extensions;

public class V2AttributeCertificateInfoGenerator {
    private DERInteger version = new DERInteger(1);
    private Holder holder;
    private AttCertIssuer issuer;
    private AlgorithmIdentifier signature;
    private DERInteger serialNumber;
    private ASN1EncodableVector attributes = new ASN1EncodableVector();
    private DERBitString issuerUniqueID;
    private X509Extensions extensions;
    private DERGeneralizedTime startDate;
    private DERGeneralizedTime endDate;

    public void setHolder(Holder holder) {
        this.holder = holder;
    }

    public void addAttribute(String oid, ASN1Encodable value) {
        this.attributes.add(new Attribute(new DERObjectIdentifier(oid), new DERSet(value)));
    }

    public void addAttribute(Attribute attribute) {
        this.attributes.add(attribute);
    }

    public void setSerialNumber(DERInteger serialNumber) {
        this.serialNumber = serialNumber;
    }

    public void setSignature(AlgorithmIdentifier signature) {
        this.signature = signature;
    }

    public void setIssuer(AttCertIssuer issuer) {
        this.issuer = issuer;
    }

    public void setStartDate(DERGeneralizedTime startDate) {
        this.startDate = startDate;
    }

    public void setEndDate(DERGeneralizedTime endDate) {
        this.endDate = endDate;
    }

    public void setIssuerUniqueID(DERBitString issuerUniqueID) {
        this.issuerUniqueID = issuerUniqueID;
    }

    public void setExtensions(X509Extensions extensions) {
        this.extensions = extensions;
    }

    public AttributeCertificateInfo generateAttributeCertificateInfo() {
        if (this.serialNumber == null || this.signature == null || this.issuer == null || this.startDate == null || this.endDate == null || this.holder == null || this.attributes == null) {
            throw new IllegalStateException("not all mandatory fields set in V2 AttributeCertificateInfo generator");
        }
        ASN1EncodableVector v = new ASN1EncodableVector();
        v.add(this.version);
        v.add(this.holder);
        v.add(this.issuer);
        v.add(this.signature);
        v.add(this.serialNumber);
        AttCertValidityPeriod validity = new AttCertValidityPeriod(this.startDate, this.endDate);
        v.add(validity);
        v.add(new DERSequence(this.attributes));
        if (this.issuerUniqueID != null) {
            v.add(this.issuerUniqueID);
        }
        if (this.extensions != null) {
            v.add(this.extensions);
        }
        return new AttributeCertificateInfo(new DERSequence(v));
    }
}

