/*
 * Decompiled with CFR 0.152.
 */
package xjyb.org.bjca.asn1.x509.qualified;

import xjyb.org.bjca.asn1.ASN1Choice;
import xjyb.org.bjca.asn1.ASN1Encodable;
import xjyb.org.bjca.asn1.DEREncodable;
import xjyb.org.bjca.asn1.DERInteger;
import xjyb.org.bjca.asn1.DERObject;
import xjyb.org.bjca.asn1.DERObjectIdentifier;

public class TypeOfBiometricData
extends ASN1Encodable
implements ASN1Choice {
    public static final int PICTURE = 0;
    public static final int HANDWRITTEN_SIGNATURE = 1;
    DEREncodable obj;

    public static TypeOfBiometricData getInstance(Object obj) {
        if (obj == null || obj instanceof TypeOfBiometricData) {
            return (TypeOfBiometricData)obj;
        }
        if (obj instanceof DERInteger) {
            DERInteger predefinedBiometricTypeObj = DERInteger.getInstance(obj);
            int predefinedBiometricType = predefinedBiometricTypeObj.getValue().intValue();
            return new TypeOfBiometricData(predefinedBiometricType);
        }
        if (obj instanceof DERObjectIdentifier) {
            DERObjectIdentifier BiometricDataID = DERObjectIdentifier.getInstance(obj);
            return new TypeOfBiometricData(BiometricDataID);
        }
        throw new IllegalArgumentException("unknown object in getInstance");
    }

    public TypeOfBiometricData(int predefinedBiometricType) {
        if (predefinedBiometricType != 0 && predefinedBiometricType != 1) {
            throw new IllegalArgumentException("unknow PredefinedBiometricType : " + predefinedBiometricType);
        }
        this.obj = new DERInteger(predefinedBiometricType);
    }

    public TypeOfBiometricData(DERObjectIdentifier BiometricDataID) {
        this.obj = BiometricDataID;
    }

    public boolean isPredefined() {
        return this.obj instanceof DERInteger;
    }

    public int getPredefinedBiometricType() {
        return ((DERInteger)this.obj).getValue().intValue();
    }

    public DERObjectIdentifier getBiometricDataOid() {
        return (DERObjectIdentifier)this.obj;
    }

    @Override
    public DERObject toASN1Object() {
        return this.obj.getDERObject();
    }
}

