/*
 * Decompiled with CFR 0.152.
 */
package xjyb.org.bjca.crypto.generators;

import java.math.BigInteger;
import java.security.SecureRandom;

class DHKeyGeneratorHelper {
    private static final int MAX_ITERATIONS = 1000;
    static final DHKeyGeneratorHelper INSTANCE = new DHKeyGeneratorHelper();
    private static final BigInteger ZERO = BigInteger.valueOf(0L);
    private static final BigInteger TWO = BigInteger.valueOf(2L);

    private DHKeyGeneratorHelper() {
    }

    BigInteger calculatePrivate(BigInteger p, SecureRandom random, int limit) {
        BigInteger x;
        BigInteger pSub2 = p.subtract(TWO);
        if (limit == 0) {
            x = this.createInRange(pSub2, random);
        } else {
            while ((x = new BigInteger(limit, 0, random)).equals(ZERO)) {
            }
        }
        return x;
    }

    private BigInteger createInRange(BigInteger max, SecureRandom random) {
        BigInteger x;
        int maxLength = max.bitLength();
        int count = 0;
        while (((x = new BigInteger(maxLength, random)).equals(ZERO) || x.compareTo(max) > 0) && ++count != 1000) {
        }
        if (count == 1000) {
            return new BigInteger(maxLength - 1, random).setBit(0);
        }
        return x;
    }

    BigInteger calculatePublic(BigInteger p, BigInteger g, BigInteger x) {
        return g.modPow(x, p);
    }
}

