/*
 * Decompiled with CFR 0.152.
 */
package xjyb.org.bjca.crypto.generators;

import java.math.BigInteger;
import xjyb.org.bjca.crypto.AsymmetricCipherKeyPair;
import xjyb.org.bjca.crypto.AsymmetricCipherKeyPairGenerator;
import xjyb.org.bjca.crypto.KeyGenerationParameters;
import xjyb.org.bjca.crypto.params.RSAKeyGenerationParameters;
import xjyb.org.bjca.crypto.params.RSAKeyParameters;
import xjyb.org.bjca.crypto.params.RSAPrivateCrtKeyParameters;

public class RSAKeyPairGenerator
implements AsymmetricCipherKeyPairGenerator {
    private static final BigInteger ONE = BigInteger.valueOf(1L);
    private RSAKeyGenerationParameters param;

    @Override
    public void init(KeyGenerationParameters param) {
        this.param = (RSAKeyGenerationParameters)param;
    }

    @Override
    public AsymmetricCipherKeyPair generateKeyPair() {
        BigInteger phi;
        BigInteger n;
        BigInteger q;
        BigInteger p;
        int strength = this.param.getStrength();
        int pbitlength = (strength + 1) / 2;
        int qbitlength = strength - pbitlength;
        int mindiffbits = strength / 3;
        BigInteger e = this.param.getPublicExponent();
        while ((p = new BigInteger(pbitlength, 1, this.param.getRandom())).mod(e).equals(ONE) || !p.isProbablePrime(this.param.getCertainty()) || !e.gcd(p.subtract(ONE)).equals(ONE)) {
        }
        while (true) {
            if ((q = new BigInteger(qbitlength, 1, this.param.getRandom())).subtract(p).abs().bitLength() < mindiffbits || q.mod(e).equals(ONE) || !q.isProbablePrime(this.param.getCertainty()) || !e.gcd(q.subtract(ONE)).equals(ONE)) {
                continue;
            }
            n = p.multiply(q);
            if (n.bitLength() == this.param.getStrength()) break;
            p = p.max(q);
        }
        if (p.compareTo(q) < 0) {
            phi = p;
            p = q;
            q = phi;
        }
        BigInteger pSub1 = p.subtract(ONE);
        BigInteger qSub1 = q.subtract(ONE);
        phi = pSub1.multiply(qSub1);
        BigInteger d = e.modInverse(phi);
        BigInteger dP = d.remainder(pSub1);
        BigInteger dQ = d.remainder(qSub1);
        BigInteger qInv = q.modInverse(p);
        return new AsymmetricCipherKeyPair(new RSAKeyParameters(false, n, e), new RSAPrivateCrtKeyParameters(n, e, d, p, q, dP, dQ, qInv));
    }
}

