/*
 * Decompiled with CFR 0.152.
 */
package xjyb.org.bjca.crypto.modes;

import java.math.BigInteger;
import xjyb.org.bjca.crypto.BlockCipher;
import xjyb.org.bjca.crypto.CipherParameters;
import xjyb.org.bjca.crypto.DataLengthException;
import xjyb.org.bjca.crypto.InvalidCipherTextException;
import xjyb.org.bjca.crypto.modes.AEADBlockCipher;
import xjyb.org.bjca.crypto.params.AEADParameters;
import xjyb.org.bjca.crypto.params.KeyParameter;
import xjyb.org.bjca.crypto.params.ParametersWithIV;
import xjyb.org.bjca.util.Arrays;
import xjyb.org.bjca.util.BigIntegers;

public class GCMBlockCipher
implements AEADBlockCipher {
    private static final int BLOCK_SIZE = 16;
    private static final byte[] ZEROES = new byte[16];
    private static final BigInteger R = new BigInteger("11100001", 2).shiftLeft(120);
    private static final BigInteger ZERO = BigInteger.valueOf(0L);
    private final BlockCipher cipher;
    private boolean forEncryption;
    private int macSize;
    private byte[] nonce;
    private byte[] A;
    private KeyParameter keyParam;
    private BigInteger H;
    private BigInteger initS;
    private byte[] J0;
    private byte[] bufBlock;
    private byte[] macBlock;
    private BigInteger S;
    private byte[] counter;
    private int bufOff;
    private long totalLength;

    public GCMBlockCipher(BlockCipher c) {
        if (c.getBlockSize() != 16) {
            throw new IllegalArgumentException("cipher required with a block size of 16.");
        }
        this.cipher = c;
    }

    @Override
    public BlockCipher getUnderlyingCipher() {
        return this.cipher;
    }

    @Override
    public String getAlgorithmName() {
        return this.cipher.getAlgorithmName() + "/GCM";
    }

    @Override
    public void init(boolean forEncryption, CipherParameters params) throws IllegalArgumentException {
        CipherParameters param;
        this.forEncryption = forEncryption;
        this.macSize = 16;
        this.macBlock = null;
        int bufLength = forEncryption ? 16 : 16 + this.macSize;
        this.bufBlock = new byte[bufLength];
        if (params instanceof AEADParameters) {
            param = (AEADParameters)params;
            this.nonce = ((AEADParameters)param).getNonce();
            this.A = ((AEADParameters)param).getAssociatedText();
            if (((AEADParameters)param).getMacSize() != 128) {
                throw new IllegalArgumentException("only 128-bit MAC supported currently");
            }
            this.keyParam = ((AEADParameters)param).getKey();
        } else if (params instanceof ParametersWithIV) {
            param = (ParametersWithIV)params;
            this.nonce = ((ParametersWithIV)param).getIV();
            this.A = null;
            this.keyParam = (KeyParameter)((ParametersWithIV)param).getParameters();
        } else {
            throw new IllegalArgumentException("invalid parameters passed to GCM");
        }
        if (this.nonce == null || this.nonce.length < 1) {
            throw new IllegalArgumentException("IV must be at least 1 byte");
        }
        if (this.A == null) {
            this.A = new byte[0];
        }
        this.cipher.init(true, this.keyParam);
        byte[] h = new byte[16];
        this.cipher.processBlock(ZEROES, 0, h, 0);
        this.H = new BigInteger(1, h);
        this.initS = this.gHASH(this.A, false);
        if (this.nonce.length == 12) {
            this.J0 = new byte[16];
            System.arraycopy(this.nonce, 0, this.J0, 0, this.nonce.length);
            this.J0[15] = 1;
        } else {
            BigInteger N = this.gHASH(this.nonce, true);
            BigInteger X = BigInteger.valueOf(this.nonce.length * 8);
            N = this.multiply(N.xor(X), this.H);
            this.J0 = this.asBlock(N);
        }
        this.S = this.initS;
        this.counter = Arrays.clone(this.J0);
        this.bufOff = 0;
        this.totalLength = 0L;
    }

    @Override
    public byte[] getMac() {
        return Arrays.clone(this.macBlock);
    }

    @Override
    public int getOutputSize(int len) {
        if (this.forEncryption) {
            return len + this.bufOff + this.macSize;
        }
        return len + this.bufOff - this.macSize;
    }

    @Override
    public int getUpdateOutputSize(int len) {
        return (len + this.bufOff) / 16 * 16;
    }

    @Override
    public int processByte(byte in, byte[] out, int outOff) throws DataLengthException {
        return this.process(in, out, outOff);
    }

    @Override
    public int processBytes(byte[] in, int inOff, int len, byte[] out, int outOff) throws DataLengthException {
        int resultLen = 0;
        for (int i = 0; i != len; ++i) {
            resultLen += this.process(in[inOff + i], out, outOff + resultLen);
        }
        return resultLen;
    }

    private int process(byte in, byte[] out, int outOff) throws DataLengthException {
        this.bufBlock[this.bufOff++] = in;
        if (this.bufOff == this.bufBlock.length) {
            this.gCTRBlock(this.bufBlock, 16, out, outOff);
            if (!this.forEncryption) {
                System.arraycopy(this.bufBlock, 16, this.bufBlock, 0, 16);
            }
            this.bufOff = this.bufBlock.length - 16;
            return 16;
        }
        return 0;
    }

    @Override
    public int doFinal(byte[] out, int outOff) throws IllegalStateException, InvalidCipherTextException {
        int extra = this.bufOff;
        if (!this.forEncryption) {
            if (extra < this.macSize) {
                throw new InvalidCipherTextException("data too short");
            }
            extra -= this.macSize;
        }
        if (extra > 0) {
            byte[] tmp = new byte[16];
            System.arraycopy(this.bufBlock, 0, tmp, 0, extra);
            this.gCTRBlock(tmp, extra, out, outOff);
        }
        BigInteger X = BigInteger.valueOf(this.A.length * 8).shiftLeft(64).add(BigInteger.valueOf(this.totalLength * 8L));
        this.S = this.multiply(this.S.xor(X), this.H);
        byte[] tBytes = new byte[16];
        this.cipher.processBlock(this.J0, 0, tBytes, 0);
        BigInteger T = this.S.xor(new BigInteger(1, tBytes));
        byte[] tag = this.asBlock(T);
        int resultLen = extra;
        if (this.forEncryption) {
            this.macBlock = tag;
            System.arraycopy(tag, 0, out, outOff + this.bufOff, tag.length);
            resultLen += tag.length;
        } else {
            this.macBlock = new byte[this.macSize];
            System.arraycopy(this.bufBlock, extra, this.macBlock, 0, this.macSize);
            if (!Arrays.areEqual(tag, this.macBlock)) {
                throw new InvalidCipherTextException("mac check in GCM failed");
            }
        }
        this.reset(false);
        return resultLen;
    }

    @Override
    public void reset() {
        this.reset(true);
    }

    private void reset(boolean clearMac) {
        this.S = this.initS;
        this.counter = Arrays.clone(this.J0);
        this.bufOff = 0;
        this.totalLength = 0L;
        if (this.bufBlock != null) {
            Arrays.fill(this.bufBlock, (byte)0);
        }
        if (clearMac) {
            this.macBlock = null;
        }
        this.cipher.reset();
    }

    private void gCTRBlock(byte[] buf, int bufCount, byte[] out, int outOff) {
        GCMBlockCipher.inc(this.counter);
        byte[] tmp = new byte[16];
        this.cipher.processBlock(this.counter, 0, tmp, 0);
        if (this.forEncryption) {
            System.arraycopy(ZEROES, bufCount, tmp, bufCount, 16 - bufCount);
            for (int i = bufCount - 1; i >= 0; --i) {
                int n = i;
                tmp[n] = (byte)(tmp[n] ^ buf[i]);
                out[outOff + i] = tmp[i];
            }
            this.gHASHBlock(tmp);
        } else {
            for (int i = bufCount - 1; i >= 0; --i) {
                int n = i;
                tmp[n] = (byte)(tmp[n] ^ buf[i]);
                out[outOff + i] = tmp[i];
            }
            this.gHASHBlock(buf);
        }
        this.totalLength += (long)bufCount;
    }

    private BigInteger gHASH(byte[] b, boolean nonce) {
        BigInteger Y = ZERO;
        for (int pos = 0; pos < b.length; pos += 16) {
            byte[] x = new byte[16];
            int num = Math.min(b.length - pos, 16);
            System.arraycopy(b, pos, x, 0, num);
            BigInteger X = new BigInteger(1, x);
            Y = this.multiply(Y.xor(X), this.H);
        }
        return Y;
    }

    private void gHASHBlock(byte[] block) {
        if (block.length > 16) {
            byte[] tmp = new byte[16];
            System.arraycopy(block, 0, tmp, 0, 16);
            block = tmp;
        }
        BigInteger X = new BigInteger(1, block);
        this.S = this.multiply(this.S.xor(X), this.H);
    }

    private static void inc(byte[] block) {
        for (int i = 15; i >= 12; --i) {
            byte b;
            block[i] = b = (byte)(block[i] + 1 & 0xFF);
            if (b != 0) break;
        }
    }

    private BigInteger multiply(BigInteger X, BigInteger Y) {
        BigInteger Z = ZERO;
        BigInteger V = X;
        for (int i = 0; i < 128; ++i) {
            if (Y.testBit(127 - i)) {
                Z = Z.xor(V);
            }
            boolean lsb = V.testBit(0);
            V = V.shiftRight(1);
            if (!lsb) continue;
            V = V.xor(R);
        }
        return Z;
    }

    private byte[] asBlock(BigInteger bi) {
        byte[] b = BigIntegers.asUnsignedByteArray(bi);
        if (b.length < 16) {
            byte[] tmp = new byte[16];
            System.arraycopy(b, 0, tmp, tmp.length - b.length, b.length);
            b = tmp;
        }
        return b;
    }
}

