/*
 * Decompiled with CFR 0.152.
 */
package xjyb.org.bjca.crypto.tls;

import java.io.IOException;
import java.io.OutputStream;
import xjyb.org.bjca.crypto.digests.SHA1Digest;
import xjyb.org.bjca.crypto.engines.AESFastEngine;
import xjyb.org.bjca.crypto.engines.DESedeEngine;
import xjyb.org.bjca.crypto.modes.CBCBlockCipher;
import xjyb.org.bjca.crypto.tls.TlsBlockCipherCipherSuite;
import xjyb.org.bjca.crypto.tls.TlsCipherSuite;
import xjyb.org.bjca.crypto.tls.TlsProtocolHandler;
import xjyb.org.bjca.crypto.tls.TlsUtils;

public class TlsCipherSuiteManager {
    private static final int TLS_RSA_WITH_3DES_EDE_CBC_SHA = 10;
    private static final int TLS_DHE_RSA_WITH_3DES_EDE_CBC_SHA = 22;
    private static final int TLS_RSA_WITH_AES_128_CBC_SHA = 47;
    private static final int TLS_DHE_RSA_WITH_AES_128_CBC_SHA = 51;
    private static final int TLS_RSA_WITH_AES_256_CBC_SHA = 53;
    private static final int TLS_DHE_RSA_WITH_AES_256_CBC_SHA = 57;

    protected static void writeCipherSuites(OutputStream os) throws IOException {
        TlsUtils.writeUint16(12, os);
        TlsUtils.writeUint16(57, os);
        TlsUtils.writeUint16(51, os);
        TlsUtils.writeUint16(22, os);
        TlsUtils.writeUint16(53, os);
        TlsUtils.writeUint16(47, os);
        TlsUtils.writeUint16(10, os);
    }

    protected static TlsCipherSuite getCipherSuite(int number, TlsProtocolHandler handler) throws IOException {
        switch (number) {
            case 10: {
                return new TlsBlockCipherCipherSuite(new CBCBlockCipher(new DESedeEngine()), new CBCBlockCipher(new DESedeEngine()), new SHA1Digest(), new SHA1Digest(), 24, 1);
            }
            case 22: {
                return new TlsBlockCipherCipherSuite(new CBCBlockCipher(new DESedeEngine()), new CBCBlockCipher(new DESedeEngine()), new SHA1Digest(), new SHA1Digest(), 24, 5);
            }
            case 47: {
                return new TlsBlockCipherCipherSuite(new CBCBlockCipher(new AESFastEngine()), new CBCBlockCipher(new AESFastEngine()), new SHA1Digest(), new SHA1Digest(), 16, 1);
            }
            case 51: {
                return new TlsBlockCipherCipherSuite(new CBCBlockCipher(new AESFastEngine()), new CBCBlockCipher(new AESFastEngine()), new SHA1Digest(), new SHA1Digest(), 16, 5);
            }
            case 53: {
                return new TlsBlockCipherCipherSuite(new CBCBlockCipher(new AESFastEngine()), new CBCBlockCipher(new AESFastEngine()), new SHA1Digest(), new SHA1Digest(), 32, 1);
            }
            case 57: {
                return new TlsBlockCipherCipherSuite(new CBCBlockCipher(new AESFastEngine()), new CBCBlockCipher(new AESFastEngine()), new SHA1Digest(), new SHA1Digest(), 32, 5);
            }
        }
        handler.failWithError((short)2, (short)40);
        return null;
    }
}

