/*
 * Decompiled with CFR 0.152.
 */
package xjyb.org.bjca.jce.fastparser;

import java.util.ArrayList;
import xjyb.org.bjca.jce.fastparser.DerUtil;
import xjyb.org.bjca.jce.fastparser.Item;

public class EncryptedContentInfo {
    private Item contentType = new Item();
    private Item contentEncryptionAlgorithm = new Item();
    private Item iv = new Item();
    private Item encryptedContent = new Item();
    private int ct;

    public void parse(byte[] input, int offset, int length) {
        if (length < 2) {
            return;
        }
        int position = 0;
        Item tmpitem = new Item();
        DerUtil.computeOffset(input, tmpitem, offset, position);
        position = tmpitem.offset + tmpitem.length;
        tmpitem.offset += offset;
        this.contentType = new Item(tmpitem);
        this.ct = DerUtil.getContentType(input, this.contentType.offset);
        DerUtil.computeOffset(input, tmpitem, offset, position);
        position = tmpitem.offset + tmpitem.length;
        tmpitem.offset += offset;
        this.contentEncryptionAlgorithm = new Item(tmpitem);
        if (tmpitem.length > 0) {
            ArrayList aiv = new ArrayList(1);
            DerUtil.parseSequence(input, tmpitem, aiv);
            if (aiv.size() > 1) {
                this.iv = new Item((Item)aiv.get(1));
            }
        }
        if (position < length - 2) {
            DerUtil.computeOffset(input, tmpitem, offset, position);
            position = tmpitem.offset + tmpitem.length;
            tmpitem.offset += offset;
            this.encryptedContent = new Item(tmpitem);
        }
        if (DerUtil.debug) {
            System.out.println("@EncryptedContentInfo\nContentEncryptionAlgorithm:" + DerUtil.toDERObjectIdentifier(input, this.contentEncryptionAlgorithm.offset, this.contentEncryptionAlgorithm.length));
            DerUtil.printItem(input, this.contentEncryptionAlgorithm);
            System.out.println("EncryptedContent:");
            DerUtil.printItem(input, this.encryptedContent);
        }
    }

    public final Item getContentType() {
        return this.contentType;
    }

    public final Item getContentEncryptionAlgorithm() {
        return this.contentEncryptionAlgorithm;
    }

    public final Item getEncryptedContent() {
        return this.encryptedContent;
    }

    public final int getCt() {
        return this.ct;
    }

    public final Item getIvParameter() {
        return this.iv;
    }
}

