/*
 * Decompiled with CFR 0.152.
 */
package xjyb.org.bjca.jce.fastparser;

import xjyb.org.bjca.jce.fastparser.DerUtil;
import xjyb.org.bjca.jce.fastparser.Item;

public class TimeStampRawData {
    public static final byte[] OID_TimeStamping = new byte[]{43, 6, 1, 5, 5, 3, 7, 8};
    private Item version = new Item();
    private byte[] versionByte = null;
    private Item contentType = new Item();
    private byte[] contentTypeByte = null;
    private Item digestAlgorithms = new Item();
    private byte[] digestAlgorithmsByte = null;
    private Item originalHashData = new Item();
    private byte[] originalHashDataByte = null;
    private Item serialNumber = new Item();
    private byte[] serialNumberByte = null;
    private Item generalizedTime = new Item();
    private byte[] generalizedTimeByte = null;
    private Item accuracy = new Item();
    private byte[] accuracyByte = null;
    private Item rawData = new Item();
    private byte[] rawDataByte = null;

    public TimeStampRawData(byte[] input, Item it) {
        this.parse(input, it.offset, it.length);
    }

    private void parse(byte[] input, int offset, int length) {
        if (length < 2) {
            return;
        }
        DerUtil.computeOffset(input, this.rawData, 0, offset);
        Item tmpItem = new Item();
        DerUtil.computeOffset(input, tmpItem, 0, this.rawData.offset);
        DerUtil.computeOffset(input, this.version, 0, tmpItem.offset);
        DerUtil.computeOffset(input, this.contentType, 0, this.version.offset + this.version.length);
        DerUtil.computeOffset(input, tmpItem, 0, this.contentType.offset + this.contentType.length);
        Item content = new Item(tmpItem);
        DerUtil.computeOffset(input, this.digestAlgorithms, 0, content.offset);
        DerUtil.computeOffset(input, this.originalHashData, 0, this.digestAlgorithms.offset + this.digestAlgorithms.length);
        DerUtil.computeOffset(input, this.serialNumber, 0, content.offset + content.length);
        DerUtil.computeOffset(input, this.generalizedTime, 0, this.serialNumber.offset + this.serialNumber.length);
        DerUtil.computeOffset(input, this.accuracy, 0, this.generalizedTime.offset + this.generalizedTime.length);
        if (this.rawData.length > 0) {
            this.rawDataByte = new byte[this.rawData.length];
            System.arraycopy(input, this.rawData.offset, this.rawDataByte, 0, this.rawData.length);
        } else {
            this.rawData = new Item();
        }
        if (this.originalHashData.length > 0) {
            this.originalHashDataByte = new byte[this.originalHashData.length];
            System.arraycopy(input, this.originalHashData.offset, this.originalHashDataByte, 0, this.originalHashData.length);
        } else {
            this.originalHashData = new Item();
        }
        if (this.serialNumber.length > 0) {
            this.serialNumberByte = new byte[this.serialNumber.length];
            System.arraycopy(input, this.serialNumber.offset, this.serialNumberByte, 0, this.serialNumber.length);
        } else {
            this.serialNumber = new Item();
        }
        if (this.generalizedTime.length > 0) {
            this.generalizedTimeByte = new byte[this.generalizedTime.length];
            System.arraycopy(input, this.generalizedTime.offset, this.generalizedTimeByte, 0, this.generalizedTime.length);
        } else {
            this.generalizedTime = new Item();
        }
        if (this.accuracy.length > 0) {
            this.accuracyByte = new byte[this.accuracy.length];
            System.arraycopy(input, this.accuracy.offset, this.accuracyByte, 0, this.accuracy.length);
        } else {
            this.accuracy = new Item();
        }
    }

    public byte[] getRawDataByte() {
        if (this.rawDataByte != null) {
            return this.rawDataByte;
        }
        return new byte[0];
    }

    public Item getOriginalHashData() {
        return this.originalHashData;
    }

    public void setOriginalHashData(Item originalHashData) {
        this.originalHashData = originalHashData;
    }

    public byte[] getOriginalHashDataByte() {
        return this.originalHashDataByte;
    }

    public void setOriginalHashDataByte(byte[] originalHashDataByte) {
        this.originalHashDataByte = originalHashDataByte;
    }

    public Item getSerialNumber() {
        return this.serialNumber;
    }

    public void setSerialNumber(Item serialNumber) {
        this.serialNumber = serialNumber;
    }

    public byte[] getSerialNumberByte() {
        return this.serialNumberByte;
    }

    public void setSerialNumberByte(byte[] serialNumberByte) {
        this.serialNumberByte = serialNumberByte;
    }

    public Item getGeneralizedTime() {
        return this.generalizedTime;
    }

    public void setGeneralizedTime(Item generalizedTime) {
        this.generalizedTime = generalizedTime;
    }

    public byte[] getGeneralizedTimeByte() {
        return this.generalizedTimeByte;
    }

    public void setGeneralizedTimeByte(byte[] generalizedTimeByte) {
        this.generalizedTimeByte = generalizedTimeByte;
    }

    public Item getAccuracy() {
        return this.accuracy;
    }

    public void setAccuracy(Item accuracy) {
        this.accuracy = accuracy;
    }

    public byte[] getAccuracyByte() {
        return this.accuracyByte;
    }

    public void setAccuracyByte(byte[] accuracyByte) {
        this.accuracyByte = accuracyByte;
    }

    public Item getRawData() {
        return this.rawData;
    }

    public void getRawData(byte[] input, Item rdItem, byte[] dst) {
        if (rdItem.length > 0 && rdItem.offset + rdItem.length <= input.length) {
            dst = new byte[rdItem.length];
            System.arraycopy(input, rdItem.offset, dst, 0, rdItem.length);
        }
    }
}

