/*
 * Decompiled with CFR 0.152.
 */
package xjyb.org.bjca.jce.fastparser.timestamp;

import java.util.ArrayList;
import xjyb.org.bjca.jce.fastparser.DerUtil;
import xjyb.org.bjca.jce.fastparser.EnvelopedData;
import xjyb.org.bjca.jce.fastparser.FX509Certificate;
import xjyb.org.bjca.jce.fastparser.IssuerAndSerialNumber;
import xjyb.org.bjca.jce.fastparser.Item;
import xjyb.org.bjca.jce.fastparser.SignerInfo;
import xjyb.org.bjca.jce.fastparser.TimeStampRawData;
import xjyb.org.bjca.jce.fastparser.timestamp.TimeStampSignedData;
import xjyb.org.bjca.util.encoders.Base64;

public class FastTimeStamp {
    private byte[] p7b;
    private int contentType = 0;
    private int version = 0;
    private int signVersion = 0;
    private Item contents;
    private ArrayList certs = new ArrayList();
    private ArrayList crls = new ArrayList();
    private ArrayList daset = new ArrayList();
    private ArrayList signerInfos = new ArrayList();
    private Item signCert = new Item();
    private String digestAlgorithm = null;
    private String digestEncryptionAlgorithm = null;
    private Item digest = new Item();
    private Item data = new Item();
    private Item rawData = new Item();
    private IssuerAndSerialNumber issuerAndSerialNum = null;
    private Item authenticatedAttributes = new Item();
    private EnvelopedData ed = null;
    private byte[] encryptedContentInfo = null;
    private byte[] encryptedContentInfoAlgId = null;
    private String encryptedContentInfoAlgIdStr = null;
    private byte[] encryptedContentInfoIvParam = null;
    private ArrayList recipientInfos = new ArrayList();
    private byte[] originalHashByte = null;
    private byte[] timeByte = null;
    private Item accuracy = null;

    public boolean pkcs7Data(byte[] input) {
        ArrayList tmpsi;
        Item tmpitem = new Item();
        int position = 0;
        DerUtil.computeOffset(input, tmpitem, 0, position);
        position = tmpitem.offset;
        DerUtil.computeOffset(input, tmpitem, 0, position);
        position = tmpitem.offset + tmpitem.length;
        DerUtil.computeOffset(input, tmpitem, 0, position);
        this.contents = new Item(tmpitem);
        TimeStampSignedData sd = new TimeStampSignedData(input, this.contents);
        this.version = sd.getVersion();
        if (sd.getContentInfo().isTimeStampContent()) {
            Item cii = new Item(sd.getContentInfo().getContent());
            TimeStampRawData rd = new TimeStampRawData(input, cii);
            this.originalHashByte = rd.getOriginalHashDataByte();
            this.timeByte = rd.getGeneralizedTimeByte();
            this.accuracy = new Item(rd.getAccuracy());
            this.rawData = new Item(rd.getRawData());
        }
        this.certs.addAll(sd.getCertificates());
        this.crls.addAll(sd.getCrls());
        if (this.daset.addAll(sd.getDigestAlgorithms())) {
            if (DerUtil.debug) {
                for (int i = 0; i < this.daset.size(); ++i) {
                    DerUtil.printItemAndTag(input, (Item)this.daset.get(i));
                    System.out.println("Digest Algorithms: " + DerUtil.toDERObjectIdentifier(input, ((Item)this.daset.get((int)i)).offset, ((Item)this.daset.get((int)i)).length));
                }
            }
            this.digestAlgorithm = DerUtil.toDERObjectIdentifier(input, ((Item)this.daset.get((int)0)).offset, ((Item)this.daset.get((int)0)).length);
        }
        if ((tmpsi = new ArrayList()).addAll(sd.getSignerInfos())) {
            for (int i = 0; i < tmpsi.size(); ++i) {
                Item it = (Item)tmpsi.get(i);
                SignerInfo si = new SignerInfo(input, it.offset - it.tagsize, it.length + it.tagsize);
                this.authenticatedAttributes = si.getAuthenticatedAttributes();
                this.signerInfos.add(si);
                this.issuerAndSerialNum = new IssuerAndSerialNumber(input, si.getIssuerAndSerialNumber());
                if (DerUtil.debug) {
                    this.printSignerInfo(input, si);
                }
                IssuerAndSerialNumber iasn = new IssuerAndSerialNumber(input, si.getIssuerAndSerialNumber());
                Item issuerItem = new Item(iasn.getIssuer());
                if (DerUtil.debug) {
                    System.out.println("IssuerItem:");
                    DerUtil.printItem(input, issuerItem);
                }
                if (this.certs.size() > 0) {
                    for (int index = 0; index < this.certs.size(); ++index) {
                        Item itCert = new Item();
                        itCert.tagsize = ((Item)this.certs.get((int)index)).tagsize;
                        itCert.length = ((Item)this.certs.get((int)index)).length + itCert.tagsize;
                        itCert.offset = ((Item)this.certs.get((int)index)).offset - itCert.tagsize;
                        FX509Certificate fx = new FX509Certificate(input, itCert);
                        if (!DerUtil.isEqual(input, issuerItem.offset - issuerItem.tagsize, input, fx.getIssuer().offset, issuerItem.length) || !DerUtil.isEqual(input, fx.getSerialNumber().offset, iasn.getSerialNumber().getSn(), 0, fx.getSerialNumber().length)) continue;
                        this.signCert = new Item((Item)this.certs.get(index));
                        this.digestAlgorithm = DerUtil.toDERObjectIdentifier(input, si.getDigestAlgorithm().offset, si.getDigestAlgorithm().length);
                        this.digestEncryptionAlgorithm = DerUtil.toDERObjectIdentifier(input, si.getDigestEncryptionAlgorithm().offset, si.getDigestEncryptionAlgorithm().length);
                        this.digest = new Item(si.getEncryptedDigest());
                        this.signVersion = si.getSignerInfoVersion();
                    }
                    continue;
                }
                this.digestAlgorithm = DerUtil.toDERObjectIdentifier(input, si.getDigestAlgorithm().offset, si.getDigestAlgorithm().length);
                this.digestEncryptionAlgorithm = DerUtil.toDERObjectIdentifier(input, si.getDigestEncryptionAlgorithm().offset, si.getDigestEncryptionAlgorithm().length);
                this.digest = new Item(si.getEncryptedDigest());
                this.signVersion = si.getSignerInfoVersion();
            }
            tmpsi.clear();
        }
        return true;
    }

    public final ArrayList getDigestAlgorithms() {
        return this.daset;
    }

    public final ArrayList getCerts() {
        return this.certs;
    }

    public final ArrayList getCrls() {
        return this.crls;
    }

    public final Item getSignCert() {
        return this.signCert;
    }

    public final String getDigestAlgorithm() {
        return this.digestAlgorithm;
    }

    public final String getDigestEncryptionAlgorithm() {
        return this.digestEncryptionAlgorithm;
    }

    public final Item getDigest() {
        return this.digest;
    }

    public final Item getRawData() {
        return this.rawData;
    }

    public Item getAccuracy() {
        return this.accuracy;
    }

    public byte[] getPkcs7(byte[] p7) {
        if (p7[0] == 48) {
            return p7;
        }
        try {
            return Base64.decode(p7);
        }
        catch (Exception e) {
            return new byte[0];
        }
    }

    public void printSignerInfo(byte[] input, SignerInfo si) {
        System.out.println("getAaSequence:");
        DerUtil.printItem(input, si.getAaSequence());
        System.out.println("getAuthenticatedAttributes:");
        DerUtil.printItem(input, si.getAuthenticatedAttributes());
        System.out.println("getDigestAlgorithm: " + DerUtil.toDERObjectIdentifier(input, si.getDigestAlgorithm().offset, si.getDigestAlgorithm().length));
        DerUtil.printItem(input, si.getDigestAlgorithm());
        System.out.println("getDigestEncryptionAlgorithm: " + DerUtil.toDERObjectIdentifier(input, si.getDigestEncryptionAlgorithm().offset, si.getDigestEncryptionAlgorithm().length));
        DerUtil.printItem(input, si.getDigestEncryptionAlgorithm());
        System.out.println("getIssuerAndSerialNumber:");
        DerUtil.printItem(input, si.getIssuerAndSerialNumber());
        IssuerAndSerialNumber iasn = new IssuerAndSerialNumber(input, si.getIssuerAndSerialNumber());
        System.out.println("SN=" + iasn.getSerialNumber().getSerialNumber());
        System.out.println("getUnauthenticatedAttributes:");
        DerUtil.printItem(input, si.getUnauthenticatedAttributes());
    }

    public final EnvelopedData getEnvelopedData() {
        return this.ed;
    }

    public final byte[] getEncryptedContentInfo() {
        return this.encryptedContentInfo;
    }

    public final String getEncryptedContentInfoAlgIdStr() {
        return this.encryptedContentInfoAlgIdStr;
    }

    public final byte[] getEncryptedContentInfoIvParam() {
        return this.encryptedContentInfoIvParam;
    }

    public final ArrayList getRecipientInfos() {
        return this.recipientInfos;
    }

    public final int getContentType() {
        return this.contentType;
    }

    public final int getVersion() {
        return this.version;
    }

    public final int getSignInfoVersion() {
        return this.signVersion;
    }

    public byte[] getOriginalHashByte() {
        return this.originalHashByte;
    }

    public void setOriginalHashByte(byte[] originalHashByte) {
        this.originalHashByte = originalHashByte;
    }

    public byte[] getTimeByte() {
        return this.timeByte;
    }

    public void setTimeByte(byte[] timeByte) {
        this.timeByte = timeByte;
    }

    public Item getAuthenticatedAttributes() {
        return this.authenticatedAttributes;
    }

    public IssuerAndSerialNumber getIssuerAndSerialNum() {
        return this.issuerAndSerialNum;
    }

    public void setIssuerAndSerialNum(IssuerAndSerialNumber issuerAndSerialNum) {
        this.issuerAndSerialNum = issuerAndSerialNum;
    }
}

