/*
 * Decompiled with CFR 0.152.
 */
package xjyb.org.bjca.jce.provider;

import java.security.AlgorithmParameterGeneratorSpi;
import java.security.AlgorithmParameters;
import java.security.InvalidAlgorithmParameterException;
import java.security.InvalidParameterException;
import java.security.SecureRandom;
import java.security.spec.AlgorithmParameterSpec;
import java.security.spec.DSAParameterSpec;
import javax.crypto.spec.DHGenParameterSpec;
import javax.crypto.spec.DHParameterSpec;
import javax.crypto.spec.IvParameterSpec;
import javax.crypto.spec.RC2ParameterSpec;
import xjyb.org.bjca.crypto.generators.DHParametersGenerator;
import xjyb.org.bjca.crypto.generators.DSAParametersGenerator;
import xjyb.org.bjca.crypto.generators.ElGamalParametersGenerator;
import xjyb.org.bjca.crypto.generators.GOST3410ParametersGenerator;
import xjyb.org.bjca.crypto.params.DHParameters;
import xjyb.org.bjca.crypto.params.DSAParameters;
import xjyb.org.bjca.crypto.params.ElGamalParameters;
import xjyb.org.bjca.crypto.params.GOST3410Parameters;
import xjyb.org.bjca.jce.spec.GOST3410ParameterSpec;
import xjyb.org.bjca.jce.spec.GOST3410PublicKeyParameterSetSpec;

public abstract class JDKAlgorithmParameterGenerator
extends AlgorithmParameterGeneratorSpi {
    protected SecureRandom random;
    protected int strength = 1024;

    @Override
    protected void engineInit(int strength, SecureRandom random) {
        this.strength = strength;
        this.random = random;
    }

    public static class RC2
    extends JDKAlgorithmParameterGenerator {
        RC2ParameterSpec spec = null;

        @Override
        protected void engineInit(AlgorithmParameterSpec genParamSpec, SecureRandom random) throws InvalidAlgorithmParameterException {
            if (genParamSpec instanceof RC2ParameterSpec) {
                this.spec = (RC2ParameterSpec)genParamSpec;
                return;
            }
            throw new InvalidAlgorithmParameterException("No supported AlgorithmParameterSpec for RC2 parameter generation.");
        }

        @Override
        protected AlgorithmParameters engineGenerateParameters() {
            AlgorithmParameters params;
            if (this.spec == null) {
                byte[] iv = new byte[8];
                if (this.random == null) {
                    this.random = new SecureRandom();
                }
                this.random.nextBytes(iv);
                try {
                    params = AlgorithmParameters.getInstance("RC2", "BC");
                    params.init(new IvParameterSpec(iv));
                }
                catch (Exception e) {
                    throw new RuntimeException(e.getMessage());
                }
            }
            try {
                params = AlgorithmParameters.getInstance("RC2", "BC");
                params.init(this.spec);
            }
            catch (Exception e) {
                throw new RuntimeException(e.getMessage());
            }
            return params;
        }
    }

    public static class DES
    extends JDKAlgorithmParameterGenerator {
        @Override
        protected void engineInit(AlgorithmParameterSpec genParamSpec, SecureRandom random) throws InvalidAlgorithmParameterException {
            throw new InvalidAlgorithmParameterException("No supported AlgorithmParameterSpec for DES parameter generation.");
        }

        @Override
        protected AlgorithmParameters engineGenerateParameters() {
            AlgorithmParameters params;
            byte[] iv = new byte[8];
            if (this.random == null) {
                this.random = new SecureRandom();
            }
            this.random.nextBytes(iv);
            try {
                params = AlgorithmParameters.getInstance("DES", "BC");
                params.init(new IvParameterSpec(iv));
            }
            catch (Exception e) {
                throw new RuntimeException(e.getMessage());
            }
            return params;
        }
    }

    public static class ElGamal
    extends JDKAlgorithmParameterGenerator {
        private int l = 0;

        @Override
        protected void engineInit(AlgorithmParameterSpec genParamSpec, SecureRandom random) throws InvalidAlgorithmParameterException {
            if (!(genParamSpec instanceof DHGenParameterSpec)) {
                throw new InvalidAlgorithmParameterException("DH parameter generator requires a DHGenParameterSpec for initialisation");
            }
            DHGenParameterSpec spec = (DHGenParameterSpec)genParamSpec;
            this.strength = spec.getPrimeSize();
            this.l = spec.getExponentSize();
            this.random = random;
        }

        @Override
        protected AlgorithmParameters engineGenerateParameters() {
            AlgorithmParameters params;
            ElGamalParametersGenerator pGen = new ElGamalParametersGenerator();
            if (this.random != null) {
                pGen.init(this.strength, 20, this.random);
            } else {
                pGen.init(this.strength, 20, new SecureRandom());
            }
            ElGamalParameters p = pGen.generateParameters();
            try {
                params = AlgorithmParameters.getInstance("ElGamal", "BC");
                params.init(new DHParameterSpec(p.getP(), p.getG(), this.l));
            }
            catch (Exception e) {
                throw new RuntimeException(e.getMessage());
            }
            return params;
        }
    }

    public static class GOST3410
    extends JDKAlgorithmParameterGenerator {
        @Override
        protected void engineInit(AlgorithmParameterSpec genParamSpec, SecureRandom random) throws InvalidAlgorithmParameterException {
            throw new InvalidAlgorithmParameterException("No supported AlgorithmParameterSpec for GOST3410 parameter generation.");
        }

        @Override
        protected AlgorithmParameters engineGenerateParameters() {
            AlgorithmParameters params;
            GOST3410ParametersGenerator pGen = new GOST3410ParametersGenerator();
            if (this.random != null) {
                pGen.init(this.strength, 2, this.random);
            } else {
                pGen.init(this.strength, 2, new SecureRandom());
            }
            GOST3410Parameters p = pGen.generateParameters();
            try {
                params = AlgorithmParameters.getInstance("GOST3410", "BC");
                params.init(new GOST3410ParameterSpec(new GOST3410PublicKeyParameterSetSpec(p.getP(), p.getQ(), p.getA())));
            }
            catch (Exception e) {
                throw new RuntimeException(e.getMessage());
            }
            return params;
        }
    }

    public static class DSA
    extends JDKAlgorithmParameterGenerator {
        @Override
        protected void engineInit(int strength, SecureRandom random) {
            if (strength < 512 || strength > 1024 || strength % 64 != 0) {
                throw new InvalidParameterException("strength must be from 512 - 1024 and a multiple of 64");
            }
            this.strength = strength;
            this.random = random;
        }

        @Override
        protected void engineInit(AlgorithmParameterSpec genParamSpec, SecureRandom random) throws InvalidAlgorithmParameterException {
            throw new InvalidAlgorithmParameterException("No supported AlgorithmParameterSpec for DSA parameter generation.");
        }

        @Override
        protected AlgorithmParameters engineGenerateParameters() {
            AlgorithmParameters params;
            DSAParametersGenerator pGen = new DSAParametersGenerator();
            if (this.random != null) {
                pGen.init(this.strength, 20, this.random);
            } else {
                pGen.init(this.strength, 20, new SecureRandom());
            }
            DSAParameters p = pGen.generateParameters();
            try {
                params = AlgorithmParameters.getInstance("DSA", "BC");
                params.init(new DSAParameterSpec(p.getP(), p.getQ(), p.getG()));
            }
            catch (Exception e) {
                throw new RuntimeException(e.getMessage());
            }
            return params;
        }
    }

    public static class DH
    extends JDKAlgorithmParameterGenerator {
        private int l = 0;

        @Override
        protected void engineInit(AlgorithmParameterSpec genParamSpec, SecureRandom random) throws InvalidAlgorithmParameterException {
            if (!(genParamSpec instanceof DHGenParameterSpec)) {
                throw new InvalidAlgorithmParameterException("DH parameter generator requires a DHGenParameterSpec for initialisation");
            }
            DHGenParameterSpec spec = (DHGenParameterSpec)genParamSpec;
            this.strength = spec.getPrimeSize();
            this.l = spec.getExponentSize();
            this.random = random;
        }

        @Override
        protected AlgorithmParameters engineGenerateParameters() {
            AlgorithmParameters params;
            DHParametersGenerator pGen = new DHParametersGenerator();
            if (this.random != null) {
                pGen.init(this.strength, 20, this.random);
            } else {
                pGen.init(this.strength, 20, new SecureRandom());
            }
            DHParameters p = pGen.generateParameters();
            try {
                params = AlgorithmParameters.getInstance("DH", "BC");
                params.init(new DHParameterSpec(p.getP(), p.getG(), this.l));
            }
            catch (Exception e) {
                throw new RuntimeException(e.getMessage());
            }
            return params;
        }
    }
}

