/*
 * Decompiled with CFR 0.152.
 */
package xjyb.org.bjca.jce.provider;

import java.security.spec.AlgorithmParameterSpec;
import javax.crypto.spec.PBEKeySpec;
import javax.crypto.spec.PBEParameterSpec;
import xjyb.org.bjca.crypto.CipherParameters;
import xjyb.org.bjca.crypto.PBEParametersGenerator;
import xjyb.org.bjca.crypto.digests.MD2Digest;
import xjyb.org.bjca.crypto.digests.MD5Digest;
import xjyb.org.bjca.crypto.digests.RIPEMD160Digest;
import xjyb.org.bjca.crypto.digests.SHA1Digest;
import xjyb.org.bjca.crypto.digests.SHA256Digest;
import xjyb.org.bjca.crypto.digests.TigerDigest;
import xjyb.org.bjca.crypto.generators.OpenSSLPBEParametersGenerator;
import xjyb.org.bjca.crypto.generators.PKCS12ParametersGenerator;
import xjyb.org.bjca.crypto.generators.PKCS5S1ParametersGenerator;
import xjyb.org.bjca.crypto.generators.PKCS5S2ParametersGenerator;
import xjyb.org.bjca.crypto.params.DESParameters;
import xjyb.org.bjca.crypto.params.KeyParameter;
import xjyb.org.bjca.crypto.params.ParametersWithIV;
import xjyb.org.bjca.jce.provider.JCEPBEKey;

public interface PBE {
    public static final int MD5 = 0;
    public static final int SHA1 = 1;
    public static final int RIPEMD160 = 2;
    public static final int TIGER = 3;
    public static final int SHA256 = 4;
    public static final int MD2 = 5;
    public static final int PKCS5S1 = 0;
    public static final int PKCS5S2 = 1;
    public static final int PKCS12 = 2;
    public static final int OPENSSL = 3;

    public static class Util {
        private static PBEParametersGenerator makePBEGenerator(int type, int hash) {
            PBEParametersGenerator generator;
            block14: {
                block16: {
                    block15: {
                        block13: {
                            if (type != 0) break block13;
                            switch (hash) {
                                case 5: {
                                    generator = new PKCS5S1ParametersGenerator(new MD2Digest());
                                    break block14;
                                }
                                case 0: {
                                    generator = new PKCS5S1ParametersGenerator(new MD5Digest());
                                    break block14;
                                }
                                case 1: {
                                    generator = new PKCS5S1ParametersGenerator(new SHA1Digest());
                                    break block14;
                                }
                                default: {
                                    throw new IllegalStateException("PKCS5 scheme 1 only supports MD2, MD5 and SHA1.");
                                }
                            }
                        }
                        if (type != 1) break block15;
                        generator = new PKCS5S2ParametersGenerator();
                        break block14;
                    }
                    if (type != 2) break block16;
                    switch (hash) {
                        case 5: {
                            generator = new PKCS12ParametersGenerator(new MD2Digest());
                            break block14;
                        }
                        case 0: {
                            generator = new PKCS12ParametersGenerator(new MD5Digest());
                            break block14;
                        }
                        case 1: {
                            generator = new PKCS12ParametersGenerator(new SHA1Digest());
                            break block14;
                        }
                        case 2: {
                            generator = new PKCS12ParametersGenerator(new RIPEMD160Digest());
                            break block14;
                        }
                        case 3: {
                            generator = new PKCS12ParametersGenerator(new TigerDigest());
                            break block14;
                        }
                        case 4: {
                            generator = new PKCS12ParametersGenerator(new SHA256Digest());
                            break block14;
                        }
                        default: {
                            throw new IllegalStateException("unknown digest scheme for PBE encryption.");
                        }
                    }
                }
                generator = new OpenSSLPBEParametersGenerator();
            }
            return generator;
        }

        static CipherParameters makePBEParameters(JCEPBEKey pbeKey, AlgorithmParameterSpec spec, String targetAlgorithm) {
            if (spec == null || !(spec instanceof PBEParameterSpec)) {
                throw new IllegalArgumentException("Need a PBEParameter spec with a PBE key.");
            }
            PBEParameterSpec pbeParam = (PBEParameterSpec)spec;
            PBEParametersGenerator generator = Util.makePBEGenerator(pbeKey.getType(), pbeKey.getDigest());
            byte[] key = pbeKey.getEncoded();
            if (pbeKey.shouldTryWrongPKCS12()) {
                key = new byte[2];
            }
            generator.init(key, pbeParam.getSalt(), pbeParam.getIterationCount());
            CipherParameters param = pbeKey.getIvSize() != 0 ? generator.generateDerivedParameters(pbeKey.getKeySize(), pbeKey.getIvSize()) : generator.generateDerivedParameters(pbeKey.getKeySize());
            if (targetAlgorithm.startsWith("DES")) {
                KeyParameter kParam;
                if (param instanceof ParametersWithIV) {
                    kParam = (KeyParameter)((ParametersWithIV)param).getParameters();
                    DESParameters.setOddParity(kParam.getKey());
                } else {
                    kParam = (KeyParameter)param;
                    DESParameters.setOddParity(kParam.getKey());
                }
            }
            for (int i = 0; i != key.length; ++i) {
                key[i] = 0;
            }
            return param;
        }

        static CipherParameters makePBEMacParameters(JCEPBEKey pbeKey, AlgorithmParameterSpec spec) {
            if (spec == null || !(spec instanceof PBEParameterSpec)) {
                throw new IllegalArgumentException("Need a PBEParameter spec with a PBE key.");
            }
            PBEParameterSpec pbeParam = (PBEParameterSpec)spec;
            PBEParametersGenerator generator = Util.makePBEGenerator(pbeKey.getType(), pbeKey.getDigest());
            byte[] key = pbeKey.getEncoded();
            if (pbeKey.shouldTryWrongPKCS12()) {
                key = new byte[2];
            }
            generator.init(key, pbeParam.getSalt(), pbeParam.getIterationCount());
            CipherParameters param = generator.generateDerivedMacParameters(pbeKey.getKeySize());
            for (int i = 0; i != key.length; ++i) {
                key[i] = 0;
            }
            return param;
        }

        static CipherParameters makePBEParameters(PBEKeySpec keySpec, int type, int hash, int keySize, int ivSize) {
            PBEParametersGenerator generator = Util.makePBEGenerator(type, hash);
            byte[] key = type == 2 ? PBEParametersGenerator.PKCS12PasswordToBytes(keySpec.getPassword()) : PBEParametersGenerator.PKCS5PasswordToBytes(keySpec.getPassword());
            generator.init(key, keySpec.getSalt(), keySpec.getIterationCount());
            CipherParameters param = ivSize != 0 ? generator.generateDerivedParameters(keySize, ivSize) : generator.generateDerivedParameters(keySize);
            for (int i = 0; i != key.length; ++i) {
                key[i] = 0;
            }
            return param;
        }

        static CipherParameters makePBEMacParameters(PBEKeySpec keySpec, int type, int hash, int keySize) {
            PBEParametersGenerator generator = Util.makePBEGenerator(type, hash);
            byte[] key = type == 2 ? PBEParametersGenerator.PKCS12PasswordToBytes(keySpec.getPassword()) : PBEParametersGenerator.PKCS5PasswordToBytes(keySpec.getPassword());
            generator.init(key, keySpec.getSalt(), keySpec.getIterationCount());
            CipherParameters param = generator.generateDerivedMacParameters(keySize);
            for (int i = 0; i != key.length; ++i) {
                key[i] = 0;
            }
            return param;
        }
    }
}

