/*
 * Decompiled with CFR 0.152.
 */
package xjyb.org.bjca.jce.provider;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.math.BigInteger;
import java.security.InvalidKeyException;
import java.security.NoSuchAlgorithmException;
import java.security.NoSuchProviderException;
import java.security.Principal;
import java.security.Provider;
import java.security.PublicKey;
import java.security.Security;
import java.security.Signature;
import java.security.SignatureException;
import java.security.cert.Certificate;
import java.security.cert.CertificateEncodingException;
import java.security.cert.CertificateException;
import java.security.cert.CertificateExpiredException;
import java.security.cert.CertificateNotYetValidException;
import java.security.cert.CertificateParsingException;
import java.security.cert.X509Certificate;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Date;
import java.util.Enumeration;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import javax.security.auth.x500.X500Principal;
import xjyb.org.bjca.asn1.ASN1InputStream;
import xjyb.org.bjca.asn1.ASN1Object;
import xjyb.org.bjca.asn1.ASN1OutputStream;
import xjyb.org.bjca.asn1.ASN1Sequence;
import xjyb.org.bjca.asn1.DERBitString;
import xjyb.org.bjca.asn1.DEREncodable;
import xjyb.org.bjca.asn1.DERIA5String;
import xjyb.org.bjca.asn1.DERInteger;
import xjyb.org.bjca.asn1.DERObject;
import xjyb.org.bjca.asn1.DERObjectIdentifier;
import xjyb.org.bjca.asn1.DEROutputStream;
import xjyb.org.bjca.asn1.misc.MiscObjectIdentifiers;
import xjyb.org.bjca.asn1.misc.NetscapeCertType;
import xjyb.org.bjca.asn1.misc.NetscapeRevocationURL;
import xjyb.org.bjca.asn1.misc.VerisignCzagExtension;
import xjyb.org.bjca.asn1.util.ASN1Dump;
import xjyb.org.bjca.asn1.x509.AlgorithmIdentifier;
import xjyb.org.bjca.asn1.x509.BasicConstraints;
import xjyb.org.bjca.asn1.x509.KeyUsage;
import xjyb.org.bjca.asn1.x509.SubjectPublicKeyInfo;
import xjyb.org.bjca.asn1.x509.Time;
import xjyb.org.bjca.asn1.x509.X509CertificateStructure;
import xjyb.org.bjca.asn1.x509.X509Extension;
import xjyb.org.bjca.asn1.x509.X509Extensions;
import xjyb.org.bjca.jce.X509Principal;
import xjyb.org.bjca.jce.fastparser.DerUtil;
import xjyb.org.bjca.jce.fastparser.FX509Certificate;
import xjyb.org.bjca.jce.interfaces.PKCS12BagAttributeCarrier;
import xjyb.org.bjca.jce.provider.JDKKeyFactory;
import xjyb.org.bjca.jce.provider.PKCS12BagAttributeCarrierImpl;
import xjyb.org.bjca.jce.provider.RFC3280CertPathUtilities;
import xjyb.org.bjca.jce.provider.X509SignatureUtil;
import xjyb.org.bjca.util.Arrays;
import xjyb.org.bjca.util.encoders.Hex;

public class X509CertificateObjectFP
extends X509Certificate
implements PKCS12BagAttributeCarrier {
    private X509CertificateStructure c;
    private BasicConstraints basicConstraints;
    private boolean[] keyUsage;
    private PKCS12BagAttributeCarrier attrCarrier = new PKCS12BagAttributeCarrierImpl();
    byte[] certData = null;
    FX509Certificate fxCert = null;
    boolean isInvokeConstructMethod = false;
    int version = -1;
    BigInteger serialNumber = null;
    Principal issuerDN = null;
    X500Principal issuerX500Principal = null;
    Principal subjectDN = null;
    X500Principal subjectX500Principal = null;
    Date notBefore = null;
    Date notAfter = null;
    byte[] tbsCertificate = null;
    byte[] signature = null;
    String sigAlgOID = null;
    AlgorithmIdentifier signatureAlgorithm = null;
    PublicKey publickey = null;
    byte[] encoded = null;
    AlgorithmIdentifier tbSCertificateSignature = null;

    public X509CertificateObjectFP(byte[] bs) {
        this.certData = bs;
        this.fxCert = new FX509Certificate();
        this.fxCert.parse(this.certData, 0, this.certData.length);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void invokeConstructMethod() {
        if (this.isInvokeConstructMethod) {
            return;
        }
        X509CertificateObjectFP x509CertificateObjectFP = this;
        synchronized (x509CertificateObjectFP) {
            if (this.isInvokeConstructMethod) {
                return;
            }
            this.isInvokeConstructMethod = true;
            if (this.certData != null) {
                byte[] bytes;
                try {
                    DERObject dobj = new ASN1InputStream(new ByteArrayInputStream(this.certData)).readObject();
                    this.c = X509CertificateStructure.getInstance(dobj);
                }
                catch (IOException e) {
                    // empty catch block
                }
                this.c = this.c;
                try {
                    bytes = this.getExtensionBytes("2.5.29.19");
                    if (bytes != null) {
                        this.basicConstraints = BasicConstraints.getInstance(ASN1Object.fromByteArray(bytes));
                    }
                }
                catch (Exception e) {
                    throw new RuntimeException("cannot construct BasicConstraints: " + e);
                }
                try {
                    bytes = this.getExtensionBytes("2.5.29.15");
                    if (bytes != null) {
                        DERBitString bits = DERBitString.getInstance(ASN1Object.fromByteArray(bytes));
                        int length = (bytes = bits.getBytes()).length * 8 - bits.getPadBits();
                        this.keyUsage = new boolean[length < 9 ? 9 : length];
                        for (int i = 0; i != length; ++i) {
                            this.keyUsage[i] = (bytes[i / 8] & 128 >>> i % 8) != 0;
                        }
                    } else {
                        this.keyUsage = null;
                    }
                }
                catch (Exception e) {
                    throw new RuntimeException("cannot construct KeyUsage: " + e);
                }
            }
        }
    }

    public X509CertificateStructure getX509CertificateStructure() {
        this.invokeConstructMethod();
        if (this.c != null) {
            return this.c;
        }
        try {
            DERObject dobj = new ASN1InputStream(new ByteArrayInputStream(this.certData)).readObject();
            this.c = X509CertificateStructure.getInstance(dobj);
            return this.c;
        }
        catch (IOException e) {
            return null;
        }
    }

    public X509CertificateObjectFP(X509CertificateStructure c) throws CertificateParsingException {
        byte[] bytes;
        this.c = c;
        try {
            bytes = this.getExtensionBytes("2.5.29.19");
            if (bytes != null) {
                this.basicConstraints = BasicConstraints.getInstance(ASN1Object.fromByteArray(bytes));
            }
        }
        catch (Exception e) {
            throw new CertificateParsingException("cannot construct BasicConstraints: " + e);
        }
        try {
            bytes = this.getExtensionBytes("2.5.29.15");
            if (bytes != null) {
                DERBitString bits = DERBitString.getInstance(ASN1Object.fromByteArray(bytes));
                int length = (bytes = bits.getBytes()).length * 8 - bits.getPadBits();
                this.keyUsage = new boolean[length < 9 ? 9 : length];
                for (int i = 0; i != length; ++i) {
                    this.keyUsage[i] = (bytes[i / 8] & 128 >>> i % 8) != 0;
                }
            } else {
                this.keyUsage = null;
            }
        }
        catch (Exception e) {
            throw new CertificateParsingException("cannot construct KeyUsage: " + e);
        }
    }

    @Override
    public void checkValidity() throws CertificateExpiredException, CertificateNotYetValidException {
        this.invokeConstructMethod();
        this.checkValidity(new Date());
    }

    @Override
    public void checkValidity(Date date) throws CertificateExpiredException, CertificateNotYetValidException {
        this.invokeConstructMethod();
        if (date.getTime() > this.getNotAfter().getTime()) {
            throw new CertificateExpiredException("certificate expired on " + this.getX509CertificateStructure().getEndDate().getTime());
        }
        if (date.getTime() < this.getNotBefore().getTime()) {
            throw new CertificateNotYetValidException("certificate not valid till " + this.getX509CertificateStructure().getStartDate().getTime());
        }
    }

    @Override
    public int getVersion() {
        if (this.version != -1) {
            return this.version;
        }
        if (this.fxCert != null) {
            byte[] bsData = this.fxCert.getItemData(this.fxCert.getVersion());
            if (bsData.length == 0) {
                this.version = new DERInteger(0).getValue().intValue() + 1;
            } else {
                try {
                    DERObject dobj = new ASN1InputStream(new ByteArrayInputStream(bsData)).readObject();
                    DERInteger dint = DERInteger.getInstance(dobj);
                    this.version = dint.getValue().intValue() + 1;
                }
                catch (IOException e) {
                    throw new RuntimeException(e.getMessage());
                }
            }
            return this.version;
        }
        return this.getX509CertificateStructure().getVersion();
    }

    @Override
    public BigInteger getSerialNumber() {
        if (this.serialNumber != null) {
            return this.serialNumber;
        }
        if (this.fxCert != null) {
            byte[] bsData = this.fxCert.getItemData(this.fxCert.getSerialNumber());
            this.serialNumber = new BigInteger(bsData);
            return this.serialNumber;
        }
        return this.getX509CertificateStructure().getSerialNumber().getValue();
    }

    @Override
    public Principal getIssuerDN() {
        if (this.fxCert != null) {
            if (this.issuerDN != null) {
                return this.issuerDN;
            }
            try {
                byte[] bsData = this.fxCert.getItemData(this.fxCert.getIssuer());
                this.issuerDN = new X509Principal(bsData);
            }
            catch (IOException e) {
                throw new RuntimeException(e.getMessage());
            }
            return this.issuerDN;
        }
        return new X509Principal(this.getX509CertificateStructure().getIssuer());
    }

    @Override
    public X500Principal getIssuerX500Principal() {
        if (this.issuerX500Principal != null) {
            return this.issuerX500Principal;
        }
        if (this.fxCert != null) {
            byte[] bsData = this.fxCert.getItemData(this.fxCert.getIssuer());
            this.issuerX500Principal = new X500Principal(bsData);
            return this.issuerX500Principal;
        }
        try {
            ByteArrayOutputStream bOut = new ByteArrayOutputStream();
            ASN1OutputStream aOut = new ASN1OutputStream(bOut);
            aOut.writeObject(this.getX509CertificateStructure().getIssuer());
            return new X500Principal(bOut.toByteArray());
        }
        catch (IOException e) {
            throw new IllegalStateException("can't encode issuer DN");
        }
    }

    @Override
    public Principal getSubjectDN() {
        if (this.subjectDN != null) {
            return this.subjectDN;
        }
        if (this.fxCert != null) {
            byte[] bsData = this.fxCert.getItemDataAndTag(this.fxCert.getSubject());
            try {
                this.subjectDN = new X509Principal(bsData);
            }
            catch (IOException e) {
                throw new RuntimeException(e.getMessage());
            }
            return this.subjectDN;
        }
        return new X509Principal(this.getX509CertificateStructure().getSubject());
    }

    @Override
    public X500Principal getSubjectX500Principal() {
        if (this.subjectX500Principal != null) {
            return this.subjectX500Principal;
        }
        if (this.fxCert != null) {
            byte[] bsData = this.fxCert.getItemDataAndTag(this.fxCert.getSubject());
            this.subjectX500Principal = new X500Principal(bsData);
            return this.subjectX500Principal;
        }
        try {
            ByteArrayOutputStream bOut = new ByteArrayOutputStream();
            ASN1OutputStream aOut = new ASN1OutputStream(bOut);
            aOut.writeObject(this.getX509CertificateStructure().getSubject());
            return new X500Principal(bOut.toByteArray());
        }
        catch (IOException e) {
            throw new IllegalStateException("can't encode issuer DN");
        }
    }

    @Override
    public Date getNotBefore() {
        if (this.notBefore != null) {
            return this.notBefore;
        }
        if (this.fxCert != null) {
            byte[] bsData = this.fxCert.getItemDataAndTag(this.fxCert.getValidity());
            ASN1InputStream ains = new ASN1InputStream(new ByteArrayInputStream(bsData));
            try {
                ASN1Sequence dates = (ASN1Sequence)ains.readObject();
                this.notBefore = Time.getInstance(dates.getObjectAt(0)).getDate();
            }
            catch (IOException e) {
                throw new RuntimeException(e.getMessage());
            }
            return this.notBefore;
        }
        return this.getX509CertificateStructure().getStartDate().getDate();
    }

    @Override
    public Date getNotAfter() {
        if (this.notAfter != null) {
            return this.notAfter;
        }
        if (this.fxCert != null) {
            byte[] bsData = this.fxCert.getItemDataAndTag(this.fxCert.getValidity());
            ASN1InputStream ains = new ASN1InputStream(new ByteArrayInputStream(bsData));
            try {
                ASN1Sequence dates = (ASN1Sequence)ains.readObject();
                this.notAfter = Time.getInstance(dates.getObjectAt(1)).getDate();
            }
            catch (IOException e) {
                throw new RuntimeException(e.getMessage());
            }
            return this.notAfter;
        }
        return this.getX509CertificateStructure().getEndDate().getDate();
    }

    @Override
    public byte[] getTBSCertificate() throws CertificateEncodingException {
        if (this.tbsCertificate != null) {
            return this.tbsCertificate;
        }
        if (this.fxCert != null) {
            byte[] bsData = this.fxCert.getItemDataAndTag(this.fxCert.getTbsCertificate());
            this.tbsCertificate = bsData;
            return this.tbsCertificate;
        }
        ByteArrayOutputStream bOut = new ByteArrayOutputStream();
        DEROutputStream dOut = new DEROutputStream(bOut);
        try {
            dOut.writeObject(this.getX509CertificateStructure().getTBSCertificate());
            return bOut.toByteArray();
        }
        catch (IOException e) {
            throw new CertificateEncodingException(e.toString());
        }
    }

    @Override
    public byte[] getSignature() {
        if (this.signature != null) {
            return this.signature;
        }
        if (this.fxCert != null) {
            byte[] bsData = this.fxCert.getItemData(this.fxCert.getSignatureValue());
            byte[] bytes = new byte[bsData.length - 1];
            System.arraycopy(bsData, 1, bytes, 0, bsData.length - 1);
            this.signature = bytes;
            return this.signature;
        }
        return this.getX509CertificateStructure().getSignature().getBytes();
    }

    @Override
    public String getSigAlgName() {
        String algName;
        this.invokeConstructMethod();
        Provider prov = Security.getProvider("BC");
        if (prov != null && (algName = prov.getProperty("Alg.Alias.Signature." + this.getSigAlgOID())) != null) {
            return algName;
        }
        Provider[] provs = Security.getProviders();
        for (int i = 0; i != provs.length; ++i) {
            String algName2 = provs[i].getProperty("Alg.Alias.Signature." + this.getSigAlgOID());
            if (algName2 == null) continue;
            return algName2;
        }
        return this.getSigAlgOID();
    }

    @Override
    public String getSigAlgOID() {
        if (this.sigAlgOID != null) {
            return this.sigAlgOID;
        }
        if (this.fxCert != null) {
            byte[] bsData = this.fxCert.getItemData(this.fxCert.getSignatureAlgorithm());
            try {
                AlgorithmIdentifier sigAlg = AlgorithmIdentifier.getInstance(DerUtil.getDerObject(bsData));
                this.sigAlgOID = sigAlg.getObjectId().getId();
            }
            catch (IOException e) {
                throw new RuntimeException(e.getMessage());
            }
            return this.sigAlgOID;
        }
        return this.getX509CertificateStructure().getSignatureAlgorithm().getObjectId().getId();
    }

    public AlgorithmIdentifier getSignatureAlgorithm() {
        if (this.signatureAlgorithm != null) {
            return this.signatureAlgorithm;
        }
        if (this.fxCert != null) {
            byte[] bsData = this.fxCert.getItemData(this.fxCert.getSignatureAlgorithm());
            try {
                AlgorithmIdentifier sigAlg;
                this.signatureAlgorithm = sigAlg = AlgorithmIdentifier.getInstance(DerUtil.getDerObject(bsData));
            }
            catch (IOException e) {
                throw new RuntimeException(e.getMessage());
            }
        }
        return this.signatureAlgorithm;
    }

    @Override
    public byte[] getSigAlgParams() {
        this.invokeConstructMethod();
        if (this.getX509CertificateStructure().getSignatureAlgorithm().getParameters() != null) {
            return this.getX509CertificateStructure().getSignatureAlgorithm().getParameters().getDERObject().getDEREncoded();
        }
        return null;
    }

    @Override
    public boolean[] getIssuerUniqueID() {
        this.invokeConstructMethod();
        DERBitString id = this.getX509CertificateStructure().getTBSCertificate().getIssuerUniqueId();
        if (id != null) {
            byte[] bytes = id.getBytes();
            boolean[] boolId = new boolean[bytes.length * 8 - id.getPadBits()];
            for (int i = 0; i != boolId.length; ++i) {
                boolId[i] = (bytes[i / 8] & 128 >>> i % 8) != 0;
            }
            return boolId;
        }
        return null;
    }

    @Override
    public boolean[] getSubjectUniqueID() {
        this.invokeConstructMethod();
        DERBitString id = this.getX509CertificateStructure().getTBSCertificate().getSubjectUniqueId();
        if (id != null) {
            byte[] bytes = id.getBytes();
            boolean[] boolId = new boolean[bytes.length * 8 - id.getPadBits()];
            for (int i = 0; i != boolId.length; ++i) {
                boolId[i] = (bytes[i / 8] & 128 >>> i % 8) != 0;
            }
            return boolId;
        }
        return null;
    }

    @Override
    public boolean[] getKeyUsage() {
        this.invokeConstructMethod();
        return this.keyUsage;
    }

    public List getExtendedKeyUsage() throws CertificateParsingException {
        this.invokeConstructMethod();
        byte[] bytes = this.getExtensionBytes("2.5.29.37");
        if (bytes != null) {
            try {
                ASN1InputStream dIn = new ASN1InputStream(bytes);
                ASN1Sequence seq = (ASN1Sequence)dIn.readObject();
                ArrayList<String> list = new ArrayList<String>();
                for (int i = 0; i != seq.size(); ++i) {
                    list.add(((DERObjectIdentifier)seq.getObjectAt(i)).getId());
                }
                return Collections.unmodifiableList(list);
            }
            catch (Exception e) {
                throw new CertificateParsingException("error processing extended key usage extension");
            }
        }
        return null;
    }

    @Override
    public int getBasicConstraints() {
        byte[] bytes;
        if (this.basicConstraints == null && (bytes = this.getExtensionBytes("2.5.29.19")) != null) {
            try {
                this.basicConstraints = BasicConstraints.getInstance(DerUtil.getDerObject(bytes));
            }
            catch (IOException e) {
                return -1;
            }
        }
        if (this.basicConstraints != null) {
            if (this.basicConstraints.isCA()) {
                if (this.basicConstraints.getPathLenConstraint() == null) {
                    return Integer.MAX_VALUE;
                }
                return this.basicConstraints.getPathLenConstraint().intValue();
            }
            return -1;
        }
        return -1;
    }

    public Set getCriticalExtensionOIDs() {
        this.invokeConstructMethod();
        if (this.getVersion() == 3) {
            HashSet<String> set = new HashSet<String>();
            X509Extensions extensions = this.getX509CertificateStructure().getTBSCertificate().getExtensions();
            if (extensions != null) {
                Enumeration e = extensions.oids();
                while (e.hasMoreElements()) {
                    DERObjectIdentifier oid = (DERObjectIdentifier)e.nextElement();
                    X509Extension ext = extensions.getExtension(oid);
                    if (!ext.isCritical()) continue;
                    set.add(oid.getId());
                }
                return set;
            }
        }
        return null;
    }

    private byte[] getExtensionBytes(String oid) {
        X509Extension ext;
        byte[] extensionBytes = null;
        if (this.fxCert != null) {
            byte[] bsData = this.fxCert.getItemDataAndTag(this.fxCert.getExtensions());
            ASN1InputStream ains = new ASN1InputStream(new ByteArrayInputStream(bsData));
            try {
                X509Extension ext2;
                X509Extensions exts = X509Extensions.getInstance(ains.readObject());
                if (exts != null && (ext2 = exts.getExtension(new DERObjectIdentifier(oid))) != null) {
                    extensionBytes = ext2.getValue().getOctets();
                }
            }
            catch (IOException e) {
                throw new RuntimeException(e.getMessage());
            }
            return extensionBytes;
        }
        X509Extensions exts = this.getX509CertificateStructure().getTBSCertificate().getExtensions();
        if (exts != null && (ext = exts.getExtension(new DERObjectIdentifier(oid))) != null) {
            return ext.getValue().getOctets();
        }
        return null;
    }

    @Override
    public byte[] getExtensionValue(String oid) {
        X509Extension ext;
        byte[] extensionValue = null;
        if (this.fxCert != null) {
            byte[] bsData = this.fxCert.getItemDataAndTag(this.fxCert.getExtensions());
            ASN1InputStream ains = new ASN1InputStream(new ByteArrayInputStream(bsData));
            try {
                X509Extension ext2;
                X509Extensions exts = X509Extensions.getInstance(ains.readObject());
                if (exts != null && (ext2 = exts.getExtension(new DERObjectIdentifier(oid))) != null) {
                    extensionValue = ext2.getValue().getEncoded();
                }
            }
            catch (IOException e) {
                throw new RuntimeException(e.getMessage());
            }
            return extensionValue;
        }
        X509Extensions exts = this.getX509CertificateStructure().getTBSCertificate().getExtensions();
        if (exts != null && (ext = exts.getExtension(new DERObjectIdentifier(oid))) != null) {
            try {
                return ext.getValue().getEncoded();
            }
            catch (Exception e) {
                throw new IllegalStateException("error parsing " + e.toString());
            }
        }
        return null;
    }

    public Set getNonCriticalExtensionOIDs() {
        this.invokeConstructMethod();
        if (this.getVersion() == 3) {
            HashSet<String> set = new HashSet<String>();
            X509Extensions extensions = this.getX509CertificateStructure().getTBSCertificate().getExtensions();
            if (extensions != null) {
                Enumeration e = extensions.oids();
                while (e.hasMoreElements()) {
                    DERObjectIdentifier oid = (DERObjectIdentifier)e.nextElement();
                    X509Extension ext = extensions.getExtension(oid);
                    if (ext.isCritical()) continue;
                    set.add(oid.getId());
                }
                return set;
            }
        }
        return null;
    }

    @Override
    public boolean hasUnsupportedCriticalExtension() {
        X509Extensions extensions;
        this.invokeConstructMethod();
        if (this.getVersion() == 3 && (extensions = this.getX509CertificateStructure().getTBSCertificate().getExtensions()) != null) {
            Enumeration e = extensions.oids();
            while (e.hasMoreElements()) {
                X509Extension ext;
                DERObjectIdentifier oid = (DERObjectIdentifier)e.nextElement();
                String oidId = oid.getId();
                if (oidId.equals(RFC3280CertPathUtilities.KEY_USAGE) || oidId.equals(RFC3280CertPathUtilities.CERTIFICATE_POLICIES) || oidId.equals(RFC3280CertPathUtilities.POLICY_MAPPINGS) || oidId.equals(RFC3280CertPathUtilities.INHIBIT_ANY_POLICY) || oidId.equals(RFC3280CertPathUtilities.CRL_DISTRIBUTION_POINTS) || oidId.equals(RFC3280CertPathUtilities.ISSUING_DISTRIBUTION_POINT) || oidId.equals(RFC3280CertPathUtilities.DELTA_CRL_INDICATOR) || oidId.equals(RFC3280CertPathUtilities.POLICY_CONSTRAINTS) || oidId.equals(RFC3280CertPathUtilities.BASIC_CONSTRAINTS) || oidId.equals(RFC3280CertPathUtilities.SUBJECT_ALTERNATIVE_NAME) || oidId.equals(RFC3280CertPathUtilities.NAME_CONSTRAINTS) || !(ext = extensions.getExtension(oid)).isCritical()) continue;
                return true;
            }
        }
        return false;
    }

    @Override
    public PublicKey getPublicKey() {
        if (this.publickey != null) {
            return this.publickey;
        }
        if (this.fxCert != null) {
            byte[] bsData = this.fxCert.getItemDataAndTag(this.fxCert.getSubjectPublicKeyInfo());
            ASN1InputStream ains = new ASN1InputStream(new ByteArrayInputStream(bsData));
            try {
                SubjectPublicKeyInfo spki = SubjectPublicKeyInfo.getInstance(ains.readObject());
                this.publickey = JDKKeyFactory.createPublicKeyFromPublicKeyInfo(spki);
            }
            catch (IOException e) {
                throw new RuntimeException(e.getMessage());
            }
            return this.publickey;
        }
        return JDKKeyFactory.createPublicKeyFromPublicKeyInfo(this.getX509CertificateStructure().getSubjectPublicKeyInfo());
    }

    @Override
    public byte[] getEncoded() throws CertificateEncodingException {
        if (this.encoded != null) {
            return this.encoded;
        }
        if (this.fxCert != null) {
            this.encoded = this.certData;
            return this.encoded;
        }
        ByteArrayOutputStream bOut = new ByteArrayOutputStream();
        DEROutputStream dOut = new DEROutputStream(bOut);
        try {
            dOut.writeObject(this.c);
            return bOut.toByteArray();
        }
        catch (IOException e) {
            throw new CertificateEncodingException(e.toString());
        }
    }

    @Override
    public boolean equals(Object o) {
        this.invokeConstructMethod();
        if (o == this) {
            return true;
        }
        if (!(o instanceof Certificate)) {
            return false;
        }
        Certificate other = (Certificate)o;
        try {
            byte[] b1 = this.getEncoded();
            byte[] b2 = other.getEncoded();
            return Arrays.areEqual(b1, b2);
        }
        catch (CertificateEncodingException e) {
            return false;
        }
    }

    @Override
    public int hashCode() {
        this.invokeConstructMethod();
        try {
            byte[] b = this.getEncoded();
            int value = 0;
            for (int i = 0; i != b.length; ++i) {
                value ^= (b[i] & 0xFF) << i % 4;
            }
            return value;
        }
        catch (CertificateEncodingException e) {
            return 0;
        }
    }

    @Override
    public void setBagAttribute(DERObjectIdentifier oid, DEREncodable attribute) {
        this.invokeConstructMethod();
        this.attrCarrier.setBagAttribute(oid, attribute);
    }

    @Override
    public DEREncodable getBagAttribute(DERObjectIdentifier oid) {
        this.invokeConstructMethod();
        return this.attrCarrier.getBagAttribute(oid);
    }

    @Override
    public Enumeration getBagAttributeKeys() {
        this.invokeConstructMethod();
        return this.attrCarrier.getBagAttributeKeys();
    }

    @Override
    public String toString() {
        this.invokeConstructMethod();
        StringBuffer buf = new StringBuffer();
        String nl = System.getProperty("line.separator");
        buf.append("  [0]         Version: ").append(this.getVersion()).append(nl);
        buf.append("         SerialNumber: ").append(this.getSerialNumber()).append(nl);
        buf.append("             IssuerDN: ").append(this.getIssuerDN()).append(nl);
        buf.append("           Start Date: ").append(this.getNotBefore()).append(nl);
        buf.append("           Final Date: ").append(this.getNotAfter()).append(nl);
        buf.append("            SubjectDN: ").append(this.getSubjectDN()).append(nl);
        buf.append("           Public Key: ").append(this.getPublicKey()).append(nl);
        buf.append("  Signature Algorithm: ").append(this.getSigAlgName()).append(nl);
        byte[] sig = this.getSignature();
        buf.append("            Signature: ").append(new String(Hex.encode(sig, 0, 20))).append(nl);
        for (int i = 20; i < sig.length; i += 20) {
            if (i < sig.length - 20) {
                buf.append("                       ").append(new String(Hex.encode(sig, i, 20))).append(nl);
                continue;
            }
            buf.append("                       ").append(new String(Hex.encode(sig, i, sig.length - i))).append(nl);
        }
        X509Extensions extensions = this.getX509CertificateStructure().getTBSCertificate().getExtensions();
        if (extensions != null) {
            Enumeration e = extensions.oids();
            if (e.hasMoreElements()) {
                buf.append("       Extensions: \n");
            }
            while (e.hasMoreElements()) {
                DERObjectIdentifier oid = (DERObjectIdentifier)e.nextElement();
                X509Extension ext = extensions.getExtension(oid);
                if (ext.getValue() != null) {
                    byte[] octs = ext.getValue().getOctets();
                    ASN1InputStream dIn = new ASN1InputStream(octs);
                    buf.append("                       critical(").append(ext.isCritical()).append(") ");
                    try {
                        if (oid.equals(X509Extensions.BasicConstraints)) {
                            buf.append(new BasicConstraints((ASN1Sequence)dIn.readObject())).append(nl);
                            continue;
                        }
                        if (oid.equals(X509Extensions.KeyUsage)) {
                            buf.append(new KeyUsage((DERBitString)dIn.readObject())).append(nl);
                            continue;
                        }
                        if (oid.equals(MiscObjectIdentifiers.netscapeCertType)) {
                            buf.append(new NetscapeCertType((DERBitString)dIn.readObject())).append(nl);
                            continue;
                        }
                        if (oid.equals(MiscObjectIdentifiers.netscapeRevocationURL)) {
                            buf.append(new NetscapeRevocationURL((DERIA5String)dIn.readObject())).append(nl);
                            continue;
                        }
                        if (oid.equals(MiscObjectIdentifiers.verisignCzagExtension)) {
                            buf.append(new VerisignCzagExtension((DERIA5String)dIn.readObject())).append(nl);
                            continue;
                        }
                        buf.append(oid.getId());
                        buf.append(" value = ").append(ASN1Dump.dumpAsString(dIn.readObject())).append(nl);
                    }
                    catch (Exception ex) {
                        buf.append(oid.getId());
                        buf.append(" value = ").append("*****").append(nl);
                    }
                    continue;
                }
                buf.append(nl);
            }
        }
        return buf.toString();
    }

    @Override
    public final void verify(PublicKey key) throws CertificateException, NoSuchAlgorithmException, InvalidKeyException, NoSuchProviderException, SignatureException {
        Signature signature;
        String sigName = this.fxCert != null ? X509SignatureUtil.getSignatureName(this.getSignatureAlgorithm()) : X509SignatureUtil.getSignatureName(this.getX509CertificateStructure().getSignatureAlgorithm());
        try {
            signature = Signature.getInstance(sigName, "BC");
        }
        catch (Exception e) {
            signature = Signature.getInstance(sigName);
        }
        this.checkSignature(key, signature);
    }

    @Override
    public final void verify(PublicKey key, String sigProvider) throws CertificateException, NoSuchAlgorithmException, InvalidKeyException, NoSuchProviderException, SignatureException {
        String sigName = this.fxCert != null ? X509SignatureUtil.getSignatureName(this.getSignatureAlgorithm()) : X509SignatureUtil.getSignatureName(this.getX509CertificateStructure().getSignatureAlgorithm());
        Signature signature = Signature.getInstance(sigName, sigProvider);
        this.checkSignature(key, signature);
    }

    AlgorithmIdentifier getTBSCertificateSignature() {
        if (this.tbSCertificateSignature != null) {
            return this.tbSCertificateSignature;
        }
        if (this.fxCert != null) {
            byte[] bytes = this.fxCert.getItemData(this.fxCert.getSignature());
            try {
                AlgorithmIdentifier alg;
                this.tbSCertificateSignature = alg = AlgorithmIdentifier.getInstance(DerUtil.getDerObject(bytes));
            }
            catch (IOException e) {
                throw new RuntimeException(e.getMessage());
            }
            return this.tbSCertificateSignature;
        }
        return this.tbSCertificateSignature;
    }

    private void checkSignature(PublicKey key, Signature signature) throws CertificateException, NoSuchAlgorithmException, SignatureException, InvalidKeyException {
        if (!this.getX509CertificateStructure().getSignatureAlgorithm().equals(this.getX509CertificateStructure().getTBSCertificate().getSignature())) {
            throw new CertificateException("signature algorithm in TBS cert not same as outer cert");
        }
        if (!this.getSignatureAlgorithm().equals(this.getTBSCertificateSignature())) {
            throw new CertificateException("signature algorithm in TBS cert not same as outer cert");
        }
        DEREncodable params = this.fxCert != null ? this.getSignatureAlgorithm().getParameters() : this.getX509CertificateStructure().getSignatureAlgorithm().getParameters();
        X509SignatureUtil.setSignatureParameters(signature, params);
        signature.initVerify(key);
        signature.update(this.getTBSCertificate());
        if (!signature.verify(this.getSignature())) {
            throw new InvalidKeyException("Public key presented not for certificate signature");
        }
    }
}

