/*
 * Decompiled with CFR 0.152.
 */
package xjyb.org.bjca.jce.provider.asymmetric.ec;

import java.math.BigInteger;
import java.security.InvalidAlgorithmParameterException;
import java.security.InvalidKeyException;
import java.security.Key;
import java.security.NoSuchAlgorithmException;
import java.security.PrivateKey;
import java.security.PublicKey;
import java.security.SecureRandom;
import java.security.spec.AlgorithmParameterSpec;
import java.util.Hashtable;
import javax.crypto.KeyAgreementSpi;
import javax.crypto.SecretKey;
import javax.crypto.ShortBufferException;
import javax.crypto.spec.SecretKeySpec;
import xjyb.org.bjca.asn1.DERObjectIdentifier;
import xjyb.org.bjca.asn1.nist.NISTObjectIdentifiers;
import xjyb.org.bjca.asn1.pkcs.PKCSObjectIdentifiers;
import xjyb.org.bjca.asn1.x9.X9IntegerConverter;
import xjyb.org.bjca.crypto.BasicAgreement;
import xjyb.org.bjca.crypto.DerivationFunction;
import xjyb.org.bjca.crypto.agreement.ECDHBasicAgreement;
import xjyb.org.bjca.crypto.agreement.ECDHCBasicAgreement;
import xjyb.org.bjca.crypto.agreement.kdf.DHKDFParameters;
import xjyb.org.bjca.crypto.agreement.kdf.ECDHKEKGenerator;
import xjyb.org.bjca.crypto.digests.SHA1Digest;
import xjyb.org.bjca.crypto.params.AsymmetricKeyParameter;
import xjyb.org.bjca.crypto.params.ECPrivateKeyParameters;
import xjyb.org.bjca.jce.interfaces.ECPrivateKey;
import xjyb.org.bjca.jce.interfaces.ECPublicKey;
import xjyb.org.bjca.jce.provider.asymmetric.ec.ECUtil;

public class KeyAgreement
extends KeyAgreementSpi {
    private static final X9IntegerConverter converter = new X9IntegerConverter();
    private static final Hashtable algorithms = new Hashtable();
    private BigInteger result;
    private ECPrivateKeyParameters privKey;
    private BasicAgreement agreement;
    private DerivationFunction kdf;

    private byte[] bigIntToBytes(BigInteger r) {
        return converter.integerToBytes(r, converter.getByteLength(this.privKey.getParameters().getG().getX()));
    }

    protected KeyAgreement(BasicAgreement agreement) {
        this.agreement = agreement;
    }

    protected KeyAgreement(BasicAgreement agreement, DerivationFunction kdf) {
        this.agreement = agreement;
        this.kdf = kdf;
    }

    @Override
    protected Key engineDoPhase(Key key, boolean lastPhase) throws InvalidKeyException, IllegalStateException {
        if (this.privKey == null) {
            throw new IllegalStateException("EC Diffie-Hellman not initialised.");
        }
        if (!lastPhase) {
            throw new IllegalStateException("EC Diffie-Hellman can only be between two parties.");
        }
        if (!(key instanceof ECPublicKey)) {
            throw new InvalidKeyException("EC Key Agreement doPhase requires ECPublicKey");
        }
        AsymmetricKeyParameter pubKey = ECUtil.generatePublicKeyParameter((PublicKey)key);
        this.result = this.agreement.calculateAgreement(pubKey);
        return null;
    }

    @Override
    protected byte[] engineGenerateSecret() throws IllegalStateException {
        return this.bigIntToBytes(this.result);
    }

    @Override
    protected int engineGenerateSecret(byte[] sharedSecret, int offset) throws IllegalStateException, ShortBufferException {
        byte[] secret = this.bigIntToBytes(this.result);
        if (sharedSecret.length - offset < secret.length) {
            throw new ShortBufferException("ECKeyAgreement - buffer too short");
        }
        System.arraycopy(secret, 0, sharedSecret, offset, secret.length);
        return secret.length;
    }

    @Override
    protected SecretKey engineGenerateSecret(String algorithm) throws NoSuchAlgorithmException {
        if (this.kdf != null) {
            if (!algorithms.containsKey(algorithm)) {
                throw new NoSuchAlgorithmException("unknown algorithm encountered: " + algorithm);
            }
            int keySize = (Integer)algorithms.get(algorithm);
            DHKDFParameters params = new DHKDFParameters(new DERObjectIdentifier(algorithm), keySize, this.bigIntToBytes(this.result));
            byte[] keyBytes = new byte[keySize / 8];
            this.kdf.init(params);
            this.kdf.generateBytes(keyBytes, 0, keyBytes.length);
            return new SecretKeySpec(keyBytes, algorithm);
        }
        return new SecretKeySpec(this.bigIntToBytes(this.result), algorithm);
    }

    @Override
    protected void engineInit(Key key, AlgorithmParameterSpec params, SecureRandom random) throws InvalidKeyException, InvalidAlgorithmParameterException {
        if (!(key instanceof ECPrivateKey)) {
            throw new InvalidKeyException("ECKeyAgreement requires ECPrivateKey for initialisation");
        }
        this.privKey = (ECPrivateKeyParameters)ECUtil.generatePrivateKeyParameter((PrivateKey)key);
        this.agreement.init(this.privKey);
    }

    @Override
    protected void engineInit(Key key, SecureRandom random) throws InvalidKeyException {
        if (!(key instanceof ECPrivateKey)) {
            throw new InvalidKeyException("ECKeyAgreement requires ECPrivateKey");
        }
        this.privKey = (ECPrivateKeyParameters)ECUtil.generatePrivateKeyParameter((PrivateKey)key);
        this.agreement.init(this.privKey);
    }

    static {
        Integer i128 = new Integer(128);
        Integer i192 = new Integer(192);
        Integer i256 = new Integer(256);
        algorithms.put(NISTObjectIdentifiers.id_aes128_CBC.getId(), i128);
        algorithms.put(NISTObjectIdentifiers.id_aes192_CBC.getId(), i192);
        algorithms.put(NISTObjectIdentifiers.id_aes256_CBC.getId(), i256);
        algorithms.put(NISTObjectIdentifiers.id_aes128_wrap.getId(), i128);
        algorithms.put(NISTObjectIdentifiers.id_aes192_wrap.getId(), i192);
        algorithms.put(NISTObjectIdentifiers.id_aes256_wrap.getId(), i256);
        algorithms.put(PKCSObjectIdentifiers.id_alg_CMS3DESwrap.getId(), i192);
    }

    public static class DHwithSHA1KDF
    extends KeyAgreement {
        public DHwithSHA1KDF() {
            super(new ECDHBasicAgreement(), new ECDHKEKGenerator(new SHA1Digest()));
        }
    }

    public static class DHC
    extends KeyAgreement {
        public DHC() {
            super(new ECDHCBasicAgreement());
        }
    }

    public static class DH
    extends KeyAgreement {
        public DH() {
            super(new ECDHBasicAgreement());
        }
    }
}

