/*
 * Decompiled with CFR 0.152.
 */
package xjyb.org.bjca.jce.provider.symmetric;

import java.io.IOException;
import java.security.AlgorithmParameters;
import java.security.InvalidAlgorithmParameterException;
import java.security.SecureRandom;
import java.security.spec.AlgorithmParameterSpec;
import java.security.spec.InvalidParameterSpecException;
import javax.crypto.spec.IvParameterSpec;
import xjyb.org.bjca.asn1.ASN1InputStream;
import xjyb.org.bjca.asn1.misc.CAST5CBCParameters;
import xjyb.org.bjca.crypto.CipherKeyGenerator;
import xjyb.org.bjca.crypto.engines.CAST5Engine;
import xjyb.org.bjca.crypto.modes.CBCBlockCipher;
import xjyb.org.bjca.jce.provider.JCEBlockCipher;
import xjyb.org.bjca.jce.provider.JCEKeyGenerator;
import xjyb.org.bjca.jce.provider.JDKAlgorithmParameterGenerator;
import xjyb.org.bjca.jce.provider.JDKAlgorithmParameters;

public final class CAST5 {
    private CAST5() {
    }

    public static class AlgParams
    extends JDKAlgorithmParameters {
        private byte[] iv;
        private int keyLength = 128;

        @Override
        protected byte[] engineGetEncoded() {
            byte[] tmp = new byte[this.iv.length];
            System.arraycopy(this.iv, 0, tmp, 0, this.iv.length);
            return tmp;
        }

        @Override
        protected byte[] engineGetEncoded(String format) throws IOException {
            if (this.isASN1FormatString(format)) {
                return new CAST5CBCParameters(this.engineGetEncoded(), this.keyLength).getEncoded();
            }
            if (format.equals("RAW")) {
                return this.engineGetEncoded();
            }
            return null;
        }

        @Override
        protected AlgorithmParameterSpec localEngineGetParameterSpec(Class paramSpec) throws InvalidParameterSpecException {
            if (paramSpec == IvParameterSpec.class) {
                return new IvParameterSpec(this.iv);
            }
            throw new InvalidParameterSpecException("unknown parameter spec passed to CAST5 parameters object.");
        }

        @Override
        protected void engineInit(AlgorithmParameterSpec paramSpec) throws InvalidParameterSpecException {
            if (!(paramSpec instanceof IvParameterSpec)) {
                throw new InvalidParameterSpecException("IvParameterSpec required to initialise a CAST5 parameters algorithm parameters object");
            }
            this.iv = ((IvParameterSpec)paramSpec).getIV();
        }

        @Override
        protected void engineInit(byte[] params) throws IOException {
            this.iv = new byte[params.length];
            System.arraycopy(params, 0, this.iv, 0, this.iv.length);
        }

        @Override
        protected void engineInit(byte[] params, String format) throws IOException {
            if (this.isASN1FormatString(format)) {
                ASN1InputStream aIn = new ASN1InputStream(params);
                CAST5CBCParameters p = CAST5CBCParameters.getInstance(aIn.readObject());
                this.keyLength = p.getKeyLength();
                this.iv = p.getIV();
                return;
            }
            if (format.equals("RAW")) {
                this.engineInit(params);
                return;
            }
            throw new IOException("Unknown parameters format in IV parameters object");
        }

        @Override
        protected String engineToString() {
            return "CAST5 Parameters";
        }
    }

    public static class AlgParamGen
    extends JDKAlgorithmParameterGenerator {
        @Override
        protected void engineInit(AlgorithmParameterSpec genParamSpec, SecureRandom random) throws InvalidAlgorithmParameterException {
            throw new InvalidAlgorithmParameterException("No supported AlgorithmParameterSpec for CAST5 parameter generation.");
        }

        @Override
        protected AlgorithmParameters engineGenerateParameters() {
            AlgorithmParameters params;
            byte[] iv = new byte[8];
            if (this.random == null) {
                this.random = new SecureRandom();
            }
            this.random.nextBytes(iv);
            try {
                params = AlgorithmParameters.getInstance("CAST5", "BC");
                params.init(new IvParameterSpec(iv));
            }
            catch (Exception e) {
                throw new RuntimeException(e.getMessage());
            }
            return params;
        }
    }

    public static class KeyGen
    extends JCEKeyGenerator {
        public KeyGen() {
            super("CAST5", 128, new CipherKeyGenerator());
        }
    }

    public static class CBC
    extends JCEBlockCipher {
        public CBC() {
            super(new CBCBlockCipher(new CAST5Engine()), 64);
        }
    }

    public static class ECB
    extends JCEBlockCipher {
        public ECB() {
            super(new CAST5Engine());
        }
    }
}

