/*
 * Decompiled with CFR 0.152.
 */
package xjyb.org.bjca.jce.provider.test;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.security.InvalidKeyException;
import java.security.Key;
import java.security.PrivateKey;
import java.security.PublicKey;
import java.security.Security;
import javax.crypto.Cipher;
import javax.crypto.CipherInputStream;
import javax.crypto.CipherOutputStream;
import javax.crypto.KeyGenerator;
import javax.crypto.SecretKey;
import javax.crypto.ShortBufferException;
import javax.crypto.spec.IvParameterSpec;
import javax.crypto.spec.SecretKeySpec;
import xjyb.org.bjca.jce.provider.BouncyCastleProvider;
import xjyb.org.bjca.util.encoders.Hex;
import xjyb.org.bjca.util.test.SimpleTest;

public class CipherStreamTest
extends SimpleTest {
    private static byte[] RK = Hex.decode("0123456789ABCDEF");
    private static byte[] RIN = Hex.decode("4e6f772069732074");
    private static byte[] ROUT = Hex.decode("3afbb5c77938280d");
    private static byte[] SIN = Hex.decode("00000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000");
    private static final byte[] SK = Hex.decode("80000000000000000000000000000000");
    private static final byte[] SIV = Hex.decode("0000000000000000");
    private static final byte[] SOUT = Hex.decode("4DFA5E481DA23EA09A31022050859936DA52FCEE218005164F267CB65F5CFD7F2B4F97E0FF16924A52DF269515110A07F9E460BC65EF95DA58F740B7D1DBB0AA");
    private static final byte[] HCIN = new byte[64];
    private static final byte[] HCIV = new byte[32];
    private static final byte[] HCK256A = new byte[32];
    private static final byte[] HC256A = Hex.decode("8589075b0df3f6d82fc0c5425179b6a63465f053f2891f808b24744e18480b72ec2792cdbf4dcfeb7769bf8dfa14aee47b4c50e8eaf3a9c8f506016c81697e32");
    private static final byte[] HCK128A = new byte[16];
    private static final byte[] HC128A = Hex.decode("731500823bfd03a0fb2fd77faa63af0ede122fc6a7dc29b662a685278b75ec689036db1e8189600500ade078491fbf9a1cdc30136c3d6e2490f664b29cd57102");

    private void runTest(String name) throws Exception {
        int c;
        String lCode = "ABCDEFGHIJKLMNOPQRSTUVWXY0123456789";
        KeyGenerator kGen = name.indexOf(47) < 0 ? KeyGenerator.getInstance(name, "BC") : KeyGenerator.getInstance(name.substring(0, name.indexOf(47)), "BC");
        Cipher in = Cipher.getInstance(name, "BC");
        Cipher out = Cipher.getInstance(name, "BC");
        SecretKey key = kGen.generateKey();
        ByteArrayInputStream bIn = new ByteArrayInputStream(lCode.getBytes());
        ByteArrayOutputStream bOut = new ByteArrayOutputStream();
        in.init(1, key);
        if (in.getIV() != null) {
            out.init(2, (Key)key, new IvParameterSpec(in.getIV()));
        } else {
            out.init(2, key);
        }
        CipherInputStream cIn = new CipherInputStream(bIn, in);
        CipherOutputStream cOut = new CipherOutputStream(bOut, out);
        while ((c = cIn.read()) >= 0) {
            cOut.write(c);
        }
        cIn.close();
        cOut.flush();
        cOut.close();
        String res = new String(bOut.toByteArray());
        if (!res.equals(lCode)) {
            this.fail("Failed - decrypted data doesn't match.");
        }
    }

    private void testAlgorithm(String name, byte[] keyBytes, byte[] iv, byte[] plainText, byte[] cipherText) throws Exception {
        byte[] dec;
        SecretKeySpec key = new SecretKeySpec(keyBytes, name);
        Cipher in = Cipher.getInstance(name, "BC");
        Cipher out = Cipher.getInstance(name, "BC");
        if (iv != null) {
            in.init(1, (Key)key, new IvParameterSpec(iv));
            out.init(2, (Key)key, new IvParameterSpec(iv));
        } else {
            in.init(1, key);
            out.init(2, key);
        }
        byte[] enc = in.doFinal(plainText);
        if (!this.areEqual(enc, cipherText)) {
            this.fail(name + ": cipher text doesn't match");
        }
        if (!this.areEqual(dec = out.doFinal(enc), plainText)) {
            this.fail(name + ": plain text doesn't match");
        }
    }

    private void testException(String name) {
        try {
            Key k;
            Cipher c;
            byte[] key128 = new byte[]{-128, -125, -123, -122, -119, -118, -116, -113, -128, -125, -123, -122, -119, -118, -116, -113};
            byte[] key256 = new byte[]{-128, -125, -123, -122, -119, -118, -116, -113, -128, -125, -123, -122, -119, -118, -116, -113, -128, -125, -123, -122, -119, -118, -116, -113, -128, -125, -123, -122, -119, -118, -116, -113};
            byte[] keyBytes = name.equals("HC256") ? key256 : key128;
            SecretKeySpec cipherKey = new SecretKeySpec(keyBytes, name);
            Cipher ecipher = Cipher.getInstance(name, "BC");
            ecipher.init(1, cipherKey);
            byte[] cipherText = new byte[]{};
            try {
                ecipher.update(new byte[20], 0, 20, cipherText);
                this.fail("failed exception test - no ShortBufferException thrown");
            }
            catch (ShortBufferException e) {
                // empty catch block
            }
            try {
                c = Cipher.getInstance(name, "BC");
                k = new PublicKey(){

                    @Override
                    public String getAlgorithm() {
                        return "STUB";
                    }

                    @Override
                    public String getFormat() {
                        return null;
                    }

                    @Override
                    public byte[] getEncoded() {
                        return null;
                    }
                };
                c.init(1, k);
                this.fail("failed exception test - no InvalidKeyException thrown for public key");
            }
            catch (InvalidKeyException e) {
                // empty catch block
            }
            try {
                c = Cipher.getInstance(name, "BC");
                k = new PrivateKey(){

                    @Override
                    public String getAlgorithm() {
                        return "STUB";
                    }

                    @Override
                    public String getFormat() {
                        return null;
                    }

                    @Override
                    public byte[] getEncoded() {
                        return null;
                    }
                };
                c.init(2, k);
                this.fail("failed exception test - no InvalidKeyException thrown for private key");
            }
            catch (InvalidKeyException e) {}
        }
        catch (Exception e) {
            this.fail("unexpected exception.", e);
        }
    }

    @Override
    public void performTest() throws Exception {
        this.runTest("RC4");
        this.testException("RC4");
        this.testAlgorithm("RC4", RK, null, RIN, ROUT);
        this.runTest("Salsa20");
        this.testException("Salsa20");
        this.testAlgorithm("Salsa20", SK, SIV, SIN, SOUT);
        this.runTest("HC128");
        this.testException("HC128");
        this.testAlgorithm("HC128", HCK128A, HCIV, HCIN, HC128A);
        this.runTest("HC256");
        this.testException("HC256");
        this.testAlgorithm("HC256", HCK256A, HCIV, HCIN, HC256A);
        this.runTest("VMPC");
        this.testException("VMPC");
        this.runTest("VMPC-KSA3");
        this.testException("VMPC-KSA3");
        this.runTest("DES/ECB/PKCS7Padding");
        this.runTest("DES/CFB8/NoPadding");
    }

    @Override
    public String getName() {
        return "CipherStreamTest";
    }

    public static void main(String[] args) {
        Security.addProvider(new BouncyCastleProvider());
        CipherStreamTest.runTest(new CipherStreamTest());
    }
}

