/*
 * Decompiled with CFR 0.152.
 */
package xjyb.org.bjca.jce.provider.test;

import java.security.AlgorithmParameters;
import java.security.Key;
import java.security.Security;
import java.security.spec.InvalidParameterSpecException;
import javax.crypto.Cipher;
import javax.crypto.Mac;
import javax.crypto.SecretKey;
import javax.crypto.SecretKeyFactory;
import javax.crypto.spec.IvParameterSpec;
import javax.crypto.spec.PBEKeySpec;
import javax.crypto.spec.PBEParameterSpec;
import javax.crypto.spec.SecretKeySpec;
import xjyb.org.bjca.crypto.Digest;
import xjyb.org.bjca.crypto.PBEParametersGenerator;
import xjyb.org.bjca.crypto.digests.SHA1Digest;
import xjyb.org.bjca.crypto.digests.SHA256Digest;
import xjyb.org.bjca.crypto.generators.OpenSSLPBEParametersGenerator;
import xjyb.org.bjca.crypto.generators.PKCS12ParametersGenerator;
import xjyb.org.bjca.crypto.params.KeyParameter;
import xjyb.org.bjca.crypto.params.ParametersWithIV;
import xjyb.org.bjca.jce.provider.BouncyCastleProvider;
import xjyb.org.bjca.util.encoders.Hex;
import xjyb.org.bjca.util.test.SimpleTest;

public class PBETest
extends SimpleTest {
    private PKCS12Test[] pkcs12Tests = new PKCS12Test[]{new PKCS12Test("DESede", "PBEWITHSHAAND3-KEYTRIPLEDES-CBC", new SHA1Digest(), 192, 64), new PKCS12Test("DESede", "PBEWITHSHAAND2-KEYTRIPLEDES-CBC", new SHA1Digest(), 128, 64), new PKCS12Test("RC4", "PBEWITHSHAAND128BITRC4", new SHA1Digest(), 128, 0), new PKCS12Test("RC4", "PBEWITHSHAAND40BITRC4", new SHA1Digest(), 40, 0), new PKCS12Test("RC2", "PBEWITHSHAAND128BITRC2-CBC", new SHA1Digest(), 128, 64), new PKCS12Test("RC2", "PBEWITHSHAAND40BITRC2-CBC", new SHA1Digest(), 40, 64), new PKCS12Test("AES", "PBEWithSHA1And128BitAES-CBC-BC", new SHA1Digest(), 128, 128), new PKCS12Test("AES", "PBEWithSHA1And192BitAES-CBC-BC", new SHA1Digest(), 192, 128), new PKCS12Test("AES", "PBEWithSHA1And256BitAES-CBC-BC", new SHA1Digest(), 256, 128), new PKCS12Test("AES", "PBEWithSHA256And128BitAES-CBC-BC", new SHA256Digest(), 128, 128), new PKCS12Test("AES", "PBEWithSHA256And192BitAES-CBC-BC", new SHA256Digest(), 192, 128), new PKCS12Test("AES", "PBEWithSHA256And256BitAES-CBC-BC", new SHA256Digest(), 256, 128), new PKCS12Test("Twofish", "PBEWithSHAAndTwofish-CBC", new SHA1Digest(), 256, 128), new PKCS12Test("IDEA", "PBEWithSHAAndIDEA-CBC", new SHA1Digest(), 128, 64)};
    private OpenSSLTest[] openSSLTests = new OpenSSLTest[]{new OpenSSLTest("AES", "PBEWITHMD5AND128BITAES-CBC-OPENSSL", 128, 128), new OpenSSLTest("AES", "PBEWITHMD5AND192BITAES-CBC-OPENSSL", 192, 128), new OpenSSLTest("AES", "PBEWITHMD5AND256BITAES-CBC-OPENSSL", 256, 128)};
    static byte[] message = Hex.decode("4869205468657265");
    private byte[] hMac1 = Hex.decode("bcc42174ccb04f425d9a5c8c4a95d6fd7c372911");
    private byte[] hMac2 = Hex.decode("cb1d8bdb6aca9e3fa8980d6eb41ab28a7eb2cfd6");

    private Cipher makePBECipherUsingParam(String algorithm, int mode, char[] password, byte[] salt, int iterationCount) throws Exception {
        PBEKeySpec pbeSpec = new PBEKeySpec(password);
        SecretKeyFactory keyFact = SecretKeyFactory.getInstance(algorithm, "BC");
        PBEParameterSpec defParams = new PBEParameterSpec(salt, iterationCount);
        Cipher cipher = Cipher.getInstance(algorithm, "BC");
        cipher.init(mode, (Key)keyFact.generateSecret(pbeSpec), defParams);
        return cipher;
    }

    private Cipher makePBECipherWithoutParam(String algorithm, int mode, char[] password, byte[] salt, int iterationCount) throws Exception {
        PBEKeySpec pbeSpec = new PBEKeySpec(password, salt, iterationCount);
        SecretKeyFactory keyFact = SecretKeyFactory.getInstance(algorithm, "BC");
        Cipher cipher = Cipher.getInstance(algorithm, "BC");
        cipher.init(mode, keyFact.generateSecret(pbeSpec));
        return cipher;
    }

    private boolean arrayEquals(byte[] a, byte[] b) {
        if (a.length != b.length) {
            return false;
        }
        for (int i = 0; i != a.length; ++i) {
            if (a[i] == b[i]) continue;
            return false;
        }
        return true;
    }

    public void testPBEHMac(String hmacName, byte[] output) {
        Mac mac;
        SecretKey key;
        try {
            SecretKeyFactory fact = SecretKeyFactory.getInstance(hmacName, "BC");
            key = fact.generateSecret(new PBEKeySpec("hello".toCharArray()));
            mac = Mac.getInstance(hmacName, "BC");
        }
        catch (Exception e) {
            this.fail("Failed - exception " + e.toString(), e);
            return;
        }
        try {
            mac.init(key, new PBEParameterSpec(new byte[20], 100));
        }
        catch (Exception e) {
            this.fail("Failed - exception " + e.toString(), e);
            return;
        }
        mac.reset();
        mac.update(message, 0, message.length);
        byte[] out = mac.doFinal();
        if (!this.arrayEquals(out, output)) {
            this.fail("Failed - expected " + new String(Hex.encode(output)) + " got " + new String(Hex.encode(out)));
        }
    }

    @Override
    public void performTest() throws Exception {
        int i;
        byte[] input = Hex.decode("1234567890abcdefabcdef1234567890fedbca098765");
        Cipher cEnc = Cipher.getInstance("DES/CBC/PKCS7Padding", "BC");
        cEnc.init(1, (Key)new SecretKeySpec(Hex.decode("30e69252758e5346"), "DES"), new IvParameterSpec(Hex.decode("7c1c1ab9c454a688")));
        byte[] out = cEnc.doFinal(input);
        char[] password = new char[]{'p', 'a', 's', 's', 'w', 'o', 'r', 'd'};
        Cipher cDec = this.makePBECipherUsingParam("PBEWithSHA1AndDES", 2, password, Hex.decode("7d60435f02e9e0ae"), 2048);
        byte[] in = cDec.doFinal(out);
        if (!this.arrayEquals(input, in)) {
            this.fail("DES failed");
        }
        if (!this.arrayEquals(input, in = (cDec = this.makePBECipherWithoutParam("PBEWithSHA1AndDES", 2, password, Hex.decode("7d60435f02e9e0ae"), 2048)).doFinal(out))) {
            this.fail("DES failed without param");
        }
        cEnc = Cipher.getInstance("DESede/CBC/PKCS7Padding", "BC");
        cEnc.init(1, (Key)new SecretKeySpec(Hex.decode("732f2d33c801732b7206756cbd44f9c1c103ddd97c7cbe8e"), "DES"), new IvParameterSpec(Hex.decode("b07bf522c8d608b8")));
        out = cEnc.doFinal(input);
        cDec = this.makePBECipherUsingParam("PBEWithSHAAnd3-KeyTripleDES-CBC", 2, password, Hex.decode("7d60435f02e9e0ae"), 2048);
        in = cDec.doFinal(out);
        if (!this.arrayEquals(input, in)) {
            this.fail("DESede failed");
        }
        cEnc = Cipher.getInstance("RC2/CBC/PKCS7Padding", "BC");
        cEnc.init(1, (Key)new SecretKeySpec(Hex.decode("732f2d33c8"), "RC2"), new IvParameterSpec(Hex.decode("b07bf522c8d608b8")));
        out = cEnc.doFinal(input);
        cDec = this.makePBECipherUsingParam("PBEWithSHAAnd40BitRC2-CBC", 2, password, Hex.decode("7d60435f02e9e0ae"), 2048);
        in = cDec.doFinal(out);
        if (!this.arrayEquals(input, in)) {
            this.fail("RC2 failed");
        }
        cEnc = Cipher.getInstance("RC4", "BC");
        cEnc.init(1, new SecretKeySpec(Hex.decode("732f2d33c801732b7206756cbd44f9c1"), "RC4"));
        out = cEnc.doFinal(input);
        cDec = this.makePBECipherUsingParam("PBEWithSHAAnd128BitRC4", 2, password, Hex.decode("7d60435f02e9e0ae"), 2048);
        in = cDec.doFinal(out);
        if (!this.arrayEquals(input, in)) {
            this.fail("RC4 failed");
        }
        if (!this.arrayEquals(input, in = (cDec = this.makePBECipherWithoutParam("PBEWithSHAAnd128BitRC4", 2, password, Hex.decode("7d60435f02e9e0ae"), 2048)).doFinal(out))) {
            this.fail("RC4 failed without param");
        }
        for (i = 0; i != this.pkcs12Tests.length; ++i) {
            this.pkcs12Tests[i].perform();
        }
        for (i = 0; i != this.openSSLTests.length; ++i) {
            this.openSSLTests[i].perform();
        }
        this.testPBEHMac("PBEWithHMacSHA1", this.hMac1);
        this.testPBEHMac("PBEWithHMacRIPEMD160", this.hMac2);
    }

    @Override
    public String getName() {
        return "PBETest";
    }

    public static void main(String[] args) {
        Security.addProvider(new BouncyCastleProvider());
        PBETest.runTest(new PBETest());
    }

    private class PKCS12Test
    extends SimpleTest {
        char[] password;
        String baseAlgorithm;
        String algorithm;
        Digest digest;
        int keySize;
        int ivSize;

        PKCS12Test(String baseAlgorithm, String algorithm, Digest digest, int keySize, int ivSize) {
            this.password = algorithm.toCharArray();
            this.baseAlgorithm = baseAlgorithm;
            this.algorithm = algorithm;
            this.digest = digest;
            this.keySize = keySize;
            this.ivSize = ivSize;
        }

        @Override
        public String getName() {
            return "PKCS12PBE";
        }

        @Override
        public void performTest() throws Exception {
            Cipher c;
            byte[] salt = new byte[this.digest.getDigestSize()];
            int iCount = 100;
            this.digest.doFinal(salt, 0);
            PKCS12ParametersGenerator pGen = new PKCS12ParametersGenerator(this.digest);
            pGen.init(PBEParametersGenerator.PKCS12PasswordToBytes(this.password), salt, iCount);
            ParametersWithIV params = (ParametersWithIV)pGen.generateDerivedParameters(this.keySize, this.ivSize);
            SecretKeySpec encKey = new SecretKeySpec(((KeyParameter)params.getParameters()).getKey(), this.baseAlgorithm);
            if (this.baseAlgorithm.equals("RC4")) {
                c = Cipher.getInstance(this.baseAlgorithm, "BC");
                c.init(1, encKey);
            } else {
                c = Cipher.getInstance(this.baseAlgorithm + "/CBC/PKCS7Padding", "BC");
                c.init(1, (Key)encKey, new IvParameterSpec(params.getIV()));
            }
            byte[] enc = c.doFinal(salt);
            c = Cipher.getInstance(this.algorithm, "BC");
            PBEKeySpec keySpec = new PBEKeySpec(this.password, salt, iCount);
            SecretKeyFactory fact = SecretKeyFactory.getInstance(this.algorithm, "BC");
            c.init(2, fact.generateSecret(keySpec));
            byte[] dec = c.doFinal(enc);
            if (!PBETest.this.arrayEquals(salt, dec)) {
                this.fail("" + this.algorithm + "failed encryption/decryption test");
            }
            AlgorithmParameters param = this.checkParameters(c, salt, iCount);
            c = Cipher.getInstance(this.algorithm, "BC");
            keySpec = new PBEKeySpec(this.password);
            c.init(2, (Key)fact.generateSecret(keySpec), param);
            this.checkParameters(c, salt, iCount);
            dec = c.doFinal(enc);
            if (!PBETest.this.arrayEquals(salt, dec)) {
                this.fail("" + this.algorithm + "failed encryption/decryption test");
            }
            c = Cipher.getInstance(this.algorithm, "BC");
            keySpec = new PBEKeySpec(this.password);
            c.init(2, (Key)fact.generateSecret(keySpec), param.getParameterSpec(PBEParameterSpec.class));
            this.checkParameters(c, salt, iCount);
            dec = c.doFinal(enc);
            if (!PBETest.this.arrayEquals(salt, dec)) {
                this.fail("" + this.algorithm + "failed encryption/decryption test");
            }
        }

        private AlgorithmParameters checkParameters(Cipher c, byte[] salt, int iCount) throws InvalidParameterSpecException {
            AlgorithmParameters param = c.getParameters();
            PBEParameterSpec spec = param.getParameterSpec(PBEParameterSpec.class);
            if (!PBETest.this.arrayEquals(salt, spec.getSalt())) {
                this.fail("" + this.algorithm + "failed salt test");
            }
            if (iCount != spec.getIterationCount()) {
                this.fail("" + this.algorithm + "failed count test");
            }
            return param;
        }
    }

    private class OpenSSLTest
    extends SimpleTest {
        char[] password;
        String baseAlgorithm;
        String algorithm;
        int keySize;
        int ivSize;

        OpenSSLTest(String baseAlgorithm, String algorithm, int keySize, int ivSize) {
            this.password = algorithm.toCharArray();
            this.baseAlgorithm = baseAlgorithm;
            this.algorithm = algorithm;
            this.keySize = keySize;
            this.ivSize = ivSize;
        }

        @Override
        public String getName() {
            return "OpenSSLPBE";
        }

        @Override
        public void performTest() throws Exception {
            Cipher c;
            byte[] salt = new byte[16];
            int iCount = 100;
            for (int i = 0; i != salt.length; ++i) {
                salt[i] = (byte)i;
            }
            OpenSSLPBEParametersGenerator pGen = new OpenSSLPBEParametersGenerator();
            pGen.init(PBEParametersGenerator.PKCS5PasswordToBytes(this.password), salt, iCount);
            ParametersWithIV params = (ParametersWithIV)pGen.generateDerivedParameters(this.keySize, this.ivSize);
            SecretKeySpec encKey = new SecretKeySpec(((KeyParameter)params.getParameters()).getKey(), this.baseAlgorithm);
            if (this.baseAlgorithm.equals("RC4")) {
                c = Cipher.getInstance(this.baseAlgorithm, "BC");
                c.init(1, encKey);
            } else {
                c = Cipher.getInstance(this.baseAlgorithm + "/CBC/PKCS7Padding", "BC");
                c.init(1, (Key)encKey, new IvParameterSpec(params.getIV()));
            }
            byte[] enc = c.doFinal(salt);
            c = Cipher.getInstance(this.algorithm, "BC");
            PBEKeySpec keySpec = new PBEKeySpec(this.password, salt, iCount);
            SecretKeyFactory fact = SecretKeyFactory.getInstance(this.algorithm, "BC");
            c.init(2, fact.generateSecret(keySpec));
            byte[] dec = c.doFinal(enc);
            if (!PBETest.this.arrayEquals(salt, dec)) {
                this.fail("" + this.algorithm + "failed encryption/decryption test");
            }
        }
    }
}

