/*
 * Decompiled with CFR 0.152.
 */
package xjyb.org.bjca.mozilla;

import java.io.ByteArrayInputStream;
import java.security.InvalidKeyException;
import java.security.KeyFactory;
import java.security.NoSuchAlgorithmException;
import java.security.NoSuchProviderException;
import java.security.PublicKey;
import java.security.Signature;
import java.security.SignatureException;
import java.security.spec.InvalidKeySpecException;
import java.security.spec.X509EncodedKeySpec;
import xjyb.org.bjca.asn1.ASN1Encodable;
import xjyb.org.bjca.asn1.ASN1InputStream;
import xjyb.org.bjca.asn1.ASN1Sequence;
import xjyb.org.bjca.asn1.DERBitString;
import xjyb.org.bjca.asn1.DERObject;
import xjyb.org.bjca.asn1.mozilla.PublicKeyAndChallenge;
import xjyb.org.bjca.asn1.x509.AlgorithmIdentifier;
import xjyb.org.bjca.asn1.x509.SubjectPublicKeyInfo;

public class SignedPublicKeyAndChallenge
extends ASN1Encodable {
    private ASN1Sequence spkacSeq;
    private PublicKeyAndChallenge pkac;
    private AlgorithmIdentifier signatureAlgorithm;
    private DERBitString signature;

    private static ASN1Sequence toDERSequence(byte[] bytes) {
        try {
            ByteArrayInputStream bIn = new ByteArrayInputStream(bytes);
            ASN1InputStream aIn = new ASN1InputStream(bIn);
            return (ASN1Sequence)aIn.readObject();
        }
        catch (Exception e) {
            throw new IllegalArgumentException("badly encoded request");
        }
    }

    public SignedPublicKeyAndChallenge(byte[] bytes) {
        this.spkacSeq = SignedPublicKeyAndChallenge.toDERSequence(bytes);
        this.pkac = PublicKeyAndChallenge.getInstance(this.spkacSeq.getObjectAt(0));
        this.signatureAlgorithm = AlgorithmIdentifier.getInstance(this.spkacSeq.getObjectAt(1));
        this.signature = (DERBitString)this.spkacSeq.getObjectAt(2);
    }

    @Override
    public DERObject toASN1Object() {
        return this.spkacSeq;
    }

    public PublicKeyAndChallenge getPublicKeyAndChallenge() {
        return this.pkac;
    }

    public boolean verify() throws NoSuchAlgorithmException, SignatureException, NoSuchProviderException, InvalidKeyException {
        return this.verify(null);
    }

    public boolean verify(String provider) throws NoSuchAlgorithmException, SignatureException, NoSuchProviderException, InvalidKeyException {
        Signature sig = null;
        sig = provider == null ? Signature.getInstance(this.signatureAlgorithm.getObjectId().getId()) : Signature.getInstance(this.signatureAlgorithm.getObjectId().getId(), provider);
        PublicKey pubKey = this.getPublicKey(provider);
        sig.initVerify(pubKey);
        DERBitString pkBytes = new DERBitString(this.pkac);
        sig.update(pkBytes.getBytes());
        return sig.verify(this.signature.getBytes());
    }

    public PublicKey getPublicKey(String provider) throws NoSuchAlgorithmException, NoSuchProviderException, InvalidKeyException {
        SubjectPublicKeyInfo subjectPKInfo = this.pkac.getSubjectPublicKeyInfo();
        try {
            DERBitString bStr = new DERBitString(subjectPKInfo);
            X509EncodedKeySpec xspec = new X509EncodedKeySpec(bStr.getBytes());
            AlgorithmIdentifier keyAlg = subjectPKInfo.getAlgorithmId();
            KeyFactory factory = KeyFactory.getInstance(keyAlg.getObjectId().getId(), provider);
            return factory.generatePublic(xspec);
        }
        catch (InvalidKeySpecException e) {
            throw new InvalidKeyException("error encoding public key");
        }
    }
}

