/*
 * Decompiled with CFR 0.152.
 */
package xjyb.org.bjca.sm2soft;

import xjyb.com.sansec.device.local.Card;
import xjyb.org.bjca.crypto.signers.SM2Signer;
import xjyb.org.bjca.util.ByteArrayUtil;
import xjyb.org.bjca.util.MathUtil;

public class SM2Algorithm
extends Card {
    private static SM2Algorithm sm2Alg = null;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static SM2Algorithm getInstance() {
        String provider = "smximpl";
        if (sm2Alg != null) return sm2Alg;
        Class<SM2Algorithm> clazz = SM2Algorithm.class;
        synchronized (SM2Algorithm.class) {
            if (sm2Alg != null) return sm2Alg;
            sm2Alg = new SM2Algorithm();
            try {
                System.loadLibrary(provider);
            }
            catch (UnsatisfiedLinkError e) {
                System.out.println("native lib  not found in java.library.path: " + System.getProperty("java.library.path"));
            }
            int rv = sm2Alg.openDevice();
            if (rv == 0) return sm2Alg;
            System.err.println("open device failed, rv[0x" + Integer.toHexString(rv) + "]");
            // ** MonitorExit[var1_1] (shouldn't be in output)
            return null;
        }
    }

    @Override
    public native int openDevice();

    @Override
    public native int closeDevice();

    @Override
    public native byte[] externalSign(int var1, byte[] var2, byte[] var3);

    @Override
    public native byte[] externalVerify(int var1, byte[] var2, byte[] var3, byte[] var4);

    @Override
    public byte[] sm2GenKeyPair() {
        byte[] allKeyPairData = new byte[100];
        byte[] stateData = ByteArrayUtil.intToByte(0);
        SM2Signer sm2 = new SM2Signer();
        byte[] keypair = sm2.genKeyPair();
        System.arraycopy(stateData, 0, allKeyPairData, 0, 4);
        System.arraycopy(keypair, 0, allKeyPairData, 4, 96);
        return allKeyPairData;
    }

    @Override
    public native byte[] sm2ExternalSign(int var1, byte[] var2, byte[] var3);

    @Override
    public native byte[] sm2ExternalVerify(int var1, byte[] var2, byte[] var3, byte[] var4);

    @Override
    public native byte[] sm3Hash(byte[] var1, byte[] var2, byte[] var3);

    @Override
    public native byte[] sm2ExternalEncrypt(byte[] var1, byte[] var2);

    @Override
    public native byte[] sm2ExternalDecrypt(byte[] var1, byte[] var2);

    @Override
    public native byte[] encrypt(int var1, boolean var2, byte[] var3, byte[] var4, byte[] var5);

    @Override
    public native byte[] decrypt(int var1, boolean var2, byte[] var3, byte[] var4, byte[] var5);

    private void testSM2Algorithm() {
        byte[] sm2_pubkey = new byte[]{-58, -5, 43, 38, -51, 79, -115, -110, 2, -28, -122, -17, -89, 13, 91, 102, 58, 117, 47, -118, 12, 115, -86, 21, -20, -102, -76, -80, 23, -75, -38, 21, -37, 104, 59, -84, 69, 9, 0, -124, 14, 52, 2, 102, 87, -78, -99, 92, 90, -67, 86, 18, -23, -114, -116, 58, 86, -16, 9, 110, 40, -91, 63, -93};
        byte[] sm2_prikey = new byte[]{11, 27, 4, 65, -100, 28, -23, -107, 30, 53, 27, -79, 125, 79, 28, 99, -119, -83, -57, -20, 122, 47, -66, 71, 14, 77, -18, -92, -106, 115, -11, 20};
        byte[] userid = new byte[]{49, 50, 51, 52, 53, 54, 55, 56, 49, 50, 51, 52, 53, 54, 55, 56};
        SM2Algorithm sm2 = new SM2Algorithm();
        byte[] plaintext = new byte[]{49, 50, 51, 52, 53, 54, 55, 56};
        byte[] retval = sm2.sm3Hash(plaintext, sm2_pubkey, userid);
        if (retval[3] != 0) {
            System.out.println("sm3Hash error");
            return;
        }
        System.out.println("sm3Hash OK");
        byte[] sm3val = new byte[retval.length - 4];
        System.arraycopy(retval, 4, sm3val, 0, sm3val.length);
        byte[] sigval = sm2.sm2ExternalSign(0, sm3val, sm2_prikey);
        byte iret = sigval[3];
        if (iret == 0) {
            System.out.println("Sign OK!");
            for (int i = 0; i < 10; ++i) {
                sigval = sm2.sm2ExternalSign(0, sm3val, sm2_prikey);
                System.out.println("Sign OK - " + i + " !");
            }
            retval = new byte[sigval.length - 4];
            System.arraycopy(sigval, 4, retval, 0, retval.length);
            byte[] vfy = sm2.sm2ExternalVerify(0, sm3val, retval, sm2_pubkey);
            iret = vfy[3];
            if (iret == 0) {
                System.out.println("Sign and verify OK!");
            } else {
                System.out.println("verify Error!");
            }
        } else {
            System.out.println("Sign Error!");
        }
        byte[] sm2encrypt = sm2.sm2ExternalEncrypt(sm2_pubkey, plaintext);
        byte encryptret = sm2encrypt[3];
        if (encryptret == 0) {
            System.out.println("sm2encrypt OK!");
            byte[] encryptval = new byte[sm2encrypt.length - 4];
            System.arraycopy(sm2encrypt, 4, encryptval, 0, encryptval.length);
            byte[] vfy = sm2.sm2ExternalDecrypt(sm2_prikey, encryptval);
            iret = vfy[3];
            if (iret == 0) {
                System.out.println("sm2encrypt and sm2decrypt OK!");
            } else {
                System.out.println("sm2decrypt Error!");
            }
        } else {
            System.out.println("sm2encrypt Error!");
        }
        byte[] sm4encrypt = sm2.encrypt(4098, true, userid, userid, plaintext);
        byte sm4encryptret = sm4encrypt[3];
        if (sm4encryptret == 0) {
            System.out.println("sm4encrypt OK!");
            byte[] encryptval = new byte[sm4encrypt.length - 4];
            System.arraycopy(sm4encrypt, 4, encryptval, 0, encryptval.length);
            byte[] vfy = sm2.decrypt(4098, true, userid, userid, encryptval);
            int rv = MathUtil.byte2int(vfy, 0);
            byte[] enData = null;
            if (rv != 0) {
                System.out.println("sm4decrypt Error!");
            } else {
                enData = new byte[vfy.length - 4];
                System.arraycopy(vfy, 4, enData, 0, enData.length);
                System.out.println("sm4encrypt and sm4decrypt OK!" + enData.length);
            }
        } else {
            System.out.println("sm4encrypt Error!");
        }
    }

    public static void main(String[] args) {
        try {
            System.loadLibrary("smximpl");
            SM2Algorithm sm2 = new SM2Algorithm();
            int ret = sm2.openDevice();
            if (ret != 0) {
                System.out.println("call sm2::openDevice() error");
                return;
            }
            sm2.testSM2Algorithm();
            sm2.closeDevice();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }
}

