/*
 * Decompiled with CFR 0.152.
 */
package xjyb.org.bjca.util;

import java.io.ByteArrayInputStream;
import java.text.SimpleDateFormat;
import org.bouncycastle.asn1.cms.CMSAttributes;
import xjyb.org.bjca.asn1.ASN1EncodableVector;
import xjyb.org.bjca.asn1.ASN1Object;
import xjyb.org.bjca.asn1.ASN1Set;
import xjyb.org.bjca.asn1.ASN1TaggedObject;
import xjyb.org.bjca.asn1.DERConstructedSequence;
import xjyb.org.bjca.asn1.DERConstructedSet;
import xjyb.org.bjca.asn1.DEREncodable;
import xjyb.org.bjca.asn1.DERInputStream;
import xjyb.org.bjca.asn1.DERObjectIdentifier;
import xjyb.org.bjca.asn1.DEROctetString;
import xjyb.org.bjca.asn1.DERSet;
import xjyb.org.bjca.asn1.DERTaggedObject;
import xjyb.org.bjca.asn1.DERUTCTime;
import xjyb.org.bjca.util.encoders.Base64;

public class GetP7InfoUtil {
    public static DERConstructedSequence getUnauthAttrs(byte[] p7sign) throws Exception {
        DERInputStream derInputStream = new DERInputStream(new ByteArrayInputStream(p7sign));
        if (derInputStream == null) {
            return null;
        }
        DERConstructedSequence whole = (DERConstructedSequence)derInputStream.readObject();
        if (whole == null) {
            return null;
        }
        DERTaggedObject tagObj = (DERTaggedObject)whole.getObjectAt(1);
        if (tagObj == null) {
            return null;
        }
        DERConstructedSequence body = (DERConstructedSequence)tagObj.getObject();
        if (body == null) {
            return null;
        }
        DERConstructedSet signerinfos = (DERConstructedSet)body.getObjectAt(4);
        if (signerinfos == null) {
            return null;
        }
        DERConstructedSequence signerinfo = (DERConstructedSequence)signerinfos.getObjectAt(0);
        if (signerinfo == null) {
            return null;
        }
        DEREncodable object = signerinfo.getObjectAt(signerinfo.size() - 1);
        DERTaggedObject contextObjOne = null;
        if (object instanceof DERTaggedObject && (contextObjOne = (DERTaggedObject)object).getTagNo() == 1) {
            DERConstructedSequence tmpObject = (DERConstructedSequence)contextObjOne.getObject();
            return tmpObject;
        }
        return null;
    }

    public static String[] getAttrsFromP7(byte[] p7sign) throws Exception {
        String[] attrsStrings = new String[3];
        byte[][] infos = GetP7InfoUtil.getAttributeSignValueAndCert(p7sign);
        if (infos != null && infos.length >= 3) {
            ByteArrayInputStream byteArrayInputStream = new ByteArrayInputStream(infos[2]);
            if (byteArrayInputStream == null) {
                throw new Exception("construct ByteArrayInputStream is null");
            }
            DERInputStream derInputStream = new DERInputStream(byteArrayInputStream);
            if (derInputStream == null) {
                throw new Exception("construct DERInputStream is null");
            }
            DERConstructedSet derSet = (DERConstructedSet)derInputStream.readObject();
            if (derSet == null) {
                throw new Exception("get DERConstructedSet is null");
            }
            for (int i = 0; i < derSet.getSize(); ++i) {
                DERConstructedSequence attrSequence = (DERConstructedSequence)derSet.getObjectAt(i);
                DERObjectIdentifier derObjectIdentifier = (DERObjectIdentifier)attrSequence.getObjectAt(0);
                if (attrSequence == null) continue;
                DERConstructedSet attrSet = (DERConstructedSet)attrSequence.getObjectAt(1);
                if (CMSAttributes.contentType.getId().equals(derObjectIdentifier.getId())) {
                    DERObjectIdentifier contentTypeIdentifier = (DERObjectIdentifier)attrSet.getObjectAt(0);
                    attrsStrings[0] = contentTypeIdentifier.toString();
                    continue;
                }
                if (CMSAttributes.signingTime.getId().equals(derObjectIdentifier.getId())) {
                    DERUTCTime utcTime = (DERUTCTime)attrSet.getObjectAt(0);
                    SimpleDateFormat dateFormat = new SimpleDateFormat("yyyyMMddHHmmss");
                    attrsStrings[1] = dateFormat.format(utcTime.getDate());
                    continue;
                }
                if (!CMSAttributes.messageDigest.getId().equals(derObjectIdentifier.getId())) continue;
                DEROctetString derOctetString = (DEROctetString)attrSet.getObjectAt(0);
                attrsStrings[2] = Base64.encode_str(derOctetString.getOctets());
            }
        }
        return attrsStrings;
    }

    public static byte[][] getAttributeSignValueAndCert(byte[] p7sign) throws Exception {
        DERConstructedSequence derSequence2;
        ASN1Object derSequence;
        byte[][] rets = new byte[6][];
        DERInputStream derInputStream = new DERInputStream(new ByteArrayInputStream(p7sign));
        if (derInputStream == null) {
            return null;
        }
        DERConstructedSequence whole = (DERConstructedSequence)derInputStream.readObject();
        if (whole == null) {
            return null;
        }
        DERTaggedObject tagObj = (DERTaggedObject)whole.getObjectAt(1);
        if (tagObj == null) {
            return null;
        }
        DERConstructedSequence body = (DERConstructedSequence)tagObj.getObject();
        if (body == null) {
            return null;
        }
        DERConstructedSequence contextObj = (DERConstructedSequence)body.getObjectAt(2);
        if (contextObj != null && contextObj.size() >= 2) {
            DERTaggedObject cxtDerTaggedObject = (DERTaggedObject)contextObj.getObjectAt(1);
            DEROctetString derOctetString = (DEROctetString)cxtDerTaggedObject.getObject();
            rets[4] = derOctetString.getOctets();
        }
        DERTaggedObject certObj = (DERTaggedObject)body.getObjectAt(3);
        DERConstructedSequence dercertificates = (DERConstructedSequence)certObj.getObject();
        rets[0] = dercertificates.getEncoded();
        DERConstructedSet signerinfos = (DERConstructedSet)body.getObjectAt(4);
        if (signerinfos == null) {
            return null;
        }
        DERConstructedSequence signerinfo = (DERConstructedSequence)signerinfos.getObjectAt(0);
        if (signerinfo == null) {
            return null;
        }
        if (signerinfo.size() >= 6) {
            DEROctetString digest = null;
            DEREncodable signObj = signerinfo.getObjectAt(5);
            if (signObj instanceof DEROctetString) {
                digest = (DEROctetString)signObj;
            } else {
                signObj = signerinfo.getObjectAt(4);
                if (signObj instanceof DEROctetString) {
                    digest = (DEROctetString)signObj;
                }
            }
            if (digest == null) {
                return null;
            }
            rets[1] = digest.getOctets();
        } else {
            rets[1] = null;
        }
        DEREncodable object = signerinfo.getObjectAt(3);
        if (object instanceof DERTaggedObject) {
            derSequence = (DERTaggedObject)object;
            derSequence2 = (DERConstructedSequence)((ASN1TaggedObject)derSequence).getObject();
            if (derSequence2 != null) {
                DERConstructedSequence attribute;
                ASN1EncodableVector attributeVector = new ASN1EncodableVector();
                for (int i = 0; i < derSequence2.size(); ++i) {
                    attributeVector.add(derSequence2.getObjectAt(i));
                    attribute = (DERConstructedSequence)derSequence2.getObjectAt(i);
                    DERObjectIdentifier derObjectIdentifier = (DERObjectIdentifier)attribute.getObjectAt(0);
                    if (!xjyb.org.bjca.asn1.cms.CMSAttributes.messageDigest.getId().equals(derObjectIdentifier.getId())) continue;
                    DERConstructedSet derSet = (DERConstructedSet)attribute.getObjectAt(1);
                    DEROctetString derOctetString = (DEROctetString)derSet.getObjectAt(0);
                    rets[3] = derOctetString.getOctets();
                }
                DERSet derRSet = new DERSet(attributeVector, false);
                rets[2] = derRSet.getDEREncoded();
                if (derSequence2.size() <= 2 && derSequence2.size() == 2) {
                    attribute = (DERConstructedSequence)derSequence2.getObjectAt(1);
                    DERConstructedSet derSet = (DERConstructedSet)attribute.getObjectAt(1);
                    DEROctetString derOctetString = (DEROctetString)derSet.getObjectAt(0);
                    rets[3] = derOctetString.getOctets();
                }
            }
        } else if (object instanceof DERConstructedSet) {
            derSequence = (DERConstructedSet)object;
            rets[2] = derSequence.getEncoded();
            derSequence2 = (DERConstructedSequence)((ASN1Set)derSequence).getObjectAt(2);
            if (derSequence2 != null) {
                DERConstructedSet derSet = (DERConstructedSet)derSequence2.getObjectAt(1);
                DEROctetString derOctetString = (DEROctetString)derSet.getObjectAt(0);
                rets[3] = derOctetString.getOctets();
            }
        }
        if (signerinfo.size() >= 7) {
            DERTaggedObject dt = (DERTaggedObject)signerinfo.getObjectAt(6);
            if (dt == null) {
                return null;
            }
            DERConstructedSequence unauthenticatedAttributeSequence = (DERConstructedSequence)dt.getObject();
            DERConstructedSet timeStampSet = (DERConstructedSet)unauthenticatedAttributeSequence.getObjectAt(1);
            DERConstructedSequence timeStampConstructedSequence = (DERConstructedSequence)timeStampSet.getObjectAt(0);
            rets[5] = timeStampConstructedSequence.getEncoded();
        }
        return rets;
    }
}

