/*
 * Decompiled with CFR 0.152.
 */
package com.ygsoft.abc.mapp.ygca.ext;

import com.alibaba.fastjson.JSONObject;
import com.ygsoft.abc.mapp.ygca.exception.VerifyRuntimeException;
import com.ygsoft.abc.mapp.ygca.ext.ofd.OFDValidateProxyContainer2;
import com.ygsoft.abc.mapp.ygca.ext.pdf.PdfValidator;
import com.ygsoft.abc.mapp.ygca.gwcw.common.types.YesnoEnum;
import com.ygsoft.abc.mapp.ygca.gwcw.domain.vo.VerifyResultVO;
import com.ygsoft.abc.mapp.ygca.gwcw.impl.service.BizSignatureService;
import com.ygsoft.abc.mapp.ygca.gwcw.service.IBizSignatureService;
import com.ygsoft.abc.mapp.ygca.gwcw.validator.ofd.OFDValidateAbstractContainer;
import com.ygsoft.abc.mapp.ygca.gwcw.validator.ofd.OFDValidateUtil;
import java.util.HashMap;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class BizSignatureService2
extends BizSignatureService
implements IBizSignatureService {
    private static final Logger LOG = LoggerFactory.getLogger(BizSignatureService2.class);

    public VerifyResultVO verify(byte[] fileData, String fileType, Map<String, String> optionalParam) {
        if (fileData == null) {
            throw new VerifyRuntimeException("\u53c2\u6570\u9519\u8bef\uff1afileData\u4e3a\u7a7a\u3002");
        }
        if ("ofd".equalsIgnoreCase(fileType)) {
            return this.verifyOFD(fileData, optionalParam);
        }
        if ("ofd2".equalsIgnoreCase(fileType)) {
            return this.verifyOFDbyAllType(fileData);
        }
        if ("pdf".equalsIgnoreCase(fileType)) {
            return PdfValidator.verifyPdf(fileData);
        }
        if ("zip".equalsIgnoreCase(fileType)) {
            return this.verifyZip(fileData);
        }
        throw new VerifyRuntimeException("\u4e0d\u652f\u6301\u7684\u6587\u4ef6\u7c7b\u578b");
    }

    public VerifyResultVO verifyOFD(byte[] fileData, Map<String, String> extraData) {
        OFDValidateProxyContainer2 validateAbstractContainer = new OFDValidateProxyContainer2();
        validateAbstractContainer.setFileData(fileData);
        if (extraData != null) {
            validateAbstractContainer.getExtraData().putAll(extraData);
        }
        return OFDValidateUtil.verifyOfd((byte[])fileData, (OFDValidateAbstractContainer)validateAbstractContainer);
    }

    public VerifyResultVO verifyOFDbyAllType(byte[] fileData) {
        HashMap<String, String> extraData;
        VerifyResultVO targetResult = null;
        try {
            extraData = new HashMap<String, String>();
            extraData.put("issued", "local");
            targetResult = this.verifyOFD(fileData, extraData);
            LOG.info("\u6807\u51c6\u9a8c\u7b7e\u65b9\u6848 SUCCESS result:" + JSONObject.toJSONString((Object)targetResult));
        }
        catch (Exception e) {
            LOG.warn("\u6807\u51c6\u9a8c\u7b7e\u65b9\u6848 FAIL result:" + e.getMessage(), (Throwable)e);
        }
        try {
            extraData = new HashMap();
            extraData.put("issued", "999");
            targetResult = this.verifyOFD(fileData, extraData);
            LOG.info("\u4e2d\u7535\u8d22\u9a8c\u7b7e\u65b9\u6848 SUCCESS result:" + JSONObject.toJSONString((Object)targetResult));
        }
        catch (Exception e) {
            LOG.warn("\u4e2d\u7535\u8d22\u9a8c\u7b7e\u65b9\u6848 FAIL result:" + e.getMessage(), (Throwable)e);
        }
        if (targetResult != null) {
            return targetResult;
        }
        return new VerifyResultVO(YesnoEnum.NO, "OFD\u9a8c\u7b7e\u5931\u8d25", null);
    }
}

