/*
 * Decompiled with CFR 0.152.
 */
package com.ygsoft.abc.mapp.ygca.ext.ofd.zhongdiancai;

import com.dianju.OFDVerifyUtil;
import com.dianju.Result;
import com.ygsoft.abc.mapp.ygca.ext.utils.OFDFileUtils;
import com.ygsoft.abc.mapp.ygca.ofdrw.core.signatures.SigType;
import com.ygsoft.abc.mapp.ygca.ofdrw.sign.verify.SignedDataValidateContainer;
import com.ygsoft.abc.mapp.ygca.ofdrw.sign.verify.exceptions.InvalidSignedValueException;
import java.io.File;
import java.io.IOException;
import java.security.GeneralSecurityException;
import java.util.ArrayList;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class OfdSealZdcValidator
implements SignedDataValidateContainer {
    private static final Logger LOG = LoggerFactory.getLogger(OfdSealZdcValidator.class);
    private final byte[] fileData;
    private static boolean init = false;
    private static boolean hasDoInit = false;

    public OfdSealZdcValidator(byte[] fileData) {
        this.fileData = fileData;
    }

    public static synchronized boolean init() {
        if (!(init || hasDoInit || System.getProperty("os.name").toLowerCase().contains("win"))) {
            try {
                Class.forName(OFDVerifyUtil.class.getName());
                init = true;
                LOG.info("\u4e2d\u7535\u8d22\u63d2\u4ef6\u521d\u59cb\u5316\u6210\u529f");
            }
            catch (Throwable e) {
                LOG.warn("\u4e2d\u7535\u8d22\u63d2\u4ef6\u521d\u59cb\u5316\u5931\u8d25", e);
            }
            finally {
                hasDoInit = true;
            }
        }
        return init;
    }

    public void validate(SigType type, String signAlgName, byte[] tbsContent, byte[] signedValue) throws InvalidSignedValueException, IOException, GeneralSecurityException {
        boolean hasInit;
        if (!init && !(hasInit = OfdSealZdcValidator.init())) {
            throw new InvalidSignedValueException("\u4e2d\u7535\u8d22\u63d2\u4ef6\u521d\u59cb\u5316\u5931\u8d25");
        }
        this.valid();
    }

    private synchronized void valid() throws InvalidSignedValueException {
        File file = null;
        try {
            file = OFDFileUtils.writeFile(this.fileData);
            ArrayList<File> files = new ArrayList<File>();
            files.add(file);
            Map resultMap = OFDVerifyUtil.OFDsVerify(files);
            Result zdcResult = null;
            if (resultMap != null && resultMap.keySet().size() > 0) {
                zdcResult = (Result)resultMap.values().iterator().next();
            }
            if (zdcResult == null) {
                LOG.warn("\u4e2d\u7535\u8d22\u9a8c\u7b7e\u65b9\u6848\u4e0d\u901a\u8fc7,\u8fd4\u56de\u4e3a\u7a7a");
                throw new InvalidSignedValueException("\u4e2d\u7535\u8d22\u9a8c\u7b7e\u65b9\u6848\u4e0d\u901a\u8fc7");
            }
            if (zdcResult.getCode() != 0) {
                LOG.warn(String.format("\u4e2d\u7535\u8d22\u9a8c\u7b7e\u65b9\u6848\u4e0d\u901a\u8fc7 result: %s", zdcResult.toString()));
                throw new InvalidSignedValueException(zdcResult.getMsg());
            }
        }
        catch (Throwable e) {
            if (e instanceof InvalidSignedValueException) {
                throw (InvalidSignedValueException)e;
            }
            throw new InvalidSignedValueException("\u4e2d\u7535\u8d22\u9a8c\u7b7e\u65b9\u6848\u5931\u8d25", e);
        }
        finally {
            if (file != null) {
                OFDFileUtils.deleteFile(file);
            }
        }
    }
}

