/*
 * Decompiled with CFR 0.152.
 */
package com.ygsoft.abc.mapp.ygca.ext.pdf.impl;

import com.itextpdf.text.pdf.AcroFields;
import com.itextpdf.text.pdf.PdfDictionary;
import com.itextpdf.text.pdf.PdfName;
import com.itextpdf.text.pdf.PdfString;
import com.itextpdf.text.pdf.RandomAccessFileOrArray;
import com.ygsoft.abc.mapp.ygca.ext.pdf.IPdfAlgorithm;
import com.ygsoft.abc.mapp.ygca.ext.pdf.PdfAlgorithmParseException;
import com.ygsoft.abc.mapp.ygca.ext.pdf.PdfAlgorithmValidException;
import com.ygsoft.abc.mapp.ygca.ext.pdf.impl.PdfValidateBase;
import com.ygsoft.abc.mapp.ygca.ofdrw.gm.ses.v4.SES_Signature;
import com.ygsoft.abc.mapp.ygca.ofdrw.gm.ses.v4.TBS_Sign;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.security.InvalidKeyException;
import java.security.NoSuchAlgorithmException;
import java.security.NoSuchProviderException;
import java.security.Provider;
import java.security.Security;
import java.security.Signature;
import java.security.SignatureException;
import java.security.cert.Certificate;
import java.security.cert.CertificateException;
import java.security.cert.CertificateFactory;
import java.security.cert.X509Certificate;
import org.bouncycastle162.asn1.ASN1InputStream;
import org.bouncycastle162.asn1.ASN1Sequence;
import org.bouncycastle162.jce.provider.BouncyCastleProvider;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class PdfSxxhAlgorithm
extends PdfValidateBase
implements IPdfAlgorithm {
    private static final Logger LOG = LoggerFactory.getLogger(PdfSxxhAlgorithm.class);
    private byte[] digest;
    private Signature sg;

    public PdfSxxhAlgorithm(RandomAccessFileOrArray originalPDF, AcroFields acroFields, String signatureName) {
        super(originalPDF, acroFields, signatureName);
    }

    @Override
    public String getValidateName() {
        return "\u9655\u897f\u4fe1\u5408\u7968\u636epdf\u9a8c\u7b7e\u7b97\u6cd5";
    }

    @Override
    public Certificate parse() throws PdfAlgorithmParseException {
        PdfDictionary pdfDictionary = this.getAcroFields().getSignatureDictionary(this.getSignatureName());
        PdfString contents = pdfDictionary.getAsString(PdfName.CONTENTS);
        ASN1InputStream asn1InputStream = new ASN1InputStream(contents.getBytes());
        ASN1Sequence seq = null;
        try {
            seq = (ASN1Sequence)asn1InputStream.readObject();
        }
        catch (IOException e) {
            throw new PdfAlgorithmParseException("asn1InputStream\u6587\u4ef6\u8bfb\u53d6\u9519\u8bef");
        }
        try {
            asn1InputStream.close();
        }
        catch (IOException e) {
            throw new PdfAlgorithmParseException("asn1InputStream\u6587\u4ef6\u5173\u95ed\u9519\u8bef");
        }
        SES_Signature sesSignature = null;
        try {
            sesSignature = SES_Signature.getInstance((Object)seq.getEncoded());
        }
        catch (IOException e) {
            throw new PdfAlgorithmParseException("SES_Signature\u5b9e\u4f8b\u5316\u9519\u8bef");
        }
        catch (IllegalArgumentException e) {
            throw new PdfAlgorithmParseException("SES_Signature\u5b9e\u4f8b\u5316\u9519\u8bef");
        }
        X509Certificate signCert = null;
        try {
            CertificateFactory cf = CertificateFactory.getInstance("X.509", "BC");
            signCert = (X509Certificate)cf.generateCertificate(new ByteArrayInputStream(sesSignature.getCert().getOctets()));
        }
        catch (CertificateException e) {
            throw new PdfAlgorithmParseException("CertificateException\u9519\u8bef");
        }
        catch (NoSuchProviderException e) {
            throw new PdfAlgorithmParseException("NoSuchProviderException\u9519\u8bef");
        }
        TBS_Sign toSign = sesSignature.getToSign();
        try {
            this.sg = Signature.getInstance(sesSignature.getSignatureAlgID().toString(), (Provider)new BouncyCastleProvider());
        }
        catch (NoSuchAlgorithmException e) {
            throw new PdfAlgorithmParseException("NoSuchAlgorithmException\u9519\u8bef");
        }
        try {
            this.sg.initVerify(signCert);
        }
        catch (InvalidKeyException e) {
            throw new PdfAlgorithmParseException("NoSuchAlgorithmException\u9519\u8bef");
        }
        try {
            this.sg.update(toSign.getEncoded("DER"));
        }
        catch (SignatureException e) {
            throw new PdfAlgorithmParseException("SignatureException\u9519\u8bef");
        }
        catch (IOException e) {
            throw new PdfAlgorithmParseException("IOException\u9519\u8bef");
        }
        this.digest = sesSignature.getSignature().getBytes();
        return signCert;
    }

    @Override
    public Boolean validate() throws PdfAlgorithmValidException, PdfAlgorithmParseException {
        boolean result = false;
        try {
            result = this.getSg().verify(this.getDigest());
        }
        catch (SignatureException e) {
            throw new PdfAlgorithmParseException(e);
        }
        return result;
    }

    public byte[] getDigest() {
        return this.digest;
    }

    public void setDigest(byte[] digest) {
        this.digest = digest;
    }

    public Signature getSg() {
        return this.sg;
    }

    public void setSg(Signature sg) {
        this.sg = sg;
    }

    static {
        Security.addProvider((Provider)new BouncyCastleProvider());
    }
}

