/**
 * UI扩展工具类.
 */
define(["jquery",
    "ecp.service",
    "ecp.utils",
    "ecp.component.loading"], function ($, ecp, ecpUtils, PageLoading) {
	
	'use strict'; //使用js语法严格模式(提高代码运行效率)
	var LOGIN_CONTEXT_KEY = "_login_context_key";
    // 本地浏览器存储生命周期一天（毫秒）
    var LOCAL_STORAGE_TIME = 24 * 3600 * 1000;
	var loading = new PageLoading();
	
	var ExtuiTool = function () {};
	ExtuiTool.prototype = {
        /**
         * 弹出提示
         * @param msg 提示信息
         * @param hasTrans  是否对msg中的<  >  进行转义，防止xss攻击    传入true转义，传入false或不传不转义
         */
        notify : function(msg, hasTrans){
        	if (hasTrans && hasTrans === true) {
        		ecpUtils.notify(msg);
        	} else {
        		// 以下代码是从平台代码中copy出来的，平台代码中增加了escapeAngleBrackets方法，将< >括号替换掉了，改方法去掉了escapeAngleBrackets方法
        		var e = msg;
        		var notifyMsgEle;
        		if (0 !== $(".alert.alert-info").length && notifyMsgEle && notifyMsgEle.$ele && 0 !== notifyMsgEle.$ele.length) {
        			var t = notifyMsgEle.$ele.find("span")
        			, n = "object" == typeof e ? e.message : e
        					, r = "notifyMsgEle13676010686"
        						, i = $("#" + r);
        			if (0 === i.length && ($("body").append("<div id='" + r + "' style='display:none;'>"),
        					i = $("#" + r)),
        					//i.html(ecpUtils.escapeAngleBrackets(n)),
        					i.html(n),
        					t && 0 !== t.length && t.text() === i.text())
        				return
        		}
        		var o, a, s;
        		"object" == typeof e && (o = e.delay,
        				a = e.container,
        				s = e.message),
        				"string" == typeof e && (s = e),
        				o = o || 5e3,
        				a = a || "body",
        				notifyMsgEle = $.notify({
        					icon: "glyphicon glyphicon-warning-sign",
        					// message: ecpUtils.escapeAngleBrackets(s)
        					message: s
        				}, {
        					element: a,
        					position: null,
        					type: "info",
        					allow_dismiss: !0,
        					newest_on_top: !1,
        					placement: {
        						from: "top",
        						align: "right"
        					},
        					offset: {
        						x: 30,
        						y: 30
        					},
        					spacing: 10,
        					z_index: 999999,
        					delay: o,
        					timer: 1e3,
        					url_target: "_blank",
        					mouse_over: "pause",
        					animate: {
        						enter: "animated fadeInDown",
        						exit: "animated fadeOutUp"
        					},
        					onShow: null,
        					onShown: null,
        					onClose: null,
        					onClosed: null,
        					icon_type: "class",
        					template: '<div data-notify="container" class="col-xs-11 col-sm-3 alert alert-{0}" role="alert"><button type="button" aria-hidden="true" class="close" data-notify="dismiss">×</button><span data-notify="message">{2}</span></div>'
        				})
        		
        	}
        },
        
        /**
         * 弹出提示
         * @param msg 提示信息
         */
        dialog: function (msg) {
            this.showMsg(msg);
        },
        /**
         * 弹出提示
         * @param msg 提示信息
         */
        showMsg: function (msg) {
            $dialog.dialog({title: $curLocaleNls.basicUtil.js.tips, content: msg, isTip: true});
        },

        /**
         * 弹出带详细信息的提示框
         * @param msg 提示信息，使用'<br/>'分割行。
         */
        showDetailMsg: function (contentTitle, msg) {
            $dialog.dialog({
                title: "提示",   //模态窗标题
                content: contentTitle, //模态窗内容
                isTip: true, //标准的提示窗口
                showCloseButton: true,  //不显示关闭按钮
                detailedMessage: msg
            });
        },
        /**
         * 弹出带有是否的消息框.
         * @param contentTitle 提示信息
         * @param callback 是的回调函数
         */
        showSfMsg: function (contentTitle, callback) {
            $dialog.dialog({
                title: '提示',
                content: contentTitle,
                showCloseButton: false,
                isTip: true,
                otherButtons: ['否', '是'],
                otherButtonStyles: ['btn-link', 'btn-primary'],
                clickButton: callback
            });
        },

        /**
         * 打开仅有确定按钮并有回调函数的弹框
         */
        openTrue2Confirm: function (contentTitle, callback) {
            $dialog.dialog({
                title: '提示',
                content: contentTitle,
                showCloseButton: false,
                isTip: true,
                otherButtons: ['确定'],
                otherButtonStyles: ['btn-primary'],
                clickButton: callback
            });
        },
        /**
         * 打开仅有确定按钮的弹框
         */
        openTrueConfirm: function (contentTitle, callback) {
            $dialog.dialog({
                title: '提示',
                content: contentTitle,
                showCloseButton: false,
                isTip: true,
                otherButtons: ['确定'],
                otherButtonStyles: ['btn-primary'],
                clickButton: function (sender, modal) {
                    // 关闭模态窗
                    modal.modal("hide");
                    callback.call();
                }
            });
        },

        /**
         * 打开是否选择的弹框
         */
        openConfirm: function (contentTitle, callback) {
            $dialog.dialog({
                title: $curLocaleNls.basicUtil.js.tips,
                content: contentTitle,
                showCloseButton: false,
                isTip: true,
                otherButtons: [$curLocaleNls.basicUtil.js.no, $curLocaleNls.basicUtil.js.yes],
                otherButtonStyles: ['btn-default', 'btn-primary'],
                clickButton: function (sender, modal, index) {
                    // 关闭模态窗
                    modal.modal("hide");
                    if (index == 1) {
                        callback();
                    }
                }
            });
        },
        /**
         * 打开是否选择的弹框
         */
        openDetailConfirm: function (contentTitle, msg, callback) {
            $dialog.dialog({
                title: '提示',
                content: contentTitle,
                showCloseButton: false,
                isTip: true,
                otherButtons: ['否', '是'],
                otherButtonStyles: ['btn-link', 'btn-primary'],
                detailedMessage: msg,
                clickButton: function (sender, modal, index) {
                    // 关闭模态窗
                    modal.modal("hide");
                    if (index == 1) {
                        callback();
                    }
                }
            });
        },
        /**
         * 打开是否选择的弹框
         */
        openConfirm2: function (contentTitle, callback1, callback2) {
            $dialog.dialog({
                title: '提示',
                content: contentTitle,
                showCloseButton: false,
                isTip: true,
                otherButtons: ['否', '是'],
                otherButtonStyles: ['btn-link', 'btn-primary'],
                clickButton: function (sender, modal, index) {
                    // 关闭模态窗
                    modal.modal("hide");
                    if (index == 0) {
                        callback1();
                    }
                    if (index == 1) {
                        callback2();
                    }
                }
            });
        },
        /**
         * 弹出自定义按钮的消息框.
         * @param contentTitle 提示信息
         * @param buttons 提示按钮中文标题集合
         * @param callback1 第一个按钮的回调函数
         * @param callback2 第二个按钮的回调函数
         */
        show2ButtonMsg: function (contentTitle, buttons, callback1, callback2) {
            $dialog.show({
                title: '提示',
                content: contentTitle,
                showCloseButton: false,
                isTip: true,
                otherButtons: buttons,
                otherButtonStyles: ['btn-link', 'btn-primary'],
                clickButton: function (sender, modal, index) {
                    // 关闭模态窗
                    modal.modal("hide");
                    if (index == 0) {
                        $.isFunction(callback1) && callback1();
                    }
                    if (index == 1) {
                        $.isFunction(callback2) && callback2();
                    }
                }
            });
        },
        /**
         * 构建遮罩弹框
         */
        buildPopDiv: function (opt) {
            var that = this;
            if (this.isEmpty(opt)) {
                throw new Error("参数错误：opt为空！无法构建弹框。");
            }
            var defaultOpt = {
                title: '这里显示title', // 弹框title
                showCloseFork: true, // 是否显示右上角×
                maximize: true, // 弹框是否最大化（为true则忽略height,width属性）
                height: 600, // 弹框高度，给定数值（如600）
                width: 1000, // 弹框宽度，给定数值（如1000）
                buttons: [{'id': 'cancelBtn', 'text': '取消'}, {'id': 'saveBtn', 'text': '保存'}],
                buttonStyles: ['btn-default', 'btn-primary']
            };

            var options = $.extend({}, defaultOpt, opt);
            var popHtmls = [];
            popHtmls.push('<div class="modal fade colorModal" id="modal@serialID" role="dialog" aria-labelledby="modalLabel@serialID" data-backdrop="static">');
            // 弹框最大化显示
            if (options['maximize']) {
                popHtmls.push('<div class="modal-dialog" style="width:100%;height:100%">');
            } else {
                // 根据屏幕宽度适应计算宽度
                var _width = that.singleContentWidth(options['width']);
                popHtmls.push('<div class="modal-dialog" style="width:' + _width + 'px">');
            }
            popHtmls.push('<div class="modal-content">');
            popHtmls.push('<div class="modal-header">');
            // 是否显示右上角叉
            if (options['showCloseFork']) {
                popHtmls.push('<button type="button" class="close" data-dismiss="modal" aria-label="Close"><span aria-hidden="true">&times;</span></button>');
            }
            popHtmls.push('<h4 class="modal-title" id="title">' + options['title'] + '</h4>');
            popHtmls.push('</div>');//modal-header 结束
            if (options['maximize']) {
                var _height = that.fullScreenHeight(true, true);
                popHtmls.push('<div class="modal-body" style="height:' + _height + 'px;overflow:auto;">@respHtml</div>');
            } else {
                var _height = that.singleContentHeight(options['height']);
                popHtmls.push('<div class="modal-body" style="height:' + _height + 'px;overflow:auto;">@respHtml</div>');
            }

            popHtmls.push('<div class="modal-footer">');
            popHtmls.push('<div style="float:right;">');
            // 构建右下角Button
            popHtmls.push(that._buildPopButtons(options));
            popHtmls.push('</div>');
            popHtmls.push('</div>');//modal-footer 结束
            popHtmls.push('</div>');//modal-content 结束
            popHtmls.push('</div>');//modal-dialog 结束
            popHtmls.push('</div>');//modal fade colorModal 结束

            return popHtmls.join('\n');
        },
        /**
         * 构建弹框遮罩右下角Buttons
         */
        _buildPopButtons: function (options) {
            var btnHtmls = [];
            var buttons = options['buttons'];
            var buttonStyles = options['buttonStyles'];
            if (buttons.length != buttonStyles.length) {
                throw new Error("参数错误：buttons定义个数与buttonStyles定义个数不相等。");
            }
            for (var i = 0, j = buttons.length; i < j; i++) {
                var btnStyle = buttonStyles[i];
                var btnId = buttons[i]['id'] + '@serialID';
                var btnText = buttons[i]['text'];
                btnHtmls.push('<button type="button" class="btn ' + btnStyle + '" id="' + btnId + '">' + btnText + '</button>');
            }
            return btnHtmls.join('\n');
        },

        /**
         * 检查页面是否有遮罩
         */
        hasBlockUI: function () {
            var allBlock = $(".overallLoadBox");
            var partBlock = $(".partLoadBox");
            if (this.isEmptyJQuery(allBlock) &&
                this.isEmptyJQuery(partBlock)) {
                return false;
            }

            return true;
        },
        /**
         * 显示BlockUI.
         */
        showBlockUI: function () {
            loading.show();
        },

        /**
         * 隐藏显示BlockUI.
         */
        hideBlockUI: function () {
//	    	if( !this.hasBlockUI() ){
//	    		return;
//	    	}

            loading.hide();
        },
        /**
         * 显示指定ID的遮罩.
         */
        showTargetBlockUI: function (targetID) {
            var opt = {
                container: $('#' + targetID),
                timeout: 10000
            };
            var loading = new PageLoading(opt);
            loading.show();
            return loading;
        },
        /**
         * 隐藏指定ID的遮罩.
         */
        hideTargetBlockUI: function (loading) {
            if (this.isEmpty(loading)) {
                throw new Error("参数错误：target为空。");
            }
            loading.hide();
        },

        /**
         * 显示遮罩层
         */
        showMask: function (target) {
            if (!target) {
                target = $("body");
            }
            var $mask = target.find('.modal-backdrop');
            if ($mask.length) {
                if (!$mask.hasClass('in')) {
                    $mask.addClass('in');
                }
            } else {
                $mask = $('<div class="modal-backdrop in"></div>');
            }
            target.append($mask);
            return $mask;
        },

        /**
         * 隐藏遮罩层
         */
        hideMask: function (target) {
            if (!target) {
                target = $("body");
            }
            var $mask = target.find('.modal-backdrop');
            $mask.length && $mask.remove();
            // 如果有回调函数，则执行
            var callback = arguments[0];
            if (callback && $.isFunction(callback)) {
                callback();
            }
        },
        /**
         * 传入url，在页面已模态iframe形式打开
         * @param url iframe打开地址
         * @param width 模态窗口宽度
         * @param height 模态窗口高度
         * @param isTransBg 模态窗口是否透明
         * @returns {*} 模态窗口对象
         */
        showIframeModal: function (url, popHtml, width, height, isTransBg) {
            var width = width || 720;
            var height = height || 480;
            var popHtml = popHtml || DEFAULT_POP_HTML;
            popHtml = $(popHtml);
            var popHtmlId = popHtml.attr("id");
            var $pop = $("#" + popHtmlId);
            if (this.isEmpty($pop)) {
                $("body").append(popHtml);
            }
            popHtml.find(".modal-dialog").css("width", width + 30);
            if (isTransBg) {
                // 穿透2.0界面不需要显示边框
                popHtml.find(".modal-content").css({
                    "background": "transparent",
                    "border": "none",
                    "box-shadow": "none"
                });
            }
            popHtml.find("iframe").attr({src: url, width: width, height: height});
            popHtml.off("hidden.bs.modal").on("hidden.bs.modal", function () {
                popHtml.remove();
            });
            return popHtml;
        },
        /**
         * 传入url，在页面已模态iframe形式全屏打开
         * @param url iframe打开地址
         * @param title 标题
         * @param option 参数
         * @param clickCallback 点击事件的回调
         * @param hiddenCallback 窗口销毁事件的回调
         */
        showNewIframeModal: function (option, clickCallback, hiddenCallback) {
            var opt = {
                fullScreenMode: true,  //默认初始化全屏
                fade: true, // 是否有动画效果
                bootstrapModalOption: { // 页面宽度需要在该属性中设置
                    width: "100%"
                },
                shrinkExpand: false, // 是否显示展开、收缩窗体内容
                modalSize: 'lg', // 窗口大小模式
                showCloseButton: false, // 显示关闭按钮
                otherButtons: ["取消", "保存"],
                otherButtonStyles: ["btn btn-default", "btn btn-primary"],
                clickButton: clickCallback,
                dialogHidden: hiddenCallback
            };
            opt = $.extend(opt, option || {});
            $dialog.window(opt);
        },
        /**
         * 传入url，打开一个不带按钮的窗口
         * @param url iframe打开地址
         * @param title 标题
         * @param option 参数
         * @param clickCallback 点击事件的回调
         * @param hiddenCallback 窗口销毁事件的回调
         */
        showNoBtnIframeModal: function (option, hiddenCallback) {
            var opt = {
                fullScreenMode: true,  //默认初始化全屏
                fade: true, // 是否有动画效果
                bootstrapModalOption: { // 页面宽度需要在该属性中设置
                    width: "100%"
                },
                shrinkExpand: false, // 是否显示展开、收缩窗体内容
                modalSize: 'lg', // 窗口大小模式
                showCloseButton: false, // 显示关闭按钮
                otherButtons: ["取消"],
                otherButtonStyles: ["hidden"],
                dialogHidden: hiddenCallback
            };
            opt = $.extend(opt, option || {});
            $dialog.window(opt);
        },
        /**
         *  打开一个全屏Iframe页面（不用默认的关闭，可用otherButtons代替）<br>
         *  @param option 参数<br>
         *  @param exterHtml 全屏子页面左下脚，额外添加Button<br>
         */
        openFullScreeIframe: function (option, exterHtml) {
            var opt = {
                fullScreenMode: true,  //默认初始化全屏
                fade: true, // 是否有动画效果
                bootstrapModalOption: { // 页面宽度需要在该属性中设置
                    width: "100%"
                },
                shrinkExpand: false, // 是否显示展开、收缩窗体内容
                modalSize: 'lg', // 窗口大小模式
                showCloseButton: false, // 显示关闭按钮
                otherButtons: ["关闭"],
                otherButtonStyles: ["btn-primary"],
                //-----建议配置的函数属性------
                title: "",
                iframeMode: {
                    "url": "", //访问的页面地址
                    "options": {}
                },
                //-----建议配置的函数回调------
                dialogHidde: function () {
                    return true;/*对话框即将关闭 */
                },
                dialogHidden: function () {/*对话框已经关闭 */
                },
                clickButton: function (sender, modal, index) {
                    modal.modal('hide');
                }
            };
            opt = $.extend(opt, option || {});
            var win = $dialog.window(opt);
            if (!this.isEmpty(exterHtml)) {
                win.find(".modal-footer").children().first().before(exterHtml);
            }
        },
        /**
         * 为ID添加serialID
         * @param ids
         * @param serialID
         *
         * ("xmlx", 123)-> "xmlx123"
         * (["xmlx", "xmlb"], 123) -> ["xmlx123", "xmlb123"]
         */
        addSerialID: function (ids, serialID) {
            if (this.isEmpty(ids)) {
                this.dialog("参数错误：ids为空。");
                return null;
            }

            var that = this;
            if ($.isArray(ids)) {
                for (var i = 0, j = ids.length; i < j; i++) {
                    ids[i] = ids[i] + serialID;
                }
                return ids;
            }

            return ids + serialID;
        },
        /**
         * 清空页面控件值
         * @param ctrl 缓存业务组件的Controller
         * @param ids 需要清空的ids
         * @param container 容器
         */
        clearValue: function (ctrl, ids, container) {
            if (this.isEmpty(ctrl) || this.isEmpty(ids)) {
                throw new Error("参数错误：ctrl or ids为空。");
            }

            var that = this;
            if (this.isEmpty(container)) {
                container = $("body");
            }

            ids = this.toArray(ids);
            $.each(ids, function (i, id) {
                var obj = ctrl[id];
                // 业务组件的清空
                if (obj && obj.setValue) {
                    obj.setValue('');
                    that.clearComboxText(container, [id]);
                } else {
                    // jQuery控件的清空
                    $("#" + id, container).val('');
                }
            });
        },
        /**
         * 获得焦点选中文本.
         */
        bindFocusSelect: function () {
            $("input[type='text']").on("focus", function () {
                this.select();
            });
        },
        /**
         * 输入框绑定change事件
         * @param ids
         * @param container
         * @param serialID
         */
        bindTextChange: function (ids, container, serialID) {
            var that = this;
            if (this.isEmpty(ids)) {
                this.dialog("参数错误：ids为空。");
                return;
            }
            if (container == null) {
                container = $("body");
            }
            // DOM绑定观察者
            if (!$.isArray(ids)) {
                ids = ids.split(",");
            }
            $.each(ids, function (i, id) {
                var obj = $("#" + id);
                var length = obj.attr("_length");
                if (obj.length > 0) {
                    obj.on("input propertychange", function () {
                        var curVal = obj.val() || '';
                        if (curVal.length > length) {
                            obj.val(curVal.substring(0, length));
                        }
                    });
                }
            });
        },
        /**
         * 管理对象等控件通过[更多]选择后，样式强制加underline<br>
         * 注意： plus_5.1需要使用，5.2不需要控制。<br>
         */
        bindAddUnderline: function (ids, container) {
            var that = this;
            if (this.isEmpty(ids)) {
                this.dialog("参数错误：ids为空。");
                return;
            }
            if (container == null) {
                container = $("body");
            }

            var addUnderlineStyle = function (domID) {
                setTimeout(function () {
                    $("#" + domID, container).addClass('form-control input_underline');
                }, 100);
            };

            // 低版本兼容处理
            var MutationObserver = window.MutationObserver ||
                window.WebKitMutationObserver ||
                window.MozMutationObserver;
            // 新建观察者对象
            var observer = new MutationObserver(function (records, mo) {
                records.forEach(function (record) {
                    addUnderlineStyle(record.target.id);
                });
            });
            // 观察者配置
            var config = {attributes: true, childList: true, characterData: true};
            // DOM绑定观察者
            if (!$.isArray(ids)) {
                ids = ids.split(",");
            }
            $.each(ids, function (i, id) {
                var obj = $("#s2id_" + id + "_render");
                if (obj.length > 0) {
                    observer.observe(obj[0], config);
                }
            });
        },
        /**
         * 业务控件动态添加'input_underline'样式
         *
         * @param container 查找容器
         * @param ids 控件id属性 支持如下参数
         * 1、'xmmc'
         * 2、'xmmc,dxgc'
         * 3、['xmmc','dxgc']
         */
        addUnderline: function (ids, container) {
            if (this.isEmpty(ids)) {
                this.dialog("参数错误：ids为空。");
                return;
            }
            if (container == null) {
                container = $("body");
            }
            var idArr = [];
            if ($.isArray(ids)) {
                idArr = ids;
            } else {
                idArr = ids.split(",");
            }

            $.each(idArr, function (i, id) {
                $("#s2id_" + id + "_render", container).addClass('form-control input_underline');
            });
            this.bindAddUnderline(ids, container);
        },
        /**
         * 业务控件动态添加'border-radius: 20px;'样式
         */
        addBorderRadius: function (ids, container) {
            if (this.isEmpty(ids)) {
                this.dialog("参数错误：ids为空。");
                return;
            }
            if (container == null) {
                container = $("body");
            }
            var idArr = [];
            if ($.isArray(ids)) {
                idArr = ids;
            } else {
                idArr = ids.split(",");
            }

            $.each(idArr, function (i, id) {
                var pobj = $("#s2id_" + id + "_render");
                pobj.css({"border-radius": "20px"});
                pobj.children("a:first").css({"border-radius": "20px"});
                //业务组件
                pobj.find("ul:first").css({"border-radius":"20px"});
//				//comboBox下来框
//				pobj.children("a:first").css({"border-radius":"20px"});
            });
        },
	};
	
	return new ExtuiTool();
});